/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.CurveCoordinate;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.ECPrivateKey$;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.SchnorrNonce;
import org.bitcoins.crypto.SchnorrPublicKey$;
import org.bitcoins.crypto.Sha256Digest;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.ModuleSerializationProxy;
import scodec.bits.ByteVector;

public final class SchnorrNonce$
extends Factory<SchnorrNonce>
implements Serializable {
    public static final SchnorrNonce$ MODULE$ = new SchnorrNonce$();

    @Override
    public SchnorrNonce fromBytes(ByteVector bytes) {
        return new SchnorrNonce(SchnorrPublicKey$.MODULE$.fromBytes(bytes).bytes());
    }

    public ECPrivateKey kFromBipSchnorr(ECPrivateKey privKey, ByteVector message, ByteVector auxRand) {
        ECPrivateKey privKeyForUse = privKey.schnorrKey();
        ByteVector randHash = CryptoUtil$.MODULE$.sha256SchnorrAuxRand(auxRand).bytes();
        ByteVector maskedKey = randHash.xor(privKeyForUse.bytes());
        Sha256Digest nonceHash = CryptoUtil$.MODULE$.sha256SchnorrNonce(maskedKey.$plus$plus(privKey.schnorrPublicKey().bytes()).$plus$plus(message));
        return ((ECPrivateKey)ECPrivateKey$.MODULE$.apply(nonceHash.bytes())).nonceKey();
    }

    public SchnorrNonce fromBipSchnorr(ECPrivateKey privKey, ByteVector message, ByteVector auxRand) {
        ECPrivateKey k = this.kFromBipSchnorr(privKey, message, auxRand);
        return k.publicKey().schnorrNonce();
    }

    public SchnorrNonce apply(CurveCoordinate xCoor) {
        return (SchnorrNonce)this.apply(xCoor.bytes());
    }

    public Option<ByteVector> unapply(SchnorrNonce x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.bytes());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SchnorrNonce$.class);
    }

    private SchnorrNonce$() {
    }
}

