/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.CurveCoordinate;
import org.bitcoins.crypto.CurveCoordinate$;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.ECPrivateKey$;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.ECPublicKey$;
import org.bitcoins.crypto.EvenParity$;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.HashDigest;
import org.bitcoins.crypto.NetworkElement;
import org.bitcoins.crypto.PublicKey;
import org.bitcoins.crypto.SchnorrDigitalSignature;
import org.bitcoins.crypto.SchnorrNonce;
import org.bitcoins.crypto.SchnorrPublicKey$;
import org.bitcoins.crypto.XOnlyPubKey;
import org.bitcoins.crypto.XOnlyPubKey$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.ByteVector;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001B\u0010!\u0001\u001eB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0007\")A\n\u0001C\u0001\u001b\")\u0001\u000b\u0001C\u0001#\")\u0001\u000b\u0001C\u00019\")1\r\u0001C\u0001I\")1\r\u0001C\u0001]\")1\r\u0001C\u0001c\")1\r\u0001C\u0001u\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u0003gA\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0003\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\t\u0019\bAA\u0001\n\u0003\n)\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131\u0012\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#C\u0011\"a%\u0001\u0003\u0003%\t%!&\b\u000f\u0005e\u0005\u0005#\u0001\u0002\u001c\u001a1q\u0004\tE\u0001\u0003;Ca\u0001T\r\u0005\u0002\u0005=\u0006bBAY3\u0011\u0005\u00111\u0017\u0005\b\u0003\u0003LB\u0011AAb\u0011%\tI-GA\u0001\n\u0003\u000bY\rC\u0005\u0002Xf\t\t\u0011\"\u0003\u0002Z\n\u00012k\u00195o_J\u0014\b+\u001e2mS\u000e\\U-\u001f\u0006\u0003C\t\naa\u0019:zaR|'BA\u0012%\u0003!\u0011\u0017\u000e^2pS:\u001c(\"A\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001AcFM\u001b\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\ty\u0003'D\u0001!\u0013\t\t\u0004EA\u0005Qk\nd\u0017nY&fsB\u0011\u0011fM\u0005\u0003i)\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00027}9\u0011q\u0007\u0010\b\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\na\u0001\u0010:p_Rt\u0014\"A\u0016\n\u0005uR\u0013a\u00029bG.\fw-Z\u0005\u0003\u007f\u0001\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!\u0010\u0016\u0002\u000b\tLH/Z:\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t\tLGo\u001d\u0006\u0002\u0011\u000611oY8eK\u000eL!AS#\u0003\u0015\tKH/\u001a,fGR|'/\u0001\u0004csR,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059{\u0005CA\u0018\u0001\u0011\u0015\t5\u00011\u0001D\u0003\u00191XM]5gsR\u0019!+V,\u0011\u0005%\u001a\u0016B\u0001++\u0005\u001d\u0011un\u001c7fC:DQA\u0016\u0003A\u0002\r\u000bA\u0001Z1uC\")\u0001\f\u0002a\u00013\u0006I1/[4oCR,(/\u001a\t\u0003_iK!a\u0017\u0011\u0003/M\u001b\u0007N\\8se\u0012Kw-\u001b;bYNKwM\\1ukJ,Gc\u0001*^E\")a,\u0002a\u0001?\u0006!\u0001.Y:i!\ty\u0003-\u0003\u0002bA\tQ\u0001*Y:i\t&<Wm\u001d;\t\u000ba+\u0001\u0019A-\u0002\u001f\r|W\u000e];uKNKw\rU8j]R$2!\u001a5j!\tyc-\u0003\u0002hA\tYQi\u0011)vE2L7mS3z\u0011\u00151f\u00011\u0001D\u0011\u0015Qg\u00011\u0001l\u0003\u0015qwN\\2f!\tyC.\u0003\u0002nA\ta1k\u00195o_J\u0014hj\u001c8dKR\u0019Qm\u001c9\t\u000by;\u0001\u0019A0\t\u000b)<\u0001\u0019A6\u0015\u0007\u0015\u0014x\u000fC\u0003t\u0011\u0001\u0007A/A\u0006csR,7\u000fV8ICND\u0007c\u0001\u001cv\u0007&\u0011a\u000f\u0011\u0002\u0007-\u0016\u001cGo\u001c:\t\u000baD\u0001\u0019A=\u0002\r9|gnY3t!\r1To\u001b\u000b\u0005KndX\u0010C\u0003W\u0013\u0001\u00071\tC\u0003k\u0013\u0001\u00071\u000eC\u0003\u007f\u0013\u0001\u0007!+\u0001\u0006d_6\u0004(/Z:tK\u0012\f\u0011\u0002];cY&\u001c7*Z=\u0016\u0003\u0015\fa\u0001_\"p_J$WCAA\u0004!\ry\u0013\u0011B\u0005\u0004\u0003\u0017\u0001#aD\"veZ,7i\\8sI&t\u0017\r^3\u0002\u000fQ|\u0007l\u00148msV\u0011\u0011\u0011\u0003\t\u0004_\u0005M\u0011bAA\u000bA\tY\u0001l\u00148msB+(mS3z\u0003!!xn\u0015;sS:<GCAA\u000e!\u0011\ti\"!\n\u000f\t\u0005}\u0011\u0011\u0005\t\u0003q)J1!a\t+\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0005\u0016\u0002\t\r|\u0007/\u001f\u000b\u0004\u001d\u0006=\u0002bB!\u000f!\u0003\u0005\raQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)DK\u0002D\u0003oY#!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007R\u0013AC1o]>$\u0018\r^5p]&!\u0011qIA\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0003\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0005Y\u0006twM\u0003\u0002\u0002X\u0005!!.\u0019<b\u0013\u0011\t9#!\u0015\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005}\u0003cA\u0015\u0002b%\u0019\u00111\r\u0016\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0014q\u000e\t\u0004S\u0005-\u0014bAA7U\t\u0019\u0011I\\=\t\u0013\u0005E$#!AA\u0002\u0005}\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002xA1\u0011\u0011PA@\u0003Sj!!a\u001f\u000b\u0007\u0005u$&\u0001\u0006d_2dWm\u0019;j_:LA!!!\u0002|\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0011\u0016q\u0011\u0005\n\u0003c\"\u0012\u0011!a\u0001\u0003S\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QJAG\u0011%\t\t(FA\u0001\u0002\u0004\ty&\u0001\u0005iCND7i\u001c3f)\t\ty&\u0001\u0004fcV\fGn\u001d\u000b\u0004%\u0006]\u0005\"CA9/\u0005\u0005\t\u0019AA5\u0003A\u00196\r\u001b8peJ\u0004VO\u00197jG.+\u0017\u0010\u0005\u000203M)\u0011$a(\u0002&B!q&!)O\u0013\r\t\u0019\u000b\t\u0002\b\r\u0006\u001cGo\u001c:z!\u0011\t9+!,\u000e\u0005\u0005%&\u0002BAV\u0003+\n!![8\n\u0007}\nI\u000b\u0006\u0002\u0002\u001c\u0006IaM]8n\u0005f$Xm\u001d\u000b\u0004\u001d\u0006U\u0006\"B!\u001c\u0001\u0004\u0019\u0005fA\u000e\u0002:B!\u00111XA_\u001b\t\t\t%\u0003\u0003\u0002@\u0006\u0005#a\u0002;bS2\u0014XmY\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001d\u0006\u0015\u0007bBAd9\u0001\u0007\u0011qA\u0001\u0006q\u000e{wN]\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti-a5\u0011\t%\nymQ\u0005\u0004\u0003#T#AB(qi&|g\u000e\u0003\u0005\u0002Vv\t\t\u00111\u0001O\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00037\u0004B!a\u0014\u0002^&!\u0011q\\A)\u0005\u0019y%M[3di\u0002")
public class SchnorrPublicKey
implements PublicKey,
Product,
Serializable {
    private final ByteVector bytes;

    public static Option<ByteVector> unapply(SchnorrPublicKey x$0) {
        return SchnorrPublicKey$.MODULE$.unapply(x$0);
    }

    public static SchnorrPublicKey apply(CurveCoordinate xCoor) {
        return SchnorrPublicKey$.MODULE$.apply(xCoor);
    }

    public static SchnorrPublicKey fromBytes(ByteVector bytes) {
        return SchnorrPublicKey$.MODULE$.fromBytes(bytes);
    }

    public static Factory<SchnorrPublicKey> self() {
        return SchnorrPublicKey$.MODULE$.self();
    }

    public static Object apply(String hex) {
        return SchnorrPublicKey$.MODULE$.apply(hex);
    }

    public static Object apply(ByteVector bytes) {
        return SchnorrPublicKey$.MODULE$.apply(bytes);
    }

    public static Object fromBytesLE(ByteVector bytes) {
        return SchnorrPublicKey$.MODULE$.fromBytesLE(bytes);
    }

    public static Try<SchnorrPublicKey> fromBytesT(ByteVector bytes) {
        return SchnorrPublicKey$.MODULE$.fromBytesT(bytes);
    }

    public static Option<SchnorrPublicKey> fromBytesOpt(ByteVector bytes) {
        return SchnorrPublicKey$.MODULE$.fromBytesOpt(bytes);
    }

    public static Object fromHexLE(String hex) {
        return SchnorrPublicKey$.MODULE$.fromHexLE(hex);
    }

    public static Try<SchnorrPublicKey> fromHexT(String hex) {
        return SchnorrPublicKey$.MODULE$.fromHexT(hex);
    }

    public static Option<SchnorrPublicKey> fromHexOpt(String hex) {
        return SchnorrPublicKey$.MODULE$.fromHexOpt(hex);
    }

    public static Object fromHex(String hex) {
        return SchnorrPublicKey$.MODULE$.fromHex(hex);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public long byteSize() {
        return NetworkElement.byteSize$(this);
    }

    @Override
    public String hex() {
        return NetworkElement.hex$(this);
    }

    @Override
    public String hexLE() {
        return NetworkElement.hexLE$(this);
    }

    @Override
    public ByteVector bytesLE() {
        return NetworkElement.bytesLE$(this);
    }

    @Override
    public ByteVector bytes() {
        return this.bytes;
    }

    public boolean verify(ByteVector data, SchnorrDigitalSignature signature) {
        return CryptoUtil$.MODULE$.schnorrVerify(data, this, signature);
    }

    public boolean verify(HashDigest hash, SchnorrDigitalSignature signature) {
        return this.verify(hash.bytes(), signature);
    }

    public ECPublicKey computeSigPoint(ByteVector data, SchnorrNonce nonce) {
        return this.computeSigPoint(data, nonce, true);
    }

    public ECPublicKey computeSigPoint(HashDigest hash, SchnorrNonce nonce) {
        return this.computeSigPoint(hash.bytes(), nonce);
    }

    public ECPublicKey computeSigPoint(Vector<ByteVector> bytesToHash, Vector<SchnorrNonce> nonces) {
        Vector bytesAndNonces = (Vector)bytesToHash.zip(nonces);
        Vector hashesAndNoncePoints = (Vector)bytesAndNonces.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ByteVector bytes = (ByteVector)tuple2._1();
                SchnorrNonce nonce = (SchnorrNonce)tuple2._2();
                ByteVector eBytes = CryptoUtil$.MODULE$.sha256SchnorrChallenge(nonce.bytes().$plus$plus(this.bytes()).$plus$plus(CryptoUtil$.MODULE$.sha256DLCAttestation(bytes).bytes())).bytes();
                ECPrivateKey e = (ECPrivateKey)ECPrivateKey$.MODULE$.apply(eBytes);
                return new Tuple2((Object)e, (Object)nonce.publicKey());
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple2 tuple2 = (Tuple2)hashesAndNoncePoints.reduce((Function2 & Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    ECPrivateKey aggHash = (ECPrivateKey)tuple22._1();
                    ECPublicKey aggPoint = (ECPublicKey)tuple22._2();
                    if (tuple23 != null) {
                        ECPrivateKey hash = (ECPrivateKey)tuple23._1();
                        ECPublicKey nonce = (ECPublicKey)tuple23._2();
                        return new Tuple2((Object)aggHash.add(hash), (Object)aggPoint.add(nonce));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ECPrivateKey aggHashes = (ECPrivateKey)tuple2._1();
        ECPublicKey aggNonces = (ECPublicKey)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)aggHashes, (Object)aggNonces);
        ECPrivateKey aggHashes2 = (ECPrivateKey)tuple22._1();
        ECPublicKey aggNonces2 = (ECPublicKey)tuple22._2();
        return this.publicKey().multiply(aggHashes2.fieldElement()).add(aggNonces2);
    }

    public ECPublicKey computeSigPoint(ByteVector data, SchnorrNonce nonce, boolean compressed) {
        return CryptoUtil$.MODULE$.schnorrComputeSigPoint(data, nonce, this, compressed);
    }

    public ECPublicKey publicKey() {
        ByteVector pubKeyBytes = EvenParity$.MODULE$.bytes().$plus$plus(this.bytes());
        return (ECPublicKey)ECPublicKey$.MODULE$.apply(pubKeyBytes);
    }

    public CurveCoordinate xCoord() {
        return (CurveCoordinate)CurveCoordinate$.MODULE$.apply(this.bytes());
    }

    public XOnlyPubKey toXOnly() {
        return (XOnlyPubKey)XOnlyPubKey$.MODULE$.apply(this.bytes());
    }

    public String toString() {
        return new StringBuilder(18).append("SchnorrPublicKey(").append(this.bytes().toHex()).append(")").toString();
    }

    public SchnorrPublicKey copy(ByteVector bytes) {
        return new SchnorrPublicKey(bytes);
    }

    public ByteVector copy$default$1() {
        return this.bytes();
    }

    public String productPrefix() {
        return "SchnorrPublicKey";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.bytes();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchnorrPublicKey;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "bytes";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchnorrPublicKey)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchnorrPublicKey schnorrPublicKey = (SchnorrPublicKey)x$1;
        ByteVector byteVector = this.bytes();
        ByteVector byteVector2 = schnorrPublicKey.bytes();
        if (byteVector == null) {
            if (byteVector2 != null) {
                return false;
            }
        } else if (!byteVector.equals(byteVector2)) return false;
        if (!schnorrPublicKey.canEqual(this)) return false;
        return true;
    }

    public SchnorrPublicKey(ByteVector bytes) {
        this.bytes = bytes;
        NetworkElement.$init$(this);
        Product.$init$((Product)this);
        Predef$.MODULE$.require(bytes.length() == 32L, (Function0 & Serializable)() -> new StringBuilder(42).append("Schnorr public keys must be 32 bytes, got ").append(this.bytes()).toString());
        Predef$.MODULE$.require(Try$.MODULE$.apply((Function0 & Serializable)() -> this.publicKey()).isSuccess(), (Function0 & Serializable)() -> new StringBuilder(53).append("Schnorr public key must be a valid x coordinate, got ").append(this.bytes()).toString());
    }
}

