/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoParams$;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.CurveCoordinate;
import org.bitcoins.crypto.CurveCoordinate$;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.ECPublicKey$;
import org.bitcoins.crypto.EvenParity$;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.FieldElement$;
import org.bitcoins.crypto.KeyParity;
import org.bitcoins.crypto.NetworkElement;
import org.bitcoins.crypto.PublicKey;
import org.bitcoins.crypto.SchnorrPublicKey;
import org.bitcoins.crypto.SchnorrPublicKey$;
import org.bitcoins.crypto.Sha256Digest;
import org.bitcoins.crypto.XOnlyPubKey$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.ByteVector;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001\u0002\u0010 \u0001\u001aB\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u0005\")1\n\u0001C\u0001\u0019\")q\n\u0001C\u0001!\")\u0011\f\u0001C\u00015\")q\n\u0001C\u0001=\")q\f\u0001C\u0001A\")A\r\u0001C\u0001K\")A\u000f\u0001C\u0001k\")q\u000f\u0001C\u0001q\")Q\u0010\u0001C\u0005}\"I\u0011\u0011\u0001\u0001\u0002\u0002\u0013\u0005\u00111\u0001\u0005\n\u0003\u000f\u0001\u0011\u0013!C\u0001\u0003\u0013A\u0011\"a\b\u0001\u0003\u0003%\t%!\t\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001f\u0001\u0005\u0005I\u0011AA \u0011%\tY\u0005AA\u0001\n\u0003\ni\u0005C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131\r\u0005\n\u0003O\u0002\u0011\u0011!C!\u0003SB\u0011\"a\u001b\u0001\u0003\u0003%\t%!\u001c\t\u0013\u0005=\u0004!!A\u0005B\u0005EtaBA;?!\u0005\u0011q\u000f\u0004\u0007=}A\t!!\u001f\t\r-CB\u0011AAF\u0011\u001d\ti\t\u0007C\u0001\u0003\u001fCq!!(\u0019\t\u0003\ty\nC\u0005\u0002$b\t\t\u0011\"!\u0002&\"I\u0011Q\u0016\r\u0002\u0002\u0013%\u0011q\u0016\u0002\f1>sG.\u001f)vE.+\u0017P\u0003\u0002!C\u000511M]=qi>T!AI\u0012\u0002\u0011\tLGoY8j]NT\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001dj\u0013\u0007\u000e\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00059zS\"A\u0010\n\u0005Az\"!\u0003)vE2L7mS3z!\tA#'\u0003\u00024S\t9\u0001K]8ek\u000e$\bCA\u001b>\u001d\t14H\u0004\u00028u5\t\u0001H\u0003\u0002:K\u00051AH]8pizJ\u0011AK\u0005\u0003y%\nq\u0001]1dW\u0006<W-\u0003\u0002?\u007f\ta1+\u001a:jC2L'0\u00192mK*\u0011A(K\u0001\u0006Ef$Xm]\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005E&$8OC\u0001H\u0003\u0019\u00198m\u001c3fG&\u0011\u0011\n\u0012\u0002\u000b\u0005f$XMV3di>\u0014\u0018A\u00022zi\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003\u001b:\u0003\"A\f\u0001\t\u000b\u0001\u001b\u0001\u0019\u0001\"\u0002\u0013A,(\r\\5d\u0017\u0016LHCA)U!\tq#+\u0003\u0002T?\tYQi\u0011)vE2L7mS3z\u0011\u0015)F\u00011\u0001W\u0003\u0019\u0001\u0018M]5usB\u0011afV\u0005\u00031~\u0011\u0011bS3z!\u0006\u0014\u0018\u000e^=\u0002!M\u001c\u0007N\\8seB+(\r\\5d\u0017\u0016LX#A.\u0011\u00059b\u0016BA/ \u0005A\u00196\r\u001b8peJ\u0004VO\u00197jG.+\u00170F\u0001R\u0003\u0015\u0019wn\u001c:e+\u0005\t\u0007C\u0001\u0018c\u0013\t\u0019wDA\bDkJ4XmQ8pe\u0012Lg.\u0019;f\u00035\u0019\u0007.Z2l)\u0006\u0004Hk^3bWR!a-[6t!\tAs-\u0003\u0002iS\t9!i\\8mK\u0006t\u0007\"\u00026\t\u0001\u0004i\u0015\u0001C5oi\u0016\u0014h.\u00197\t\u000b1D\u0001\u0019A7\u0002\u001b5,'o\u001b7f%>|Go\u00149u!\rAc\u000e]\u0005\u0003_&\u0012aa\u00149uS>t\u0007C\u0001\u0018r\u0013\t\u0011xD\u0001\u0007TQ\u0006\u0014TG\u000e#jO\u0016\u001cH\u000fC\u0003V\u0011\u0001\u0007a-A\nd_6\u0004X\u000f^3UCB$v/Z1l\u0011\u0006\u001c\b\u000e\u0006\u0002qm\")A.\u0003a\u0001[\u0006q1M]3bi\u0016$\u0016\r\u001d+xK\u0006\\GCA=}!\u0011A#PV'\n\u0005mL#A\u0002+va2,'\u0007C\u0003m\u0015\u0001\u0007Q.\u0001\u0007uCB$v/Z1l\u0011\u0006\u001c\b\u000e\u0006\u0002q\u007f\")\u0001i\u0003a\u0001\u0005\u0006!1m\u001c9z)\ri\u0015Q\u0001\u0005\b\u00012\u0001\n\u00111\u0001C\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0003+\u0007\t\u000bia\u000b\u0002\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!C;oG\",7m[3e\u0015\r\tI\"K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0012\u0001\u00026bm\u0006LA!!\r\u0002(\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000e\u0011\u0007!\nI$C\u0002\u0002<%\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0011\u0002HA\u0019\u0001&a\u0011\n\u0007\u0005\u0015\u0013FA\u0002B]fD\u0011\"!\u0013\u0011\u0003\u0003\u0005\r!a\u000e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0005\u0005\u0004\u0002R\u0005]\u0013\u0011I\u0007\u0003\u0003'R1!!\u0016*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00033\n\u0019F\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00014\u0002`!I\u0011\u0011\n\n\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002$\u0005\u0015\u0004\"CA%'\u0005\u0005\t\u0019AA\u001c\u0003!A\u0017m\u001d5D_\u0012,GCAA\u001c\u0003!!xn\u0015;sS:<GCAA\u0012\u0003\u0019)\u0017/^1mgR\u0019a-a\u001d\t\u0013\u0005%c#!AA\u0002\u0005\u0005\u0013a\u0003-P]2L\b+\u001e2LKf\u0004\"A\f\r\u0014\u000ba\tY(!!\u0011\t9\ni(T\u0005\u0004\u0003\u007fz\"a\u0002$bGR|'/\u001f\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*!\u0011qQA\u0016\u0003\tIw.C\u0002?\u0003\u000b#\"!a\u001e\u0002\u0013\u0019\u0014x.\u001c\"zi\u0016\u001cHcA'\u0002\u0012\")\u0001I\u0007a\u0001\u0005\"\u001a!$!&\u0011\t\u0005]\u0015\u0011T\u0007\u0003\u0003/IA!a'\u0002\u0018\t9A/Y5me\u0016\u001c\u0017!B1qa2LHcA'\u0002\"\")ql\u0007a\u0001C\u00069QO\\1qa2LH\u0003BAT\u0003S\u00032\u0001\u000b8C\u0011!\tY\u000bHA\u0001\u0002\u0004i\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0017\t\u0005\u0003K\t\u0019,\u0003\u0003\u00026\u0006\u001d\"AB(cU\u0016\u001cG\u000f")
public class XOnlyPubKey
implements PublicKey,
Product,
Serializable {
    private final ByteVector bytes;

    public static Option<ByteVector> unapply(XOnlyPubKey x$0) {
        return XOnlyPubKey$.MODULE$.unapply(x$0);
    }

    public static XOnlyPubKey apply(CurveCoordinate coord) {
        return XOnlyPubKey$.MODULE$.apply(coord);
    }

    public static XOnlyPubKey fromBytes(ByteVector bytes) {
        return XOnlyPubKey$.MODULE$.fromBytes(bytes);
    }

    public static Factory<XOnlyPubKey> self() {
        return XOnlyPubKey$.MODULE$.self();
    }

    public static Object apply(String hex) {
        return XOnlyPubKey$.MODULE$.apply(hex);
    }

    public static Object apply(ByteVector bytes) {
        return XOnlyPubKey$.MODULE$.apply(bytes);
    }

    public static Object fromBytesLE(ByteVector bytes) {
        return XOnlyPubKey$.MODULE$.fromBytesLE(bytes);
    }

    public static Try<XOnlyPubKey> fromBytesT(ByteVector bytes) {
        return XOnlyPubKey$.MODULE$.fromBytesT(bytes);
    }

    public static Option<XOnlyPubKey> fromBytesOpt(ByteVector bytes) {
        return XOnlyPubKey$.MODULE$.fromBytesOpt(bytes);
    }

    public static Object fromHexLE(String hex) {
        return XOnlyPubKey$.MODULE$.fromHexLE(hex);
    }

    public static Try<XOnlyPubKey> fromHexT(String hex) {
        return XOnlyPubKey$.MODULE$.fromHexT(hex);
    }

    public static Option<XOnlyPubKey> fromHexOpt(String hex) {
        return XOnlyPubKey$.MODULE$.fromHexOpt(hex);
    }

    public static Object fromHex(String hex) {
        return XOnlyPubKey$.MODULE$.fromHex(hex);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public long byteSize() {
        return NetworkElement.byteSize$(this);
    }

    @Override
    public String hex() {
        return NetworkElement.hex$(this);
    }

    @Override
    public String hexLE() {
        return NetworkElement.hexLE$(this);
    }

    @Override
    public ByteVector bytesLE() {
        return NetworkElement.bytesLE$(this);
    }

    @Override
    public ByteVector bytes() {
        return this.bytes;
    }

    public ECPublicKey publicKey(KeyParity parity) {
        ByteVector pubKeyBytes = parity.bytes().$plus$plus(this.bytes());
        return (ECPublicKey)ECPublicKey$.MODULE$.apply(pubKeyBytes);
    }

    public SchnorrPublicKey schnorrPublicKey() {
        return (SchnorrPublicKey)SchnorrPublicKey$.MODULE$.apply(this.bytes());
    }

    public ECPublicKey publicKey() {
        return this.schnorrPublicKey().publicKey();
    }

    public CurveCoordinate coord() {
        return (CurveCoordinate)CurveCoordinate$.MODULE$.apply(this.bytes());
    }

    public boolean checkTapTweak(XOnlyPubKey internal, Option<Sha256Digest> merkleRootOpt, boolean parity) {
        Sha256Digest tweaked = internal.computeTapTweakHash(merkleRootOpt);
        FieldElement fe = (FieldElement)FieldElement$.MODULE$.fromBytes(tweaked.bytes());
        ECPublicKey multi = CryptoParams$.MODULE$.getG().multiply(fe);
        ECPublicKey add = internal.publicKey().add(multi);
        XOnlyPubKey xOnlyPubKey = this;
        XOnlyPubKey xOnlyPubKey2 = add.toXOnly();
        return !(xOnlyPubKey != null ? !((Object)xOnlyPubKey).equals(xOnlyPubKey2) : xOnlyPubKey2 != null) && add.parity().isOdd() == parity;
    }

    public Sha256Digest computeTapTweakHash(Option<Sha256Digest> merkleRootOpt) {
        Option<Sha256Digest> option = merkleRootOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Sha256Digest merkleRoot = (Sha256Digest)some.value();
            return this.tapTweakHash(this.bytes().$plus$plus(merkleRoot.bytes()));
        }
        if (None$.MODULE$.equals(option)) {
            return this.tapTweakHash(this.bytes());
        }
        throw new MatchError(option);
    }

    public Tuple2<KeyParity, XOnlyPubKey> createTapTweak(Option<Sha256Digest> merkleRootOpt) {
        Sha256Digest taggedHash = this.computeTapTweakHash(merkleRootOpt);
        ECPublicKey result = CryptoParams$.MODULE$.getG().multiply((FieldElement)FieldElement$.MODULE$.apply(taggedHash.bytes())).add(this.publicKey());
        return new Tuple2((Object)result.parity(), (Object)result.toXOnly());
    }

    private Sha256Digest tapTweakHash(ByteVector bytes) {
        return CryptoUtil$.MODULE$.tapTweakHash(bytes);
    }

    public XOnlyPubKey copy(ByteVector bytes) {
        return new XOnlyPubKey(bytes);
    }

    public ByteVector copy$default$1() {
        return this.bytes();
    }

    public String productPrefix() {
        return "XOnlyPubKey";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.bytes();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XOnlyPubKey;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "bytes";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XOnlyPubKey)) return false;
        boolean bl = true;
        if (!bl) return false;
        XOnlyPubKey xOnlyPubKey = (XOnlyPubKey)x$1;
        ByteVector byteVector = this.bytes();
        ByteVector byteVector2 = xOnlyPubKey.bytes();
        if (byteVector == null) {
            if (byteVector2 != null) {
                return false;
            }
        } else if (!byteVector.equals(byteVector2)) return false;
        if (!xOnlyPubKey.canEqual(this)) return false;
        return true;
    }

    public XOnlyPubKey(ByteVector bytes) {
        this.bytes = bytes;
        NetworkElement.$init$(this);
        Product.$init$((Product)this);
        Predef$.MODULE$.require(bytes.length() == 32L, (Function0 & Serializable)() -> new StringBuilder(41).append("x-only public keys must be 32 bytes, got ").append(this.bytes()).toString());
        Predef$.MODULE$.require(Try$.MODULE$.apply((Function0 & Serializable)() -> this.publicKey(EvenParity$.MODULE$)).isSuccess(), (Function0 & Serializable)() -> new StringBuilder(52).append("x-only public key must be a valid x coordinate, got ").append(this.bytes()).toString());
    }
}

