/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto.musig;

import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.FieldElement$;
import org.bitcoins.crypto.SchnorrPublicKey;
import org.bitcoins.crypto.musig.LexicographicKeySet;
import org.bitcoins.crypto.musig.MuSigTweak;
import org.bitcoins.crypto.musig.MuSigTweakContext;
import org.bitcoins.crypto.musig.MuSigTweakContext$;
import org.bitcoins.crypto.musig.MuSigUtil$;
import org.bitcoins.crypto.musig.UnsortedKeySet;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scodec.bits.ByteVector;

@ScalaSignature(bytes="\u0006\u0005\u0005=aaB\n\u0015!\u0003\r\t!\b\u0005\u0006I\u0001!\t!\n\u0005\u0006S\u00011\tA\u000b\u0005\u0006w\u00011\t\u0001\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\u0006\u0019\u0002!\t!\u0014\u0005\t!\u0002A)\u0019!C\u0001#\")!\f\u0001C\u00017\"A\u0011\r\u0001EC\u0002\u0013%!\r\u0003\u0005m\u0001!\u0015\r\u0011\"\u0001n\u0011!q\u0007\u0001#b\u0001\n\u0003y\u0007\u0002\u00039\u0001\u0011\u000b\u0007I\u0011A9\b\u000bU$\u0002\u0012\u0001<\u0007\u000bM!\u0002\u0012A<\t\u000batA\u0011A=\t\u000b1sA\u0011\u0001>\t\u000b1sA\u0011A@\t\r1sA\u0011AA\u0005\u0005\u0019YU-_*fi*\u0011QCF\u0001\u0006[V\u001c\u0018n\u001a\u0006\u0003/a\taa\u0019:zaR|'BA\r\u001b\u0003!\u0011\u0017\u000e^2pS:\u001c(\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002MA\u0011qdJ\u0005\u0003Q\u0001\u0012A!\u00168ji\u0006!1.Z=t+\u0005Y\u0003c\u0001\u00175o9\u0011QF\r\b\u0003]Ej\u0011a\f\u0006\u0003aq\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005M\u0002\u0013a\u00029bG.\fw-Z\u0005\u0003kY\u0012aAV3di>\u0014(BA\u001a!!\tA\u0014(D\u0001\u0017\u0013\tQdC\u0001\tTG\"twN\u001d:Qk\nd\u0017nY&fs\u00061Ao^3bWN,\u0012!\u0010\t\u0004YQr\u0004CA A\u001b\u0005!\u0012BA!\u0015\u0005)iUoU5h)^,\u0017m[\u0001\u000bo&$\b\u000eV<fC.\u001cHC\u0001#F!\ty\u0004\u0001C\u0003G\t\u0001\u0007Q(A\u0005oK^$v/Z1lg\u00061A.\u001a8hi\",\u0012!\u0013\t\u0003?)K!a\u0013\u0011\u0003\u0007%sG/A\u0003baBd\u0017\u0010\u0006\u00028\u001d\")qJ\u0002a\u0001\u0013\u0006\t\u0011.A\u0005tKJL\u0017\r\\5{KV\t!\u000b\u0005\u0002T16\tAK\u0003\u0002V-\u0006!!-\u001b;t\u0015\u00059\u0016AB:d_\u0012,7-\u0003\u0002Z)\nQ!)\u001f;f-\u0016\u001cGo\u001c:\u0002\u0015-,\u00170Q4h\u0007>,g\r\u0006\u0002]?B\u0011\u0001(X\u0005\u0003=Z\u0011ABR5fY\u0012,E.Z7f]RDQ\u0001\u0019\u0005A\u0002]\n1a[3z\u0003}\u0019w.\u001c9vi\u0016\fum\u001a)vE.+\u00170\u00118e)^,\u0017m[\"p]R,\u0007\u0010^\u000b\u0002GB!q\u0004\u001a4j\u0013\t)\u0007E\u0001\u0004UkBdWM\r\t\u0003q\u001dL!\u0001\u001b\f\u0003\u0017\u0015\u001b\u0005+\u001e2mS\u000e\\U-\u001f\t\u0003\u007f)L!a\u001b\u000b\u0003#5+8+[4Uo\u0016\f7nQ8oi\u0016DH/A\u0005bO\u001e\u0004VOY&fsV\ta-\u0001\u0007uo\u0016\f7nQ8oi\u0016DH/F\u0001j\u00031\u0019XmY8oI.+\u0017p\u00149u+\u0005\u0011\bcA\u0010to%\u0011A\u000f\t\u0002\u0007\u001fB$\u0018n\u001c8\u0002\r-+\u0017pU3u!\tydb\u0005\u0002\u000f=\u00051A(\u001b8jiz\"\u0012A\u001e\u000b\u0003wz\u0004\"a\u0010?\n\u0005u$\"a\u0005'fq&\u001cwn\u001a:ba\"L7mS3z'\u0016$\b\"B\u0015\u0011\u0001\u0004YCcA>\u0002\u0002!1\u0011&\u0005a\u0001\u0003\u0007\u0001BaHA\u0003o%\u0019\u0011q\u0001\u0011\u0003\u0015q\u0012X\r]3bi\u0016$g\bF\u0003|\u0003\u0017\ti\u0001C\u0003*%\u0001\u00071\u0006C\u0003<%\u0001\u0007Q\b")
public interface KeySet {
    public Vector<SchnorrPublicKey> keys();

    public Vector<MuSigTweak> tweaks();

    public static /* synthetic */ KeySet withTweaks$(KeySet $this, Vector newTweaks) {
        return $this.withTweaks((Vector<MuSigTweak>)newTweaks);
    }

    default public KeySet withTweaks(Vector<MuSigTweak> newTweaks) {
        Predef$.MODULE$.require(this.tweaks().isEmpty(), (Function0 & Serializable)() -> "withTweaks is not meant for replacing tweaks");
        KeySet keySet = this;
        if (keySet instanceof LexicographicKeySet) {
            LexicographicKeySet lexicographicKeySet = (LexicographicKeySet)keySet;
            Vector<MuSigTweak> x$1 = newTweaks;
            Vector<SchnorrPublicKey> x$2 = lexicographicKeySet.copy$default$1();
            return lexicographicKeySet.copy(x$2, x$1);
        }
        if (keySet instanceof UnsortedKeySet) {
            UnsortedKeySet unsortedKeySet = (UnsortedKeySet)keySet;
            Vector<MuSigTweak> x$3 = newTweaks;
            Vector<SchnorrPublicKey> x$4 = unsortedKeySet.copy$default$1();
            return unsortedKeySet.copy(x$4, x$3);
        }
        throw new MatchError((Object)keySet);
    }

    public static /* synthetic */ int length$(KeySet $this) {
        return $this.length();
    }

    default public int length() {
        return this.keys().length();
    }

    public static /* synthetic */ SchnorrPublicKey apply$(KeySet $this, int i) {
        return $this.apply(i);
    }

    default public SchnorrPublicKey apply(int i) {
        return (SchnorrPublicKey)this.keys().apply(i);
    }

    public static /* synthetic */ ByteVector serialize$(KeySet $this) {
        return $this.serialize();
    }

    default public ByteVector serialize() {
        return (ByteVector)((IterableOnceOps)this.keys().map((Function1 & Serializable)x$1 -> x$1.bytes())).reduce((Function2 & Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3));
    }

    public static /* synthetic */ FieldElement keyAggCoef$(KeySet $this, SchnorrPublicKey key) {
        return $this.keyAggCoef(key);
    }

    default public FieldElement keyAggCoef(SchnorrPublicKey key) {
        if (this.secondKeyOpt().contains((Object)key)) {
            return (FieldElement)FieldElement$.MODULE$.one();
        }
        ByteVector listHashBytes = MuSigUtil$.MODULE$.aggListHash(this.serialize());
        ByteVector bytes = MuSigUtil$.MODULE$.aggCoefHash(listHashBytes.$plus$plus(key.bytes()));
        return (FieldElement)FieldElement$.MODULE$.apply(new BigInteger(1, bytes.toArray()));
    }

    public static /* synthetic */ Tuple2 org$bitcoins$crypto$musig$KeySet$$computeAggPubKeyAndTweakContext$(KeySet $this) {
        return $this.org$bitcoins$crypto$musig$KeySet$$computeAggPubKeyAndTweakContext();
    }

    default public Tuple2<ECPublicKey, MuSigTweakContext> org$bitcoins$crypto$musig$KeySet$$computeAggPubKeyAndTweakContext() {
        ECPublicKey untweakedAggPubKey = (ECPublicKey)((IterableOnceOps)this.keys().map((Function1 & Serializable)key -> {
            FieldElement coef = this.keyAggCoef((SchnorrPublicKey)key);
            return key.publicKey().multiply(coef);
        })).reduce((Function2 & Serializable)(x$4, x$5) -> x$4.add((ECPublicKey)x$5));
        return (Tuple2)this.tweaks().foldLeft((Object)new Tuple2((Object)untweakedAggPubKey, (Object)MuSigTweakContext$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                MuSigTweak tweak = (MuSigTweak)tuple2._2();
                if (tuple22 != null) {
                    ECPublicKey pubKeySoFar = (ECPublicKey)tuple22._1();
                    MuSigTweakContext context = (MuSigTweakContext)tuple22._2();
                    return context.applyTweak(tweak, pubKeySoFar);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static /* synthetic */ ECPublicKey aggPubKey$(KeySet $this) {
        return $this.aggPubKey();
    }

    default public ECPublicKey aggPubKey() {
        return (ECPublicKey)this.org$bitcoins$crypto$musig$KeySet$$computeAggPubKeyAndTweakContext()._1();
    }

    public static /* synthetic */ MuSigTweakContext tweakContext$(KeySet $this) {
        return $this.tweakContext();
    }

    default public MuSigTweakContext tweakContext() {
        return (MuSigTweakContext)this.org$bitcoins$crypto$musig$KeySet$$computeAggPubKeyAndTweakContext()._2();
    }

    public static /* synthetic */ Option secondKeyOpt$(KeySet $this) {
        return $this.secondKeyOpt();
    }

    default public Option<SchnorrPublicKey> secondKeyOpt() {
        return this.keys().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KeySet.$anonfun$secondKeyOpt$1(this, x$6)));
    }

    public static /* synthetic */ boolean $anonfun$secondKeyOpt$1(KeySet $this, SchnorrPublicKey x$6) {
        SchnorrPublicKey schnorrPublicKey = x$6;
        Object object = $this.keys().head();
        return schnorrPublicKey == null ? object != null : !((Object)schnorrPublicKey).equals(object);
    }

    public static void $init$(KeySet $this) {
    }
}

