/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto.musig;

import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.ECPrivateKey$;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.FieldElement$;
import org.bitcoins.crypto.SchnorrPublicKey;
import org.bitcoins.crypto.musig.MuSigNoncePriv;
import org.bitcoins.crypto.musig.MuSigUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class MuSigNoncePriv$
extends Factory<MuSigNoncePriv>
implements Serializable {
    public static final MuSigNoncePriv$ MODULE$ = new MuSigNoncePriv$();

    @Override
    public MuSigNoncePriv fromBytes(ByteVector bytes2) {
        Vector privs = (Vector)((StrictOptimizedIterableOps)ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.byteArrayOps(bytes2.toArray()), 32).toVector().map((Function1 & Serializable)x$11 -> ByteVector$.MODULE$.apply(x$11))).map((Function1 & Serializable)bytes -> ECPrivateKey$.MODULE$.fromBytes((ByteVector)bytes));
        return new MuSigNoncePriv((Vector<ECPrivateKey>)privs);
    }

    public MuSigNoncePriv genInternal(ByteVector preRand, Option<ECPrivateKey> privKeyOpt, Option<SchnorrPublicKey> aggPubKeyOpt, Option<ByteVector> msgOpt, Option<ByteVector> extraInOpt) {
        ByteVector byteVector;
        Predef$.MODULE$.require(preRand.length() == 32L, (Function0 & Serializable)() -> new StringBuilder(44).append("32 bytes of entropy must be provided, found ").append(preRand).toString());
        Predef$.MODULE$.require(msgOpt.forall((Function1 & Serializable)msg -> BoxesRunTime.boxToBoolean((boolean)MuSigNoncePriv$.$anonfun$genInternal$2(msg))), (Function0 & Serializable)() -> new StringBuilder(49).append("The message to be signed must be 32 bytes, found ").append(msgOpt).toString());
        Predef$.MODULE$.require(extraInOpt.forall((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MuSigNoncePriv$.$anonfun$genInternal$4(x$12))), (Function0 & Serializable)() -> "extraIn too long, its length must be represented by at most four bytes");
        Option<ECPrivateKey> option = privKeyOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            ECPrivateKey privKey = (ECPrivateKey)some.value();
            byteVector = MuSigUtil$.MODULE$.auxHash(preRand).xor(privKey.bytes());
        } else if (None$.MODULE$.equals(option)) {
            byteVector = preRand;
        } else {
            throw new MatchError(option);
        }
        ByteVector rand = byteVector;
        ByteVector aggPubKeyBytes = MuSigNoncePriv$.serializeWithLen$1(aggPubKeyOpt.map((Function1 & Serializable)x$13 -> x$13.bytes()), MuSigNoncePriv$.serializeWithLen$default$2$1());
        ByteVector msgBytes = MuSigNoncePriv$.serializeWithLen$1(msgOpt, MuSigNoncePriv$.serializeWithLen$default$2$1());
        ByteVector extraInBytes = MuSigNoncePriv$.serializeWithLen$1(extraInOpt, 4);
        ByteVector dataBytes = rand.$plus$plus(aggPubKeyBytes).$plus$plus(msgBytes).$plus$plus(extraInBytes);
        Vector privNonceKeys = (Vector)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MuSigUtil$.MODULE$.nonceNum()).toVector().map((Function1 & Serializable)index -> MuSigNoncePriv$.$anonfun$genInternal$7(dataBytes, BoxesRunTime.unboxToInt((Object)index)));
        return new MuSigNoncePriv((Vector<ECPrivateKey>)privNonceKeys);
    }

    public MuSigNoncePriv gen(Option<ECPrivateKey> privKeyOpt, Option<SchnorrPublicKey> aggPubKeyOpt, Option<ByteVector> msgOpt, Option<ByteVector> extraInOpt) {
        ByteVector preRand = CryptoUtil$.MODULE$.randomBytes(32);
        return this.genInternal(preRand, privKeyOpt, aggPubKeyOpt, msgOpt, extraInOpt);
    }

    public Option<ECPrivateKey> genInternal$default$2() {
        return None$.MODULE$;
    }

    public Option<SchnorrPublicKey> genInternal$default$3() {
        return None$.MODULE$;
    }

    public Option<ByteVector> genInternal$default$4() {
        return None$.MODULE$;
    }

    public Option<ByteVector> genInternal$default$5() {
        return None$.MODULE$;
    }

    public Option<ECPrivateKey> gen$default$1() {
        return None$.MODULE$;
    }

    public Option<SchnorrPublicKey> gen$default$2() {
        return None$.MODULE$;
    }

    public Option<ByteVector> gen$default$3() {
        return None$.MODULE$;
    }

    public Option<ByteVector> gen$default$4() {
        return None$.MODULE$;
    }

    public MuSigNoncePriv apply(Vector<ECPrivateKey> privNonces) {
        return new MuSigNoncePriv(privNonces);
    }

    public Option<Vector<ECPrivateKey>> unapply(MuSigNoncePriv x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some(x$0.privNonces());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MuSigNoncePriv$.class);
    }

    public static final /* synthetic */ boolean $anonfun$genInternal$2(ByteVector msg) {
        return msg.length() == 32L;
    }

    public static final /* synthetic */ boolean $anonfun$genInternal$4(ByteVector x$12) {
        return x$12.length() <= 0xFFFFFFFFL;
    }

    private static final ByteVector serializeWithLen$1(Option bytesOpt, int lengthSize) {
        Option option = bytesOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteVector bytes = (ByteVector)some.value();
            return ByteVector$.MODULE$.fromLong(bytes.length(), lengthSize, ByteVector$.MODULE$.fromLong$default$3()).$plus$plus(bytes);
        }
        if (None$.MODULE$.equals(option)) {
            return ByteVector$.MODULE$.fromLong(0L, lengthSize, ByteVector$.MODULE$.fromLong$default$3());
        }
        throw new MatchError((Object)option);
    }

    private static final int serializeWithLen$default$2$1() {
        return 1;
    }

    public static final /* synthetic */ ECPrivateKey $anonfun$genInternal$7(ByteVector dataBytes$1, int index) {
        ByteVector indexByte = ByteVector$.MODULE$.fromByte((byte)index);
        ByteVector noncePreBytes = MuSigUtil$.MODULE$.nonHash(dataBytes$1.$plus$plus(indexByte));
        BigInteger noncePreNum = new BigInteger(1, noncePreBytes.toArray());
        return ((FieldElement)FieldElement$.MODULE$.apply(noncePreNum)).toPrivateKey();
    }

    private MuSigNoncePriv$() {
    }
}

