/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto.musig;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.EvenParity$;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.FieldElement$;
import org.bitcoins.crypto.KeyParity;
import org.bitcoins.crypto.OddParity$;
import org.bitcoins.crypto.SchnorrDigitalSignature;
import org.bitcoins.crypto.SchnorrPublicKey;
import org.bitcoins.crypto.musig.KeySet;
import org.bitcoins.crypto.musig.MuSigNoncePriv;
import org.bitcoins.crypto.musig.MuSigNoncePub;
import org.bitcoins.crypto.musig.MuSigNoncePub$;
import org.bitcoins.crypto.musig.MuSigTweakData;
import org.bitcoins.crypto.musig.ParityMultiplier;
import org.bitcoins.crypto.musig.ParityMultiplier$;
import org.bitcoins.crypto.musig.SigningSession;
import org.bitcoins.crypto.musig.SigningSession$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Vector;
import scodec.bits.ByteVector;

public final class MuSigUtil$ {
    public static final MuSigUtil$ MODULE$ = new MuSigUtil$();
    private static final int nonceNum = 2;

    public int nonceNum() {
        return nonceNum;
    }

    public ByteVector aggListHash(ByteVector bytes) {
        return CryptoUtil$.MODULE$.taggedSha256(bytes, "KeyAgg list").bytes();
    }

    public ByteVector aggCoefHash(ByteVector bytes) {
        return CryptoUtil$.MODULE$.taggedSha256(bytes, "KeyAgg coefficient").bytes();
    }

    public ByteVector nonHash(ByteVector bytes) {
        return CryptoUtil$.MODULE$.taggedSha256(bytes, "MuSig/nonce").bytes();
    }

    public ByteVector nonCoefHash(ByteVector bytes) {
        return CryptoUtil$.MODULE$.taggedSha256(bytes, "MuSig/noncecoef").bytes();
    }

    public ByteVector auxHash(ByteVector bytes) {
        return CryptoUtil$.MODULE$.taggedSha256(bytes, "MuSig/aux").bytes();
    }

    public <T> T nonceSum(Vector<T> nonces, FieldElement b, Function2<T, T, T> add, Function2<T, FieldElement, T> multiply, T identity) {
        return (T)((Tuple2)nonces.foldLeft((Object)new Tuple2(FieldElement$.MODULE$.one(), identity), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object nonce = tuple2._2();
                if (tuple22 != null) {
                    FieldElement pow = (FieldElement)tuple22._1();
                    Object sumSoFar = tuple22._2();
                    Object prod = multiply.apply(nonce, (Object)pow);
                    return new Tuple2((Object)pow.multiply(b), add.apply(sumSoFar, prod));
                }
            }
            throw new MatchError((Object)tuple2);
        }))._2();
    }

    public Tuple2<ECPublicKey, FieldElement> sign(MuSigNoncePriv noncePriv, MuSigNoncePub aggNoncePub, ECPrivateKey privKey, ByteVector message, KeySet keySet) {
        MuSigNoncePriv muSigNoncePriv;
        ECPublicKey pubKey = privKey.publicKey();
        FieldElement coef = keySet.keyAggCoef(pubKey.schnorrPublicKey());
        SigningSession signingSession = SigningSession$.MODULE$.apply(aggNoncePub, keySet, message);
        if (signingSession == null) {
            throw new MatchError((Object)signingSession);
        }
        FieldElement b = signingSession.b();
        ECPublicKey aggNonce = signingSession.aggNonce();
        FieldElement e = signingSession.e();
        Tuple3 tuple3 = new Tuple3((Object)b, (Object)aggNonce, (Object)e);
        FieldElement b2 = (FieldElement)tuple3._1();
        ECPublicKey aggNonce2 = (ECPublicKey)tuple3._2();
        FieldElement e2 = (FieldElement)tuple3._3();
        KeyParity keyParity = aggNonce2.parity();
        if (EvenParity$.MODULE$.equals(keyParity)) {
            muSigNoncePriv = noncePriv;
        } else if (OddParity$.MODULE$.equals(keyParity)) {
            muSigNoncePriv = noncePriv.negate();
        } else {
            throw new MatchError((Object)keyParity);
        }
        MuSigNoncePriv adjustedNoncePriv = muSigNoncePriv;
        ParityMultiplier gp = ParityMultiplier$.MODULE$.fromParity(pubKey.parity());
        ParityMultiplier g = ParityMultiplier$.MODULE$.fromParity(keySet.aggPubKey().parity());
        FieldElement adjustedPrivKey = gp.multiply(g).multiply(keySet.tweakContext().parityAcc()).modify(privKey.fieldElement());
        FieldElement privNonceSum = adjustedNoncePriv.sumToKey(b2);
        FieldElement s = adjustedPrivKey.multiply(e2).multiply(coef).add(privNonceSum);
        Predef$.MODULE$.require(this.partialSigVerify(s, noncePriv.toPublicNonces(), pubKey.schnorrPublicKey(), keySet, b2, aggNonce2, e2), (Function0 & Serializable)() -> "Failed verification when generating signature.");
        return new Tuple2((Object)aggNonce2, (Object)s);
    }

    public boolean partialSigVerify(FieldElement partialSig, Vector<MuSigNoncePub> pubNonces, KeySet keySet, ByteVector message, int signerIndex) {
        Predef$.MODULE$.require(signerIndex >= 0 && signerIndex < keySet.length(), (Function0 & Serializable)() -> new StringBuilder(34).append("Invalid signer index ").append(signerIndex).append(" for ").append(keySet.length()).append(" signers").toString());
        return this.partialSigVerify(partialSig, (MuSigNoncePub)pubNonces.apply(signerIndex), MuSigNoncePub$.MODULE$.aggregate(pubNonces), keySet.apply(signerIndex), keySet, message);
    }

    public boolean partialSigVerify(FieldElement partialSig, MuSigNoncePub noncePub, MuSigNoncePub aggNoncePub, SchnorrPublicKey pubKey, KeySet keySet, ByteVector message) {
        SigningSession signingSession = SigningSession$.MODULE$.apply(aggNoncePub, keySet, message);
        if (signingSession == null) {
            throw new MatchError((Object)signingSession);
        }
        FieldElement b = signingSession.b();
        ECPublicKey aggNonce = signingSession.aggNonce();
        FieldElement e = signingSession.e();
        Tuple3 tuple3 = new Tuple3((Object)b, (Object)aggNonce, (Object)e);
        FieldElement b2 = (FieldElement)tuple3._1();
        ECPublicKey aggNonce2 = (ECPublicKey)tuple3._2();
        FieldElement e2 = (FieldElement)tuple3._3();
        return this.partialSigVerify(partialSig, noncePub, pubKey, keySet, b2, aggNonce2, e2);
    }

    public boolean partialSigVerify(FieldElement partialSig, MuSigNoncePub noncePub, SchnorrPublicKey pubKey, KeySet keySet, FieldElement b, ECPublicKey aggNonce, FieldElement e) {
        ECPublicKey eCPublicKey;
        ECPublicKey nonceSum = noncePub.sumToKey(b);
        KeyParity keyParity = aggNonce.parity();
        if (EvenParity$.MODULE$.equals(keyParity)) {
            eCPublicKey = nonceSum;
        } else if (OddParity$.MODULE$.equals(keyParity)) {
            eCPublicKey = nonceSum.negate();
        } else {
            throw new MatchError((Object)keyParity);
        }
        ECPublicKey nonceSumAdjusted = eCPublicKey;
        ParityMultiplier g = ParityMultiplier$.MODULE$.fromParity(keySet.aggPubKey().parity());
        KeyParity aggKeyParity = g.multiply(keySet.tweakContext().parityAcc()).toParity();
        ECPublicKey aggKey = pubKey.toXOnly().publicKey(aggKeyParity);
        FieldElement a = keySet.keyAggCoef(pubKey);
        ECPublicKey eCPublicKey2 = partialSig.getPublicKey();
        ECPublicKey eCPublicKey3 = nonceSumAdjusted.add(aggKey.multiply(e.multiply(a)));
        return !(eCPublicKey2 != null ? !((Object)eCPublicKey2).equals(eCPublicKey3) : eCPublicKey3 != null);
    }

    public SchnorrDigitalSignature signAgg(Vector<FieldElement> sVals, MuSigNoncePub aggNoncePub, KeySet keySet, ByteVector message) {
        SigningSession signingSession = SigningSession$.MODULE$.apply(aggNoncePub, keySet, message);
        if (signingSession == null) {
            throw new MatchError((Object)signingSession);
        }
        ECPublicKey aggNonce = signingSession.aggNonce();
        FieldElement e = signingSession.e();
        Tuple2 tuple2 = new Tuple2((Object)aggNonce, (Object)e);
        ECPublicKey aggNonce2 = (ECPublicKey)tuple2._1();
        FieldElement e2 = (FieldElement)tuple2._2();
        MuSigTweakData tweakData = new MuSigTweakData(keySet.tweakContext(), keySet.aggPubKey().parity(), e2);
        return this.signAgg(sVals, aggNonce2, (Option<MuSigTweakData>)new Some((Object)tweakData));
    }

    public SchnorrDigitalSignature signAgg(Vector<FieldElement> sVals, ECPublicKey aggPubNonce, Option<MuSigTweakData> tweakDataOpt) {
        FieldElement fieldElement;
        FieldElement sSum = (FieldElement)sVals.reduce((Function2 & Serializable)(x$4, x$5) -> x$4.add(x$5));
        Option<MuSigTweakData> option = tweakDataOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            MuSigTweakData tweakData = (MuSigTweakData)some.value();
            fieldElement = sSum.add(tweakData.additiveTweak());
        } else if (None$.MODULE$.equals(option)) {
            fieldElement = sSum;
        } else {
            throw new MatchError(option);
        }
        FieldElement s = fieldElement;
        return new SchnorrDigitalSignature(aggPubNonce.schnorrNonce(), s);
    }

    public Option<MuSigTweakData> signAgg$default$3() {
        return None$.MODULE$;
    }

    private MuSigUtil$() {
    }
}

