/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto.musig;

import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.FieldElement$;
import org.bitcoins.crypto.SchnorrPublicKey;
import org.bitcoins.crypto.musig.KeySet;
import org.bitcoins.crypto.musig.MuSigNoncePub;
import org.bitcoins.crypto.musig.MuSigUtil$;
import org.bitcoins.crypto.musig.SigningSession;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.runtime.ModuleSerializationProxy;
import scodec.bits.ByteVector;

public final class SigningSession$
implements Serializable {
    public static final SigningSession$ MODULE$ = new SigningSession$();

    public FieldElement computeB(MuSigNoncePub aggNoncePub, KeySet keySet, ByteVector message) {
        SchnorrPublicKey aggPubKey = keySet.aggPubKey().schnorrPublicKey();
        ByteVector bHash = MuSigUtil$.MODULE$.nonCoefHash(aggNoncePub.bytes().$plus$plus(aggPubKey.bytes()).$plus$plus(message));
        return (FieldElement)FieldElement$.MODULE$.apply(new BigInteger(1, bHash.toArray()));
    }

    public FieldElement computeE(SchnorrPublicKey aggPubKey, ECPublicKey aggNonce, ByteVector message) {
        ByteVector eBytes = CryptoUtil$.MODULE$.sha256SchnorrChallenge(aggNonce.schnorrNonce().bytes().$plus$plus(aggPubKey.bytes()).$plus$plus(message)).bytes();
        return (FieldElement)FieldElement$.MODULE$.apply(new BigInteger(1, eBytes.toArray()));
    }

    public SigningSession getSessionValues(MuSigNoncePub aggNoncePub, KeySet keySet, ByteVector message) {
        SchnorrPublicKey aggPubKey = keySet.aggPubKey().schnorrPublicKey();
        FieldElement b = this.computeB(aggNoncePub, keySet, message);
        ECPublicKey aggNonce = aggNoncePub.sumToKey(b);
        FieldElement e = this.computeE(aggPubKey, aggNonce, message);
        return new SigningSession(b, aggNonce, e);
    }

    public SigningSession apply(MuSigNoncePub aggNoncePub, KeySet keySet, ByteVector message) {
        return this.getSessionValues(aggNoncePub, keySet, message);
    }

    public SigningSession apply(FieldElement b, ECPublicKey aggNonce, FieldElement e) {
        return new SigningSession(b, aggNonce, e);
    }

    public Option<Tuple3<FieldElement, ECPublicKey, FieldElement>> unapply(SigningSession x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.b(), (Object)x$0.aggNonce(), (Object)x$0.e()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SigningSession$.class);
    }

    private SigningSession$() {
    }
}

