/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.db;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.bitcoins.commons.file.FileUtil$;
import org.bitcoins.db.SQLiteUtil$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class DatadirUtil$ {
    public static DatadirUtil$ MODULE$;

    static {
        new DatadirUtil$();
    }

    public Try<Path> zipDatadir(Path source, Path target) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            Path path;
            if (Files.exists(target, new LinkOption[0])) {
                throw new IOException(new StringBuilder(48).append("Cannot zip datadir. Target file already exists: ").append(target).toString());
            }
            Path temp = Files.createTempDirectory(source, "backup", new FileAttribute[0]);
            try {
                Regex tempRE = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(6).append(".*/").append(temp.getFileName()).append("/.*").toString())).r();
                FileUtil$.MODULE$.copyDirectory(source, temp, (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Regex[]{new StringOps(Predef$.MODULE$.augmentString(".*.sqlite$")).r(), new StringOps(Predef$.MODULE$.augmentString(".*.sqlite-shm$")).r(), new StringOps(Predef$.MODULE$.augmentString(".*.sqlite-wal$")).r(), new StringOps(Predef$.MODULE$.augmentString(".*bitcoin-s.log$")).r(), new StringOps(Predef$.MODULE$.augmentString(".*/seeds/.*")).r(), new StringOps(Predef$.MODULE$.augmentString(".*/tor/.*")).r(), new StringOps(Predef$.MODULE$.augmentString(".*/binaries/.*")).r(), new StringOps(Predef$.MODULE$.augmentString(".*.zip$")).r(), new StringOps(Predef$.MODULE$.augmentString(".*.DS_Store")).r(), tempRE})));
                SQLiteUtil$.MODULE$.backupDirectory(source, temp, (Vector<Regex>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Regex[]{new StringOps(Predef$.MODULE$.augmentString(".*chaindb.sqlite$")).r(), tempRE}))), SQLiteUtil$.MODULE$.backupDirectory$default$4());
                path = FileUtil$.MODULE$.zipDirectory(temp, target, FileUtil$.MODULE$.zipDirectory$default$3());
            }
            finally {
                FileUtil$.MODULE$.removeDirectory(temp);
            }
            return path;
        });
    }

    private DatadirUtil$() {
        MODULE$ = this;
    }
}

