/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.db;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.bitcoins.commons.config.AppConfig;
import org.bitcoins.commons.config.AppConfig$;
import org.bitcoins.commons.config.package;
import org.bitcoins.commons.config.package$;
import org.bitcoins.db.DatabaseDriver;
import org.bitcoins.db.DatabaseDriver$PostgreSQL$;
import org.bitcoins.db.DatabaseDriver$SQLite$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import slick.basic.DatabaseConfig;
import slick.basic.DatabaseConfig$;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0004\b\u0002\u0002UAQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005B\rB\u0001\u0002\r\u0001\t\u0006\u0004%\t!\r\u0005\tk\u0001A)\u0019!C\u0001m!A!\t\u0001EC\u0002\u0013\u00051\t\u0003\u0005O\u0001!\u0015\r\u0011\"\u00017\u0011!y\u0005\u0001#b\u0001\n\u00031\u0004\u0002\u0003)\u0001\u0011\u000b\u0007I\u0011A)\t\u0011U\u0003\u0001R1A\u0005\u0002YC\u0001B\u0017\u0001\t\u0006\u0004%\ta\u0017\u0005\tU\u0002A)\u0019!C\u0001W\"Aq\u000e\u0001EC\u0002\u0013\u0005\u0001OA\u0006EE\u0006\u0003\boQ8oM&<'BA\b\u0011\u0003\t!'M\u0003\u0002\u0012%\u0005A!-\u001b;d_&t7OC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u000511m\u001c8gS\u001eT!a\u0007\t\u0002\u000f\r|W.\\8og&\u0011Q\u0004\u0007\u0002\n\u0003B\u00048i\u001c8gS\u001e\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\b\u0002\tM$x\u000e\u001d\u000b\u0002IA\u0019QE\u000b\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0015\r|gnY;se\u0016tGOC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tYcE\u0001\u0004GkR,(/\u001a\t\u0003[9j\u0011\u0001K\u0005\u0003_!\u0012A!\u00168ji\u00061AM]5wKJ,\u0012A\r\t\u0003CMJ!\u0001\u000e\b\u0003\u001d\u0011\u000bG/\u00192bg\u0016$%/\u001b<fe\u00069!\u000e\u001a2d+JdW#A\u001c\u0011\u0005azdBA\u001d>!\tQ\u0004&D\u0001<\u0015\taD#\u0001\u0004=e>|GOP\u0005\u0003}!\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011a\bK\u0001\u0007I\n\u0004\u0016\r\u001e5\u0016\u0003\u0011\u0003\"!\u0012'\u000e\u0003\u0019S!a\u0012%\u0002\t\u0019LG.\u001a\u0006\u0003\u0013*\u000b1A\\5p\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014$\u0003\tA\u000bG\u000f[\u0001\u0007I\nt\u0015-\\3\u0002\r\u0011\u0014\u0007j\\:u\u0003\u0019!'\rU8siV\t!\u000b\u0005\u0002.'&\u0011A\u000b\u000b\u0002\u0004\u0013:$\u0018AC:dQ\u0016l\u0017MT1nKV\tq\u000bE\u0002.1^J!!\u0017\u0015\u0003\r=\u0003H/[8o\u00035\u0019H.[2l\t\n\u001cuN\u001c4jOV\tA\fE\u0002^E\u0012l\u0011A\u0018\u0006\u0003?\u0002\fQAY1tS\u000eT\u0011!Y\u0001\u0006g2L7m[\u0005\u0003Gz\u0013a\u0002R1uC\n\f7/Z\"p]\u001aLw\r\u0005\u0002fQ6\taM\u0003\u0002hA\u0006!!\u000e\u001a2d\u0013\tIgMA\u0006KI\n\u001c\u0007K]8gS2,\u0017AF5t\u0011&\\\u0017M]5M_\u001e<\u0017N\\4F]\u0006\u0014G.\u001a3\u0016\u00031\u0004\"!L7\n\u00059D#a\u0002\"p_2,\u0017M\\\u0001\u0016Q&\\\u0017M]5M_\u001e<\u0017N\\4J]R,'O^1m+\u0005\t\bcA\u0017YeB\u00111O^\u0007\u0002i*\u0011QOJ\u0001\tIV\u0014\u0018\r^5p]&\u0011q\u000f\u001e\u0002\t\tV\u0014\u0018\r^5p]\u0002")
public abstract class DbAppConfig
extends AppConfig {
    private DatabaseDriver driver;
    private String jdbcUrl;
    private Path dbPath;
    private String dbName;
    private String dbHost;
    private int dbPort;
    private Option<String> schemaName;
    private DatabaseConfig<JdbcProfile> slickDbConfig;
    private boolean isHikariLoggingEnabled;
    private Option<Duration> hikariLoggingInterval;
    private volatile int bitmap$0;

    public Future<BoxedUnit> stop() {
        ((JdbcBackend.DatabaseDef)this.slickDbConfig().db()).close();
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private DatabaseDriver driver$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 1) == 0) {
                DatabaseDriver databaseDriver;
                String driverStr = this.getConfigString(new StringBuilder(20).append("bitcoin-s.").append(this.moduleName()).append(".db.driver").toString()).toLowerCase();
                if (driverStr.contains("sqlite")) {
                    databaseDriver = DatabaseDriver$SQLite$.MODULE$;
                } else if (driverStr.contains("postgres")) {
                    databaseDriver = DatabaseDriver$PostgreSQL$.MODULE$;
                } else {
                    throw scala.sys.package$.MODULE$.error(new StringBuilder(43).append("Could not find a DatabaseDriver for string=").append(driverStr).toString());
                }
                this.driver = databaseDriver;
                this.bitmap$0 |= 1;
            }
        }
        return this.driver;
    }

    public DatabaseDriver driver() {
        return (this.bitmap$0 & 1) == 0 ? this.driver$lzycompute() : this.driver;
    }

    private String jdbcUrl$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 2) == 0) {
                String string;
                DatabaseDriver databaseDriver = this.driver();
                if (DatabaseDriver$SQLite$.MODULE$.equals(databaseDriver)) {
                    string = new StringBuilder(15).append("\"jdbc:sqlite:\"").append(AppConfig$.MODULE$.safePathToString(this.dbPath())).append("/").append(this.dbName()).toString();
                } else if (DatabaseDriver$PostgreSQL$.MODULE$.equals(databaseDriver)) {
                    string = new StringBuilder(22).append("\"jdbc:postgresql://").append(this.dbHost()).append(":").append(this.dbPort()).append("/").append(this.dbName()).append("\"").toString();
                } else {
                    throw new MatchError((Object)databaseDriver);
                }
                this.jdbcUrl = string;
                this.bitmap$0 |= 2;
            }
        }
        return this.jdbcUrl;
    }

    public String jdbcUrl() {
        return (this.bitmap$0 & 2) == 0 ? this.jdbcUrl$lzycompute() : this.jdbcUrl;
    }

    private Path dbPath$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 4) == 0) {
                Option pathStrOpt = this.getConfigStringOpt(new StringBuilder(18).append("bitcoin-s.").append(this.moduleName()).append(".db.path").toString());
                Option option = pathStrOpt;
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw scala.sys.package$.MODULE$.error(new StringBuilder(34).append("Could not find dbPath for ").append(this.moduleName()).append(".db.path").toString());
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String pathStr = (String)some.value();
                Path path = Paths.get(pathStr, new String[0]);
                this.dbPath = path;
                this.bitmap$0 |= 4;
            }
        }
        return this.dbPath;
    }

    public Path dbPath() {
        return (this.bitmap$0 & 4) == 0 ? this.dbPath$lzycompute() : this.dbPath;
    }

    private String dbName$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 8) == 0) {
                String string;
                String name = this.getConfigString(new StringBuilder(18).append("bitcoin-s.").append(this.moduleName()).append(".db.name").toString());
                DatabaseDriver databaseDriver = this.driver();
                if (DatabaseDriver$SQLite$.MODULE$.equals(databaseDriver)) {
                    string = new StringBuilder(7).append(name).append(".sqlite").toString();
                } else if (DatabaseDriver$PostgreSQL$.MODULE$.equals(databaseDriver)) {
                    string = name;
                } else {
                    throw new MatchError((Object)databaseDriver);
                }
                this.dbName = string;
                this.bitmap$0 |= 8;
            }
        }
        return this.dbName;
    }

    public String dbName() {
        return (this.bitmap$0 & 8) == 0 ? this.dbName$lzycompute() : this.dbName;
    }

    private String dbHost$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 0x10) == 0) {
                String string;
                Option hostOpt = this.getConfigStringOpt(new StringBuilder(18).append("bitcoin-s.").append(this.moduleName()).append(".db.host").toString());
                Option option = hostOpt;
                if (option instanceof Some) {
                    String host;
                    Some some = (Some)option;
                    string = host = (String)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    string = "localhost";
                } else {
                    throw new MatchError((Object)option);
                }
                this.dbHost = string;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.dbHost;
    }

    public String dbHost() {
        return (this.bitmap$0 & 0x10) == 0 ? this.dbHost$lzycompute() : this.dbHost;
    }

    private int dbPort$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 0x20) == 0) {
                int n;
                Option portOpt = package.ConfigOps$.MODULE$.getIntOpt$extension(package$.MODULE$.ConfigOps(this.config()), new StringBuilder(18).append("bitcoin-s.").append(this.moduleName()).append(".db.port").toString());
                Option option = portOpt;
                if (option instanceof Some) {
                    int port;
                    Some some = (Some)option;
                    n = port = BoxesRunTime.unboxToInt((Object)some.value());
                } else if (None$.MODULE$.equals(option)) {
                    n = 5432;
                } else {
                    throw new MatchError((Object)option);
                }
                this.dbPort = n;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.dbPort;
    }

    public int dbPort() {
        return (this.bitmap$0 & 0x20) == 0 ? this.dbPort$lzycompute() : this.dbPort;
    }

    private Option<String> schemaName$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 0x40) == 0) {
                Some some;
                DatabaseDriver databaseDriver = this.driver();
                if (DatabaseDriver$PostgreSQL$.MODULE$.equals(databaseDriver)) {
                    some = new Some((Object)this.moduleName());
                } else if (DatabaseDriver$SQLite$.MODULE$.equals(databaseDriver)) {
                    some = None$.MODULE$;
                } else {
                    throw new MatchError((Object)databaseDriver);
                }
                this.schemaName = some;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.schemaName;
    }

    public Option<String> schemaName() {
        return (this.bitmap$0 & 0x40) == 0 ? this.schemaName$lzycompute() : this.schemaName;
    }

    private DatabaseConfig<JdbcProfile> slickDbConfig$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 0x80) == 0) {
                DatabaseConfig value;
                Config overrideConf = ConfigFactory.parseString((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(184).append("\n         |bitcoin-s {\n         |  ").append(this.moduleName()).append(" {\n         |     db {\n         |        path = ").append(AppConfig$.MODULE$.safePathToString(this.dbPath())).append("\n         |        name = ").append(this.dbName()).append("\n         |        url = ").append(this.jdbcUrl()).append("\n         |     }\n         |  }\n         |}\n      ").toString())).stripMargin());
                Config usedConf = overrideConf.withFallback((ConfigMergeable)this.config());
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    void var2_2;
                    DatabaseConfig c = DatabaseConfig$.MODULE$.forConfig(new StringBuilder(10).append("bitcoin-s.").append(this.moduleName()).toString(), usedConf, DatabaseConfig$.MODULE$.forConfig$default$3(), ClassTag$.MODULE$.apply(JdbcProfile.class));
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Resolved DB config: ").append(package.ConfigOps$.MODULE$.asReadableJson$extension(package$.MODULE$.ConfigOps(c.config()))).toString());
                    return var2_2;
                });
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error when loading database from config: ").append(exception).toString());
                        this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Configuration: ").append(package.ConfigOps$.MODULE$.asReadableJson$extension(package$.MODULE$.ConfigOps(usedConf))).toString());
                        throw exception;
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                DatabaseConfig databaseConfig = value = (DatabaseConfig)success.value();
                this.slickDbConfig = databaseConfig;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.slickDbConfig;
    }

    public DatabaseConfig<JdbcProfile> slickDbConfig() {
        return (this.bitmap$0 & 0x80) == 0 ? this.slickDbConfig$lzycompute() : this.slickDbConfig;
    }

    private boolean isHikariLoggingEnabled$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 0x100) == 0) {
                boolean bl;
                Option hikariLoggingOpt = package.ConfigOps$.MODULE$.getBooleanOpt$extension(package$.MODULE$.ConfigOps(this.config()), new StringBuilder(25).append("bitcoin-s.").append(this.moduleName()).append(".hikari-logging").toString());
                Option option = hikariLoggingOpt;
                if (option instanceof Some) {
                    boolean bool;
                    Some some = (Some)option;
                    bl = bool = BoxesRunTime.unboxToBoolean((Object)some.value());
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                this.isHikariLoggingEnabled = bl;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.isHikariLoggingEnabled;
    }

    public boolean isHikariLoggingEnabled() {
        return (this.bitmap$0 & 0x100) == 0 ? this.isHikariLoggingEnabled$lzycompute() : this.isHikariLoggingEnabled;
    }

    private Option<Duration> hikariLoggingInterval$lzycompute() {
        DbAppConfig dbAppConfig = this;
        synchronized (dbAppConfig) {
            if ((this.bitmap$0 & 0x200) == 0) {
                None$ none$;
                if (this.isHikariLoggingEnabled()) {
                    Duration duration;
                    Option intervalOpt = package.ConfigOps$.MODULE$.getDurationOpt$extension(package$.MODULE$.ConfigOps(this.config()), new StringBuilder(34).append("bitcoin-s.").append(this.moduleName()).append(".hikari-logging-interval").toString());
                    Option option = intervalOpt;
                    if (option instanceof Some) {
                        Duration interval;
                        Some some = (Some)option;
                        duration = interval = (Duration)some.value();
                    } else if (None$.MODULE$.equals(option)) {
                        duration = new FiniteDuration(1L, TimeUnit.MINUTES);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    Duration interval = duration;
                    none$ = new Some((Object)interval);
                } else {
                    none$ = None$.MODULE$;
                }
                this.hikariLoggingInterval = none$;
                this.bitmap$0 |= 0x200;
            }
        }
        return this.hikariLoggingInterval;
    }

    public Option<Duration> hikariLoggingInterval() {
        return (this.bitmap$0 & 0x200) == 0 ? this.hikariLoggingInterval$lzycompute() : this.hikariLoggingInterval;
    }
}

