/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.db;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import org.slf4j.Marker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class SQLiteUtil$
implements Logging {
    public static SQLiteUtil$ MODULE$;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SQLiteUtil$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SQLiteUtil$ sQLiteUtil$ = this;
        synchronized (sQLiteUtil$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String pathToJdbcUrl(Path path) {
        return new StringBuilder(12).append("jdbc:sqlite:").append(path.toAbsolutePath()).toString();
    }

    public void backupDirectory(Path source, Path target, Vector<Regex> fileNameFilter, String dbExtension) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Files.list(source).toArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> (Path)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            SQLiteUtil$.$anonfun$backupDirectory$2(fileNameFilter, target, dbExtension, file);
            return BoxedUnit.UNIT;
        });
    }

    public void backup(String jdbcUrl, Path backupFilePath) {
        block4: {
            try (Connection conn = DriverManager.getConnection(jdbcUrl);){
                boolean doesntExistAndPArentIsWritable;
                boolean existsAndWritable = Files.exists(backupFilePath, new LinkOption[0]) && Files.isWritable(backupFilePath);
                boolean bl = doesntExistAndPArentIsWritable = !Files.exists(backupFilePath, new LinkOption[0]) && Files.isWritable(backupFilePath.getParent());
                if (existsAndWritable || doesntExistAndPArentIsWritable) {
                    int _ = conn.createStatement().executeUpdate(new StringBuilder(10).append("BACKUP TO ").append(backupFilePath).toString());
                    break block4;
                }
                throw new IOException(new StringBuilder(36).append("Backup destination is not writable: ").append(backupFilePath).toString());
            }
        }
    }

    public Vector<Regex> backupDirectory$default$3() {
        return package$.MODULE$.Vector().empty();
    }

    public String backupDirectory$default$4() {
        return ".sqlite";
    }

    public void setJournalMode(String jdbcUrl, String mode) {
        try (Connection conn = DriverManager.getConnection(jdbcUrl);){
            int _ = conn.createStatement().executeUpdate(new StringBuilder(20).append("PRAGMA journal_mode=").append(mode.toUpperCase()).toString());
        }
    }

    public void createDbFileIfDNE(Path dbPath, String dbName) {
        block0: {
            if (Files.exists(dbPath, new LinkOption[0])) break block0;
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Creating database directory=").append(dbPath).toString());
            Files.createDirectories(dbPath, new FileAttribute[0]);
            Path dbFilePath = dbPath.resolve(dbName);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Creating database file=").append(dbFilePath).toString());
            Path path = Files.createFile(dbFilePath, new FileAttribute[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$backupDirectory$3(Path file$1, Regex reg) {
        return ((Object)file$1.toAbsolutePath()).toString().matches(reg.regex());
    }

    public static final /* synthetic */ void $anonfun$backupDirectory$2(Vector fileNameFilter$1, Path target$1, String dbExtension$1, Path file) {
        block1: {
            block2: {
                block0: {
                    if (!fileNameFilter$1.exists((Function1 & Serializable & scala.Serializable)reg -> BoxesRunTime.boxToBoolean((boolean)SQLiteUtil$.$anonfun$backupDirectory$3(file, reg)))) break block0;
                    MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Skipping ").append(file.toAbsolutePath()).append(" for backup").toString());
                    break block1;
                }
                if (!Files.isDirectory(file, new LinkOption[0])) break block2;
                MODULE$.backupDirectory(file, target$1.resolve(file.getFileName()), (Vector<Regex>)fileNameFilter$1, dbExtension$1);
                break block1;
            }
            if (!Files.isRegularFile(file, LinkOption.NOFOLLOW_LINKS) || !((Object)file).toString().endsWith(dbExtension$1)) break block1;
            Path backupFile = target$1.resolve(file.getFileName());
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Backing up file=").append(file.toAbsolutePath()).append(" to ").append(backupFile.toAbsolutePath()).toString());
            Files.createDirectories(target$1, new FileAttribute[0]);
            MODULE$.backup(MODULE$.pathToJdbcUrl(file), backupFile);
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Done backing up file=").append(file.toAbsolutePath()).toString());
        }
    }

    private SQLiteUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        Class.forName("org.sqlite.JDBC");
    }
}

