/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.bitcoins.core.compat.CompatEither;
import org.bitcoins.core.compat.CompatLeft;
import org.bitcoins.core.compat.CompatRight;
import org.bitcoins.core.crypto.AesEncryptedData;
import org.bitcoins.core.crypto.AesIV;
import org.bitcoins.core.crypto.AesIV$;
import org.bitcoins.core.crypto.AesPassword;
import org.bitcoins.core.crypto.AesSalt;
import org.bitcoins.core.crypto.AesSalt$;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.keymanager.EncryptedMnemonic;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.ReadMnemonicError$DecryptionError$;
import org.bitcoins.keymanager.ReadMnemonicError$NotFoundError$;
import org.bitcoins.keymanager.WalletStorage$;
import org.bitcoins.keymanager.WalletStorage$$anonfun$5$;
import org.bitcoins.keymanager.WalletStorage$$anonfun$5$$anonfun$7$;
import org.bitcoins.keymanager.WalletStorage$MnemonicJsonKeys$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;
import ujson.Obj;
import ujson.Obj$;
import ujson.ParseException;
import ujson.Readable;
import ujson.Readable$;
import ujson.Str;
import ujson.Value;
import ujson.Value$;

public final class WalletStorage$ {
    public static final WalletStorage$ MODULE$;
    private final String ENCRYPTED_SEED_FILE_NAME;
    private final Logger org$bitcoins$keymanager$WalletStorage$$logger;

    static {
        new WalletStorage$();
    }

    public String ENCRYPTED_SEED_FILE_NAME() {
        return this.ENCRYPTED_SEED_FILE_NAME;
    }

    public Logger org$bitcoins$keymanager$WalletStorage$$logger() {
        return this.org$bitcoins$keymanager$WalletStorage$$logger;
    }

    public boolean seedExists(Path seedPath) {
        return Files.exists(seedPath, new LinkOption[0]);
    }

    public Path writeMnemonicToDisk(Path seedPath, EncryptedMnemonic mnemonic) {
        CompatEither<ReadMnemonicError, EncryptedMnemonic> compatEither;
        block7: {
            None$ foundMnemonicOpt;
            None$ none$;
            String writtenJs;
            block6: {
                block5: {
                    AesEncryptedData encrypted = mnemonic.value();
                    Obj jsObject = Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.IV()), (Object)new AesIV(encrypted.iv()).hex()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.CIPHER_TEXT()), (Object)Value$.MODULE$.JsonableString((CharSequence)encrypted.cipherText().toHex())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.SALT()), (Object)Value$.MODULE$.JsonableString((CharSequence)mnemonic.salt().toHex()))}), (Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Str apply(CharSequence s) {
                            return Value$.MODULE$.JsonableString(s);
                        }
                    });
                    this.org$bitcoins$keymanager$WalletStorage$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing mnemonic to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
                    writtenJs = ujson.package$.MODULE$.write((Value)jsObject, ujson.package$.MODULE$.write$default$2(), ujson.package$.MODULE$.write$default$3());
                    compatEither = this.readEncryptedMnemonicFromDisk(seedPath);
                    if (!(compatEither instanceof CompatLeft)) break block5;
                    none$ = None$.MODULE$;
                    break block6;
                }
                if (!(compatEither instanceof CompatRight)) break block7;
                CompatRight compatRight = (CompatRight)compatEither;
                EncryptedMnemonic mnemonic2 = (EncryptedMnemonic)compatRight.value();
                none$ = new Some((Object)mnemonic2);
            }
            None$ none$2 = foundMnemonicOpt = none$;
            if (None$.MODULE$.equals(none$2)) {
                this.org$bitcoins$keymanager$WalletStorage$$logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
                Path path = this.writeJsToDisk$1(seedPath, writtenJs);
                return path;
            }
            if (none$2 instanceof Some) {
                this.org$bitcoins$keymanager$WalletStorage$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to overwrite an existing mnemonic seed, this is dangerous!"})).s((Seq)Nil$.MODULE$));
            }
            throw new MatchError((Object)none$2);
        }
        throw new MatchError(compatEither);
    }

    /*
     * Unable to fully structure code
     */
    private CompatEither<ReadMnemonicError, EncryptedMnemonic> readEncryptedMnemonicFromDisk(Path seedPath) {
        block3: {
            if (!Files.isRegularFile(seedPath, new LinkOption[0])) ** GOTO lbl28
            rawJson = ((TraversableOnce)org.bitcoins.core.compat.package$.MODULE$.JavaConverters().asScalaBufferConverter(Files.readAllLines(seedPath)).asScala()).mkString("\n");
            this.org$bitcoins$keymanager$WalletStorage$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read raw encrypted mnemonic from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
            var4_3 = false;
            var5_4 = null;
            var6_5 = Try$.MODULE$.apply((Function0)new Serializable(rawJson){
                public static final long serialVersionUID = 0L;
                private final String rawJson$1;

                public final Value apply() {
                    return ujson.package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(this.rawJson$1));
                }
                {
                    this.rawJson$1 = rawJson$1;
                }
            });
            if (!(var6_5 instanceof Failure)) break block3;
            var4_3 = true;
            var5_4 = (Failure)var6_5;
            var7_6 = var5_4.exception();
            if (!(var7_6 instanceof ParseException)) break block3;
            var8_7 = (ParseException)var7_6;
            clue = var8_7.clue();
            var10_9 = new CompatLeft((Object)new ReadMnemonicError.JsonParsingError(clue));
            ** GOTO lbl25
        }
        if (var4_3) {
            exception = var5_4.exception();
            throw exception;
        }
        if (var6_5 instanceof Success) {
            var12_11 = (Success)var6_5;
            value = (Value)var12_11.value();
            this.org$bitcoins$keymanager$WalletStorage$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed ", " into valid json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
            var10_9 = new CompatRight((Object)value);
lbl25:
            // 2 sources

            v0 = var10_9;
        } else {
            throw new MatchError((Object)var6_5);
lbl28:
            // 1 sources

            this.org$bitcoins$keymanager$WalletStorage$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encrypted mnemonic not found at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
            v0 = new CompatLeft((Object)ReadMnemonicError$NotFoundError$.MODULE$);
        }
        jsonE = v0;
        readJsonTupleEither = jsonE.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CompatEither<ReadMnemonicError, Tuple3<String, String, String>> apply(Value json) {
                WalletStorage$.MODULE$.org$bitcoins$keymanager$WalletStorage$$logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read encrypted mnemonic JSON: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{json})));
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, json){
                    public static final long serialVersionUID = 0L;
                    private final Value json$1;

                    public final Tuple3<String, String, String> apply() {
                        String ivString = this.json$1.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.IV())).str();
                        String cipherTextString = this.json$1.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.CIPHER_TEXT())).str();
                        String rawSaltString = this.json$1.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.SALT())).str();
                        return new Tuple3((Object)ivString, (Object)cipherTextString, (Object)rawSaltString);
                    }
                    {
                        this.json$1 = json$1;
                    }
                });
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Tuple3 value = (Tuple3)success.value();
                    CompatRight compatRight = new CompatRight((Object)value);
                    return compatRight;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw exception;
                }
                throw new MatchError((Object)try_);
            }
        });
        encryptedEither = readJsonTupleEither.flatMap((Function1)new Serializable(seedPath){
            public static final long serialVersionUID = 0L;
            public final Path seedPath$2;

            public final CompatEither<ReadMnemonicError, EncryptedMnemonic> apply(Tuple3<String, String, String> x0$1) {
                Tuple3<String, String, String> tuple3 = x0$1;
                if (tuple3 != null) {
                    String rawIv = (String)tuple3._1();
                    String rawCipherText = (String)tuple3._2();
                    String rawSalt = (String)tuple3._3();
                    Option encryptedOpt = ByteVector$.MODULE$.fromHex(rawIv, ByteVector$.MODULE$.fromHex$default$2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ByteVector apply(ByteVector x$1) {
                            return AesIV$.MODULE$.fromValidBytes(x$1);
                        }
                    }).flatMap((Function1)new Serializable(this, rawCipherText, rawSalt){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.5 $outer;
                        private final String rawCipherText$1;
                        public final String rawSalt$1;

                        public final Option<EncryptedMnemonic> apply(ByteVector iv) {
                            return ByteVector$.MODULE$.fromHex(this.rawCipherText$1, ByteVector$.MODULE$.fromHex$default$2()).flatMap((Function1)new Serializable(this, iv){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$5$$anonfun$7 $outer;
                                public final ByteVector iv$1;

                                public final Option<EncryptedMnemonic> apply(ByteVector cipherText) {
                                    return ByteVector$.MODULE$.fromHex(this.$outer.rawSalt$1, ByteVector$.MODULE$.fromHex$default$2()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final ByteVector apply(ByteVector x$2) {
                                            return ((AesSalt)AesSalt$.MODULE$.apply(x$2)).bytes();
                                        }
                                    }).map((Function1)new Serializable(this, cipherText){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$5$$anonfun$7$$anonfun$apply$1 $outer;
                                        private final ByteVector cipherText$1;

                                        public final EncryptedMnemonic apply(ByteVector salt) {
                                            WalletStorage$.MODULE$.org$bitcoins$keymanager$WalletStorage$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed contents of ", " into an EncryptedMnemonic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$bitcoins$keymanager$WalletStorage$$anonfun$$anonfun$$anonfun$$$outer().org$bitcoins$keymanager$WalletStorage$$anonfun$$anonfun$$$outer().seedPath$2})));
                                            return new EncryptedMnemonic(new AesEncryptedData(this.cipherText$1, this.$outer.iv$1), salt);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.cipherText$1 = cipherText$1;
                                        }
                                    });
                                }

                                public /* synthetic */ anonfun$5$$anonfun$7 org$bitcoins$keymanager$WalletStorage$$anonfun$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.iv$1 = iv$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.5 org$bitcoins$keymanager$WalletStorage$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rawCipherText$1 = rawCipherText$1;
                            this.rawSalt$1 = rawSalt$1;
                        }
                    });
                    Option toRight = encryptedOpt.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final CompatRight<ReadMnemonicError, EncryptedMnemonic> apply(EncryptedMnemonic x$3) {
                            return new CompatRight((Object)x$3);
                        }
                    });
                    CompatEither compatEither = (CompatEither)toRight.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final CompatLeft<ReadMnemonicError.JsonParsingError, Nothing$> apply() {
                            return new CompatLeft((Object)new ReadMnemonicError.JsonParsingError("JSON contents was not hex strings"));
                        }
                    });
                    return compatEither;
                }
                throw new MatchError(tuple3);
            }
            {
                this.seedPath$2 = seedPath$2;
            }
        });
        return encryptedEither;
    }

    public Either<ReadMnemonicError, MnemonicCode> decryptMnemonicFromDisk(Path seedPath, AesPassword passphrase) {
        CompatEither compatEither;
        block4: {
            Left left;
            block3: {
                block2: {
                    CompatEither<ReadMnemonicError, EncryptedMnemonic> encryptedEither = this.readEncryptedMnemonicFromDisk(seedPath);
                    CompatEither decryptedEither = encryptedEither.flatMap((Function1)new Serializable(passphrase){
                        public static final long serialVersionUID = 0L;
                        private final AesPassword passphrase$1;

                        public final CompatEither<ReadMnemonicError, MnemonicCode> apply(EncryptedMnemonic encrypted) {
                            Try<MnemonicCode> try_;
                            block4: {
                                CompatRight compatRight;
                                block3: {
                                    block2: {
                                        try_ = encrypted.toMnemonic(this.passphrase$1);
                                        if (!(try_ instanceof Failure)) break block2;
                                        Failure failure = (Failure)try_;
                                        Throwable exc = failure.exception();
                                        WalletStorage$.MODULE$.org$bitcoins$keymanager$WalletStorage$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when decrypting ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encrypted, exc})));
                                        compatRight = new CompatLeft((Object)ReadMnemonicError$DecryptionError$.MODULE$);
                                        break block3;
                                    }
                                    if (!(try_ instanceof Success)) break block4;
                                    Success success = (Success)try_;
                                    MnemonicCode value = (MnemonicCode)success.value();
                                    WalletStorage$.MODULE$.org$bitcoins$keymanager$WalletStorage$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decrypted ", " successfully"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encrypted})));
                                    compatRight = new CompatRight((Object)value);
                                }
                                return compatRight;
                            }
                            throw new MatchError(try_);
                        }
                        {
                            this.passphrase$1 = passphrase$1;
                        }
                    });
                    compatEither = decryptedEither;
                    if (!(compatEither instanceof CompatLeft)) break block2;
                    CompatLeft compatLeft = (CompatLeft)compatEither;
                    ReadMnemonicError value = (ReadMnemonicError)compatLeft.value();
                    left = package$.MODULE$.Left().apply((Object)value);
                    break block3;
                }
                if (!(compatEither instanceof CompatRight)) break block4;
                CompatRight compatRight = (CompatRight)compatEither;
                MnemonicCode value = (MnemonicCode)compatRight.value();
                left = package$.MODULE$.Right().apply((Object)value);
            }
            return left;
        }
        throw new MatchError((Object)compatEither);
    }

    /*
     * WARNING - void declaration
     */
    private final Path writeJsToDisk$1(Path seedPath$1, String writtenJs$1) {
        void var3_3;
        Path writtenPath = Files.write(seedPath$1, writtenJs$1.getBytes(), new OpenOption[0]);
        this.org$bitcoins$keymanager$WalletStorage$$logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrote encrypted mnemonic to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath$1})));
        return var3_3;
    }

    private WalletStorage$() {
        MODULE$ = this;
        this.ENCRYPTED_SEED_FILE_NAME = "encrypted-bitcoin-s-seed.json";
        this.org$bitcoins$keymanager$WalletStorage$$logger = LoggerFactory.getLogger(this.getClass());
    }
}

