/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager.bip39;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.bitcoins.core.compat.CompatEither;
import org.bitcoins.core.compat.CompatEither$;
import org.bitcoins.core.compat.CompatLeft;
import org.bitcoins.core.compat.CompatRight;
import org.bitcoins.core.crypto.AesPassword;
import org.bitcoins.core.crypto.AesPassword$;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.core.crypto.MnemonicCode$;
import org.bitcoins.core.util.BitcoinSLogger;
import org.bitcoins.keymanager.BIP39KeyManagerCreateApi;
import org.bitcoins.keymanager.BIP39KeyManagerCreateApi$class;
import org.bitcoins.keymanager.EncryptedMnemonic;
import org.bitcoins.keymanager.EncryptedMnemonicHelper$;
import org.bitcoins.keymanager.InitializeKeyManagerError;
import org.bitcoins.keymanager.InitializeKeyManagerError$BadEntropy$;
import org.bitcoins.keymanager.KeyManager;
import org.bitcoins.keymanager.KeyManagerInitializeError;
import org.bitcoins.keymanager.KeyManagerParams;
import org.bitcoins.keymanager.KeyManagerUnlockError;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.WalletStorage$;
import org.bitcoins.keymanager.bip39.BIP39KeyManager;
import org.bitcoins.keymanager.bip39.BIP39KeyManager$;
import org.bitcoins.keymanager.bip39.BIP39LockedKeyManager$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.BitVector;

public final class BIP39KeyManager$
implements BIP39KeyManagerCreateApi,
BitcoinSLogger,
Serializable {
    public static final BIP39KeyManager$ MODULE$;
    private final AesPassword badPassphrase;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BIP39KeyManager$();
    }

    private Logger logger$lzycompute() {
        BIP39KeyManager$ bIP39KeyManager$ = this;
        synchronized (bIP39KeyManager$) {
            if (!this.bitmap$0) {
                this.logger = BitcoinSLogger.class.logger((BitcoinSLogger)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public final Either<KeyManagerInitializeError, BIP39KeyManager> initialize(KeyManagerParams kmParams, Option<String> bip39PasswordOpt) {
        return BIP39KeyManagerCreateApi$class.initialize(this, kmParams, bip39PasswordOpt);
    }

    @Override
    public final Either<KeyManagerInitializeError, BIP39KeyManager> initializeWithMnemonic(MnemonicCode mnemonicCode, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        return BIP39KeyManagerCreateApi$class.initializeWithMnemonic(this, mnemonicCode, bip39PasswordOpt, kmParams);
    }

    public AesPassword badPassphrase() {
        return this.badPassphrase;
    }

    @Override
    public Either<KeyManagerInitializeError, BIP39KeyManager> initializeWithEntropy(BitVector entropy, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        Either<ReadMnemonicError, MnemonicCode> either;
        block9: {
            CompatEither compatEither;
            block12: {
                Right right;
                block11: {
                    block10: {
                        CompatEither biasedFinalE;
                        CompatRight compatRight;
                        block6: {
                            CompatRight compatRight2;
                            block8: {
                                block7: {
                                    Path seedPath;
                                    block2: {
                                        Try try_;
                                        block5: {
                                            CompatEither compatEither2;
                                            block4: {
                                                block3: {
                                                    Try mnemonicT;
                                                    seedPath = kmParams.seedPath();
                                                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing wallet with seedPath=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
                                                    if (!Files.notExists(seedPath, new LinkOption[0])) break block2;
                                                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Seed path parent directory does not exist, creating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath.getParent()})));
                                                    Files.createDirectories(seedPath.getParent(), new FileAttribute[0]);
                                                    try_ = mnemonicT = Try$.MODULE$.apply((Function0)new Serializable(entropy){
                                                        public static final long serialVersionUID = 0L;
                                                        private final BitVector entropy$1;

                                                        public final MnemonicCode apply() {
                                                            return MnemonicCode$.MODULE$.fromEntropy(this.entropy$1);
                                                        }
                                                        {
                                                            this.entropy$1 = entropy$1;
                                                        }
                                                    });
                                                    if (!(try_ instanceof Success)) break block3;
                                                    Success success = (Success)try_;
                                                    MnemonicCode mnemonic = (MnemonicCode)success.value();
                                                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created mnemonic from entropy"})).s((Seq)Nil$.MODULE$));
                                                    compatEither2 = CompatEither$.MODULE$.apply((Either)package$.MODULE$.Right().apply((Object)mnemonic));
                                                    break block4;
                                                }
                                                if (!(try_ instanceof Failure)) break block5;
                                                Failure failure = (Failure)try_;
                                                Throwable err = failure.exception();
                                                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create mnemonic from entropy! ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})));
                                                compatEither2 = CompatEither$.MODULE$.apply((Either)package$.MODULE$.Left().apply((Object)InitializeKeyManagerError$BadEntropy$.MODULE$));
                                            }
                                            CompatEither mnemonicE = compatEither2;
                                            CompatEither encryptedMnemonicE = mnemonicE.map((Function1)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final EncryptedMnemonic apply(MnemonicCode x$1) {
                                                    return EncryptedMnemonicHelper$.MODULE$.encrypt(x$1, BIP39KeyManager$.MODULE$.badPassphrase());
                                                }
                                            });
                                            compatRight = mnemonicE.flatMap((Function1)new Serializable(bip39PasswordOpt, kmParams, seedPath, encryptedMnemonicE){
                                                public static final long serialVersionUID = 0L;
                                                public final Option bip39PasswordOpt$2;
                                                public final KeyManagerParams kmParams$1;
                                                public final Path seedPath$1;
                                                private final CompatEither encryptedMnemonicE$1;

                                                public final CompatEither<KeyManagerInitializeError, KeyManager> apply(MnemonicCode mnemonic) {
                                                    return this.encryptedMnemonicE$1.map((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ anonfun.3 $outer;

                                                        public final Tuple2<EncryptedMnemonic, BoxedUnit> apply(EncryptedMnemonic encrypted) {
                                                            Path mnemonicPath = WalletStorage$.MODULE$.writeMnemonicToDisk(this.$outer.seedPath$1, encrypted);
                                                            BIP39KeyManager$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saved encrypted wallet mnemonic to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mnemonicPath})));
                                                            BoxedUnit x$2 = BoxedUnit.UNIT;
                                                            return new Tuple2((Object)encrypted, (Object)x$2);
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    }).map((Function1)new Serializable(this, mnemonic){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ anonfun.3 $outer;
                                                        private final MnemonicCode mnemonic$2;

                                                        public final KeyManager apply(Tuple2<EncryptedMnemonic, BoxedUnit> x$3) {
                                                            Tuple2<EncryptedMnemonic, BoxedUnit> tuple2 = x$3;
                                                            if (tuple2 != null) {
                                                                BIP39KeyManager bIP39KeyManager = new BIP39KeyManager(this.mnemonic$2, this.$outer.kmParams$1, (Option<String>)this.$outer.bip39PasswordOpt$2);
                                                                return bIP39KeyManager;
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                            this.mnemonic$2 = mnemonic$2;
                                                        }
                                                    });
                                                }
                                                {
                                                    this.bip39PasswordOpt$2 = bip39PasswordOpt$2;
                                                    this.kmParams$1 = kmParams$1;
                                                    this.seedPath$1 = seedPath$1;
                                                    this.encryptedMnemonicE$1 = encryptedMnemonicE$1;
                                                }
                                            });
                                            break block6;
                                        }
                                        throw new MatchError((Object)try_);
                                    }
                                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Seed file already exists, attempting to initialize form existing seed file=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seedPath})));
                                    either = WalletStorage$.MODULE$.decryptMnemonicFromDisk(kmParams.seedPath(), this.badPassphrase());
                                    if (!(either instanceof Right)) break block7;
                                    Right right2 = (Right)either;
                                    MnemonicCode mnemonic = (MnemonicCode)right2.b();
                                    compatRight2 = new CompatRight((Object)new BIP39KeyManager(mnemonic, kmParams, bip39PasswordOpt));
                                    break block8;
                                }
                                if (!(either instanceof Left)) break block9;
                                Left left = (Left)either;
                                ReadMnemonicError err = (ReadMnemonicError)left.a();
                                compatRight2 = new CompatLeft((Object)new InitializeKeyManagerError.FailedToReadWrittenSeed(new KeyManagerUnlockError.JsonParsingError(err.toString())));
                            }
                            compatRight = compatRight2;
                        }
                        CompatRight writtenToDiskE = compatRight;
                        Either<KeyManagerUnlockError, BIP39KeyManager> unlocked = BIP39LockedKeyManager$.MODULE$.unlock(this.badPassphrase(), bip39PasswordOpt, kmParams);
                        compatEither = biasedFinalE = writtenToDiskE.flatMap((Function1)new Serializable(unlocked){
                            public static final long serialVersionUID = 0L;
                            private final Either unlocked$1;

                            public final CompatEither<InitializeKeyManagerError.FailedToReadWrittenSeed, BIP39KeyManager> apply(KeyManager kmBeforeWrite) {
                                Either either;
                                block4: {
                                    CompatLeft compatLeft;
                                    block3: {
                                        block2: {
                                            either = this.unlocked$1;
                                            if (!(either instanceof Right)) break block2;
                                            Right right = (Right)either;
                                            BIP39KeyManager unlockedKeyManager = (BIP39KeyManager)right.b();
                                            KeyManager keyManager = kmBeforeWrite;
                                            BIP39KeyManager bIP39KeyManager = unlockedKeyManager;
                                            Predef$.MODULE$.require(!(keyManager != null ? !keyManager.equals(bIP39KeyManager) : bIP39KeyManager != null), (Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply() {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We could not read the key manager we just wrote!"})).s((Seq)Nil$.MODULE$);
                                                }
                                            });
                                            compatLeft = new CompatRight((Object)unlockedKeyManager);
                                            break block3;
                                        }
                                        if (!(either instanceof Left)) break block4;
                                        Left left = (Left)either;
                                        KeyManagerUnlockError err = (KeyManagerUnlockError)left.a();
                                        compatLeft = new CompatLeft((Object)new InitializeKeyManagerError.FailedToReadWrittenSeed(err));
                                    }
                                    return ((CompatEither)compatLeft).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final BIP39KeyManager apply(BIP39KeyManager invariant) {
                                            return invariant;
                                        }
                                    });
                                }
                                throw new MatchError((Object)either);
                            }
                            {
                                this.unlocked$1 = unlocked$1;
                            }
                        });
                        if (!(compatEither instanceof CompatRight)) break block10;
                        CompatRight compatRight3 = (CompatRight)compatEither;
                        BIP39KeyManager initSuccess = (BIP39KeyManager)compatRight3.value();
                        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully initialized wallet"})).s((Seq)Nil$.MODULE$));
                        right = package$.MODULE$.Right().apply((Object)initSuccess);
                        break block11;
                    }
                    if (!(compatEither instanceof CompatLeft)) break block12;
                    CompatLeft compatLeft = (CompatLeft)compatEither;
                    KeyManagerInitializeError err = (KeyManagerInitializeError)compatLeft.value();
                    this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to initialize key manager with err=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})));
                    right = package$.MODULE$.Left().apply((Object)err);
                }
                return right;
            }
            throw new MatchError((Object)compatEither);
        }
        throw new MatchError(either);
    }

    public Either<ReadMnemonicError, BIP39KeyManager> fromParams(KeyManagerParams kmParams, AesPassword password, Option<String> bip39PasswordOpt) {
        Either<ReadMnemonicError, MnemonicCode> either;
        block4: {
            Left left;
            block3: {
                block2: {
                    Either<ReadMnemonicError, MnemonicCode> mnemonicCodeE = WalletStorage$.MODULE$.decryptMnemonicFromDisk(kmParams.seedPath(), password);
                    either = mnemonicCodeE;
                    if (!(either instanceof Right)) break block2;
                    Right right = (Right)either;
                    MnemonicCode mnemonic = (MnemonicCode)right.b();
                    left = package$.MODULE$.Right().apply((Object)new BIP39KeyManager(mnemonic, kmParams, bip39PasswordOpt));
                    break block3;
                }
                if (!(either instanceof Left)) break block4;
                Left left2 = (Left)either;
                ReadMnemonicError v = (ReadMnemonicError)left2.a();
                left = package$.MODULE$.Left().apply((Object)v);
            }
            return left;
        }
        throw new MatchError(either);
    }

    public BIP39KeyManager apply(MnemonicCode mnemonic, KeyManagerParams kmParams, Option<String> bip39PasswordOpt) {
        return new BIP39KeyManager(mnemonic, kmParams, bip39PasswordOpt);
    }

    public Option<Tuple3<MnemonicCode, KeyManagerParams, Option<String>>> unapply(BIP39KeyManager x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.mnemonic$1(), (Object)x$0.kmParams(), x$0.bip39PasswordOpt$1()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BIP39KeyManager$() {
        MODULE$ = this;
        BIP39KeyManagerCreateApi$class.$init$(this);
        BitcoinSLogger.class.$init$((BitcoinSLogger)this);
        this.badPassphrase = (AesPassword)AesPassword$.MODULE$.fromString("changeMe").get();
    }
}

