/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager.bip39;

import org.bitcoins.core.crypto.AesPassword;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.core.util.BitcoinSLogger;
import org.bitcoins.keymanager.KeyManagerParams;
import org.bitcoins.keymanager.KeyManagerUnlockError;
import org.bitcoins.keymanager.KeyManagerUnlockError$BadPassword$;
import org.bitcoins.keymanager.KeyManagerUnlockError$MnemonicNotFound$;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.ReadMnemonicError$DecryptionError$;
import org.bitcoins.keymanager.ReadMnemonicError$NotFoundError$;
import org.bitcoins.keymanager.WalletStorage$;
import org.bitcoins.keymanager.bip39.BIP39KeyManager;
import org.slf4j.Logger;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BIP39LockedKeyManager$
implements BitcoinSLogger {
    public static final BIP39LockedKeyManager$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BIP39LockedKeyManager$();
    }

    private Logger logger$lzycompute() {
        BIP39LockedKeyManager$ bIP39LockedKeyManager$ = this;
        synchronized (bIP39LockedKeyManager$) {
            if (!this.bitmap$0) {
                this.logger = BitcoinSLogger.class.logger((BitcoinSLogger)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Either<KeyManagerUnlockError, BIP39KeyManager> unlock(AesPassword passphrase, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        Either<ReadMnemonicError, MnemonicCode> either;
        block4: {
            ReadMnemonicError readMnemonicError;
            block8: {
                Right right;
                block3: {
                    Left left;
                    block6: {
                        block7: {
                            block5: {
                                block2: {
                                    Either<ReadMnemonicError, MnemonicCode> resultE;
                                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to unlock wallet with seedPath=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kmParams.seedPath()})));
                                    either = resultE = WalletStorage$.MODULE$.decryptMnemonicFromDisk(kmParams.seedPath(), passphrase);
                                    if (!(either instanceof Right)) break block2;
                                    Right right2 = (Right)either;
                                    MnemonicCode mnemonicCode = (MnemonicCode)right2.b();
                                    right = package$.MODULE$.Right().apply((Object)new BIP39KeyManager(mnemonicCode, kmParams, bip39PasswordOpt));
                                    break block3;
                                }
                                if (!(either instanceof Left)) break block4;
                                Left left2 = (Left)either;
                                ReadMnemonicError result = (ReadMnemonicError)left2.a();
                                readMnemonicError = result;
                                if (!ReadMnemonicError$DecryptionError$.MODULE$.equals(readMnemonicError)) break block5;
                                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad password for unlocking wallet!"})).s((Seq)Nil$.MODULE$));
                                left = package$.MODULE$.Left().apply((Object)KeyManagerUnlockError$BadPassword$.MODULE$);
                                break block6;
                            }
                            if (!(readMnemonicError instanceof ReadMnemonicError.JsonParsingError)) break block7;
                            ReadMnemonicError.JsonParsingError jsonParsingError = (ReadMnemonicError.JsonParsingError)readMnemonicError;
                            String message = jsonParsingError.message();
                            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JSON parsing error when unlocking wallet: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
                            left = package$.MODULE$.Left().apply((Object)new KeyManagerUnlockError.JsonParsingError(message));
                            break block6;
                        }
                        if (!ReadMnemonicError$NotFoundError$.MODULE$.equals(readMnemonicError)) break block8;
                        this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encrypted mnemonic not found when unlocking the wallet!"})).s((Seq)Nil$.MODULE$));
                        left = package$.MODULE$.Left().apply((Object)KeyManagerUnlockError$MnemonicNotFound$.MODULE$);
                    }
                    right = left;
                }
                return right;
            }
            throw new MatchError((Object)readMnemonicError);
        }
        throw new MatchError(either);
    }

    private BIP39LockedKeyManager$() {
        MODULE$ = this;
        BitcoinSLogger.class.$init$((BitcoinSLogger)this);
    }
}

