/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager;

import java.io.Serializable;
import java.time.Instant;
import org.bitcoins.core.crypto.ExtPrivateKey;
import org.bitcoins.core.crypto.ExtPrivateKey$;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.core.crypto.MnemonicCode$;
import org.bitcoins.crypto.AesCrypt$;
import org.bitcoins.crypto.AesEncryptedData;
import org.bitcoins.crypto.AesKey;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.crypto.AesSalt;
import org.bitcoins.keymanager.EncryptedSeed$;
import org.bitcoins.keymanager.ReadMnemonicError$DecryptionError$;
import org.bitcoins.keymanager.SeedState;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scodec.bits.ByteVector;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u0014(\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0015\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011!9\u0006A!f\u0001\n\u0003A\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011B-\t\u0011\t\u0004!Q3A\u0005\u0002\rD\u0001b\u001a\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011)\u001a!C\u0001S\"AQ\u000e\u0001B\tB\u0003%!\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003w\u0001\u0011%q\u000fC\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\b\u0001\u0005B\u0005u\u0002\"CA\"\u0001\u0005\u0005I\u0011AA#\u0011%\t\t\u0006AI\u0001\n\u0003\t\u0019\u0006C\u0005\u0002j\u0001\t\n\u0011\"\u0001\u0002l!I\u0011q\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003k\u0002\u0011\u0013!C\u0001\u0003oB\u0011\"a\u001f\u0001#\u0003%\t!! \t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\r\u0005\"CAH\u0001\u0005\u0005I\u0011AAI\u0011%\tI\nAA\u0001\n\u0003\tY\nC\u0005\u0002(\u0002\t\t\u0011\"\u0011\u0002*\"I\u0011q\u0017\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003{\u0003\u0011\u0011!C!\u0003\u007fC\u0011\"a1\u0001\u0003\u0003%\t%!2\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%\u0007\"CAf\u0001\u0005\u0005I\u0011IAg\u000f%\t\tnJA\u0001\u0012\u0003\t\u0019N\u0002\u0005'O\u0005\u0005\t\u0012AAk\u0011\u0019q\u0007\u0005\"\u0001\u0002n\"I\u0011q\u0019\u0011\u0002\u0002\u0013\u0015\u0013\u0011\u001a\u0005\n\u0003_\u0004\u0013\u0011!CA\u0003cD\u0011\"!@!\u0003\u0003%\t)a@\t\u0013\t5\u0001%!A\u0005\n\t=!!D#oGJL\b\u000f^3e'\u0016,GM\u0003\u0002)S\u0005Q1.Z=nC:\fw-\u001a:\u000b\u0005)Z\u0013\u0001\u00032ji\u000e|\u0017N\\:\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00186sq\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0007C\u0001\u001c8\u001b\u00059\u0013B\u0001\u001d(\u0005%\u0019V-\u001a3Ti\u0006$X\r\u0005\u00021u%\u00111(\r\u0002\b!J|G-^2u!\tiTI\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)L\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!\u0001R\u0019\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\tF\nQA^1mk\u0016,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b&\naa\u0019:zaR|\u0017BA(M\u0005A\tUm]#oGJL\b\u000f^3e\t\u0006$\u0018-\u0001\u0004wC2,X\rI\u0001\u0005g\u0006dG/F\u0001T!\tYE+\u0003\u0002V\u0019\n9\u0011)Z:TC2$\u0018!B:bYR\u0004\u0013\u0001D2sK\u0006$\u0018n\u001c8US6,W#A-\u0011\u0005i{V\"A.\u000b\u0005qk\u0016\u0001\u0002;j[\u0016T\u0011AX\u0001\u0005U\u00064\u0018-\u0003\u0002a7\n9\u0011J\\:uC:$\u0018!D2sK\u0006$\u0018n\u001c8US6,\u0007%A\u0007cC\u000e\\W\u000f\u001d+j[\u0016|\u0005\u000f^\u000b\u0002IB\u0019\u0001'Z-\n\u0005\u0019\f$AB(qi&|g.\u0001\bcC\u000e\\W\u000f\u001d+j[\u0016|\u0005\u000f\u001e\u0011\u0002\u0011%l\u0007o\u001c:uK\u0012,\u0012A\u001b\t\u0003a-L!\u0001\\\u0019\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011.\u001c9peR,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\rA\f(o\u001d;v!\t1\u0004\u0001C\u0003I\u0017\u0001\u0007!\nC\u0003R\u0017\u0001\u00071\u000bC\u0003X\u0017\u0001\u0007\u0011\fC\u0003c\u0017\u0001\u0007A\rC\u0003i\u0017\u0001\u0007!.\u0001\u0006eK\u000e\u0014\u0018\u0010\u001d;TiJ$2\u0001_A\u0007!\rIHP`\u0007\u0002u*\u001110M\u0001\u0005kRLG.\u0003\u0002~u\n\u0019AK]=\u0011\u0007}\f9A\u0004\u0003\u0002\u0002\u0005\r\u0001CA 2\u0013\r\t)!M\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00111\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0011\u0007C\u0004\u0002\u00101\u0001\r!!\u0005\u0002\u0011A\f7o]<pe\u0012\u00042aSA\n\u0013\r\t)\u0002\u0014\u0002\f\u0003\u0016\u001c\b+Y:to>\u0014H-\u0001\u0006u_6sW-\\8oS\u000e$B!a\u0007\u0002,A!\u0011\u0010`A\u000f!\u0011\ty\"a\n\u000e\u0005\u0005\u0005\"bA'\u0002$)\u0019\u0011QE\u0015\u0002\t\r|'/Z\u0005\u0005\u0003S\t\tC\u0001\u0007N]\u0016lwN\\5d\u0007>$W\rC\u0004\u0002\u00105\u0001\r!!\u0005\u0002\u0019Q|W\t\u001f;Qe&48*Z=\u0015\t\u0005E\u0012\u0011\b\t\u0005sr\f\u0019\u0004\u0005\u0003\u0002 \u0005U\u0012\u0002BA\u001c\u0003C\u0011Q\"\u0012=u!JLg/\u0019;f\u0017\u0016L\bbBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\u000fo&$\bNQ1dWV\u0004H+[7f)\r)\u0014q\b\u0005\u0007\u0003\u0003z\u0001\u0019A-\u0002\u0015\t\f7m[;q)&lW-\u0001\u0003d_BLHc\u00039\u0002H\u0005%\u00131JA'\u0003\u001fBq\u0001\u0013\t\u0011\u0002\u0003\u0007!\nC\u0004R!A\u0005\t\u0019A*\t\u000f]\u0003\u0002\u0013!a\u00013\"9!\r\u0005I\u0001\u0002\u0004!\u0007b\u00025\u0011!\u0003\u0005\rA[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)FK\u0002K\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G\n\u0014AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiGK\u0002T\u0003/\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002t)\u001a\u0011,a\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0010\u0016\u0004I\u0006]\u0013AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003\u007fR3A[A,\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111R/\u0002\t1\fgnZ\u0005\u0005\u0003\u0013\tI)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0014B\u0019\u0001'!&\n\u0007\u0005]\u0015GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001e\u0006\r\u0006c\u0001\u0019\u0002 &\u0019\u0011\u0011U\u0019\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002&b\t\t\u00111\u0001\u0002\u0014\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a+\u0011\r\u00055\u00161WAO\u001b\t\tyKC\u0002\u00022F\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t),a,\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004U\u0006m\u0006\"CAS5\u0005\u0005\t\u0019AAO\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u0015\u0015\u0011\u0019\u0005\n\u0003K[\u0012\u0011!a\u0001\u0003'\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003'\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\u000ba!Z9vC2\u001cHc\u00016\u0002P\"I\u0011Q\u0015\u0010\u0002\u0002\u0003\u0007\u0011QT\u0001\u000e\u000b:\u001c'/\u001f9uK\u0012\u001cV-\u001a3\u0011\u0005Y\u00023#\u0002\u0011\u0002X\u0006\r\bCCAm\u0003?T5+\u00173ka6\u0011\u00111\u001c\u0006\u0004\u0003;\f\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003C\fYNA\tBEN$(/Y2u\rVt7\r^5p]V\u0002B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0004\u0003Sl\u0016AA5p\u0013\r1\u0015q\u001d\u000b\u0003\u0003'\fQ!\u00199qYf$2\u0002]Az\u0003k\f90!?\u0002|\")\u0001j\ta\u0001\u0015\")\u0011k\ta\u0001'\")qk\ta\u00013\")!m\ta\u0001I\")\u0001n\ta\u0001U\u00069QO\\1qa2LH\u0003\u0002B\u0001\u0005\u0013\u0001B\u0001M3\u0003\u0004AA\u0001G!\u0002K'f#'.C\u0002\u0003\bE\u0012a\u0001V;qY\u0016,\u0004\u0002\u0003B\u0006I\u0005\u0005\t\u0019\u00019\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0012A!\u0011q\u0011B\n\u0013\u0011\u0011)\"!#\u0003\r=\u0013'.Z2u\u0001")
public class EncryptedSeed
implements SeedState,
Product,
Serializable {
    private final AesEncryptedData value;
    private final ByteVector salt;
    private final Instant creationTime;
    private final Option<Instant> backupTimeOpt;
    private final boolean imported;

    public static Option<Tuple5<AesEncryptedData, AesSalt, Instant, Option<Instant>, Object>> unapply(EncryptedSeed x$0) {
        return EncryptedSeed$.MODULE$.unapply(x$0);
    }

    public static EncryptedSeed apply(AesEncryptedData value, ByteVector salt, Instant creationTime, Option<Instant> backupTimeOpt, boolean imported) {
        return EncryptedSeed$.MODULE$.apply(value, salt, creationTime, backupTimeOpt, imported);
    }

    public static Function1<Tuple5<AesEncryptedData, AesSalt, Instant, Option<Instant>, Object>, EncryptedSeed> tupled() {
        return EncryptedSeed$.MODULE$.tupled();
    }

    public static Function1<AesEncryptedData, Function1<AesSalt, Function1<Instant, Function1<Option<Instant>, Function1<Object, EncryptedSeed>>>>> curried() {
        return EncryptedSeed$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public AesEncryptedData value() {
        return this.value;
    }

    public ByteVector salt() {
        return this.salt;
    }

    @Override
    public Instant creationTime() {
        return this.creationTime;
    }

    @Override
    public Option<Instant> backupTimeOpt() {
        return this.backupTimeOpt;
    }

    @Override
    public boolean imported() {
        return this.imported;
    }

    private Try<String> decryptStr(AesPassword password) {
        AesKey key = password.toKey(this.salt());
        Either either = AesCrypt$.MODULE$.decrypt(this.value(), key);
        return either.toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)decrypted -> {
            Failure failure;
            Either either = decrypted.decodeUtf8();
            if (either instanceof Left) {
                failure = new Failure((Throwable)ReadMnemonicError$DecryptionError$.MODULE$);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                String str = (String)right.value();
                failure = new Success((Object)str);
            } else {
                throw new MatchError((Object)either);
            }
            return failure;
        });
    }

    public Try<MnemonicCode> toMnemonic(AesPassword password) {
        return this.decryptStr(password).map((Function1 & Serializable)wordsStr -> {
            Vector wordsVec = Predef$.MODULE$.wrapRefArray((Object[])wordsStr.split(" ")).toVector();
            return MnemonicCode$.MODULE$.fromWords(wordsVec);
        });
    }

    public Try<ExtPrivateKey> toExtPrivKey(AesPassword password) {
        return this.decryptStr(password).map((Function1 & Serializable)base58 -> ExtPrivateKey$.MODULE$.fromString(base58));
    }

    @Override
    public SeedState withBackupTime(Instant backupTime) {
        EncryptedSeed encryptedSeed;
        if (this.backupTimeOpt().isEmpty()) {
            Some x$1 = new Some((Object)backupTime);
            AesEncryptedData x$2 = this.copy$default$1();
            ByteVector x$3 = this.copy$default$2();
            Instant x$4 = this.copy$default$3();
            boolean x$5 = this.copy$default$5();
            encryptedSeed = this.copy(x$2, x$3, x$4, (Option<Instant>)x$1, x$5);
        } else {
            encryptedSeed = this;
        }
        return encryptedSeed;
    }

    public EncryptedSeed copy(AesEncryptedData value, ByteVector salt, Instant creationTime, Option<Instant> backupTimeOpt, boolean imported) {
        return new EncryptedSeed(value, salt, creationTime, backupTimeOpt, imported);
    }

    public AesEncryptedData copy$default$1() {
        return this.value();
    }

    public ByteVector copy$default$2() {
        return this.salt();
    }

    public Instant copy$default$3() {
        return this.creationTime();
    }

    public Option<Instant> copy$default$4() {
        return this.backupTimeOpt();
    }

    public boolean copy$default$5() {
        return this.imported();
    }

    public String productPrefix() {
        return "EncryptedSeed";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.value();
                break;
            }
            case 1: {
                object = new AesSalt(this.salt());
                break;
            }
            case 2: {
                object = this.creationTime();
                break;
            }
            case 3: {
                object = this.backupTimeOpt();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.imported());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EncryptedSeed;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "value";
                break;
            }
            case 1: {
                string = "salt";
                break;
            }
            case 2: {
                string = "creationTime";
                break;
            }
            case 3: {
                string = "backupTimeOpt";
                break;
            }
            case 4: {
                string = "imported";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.value()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)new AesSalt(this.salt())));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.creationTime()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.backupTimeOpt()));
        n = Statics.mix((int)n, (int)(this.imported() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EncryptedSeed)) return false;
        boolean bl = true;
        if (!bl) return false;
        EncryptedSeed encryptedSeed = (EncryptedSeed)x$1;
        if (this.imported() != encryptedSeed.imported()) return false;
        AesEncryptedData aesEncryptedData = this.value();
        AesEncryptedData aesEncryptedData2 = encryptedSeed.value();
        if (aesEncryptedData == null) {
            if (aesEncryptedData2 != null) {
                return false;
            }
        } else if (!aesEncryptedData.equals(aesEncryptedData2)) return false;
        ByteVector byteVector = this.salt();
        ByteVector byteVector2 = encryptedSeed.salt();
        if (byteVector == null) {
            if (byteVector2 != null) {
                return false;
            }
        } else if (!byteVector.equals(byteVector2)) return false;
        Instant instant = this.creationTime();
        Instant instant2 = encryptedSeed.creationTime();
        if (instant == null) {
            if (instant2 != null) {
                return false;
            }
        } else if (!((Object)instant).equals(instant2)) return false;
        Option<Instant> option = this.backupTimeOpt();
        Option<Instant> option2 = encryptedSeed.backupTimeOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!encryptedSeed.canEqual(this)) return false;
        return true;
    }

    public EncryptedSeed(AesEncryptedData value, ByteVector salt, Instant creationTime, Option<Instant> backupTimeOpt, boolean imported) {
        this.value = value;
        this.salt = salt;
        this.creationTime = creationTime;
        this.backupTimeOpt = backupTimeOpt;
        this.imported = imported;
        Product.$init$((Product)this);
    }
}

