/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.NoSuchElementException;
import org.bitcoins.core.crypto.BIP39Seed;
import org.bitcoins.core.crypto.BIP39Seed$;
import org.bitcoins.core.crypto.ExtKeyPrivVersion;
import org.bitcoins.core.crypto.ExtPrivateKey;
import org.bitcoins.core.crypto.ExtPrivateKey$;
import org.bitcoins.core.crypto.ExtPrivateKeyHardened;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.core.crypto.MnemonicCode$;
import org.bitcoins.crypto.AesEncryptedData;
import org.bitcoins.crypto.AesIV;
import org.bitcoins.crypto.AesIV$;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.crypto.AesSalt;
import org.bitcoins.crypto.AesSalt$;
import org.bitcoins.keymanager.DecryptedExtPrivKey;
import org.bitcoins.keymanager.DecryptedMnemonic;
import org.bitcoins.keymanager.DecryptedSeedState;
import org.bitcoins.keymanager.EncryptedSeed;
import org.bitcoins.keymanager.KeyManagerLogger;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.ReadMnemonicError$DecryptionError$;
import org.bitcoins.keymanager.ReadMnemonicError$NotFoundError$;
import org.bitcoins.keymanager.SeedState;
import org.bitcoins.keymanager.WalletStorage;
import org.bitcoins.keymanager.WalletStorage$MnemonicJsonKeys$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;
import ujson.Bool$;
import ujson.Null$;
import ujson.Num;
import ujson.Obj;
import ujson.Obj$;
import ujson.ParseException;
import ujson.Readable;
import ujson.Readable$;
import ujson.Str;
import ujson.Value;
import ujson.Value$;

public final class WalletStorage$
implements KeyManagerLogger {
    public static final WalletStorage$ MODULE$ = new WalletStorage$();
    private static final String SEED_FOLDER_NAME;
    private static final String ENCRYPTED_SEED_FILE_NAME;
    private static final long GENESIS_TIME;
    private static final long FIRST_BITCOIN_S_WALLET_TIME;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
        SEED_FOLDER_NAME = "seeds";
        ENCRYPTED_SEED_FILE_NAME = "encrypted-bitcoin-s-seed.json";
        GENESIS_TIME = 1231006505L;
        FIRST_BITCOIN_S_WALLET_TIME = 1546042867L;
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WalletStorage$ walletStorage$ = this;
        synchronized (walletStorage$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    public String SEED_FOLDER_NAME() {
        return SEED_FOLDER_NAME;
    }

    public String ENCRYPTED_SEED_FILE_NAME() {
        return ENCRYPTED_SEED_FILE_NAME;
    }

    public long GENESIS_TIME() {
        return GENESIS_TIME;
    }

    public long FIRST_BITCOIN_S_WALLET_TIME() {
        return FIRST_BITCOIN_S_WALLET_TIME;
    }

    public boolean seedExists(Path seedPath) {
        return Files.exists(seedPath, new LinkOption[0]);
    }

    public Path writeSeedToDisk(Path seedPath, SeedState seed) {
        Path path;
        SeedState seedState = seed;
        if (seedState instanceof DecryptedMnemonic) {
            DecryptedMnemonic decryptedMnemonic = (DecryptedMnemonic)seedState;
            path = this.writeSeedToDisk(seedPath, decryptedMnemonic);
        } else if (seedState instanceof DecryptedExtPrivKey) {
            DecryptedExtPrivKey decryptedExtPrivKey = (DecryptedExtPrivKey)seedState;
            path = this.writeSeedToDisk(seedPath, decryptedExtPrivKey);
        } else if (seedState instanceof EncryptedSeed) {
            EncryptedSeed encryptedSeed = (EncryptedSeed)seedState;
            path = this.writeSeedToDisk(seedPath, encryptedSeed);
        } else {
            throw new MatchError((Object)seedState);
        }
        return path;
    }

    public Path writeSeedToDisk(Path seedPath, EncryptedSeed seed) {
        AesEncryptedData encrypted = seed.value();
        Obj jsObject = Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.IV()), (Object)new AesIV(encrypted.iv()).hex()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.CIPHER_TEXT()), (Object)Value$.MODULE$.JsonableString((CharSequence)encrypted.cipherText().toHex())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.SALT()), (Object)Value$.MODULE$.JsonableString((CharSequence)seed.salt().toHex())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.CREATION_TIME()), (Object)new Num((double)seed.creationTime().getEpochSecond())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.BACKUP_TIME()), seed.backupTimeOpt().map((Function1 & Serializable)ts -> new Num((double)ts.getEpochSecond())).getOrElse((Function0 & Serializable)() -> Null$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.IMPORTED()), (Object)Bool$.MODULE$.apply(seed.imported()))}), (Function1 & Serializable)s -> Value$.MODULE$.JsonableString(s));
        return this.writeSeedJsonToDisk(seedPath, jsObject);
    }

    public Path writeSeedToDisk(Path seedPath, DecryptedMnemonic mnemonic) {
        MnemonicCode mnemonicCode = mnemonic.mnemonicCode();
        Obj jsObject = Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.MNEMONIC_SEED()), (Object)mnemonicCode.toVector()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.CREATION_TIME()), (Object)new Num((double)mnemonic.creationTime().getEpochSecond())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.BACKUP_TIME()), mnemonic.backupTimeOpt().map((Function1 & Serializable)ts -> new Num((double)ts.getEpochSecond())).getOrElse((Function0 & Serializable)() -> Null$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.IMPORTED()), (Object)Bool$.MODULE$.apply(mnemonic.imported()))}), (Function1 & Serializable)items -> Value$.MODULE$.JsonableSeq(items, (Function1 & Serializable)s -> Value$.MODULE$.JsonableString(s)));
        return this.writeSeedJsonToDisk(seedPath, jsObject);
    }

    public Path writeSeedToDisk(Path seedPath, DecryptedExtPrivKey extKey) {
        Obj jsObject = Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.XPRV()), (Object)new Str(extKey.xprv().toStringSensitive())), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)WalletStorage$MnemonicJsonKeys$.MODULE$.CREATION_TIME()), (Object)new Num((double)extKey.creationTime().getEpochSecond()))}), Predef$.MODULE$.$conforms());
        return this.writeSeedJsonToDisk(seedPath, jsObject);
    }

    private Path writeSeedJsonToDisk(Path seedPath, Obj jsObject) {
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(16).append("Writing seed to ").append(seedPath).toString());
        String writtenJs = ujson.package$.MODULE$.write((Value)jsObject, ujson.package$.MODULE$.write$default$2(), ujson.package$.MODULE$.write$default$3());
        boolean hasMnemonic = Files.isRegularFile(seedPath, new LinkOption[0]);
        if (hasMnemonic) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(15).append(seedPath).append(" already exists").toString());
            throw new RuntimeException(new StringBuilder(67).append("Attempting to overwrite an existing seed, this is dangerous! path: ").append(seedPath).toString());
        }
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(15).append(seedPath).append(" does not exist").toString());
        return this.writeJsToDisk$1(seedPath, writtenJs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long parseCreationTime(Value json) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> (long)json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.CREATION_TIME())).num());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            long value = BoxesRunTime.unboxToLong((Object)success.value());
            return value;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NoSuchElementException) {
                return this.FIRST_BITCOIN_S_WALLET_TIME();
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable exception = failure.exception();
        throw exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Object> parseBackupTime(Value json) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.BACKUP_TIME())));
        if (try_ instanceof Success) {
            None$ none$;
            Success success = (Success)try_;
            Value js = (Value)success.value();
            Value value = js;
            if (Null$.MODULE$.equals(value)) {
                none$ = None$.MODULE$;
                return none$;
            } else {
                if (value == null) throw new MatchError((Object)value);
                Value value2 = value;
                none$ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> (long)value2.num()).toOption();
            }
            return none$;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NoSuchElementException) {
                return None$.MODULE$;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable exception = failure.exception();
        throw exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseImported(Value json) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.IMPORTED())));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Value js = (Value)success.value();
            return js.bool();
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NoSuchElementException) {
                return false;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable exception = failure.exception();
        throw exception;
    }

    /*
     * Unable to fully structure code
     */
    private Either<ReadMnemonicError, Value> readJsonFromDisk(Path seedPath) {
        block6: {
            block5: {
                if (!Files.isRegularFile(seedPath, new LinkOption[0])) break block5;
                rawJson = org.bitcoins.core.compat.package$.MODULE$.JavaConverters().ListHasAsScala(Files.readAllLines(seedPath)).asScala().mkString("\n");
                this.logger().debug((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$readJsonFromDisk$1(java.nio.file.Path ), ()Ljava/lang/String;)((Path)seedPath));
                var4_3 = false;
                var5_4 = null;
                var6_5 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$readJsonFromDisk$2(java.lang.String ), ()Lujson/Value;)((String)rawJson));
                if (!(var6_5 instanceof Failure)) ** GOTO lbl-1000
                var4_3 = true;
                var5_4 = (Failure)var6_5;
                var7_6 = var5_4.exception();
                if (var7_6 instanceof ParseException) {
                    var8_7 = (ParseException)var7_6;
                    clue = var8_7.clue();
                    var2_9 = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError(clue));
                } else lbl-1000:
                // 2 sources

                {
                    if (var4_3) {
                        exception = var5_4.exception();
                        throw exception;
                    }
                    if (var6_5 instanceof Success) {
                        var11_11 = (Success)var6_5;
                        value = (Value)var11_11.value();
                        this.logger().debug((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$readJsonFromDisk$3(java.nio.file.Path ), ()Ljava/lang/String;)((Path)seedPath));
                        var2_9 = package$.MODULE$.Right().apply((Object)value);
                    } else {
                        throw new MatchError((Object)var6_5);
                    }
                }
                v0 = var2_9;
                break block6;
            }
            this.logger().error((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$readJsonFromDisk$4(java.nio.file.Path ), ()Ljava/lang/String;)((Path)seedPath));
            v0 = package$.MODULE$.Left().apply((Object)ReadMnemonicError$NotFoundError$.MODULE$);
        }
        return v0;
    }

    private Either<ReadMnemonicError, EncryptedSeed> readEncryptedMnemonicFromJson(Value json) {
        Right right;
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(30).append("Read encrypted mnemonic JSON: ").append(json).toString());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            long creationTimeNum = MODULE$.parseCreationTime(json);
            Option<Object> backupTimeOpt = MODULE$.parseBackupTime(json);
            String ivString = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.IV())).str();
            String cipherTextString = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.CIPHER_TEXT())).str();
            String rawSaltString = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.SALT())).str();
            boolean imported = MODULE$.parseImported(json);
            return new WalletStorage.RawEncryptedSeed(ivString, cipherTextString, rawSaltString, creationTimeNum, backupTimeOpt, imported);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            WalletStorage.RawEncryptedSeed value = (WalletStorage.RawEncryptedSeed)success.value();
            right = package$.MODULE$.Right().apply((Object)value);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            right = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError(exception.getMessage()));
        } else {
            throw new MatchError((Object)try_);
        }
        Right readJsonTupleEither = right;
        return readJsonTupleEither.flatMap((Function1 & Serializable)x0$1 -> {
            Right right;
            WalletStorage.RawEncryptedSeed rawEncryptedSeed = x0$1;
            if (rawEncryptedSeed == null) throw new MatchError((Object)rawEncryptedSeed);
            String rawIv = rawEncryptedSeed.rawIv();
            String rawCipherText = rawEncryptedSeed.rawCipherText();
            String rawSalt = rawEncryptedSeed.rawSalt();
            long rawCreationTime = rawEncryptedSeed.rawCreationTime();
            Option<Object> rawBackupTime = rawEncryptedSeed.rawBackupTime();
            boolean rawImported = rawEncryptedSeed.rawImported();
            Option encryptedOpt = ByteVector$.MODULE$.fromHex(rawIv, ByteVector$.MODULE$.fromHex$default$2()).map((Function1 & Serializable)bytes -> new AesIV(AesIV$.MODULE$.fromValidBytes(bytes))).flatMap((Function1 & Serializable)iv -> WalletStorage$.$anonfun$readEncryptedMnemonicFromJson$5(rawCipherText, rawSalt, rawCreationTime, rawBackupTime, rawImported, ((AesIV)iv).bytes()));
            Option option = encryptedOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                EncryptedSeed encrypted = (EncryptedSeed)some.value();
                right = package$.MODULE$.Right().apply((Object)encrypted);
                return right;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                right = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError("JSON contents was not hex strings"));
            }
            return right;
        });
    }

    private Either<ReadMnemonicError, DecryptedMnemonic> readUnencryptedMnemonicFromJson(Value json) {
        Right right;
        this.logger().trace((Function0 & Serializable)() -> "Read mnemonic JSON: Masked(json)");
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            long creationTimeNum = MODULE$.parseCreationTime(json);
            Option<Object> backupTimeOpt = MODULE$.parseBackupTime(json);
            Vector words = (Vector)json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.MNEMONIC_SEED())).arr().toVector().map((Function1 & Serializable)x$2 -> x$2.str());
            boolean imported = MODULE$.parseImported(json);
            return new Tuple4((Object)words, (Object)BoxesRunTime.boxToLong((long)creationTimeNum), backupTimeOpt, (Object)BoxesRunTime.boxToBoolean((boolean)imported));
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple4 value = (Tuple4)success.value();
            right = package$.MODULE$.Right().apply((Object)value);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            right = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError(exception.getMessage()));
        } else {
            throw new MatchError((Object)try_);
        }
        Right readJsonTupleEither = right;
        return readJsonTupleEither.flatMap((Function1 & Serializable)x0$1 -> {
            Left left;
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) throw new MatchError((Object)tuple4);
            Vector words = (Vector)tuple4._1();
            long rawCreationTime = BoxesRunTime.unboxToLong((Object)tuple4._2());
            Option rawBackupTimeOpt = (Option)tuple4._3();
            boolean rawImported = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> MnemonicCode$.MODULE$.fromWords(words));
            if (try_ instanceof Failure) {
                left = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError("JSON contents was incorrectly formatted"));
                return left;
            } else {
                if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                Success success = (Success)try_;
                MnemonicCode mnemonicCode = (MnemonicCode)success.value();
                MODULE$.logger().debug((Function0 & Serializable)() -> "Parsed contents into a DecryptedMnemonic");
                DecryptedMnemonic decrypted = new DecryptedMnemonic(mnemonicCode, Instant.ofEpochSecond(rawCreationTime), (Option<Instant>)rawBackupTimeOpt.map((Function1 & Serializable)x$1 -> WalletStorage$.$anonfun$readUnencryptedMnemonicFromJson$7(BoxesRunTime.unboxToLong((Object)x$1))), rawImported);
                left = package$.MODULE$.Right().apply((Object)decrypted);
            }
            return left;
        });
    }

    private Either<ReadMnemonicError, DecryptedExtPrivKey> readUnencryptedSeedFromJson(Value json) {
        Right right;
        this.logger().trace((Function0 & Serializable)() -> "Read mnemonic JSON: Masked(json)");
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            long creationTimeNum = MODULE$.parseCreationTime(json);
            Option<Object> backupTimeOpt = MODULE$.parseBackupTime(json);
            String xprvStr = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.XPRV())).str();
            boolean imported = MODULE$.parseImported(json);
            return new Tuple4((Object)xprvStr, (Object)BoxesRunTime.boxToLong((long)creationTimeNum), backupTimeOpt, (Object)BoxesRunTime.boxToBoolean((boolean)imported));
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple4 value = (Tuple4)success.value();
            right = package$.MODULE$.Right().apply((Object)value);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            right = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError(exception.getMessage()));
        } else {
            throw new MatchError((Object)try_);
        }
        Right readJsonTupleEither = right;
        return readJsonTupleEither.flatMap((Function1 & Serializable)x0$1 -> {
            Left left;
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) throw new MatchError((Object)tuple4);
            String str = (String)tuple4._1();
            long rawCreationTime = BoxesRunTime.unboxToLong((Object)tuple4._2());
            Option rawBackupTimeOpt = (Option)tuple4._3();
            boolean rawImported = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Try try_ = ExtPrivateKey$.MODULE$.fromStringT(str);
            if (try_ instanceof Failure) {
                left = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError("JSON contents was correctly formatted"));
                return left;
            } else {
                if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                Success success = (Success)try_;
                ExtPrivateKey xprv = (ExtPrivateKey)success.value();
                MODULE$.logger().debug((Function0 & Serializable)() -> "Parsed contents into a DecryptedMnemonic");
                DecryptedExtPrivKey decrypted = new DecryptedExtPrivKey(xprv, Instant.ofEpochSecond(rawCreationTime), (Option<Instant>)rawBackupTimeOpt.map((Function1 & Serializable)x$1 -> WalletStorage$.$anonfun$readUnencryptedSeedFromJson$5(BoxesRunTime.unboxToLong((Object)x$1))), rawImported);
                left = package$.MODULE$.Right().apply((Object)decrypted);
            }
            return left;
        });
    }

    private Either<ReadMnemonicError, DecryptedSeedState> decryptSeed(EncryptedSeed encrypted, AesPassword passphrase) {
        Left left;
        Try<MnemonicCode> try_ = encrypted.toMnemonic(passphrase);
        if (try_ instanceof Failure) {
            Left left2;
            Try<ExtPrivateKey> try_2 = encrypted.toExtPrivKey(passphrase);
            if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable exc = failure.exception();
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(24).append("Error when decrypting ").append(encrypted).append(": ").append(exc).toString());
                left2 = package$.MODULE$.Left().apply((Object)ReadMnemonicError$DecryptionError$.MODULE$);
            } else if (try_2 instanceof Success) {
                Success success = (Success)try_2;
                ExtPrivateKey xprv = (ExtPrivateKey)success.value();
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Decrypted ").append(encrypted).append(" successfully").toString());
                DecryptedExtPrivKey decryptedExtPrivKey = new DecryptedExtPrivKey(xprv, encrypted.creationTime(), encrypted.backupTimeOpt(), encrypted.imported());
                left2 = package$.MODULE$.Right().apply((Object)decryptedExtPrivKey);
            } else {
                throw new MatchError(try_2);
            }
            left = left2;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            MnemonicCode mnemonic = (MnemonicCode)success.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Decrypted ").append(encrypted).append(" successfully").toString());
            DecryptedMnemonic decryptedMnemonic = new DecryptedMnemonic(mnemonic, encrypted.creationTime(), encrypted.backupTimeOpt(), encrypted.imported());
            left = package$.MODULE$.Right().apply((Object)decryptedMnemonic);
        } else {
            throw new MatchError(try_);
        }
        return left;
    }

    public Either<ReadMnemonicError, DecryptedSeedState> decryptSeedFromDisk(Path seedPath, Option<AesPassword> passphraseOpt) {
        Left left;
        Either<ReadMnemonicError, Value> jsonE = this.readJsonFromDisk(seedPath);
        Either<ReadMnemonicError, Value> either = jsonE;
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ReadMnemonicError error = (ReadMnemonicError)left2.value();
            left = package$.MODULE$.Left().apply((Object)error);
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            Value json = (Value)right.value();
            if (Try$.MODULE$.apply((Function0 & Serializable)() -> json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.IV()))).isSuccess()) {
                Left left4;
                Option<AesPassword> option = passphraseOpt;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AesPassword passphrase = (AesPassword)some.value();
                    left4 = this.readEncryptedMnemonicFromJson(json).flatMap((Function1 & Serializable)encrypted -> MODULE$.decryptSeed((EncryptedSeed)encrypted, passphrase));
                } else if (None$.MODULE$.equals(option)) {
                    left4 = package$.MODULE$.Left().apply((Object)ReadMnemonicError$DecryptionError$.MODULE$);
                } else {
                    throw new MatchError(option);
                }
                left3 = left4;
            } else if (Try$.MODULE$.apply((Function0 & Serializable)() -> json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.MNEMONIC_SEED()))).isSuccess()) {
                Either<ReadMnemonicError, DecryptedMnemonic> either2;
                Option<AesPassword> option = passphraseOpt;
                if (option instanceof Some) {
                    either2 = package$.MODULE$.Left().apply((Object)ReadMnemonicError$DecryptionError$.MODULE$);
                } else if (None$.MODULE$.equals(option)) {
                    either2 = this.readUnencryptedMnemonicFromJson(json);
                } else {
                    throw new MatchError(option);
                }
                left3 = either2;
            } else if (Try$.MODULE$.apply((Function0 & Serializable)() -> json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(WalletStorage$MnemonicJsonKeys$.MODULE$.XPRV()))).isSuccess()) {
                Either<ReadMnemonicError, DecryptedExtPrivKey> either3;
                Option<AesPassword> option = passphraseOpt;
                if (option instanceof Some) {
                    either3 = package$.MODULE$.Left().apply((Object)ReadMnemonicError$DecryptionError$.MODULE$);
                } else if (None$.MODULE$.equals(option)) {
                    either3 = this.readUnencryptedSeedFromJson(json);
                } else {
                    throw new MatchError(option);
                }
                left3 = either3;
            } else {
                left3 = package$.MODULE$.Left().apply((Object)new ReadMnemonicError.JsonParsingError("Seed file is incorrectly formatted"));
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public Try<Vector<String>> readDecryptedSeedPhraseForBackup(Path seedPath, Option<AesPassword> passphraseOpt) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Vector vector;
            block9: {
                Either<ReadMnemonicError, DecryptedSeedState> either;
                block6: {
                    MnemonicCode mnemonicCode;
                    block8: {
                        Option<Instant> option;
                        DecryptedSeedState decryptedSeedState;
                        DecryptedMnemonic decryptedMnemonic;
                        boolean bl;
                        block7: {
                            either = MODULE$.decryptSeedFromDisk(seedPath, passphraseOpt);
                            if (!(either instanceof Right)) break block6;
                            Right right = (Right)either;
                            DecryptedSeedState seedState = (DecryptedSeedState)right.value();
                            bl = false;
                            decryptedMnemonic = null;
                            decryptedSeedState = seedState;
                            if (!(decryptedSeedState instanceof DecryptedMnemonic)) break block7;
                            bl = true;
                            decryptedMnemonic = (DecryptedMnemonic)decryptedSeedState;
                            mnemonicCode = decryptedMnemonic.mnemonicCode$access$0();
                            Option<Instant> option2 = decryptedMnemonic.backupTimeOpt();
                            if (None$.MODULE$.equals(option2)) break block8;
                        }
                        if (bl && (option = decryptedMnemonic.backupTimeOpt()) instanceof Some) {
                            throw new WalletStorage.AlreadyBackedUpException("The seed is already backed up");
                        }
                        if (decryptedSeedState != null) {
                            DecryptedSeedState decryptedSeedState2 = decryptedSeedState;
                            throw new SecurityException(new StringBuilder(19).append("Unknown seed type: ").append(decryptedSeedState2.getClass().getName()).toString());
                        }
                        throw new MatchError((Object)decryptedSeedState);
                    }
                    vector = mnemonicCode.words();
                    break block9;
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ReadMnemonicError err = (ReadMnemonicError)left.value();
                    throw new SecurityException(err.toString());
                }
                throw new MatchError(either);
            }
            Vector vector2 = vector;
            return vector2;
        });
    }

    public Try<BoxedUnit> markSeedAsBackedUp(Path seedPath, Option<AesPassword> passphraseOpt) {
        Try try_;
        Either<ReadMnemonicError, DecryptedSeedState> either = this.decryptSeedFromDisk(seedPath, passphraseOpt);
        if (either instanceof Right) {
            Right right = (Right)either;
            DecryptedSeedState seedState = (DecryptedSeedState)right.value();
            try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                DecryptedSeedState decryptedSeedState = seedState;
                if (decryptedSeedState == null) throw new MatchError((Object)decryptedSeedState);
                DecryptedSeedState decryptedSeedState2 = decryptedSeedState;
                Option<Instant> option = decryptedSeedState2.backupTimeOpt();
                if (None$.MODULE$.equals(option)) {
                    void var6_11;
                    Option option2 = passphraseOpt;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        AesPassword pass = (AesPassword)some.value();
                        EncryptedSeed encryptedSeed = decryptedSeedState2.encrypt(pass);
                    } else {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                        DecryptedSeedState decryptedSeedState3 = decryptedSeedState2;
                    }
                    SeedState toWrite = var6_11.withBackupTime(Instant.now());
                    SeedState seedState = MODULE$.writeSeedState(seedPath, toWrite);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    if (!(option instanceof Some)) throw new MatchError(option);
                    MODULE$.logger().warn((Function0 & Serializable)() -> "Seed has already been backed up, ignoring new request to mark it as backed up");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ReadMnemonicError err = (ReadMnemonicError)left.value();
            try_ = new Failure((Throwable)new SecurityException(new StringBuilder(24).append("Error reading the seed: ").append(err).toString()));
        } else {
            throw new MatchError(either);
        }
        return try_;
    }

    public Try<Option<Instant>> getSeedBackupTime(Path seedPath, Option<AesPassword> passphraseOpt) {
        Success success;
        Either<ReadMnemonicError, DecryptedSeedState> either = this.decryptSeedFromDisk(seedPath, passphraseOpt);
        if (either instanceof Right) {
            Right right = (Right)either;
            DecryptedSeedState seedState = (DecryptedSeedState)right.value();
            success = new Success(seedState.backupTimeOpt());
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ReadMnemonicError err = (ReadMnemonicError)left.value();
            success = new Failure((Throwable)new SecurityException(new StringBuilder(24).append("Error reading the seed: ").append(err).toString()));
        } else {
            throw new MatchError(either);
        }
        return success;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SeedState changeAesPassword(Path seedPath, Option<AesPassword> oldPasswordOpt, Option<AesPassword> newPasswordOpt) {
        void var5_14;
        this.logger().info((Function0 & Serializable)() -> "Changing encryption password for seed");
        Either<ReadMnemonicError, DecryptedSeedState> either = this.decryptSeedFromDisk(seedPath, oldPasswordOpt);
        if (either instanceof Left) {
            Left left = (Left)either;
            ReadMnemonicError err = (ReadMnemonicError)left.value();
            throw scala.sys.package$.MODULE$.error(err.toString());
        }
        if (!(either instanceof Right)) throw new MatchError(either);
        Right right = (Right)either;
        DecryptedSeedState decrypted = (DecryptedSeedState)right.value();
        Option<AesPassword> option = newPasswordOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            AesPassword pass = (AesPassword)some.value();
            EncryptedSeed encryptedSeed = decrypted.encrypt(pass);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            DecryptedSeedState decryptedSeedState = decrypted;
        }
        void toWrite = var5_14;
        return this.writeSeedState(seedPath, (SeedState)toWrite);
    }

    private SeedState writeSeedState(Path seedPath, SeedState toWrite) {
        String fileName = ((Object)seedPath.getFileName()).toString();
        this.logger().info((Function0 & Serializable)() -> "Creating backup file...");
        Path backup = seedPath.getParent().resolve(new StringBuilder(7).append(fileName).append(".backup").toString());
        Files.move(seedPath, backup, new CopyOption[0]);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.writeSeedToDisk(seedPath, toWrite));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(71).append("Failed to write new seed, backup of previous seed file can be found at ").append(backup).toString());
            throw exception;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        this.logger().info((Function0 & Serializable)() -> "Successfully wrote to disk, deleting backup file");
        Files.delete(backup);
        SeedState seedState = toWrite;
        return seedState;
    }

    public ExtPrivateKeyHardened getPrivateKeyFromDisk(Path seedPath, ExtKeyPrivVersion privKeyVersion, Option<AesPassword> passphraseOpt, Option<String> bip39PasswordOpt) {
        ExtPrivateKeyHardened extPrivateKeyHardened;
        DecryptedSeedState decryptedSeed;
        DecryptedSeedState mnemonic;
        Either<ReadMnemonicError, DecryptedSeedState> either = this.decryptSeedFromDisk(seedPath, passphraseOpt);
        if (either instanceof Left) {
            Left left = (Left)either;
            ReadMnemonicError error = (ReadMnemonicError)left.value();
            throw scala.sys.package$.MODULE$.error(error.toString());
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        DecryptedSeedState decryptedSeedState = mnemonic = (DecryptedSeedState)right.value();
        DecryptedSeedState decryptedSeedState2 = decryptedSeed = decryptedSeedState;
        if (decryptedSeedState2 instanceof DecryptedMnemonic) {
            DecryptedMnemonic decryptedMnemonic = (DecryptedMnemonic)decryptedSeedState2;
            MnemonicCode mnemonicCode = decryptedMnemonic.mnemonicCode$access$0();
            BIP39Seed seed = BIP39Seed$.MODULE$.fromMnemonic(mnemonicCode, bip39PasswordOpt);
            extPrivateKeyHardened = seed.toExtPrivateKey(privKeyVersion).toHardened();
        } else if (decryptedSeedState2 instanceof DecryptedExtPrivKey) {
            DecryptedExtPrivKey decryptedExtPrivKey = (DecryptedExtPrivKey)decryptedSeedState2;
            ExtPrivateKey xprv = decryptedExtPrivKey.xprv$access$0();
            extPrivateKeyHardened = xprv.toHardened();
        } else {
            throw new MatchError((Object)decryptedSeedState2);
        }
        return extPrivateKeyHardened;
    }

    /*
     * WARNING - void declaration
     */
    private final Path writeJsToDisk$1(Path seedPath$1, String writtenJs$1) {
        void var3_3;
        Files.createDirectories(seedPath$1.getParent(), new FileAttribute[0]);
        Path writtenPath = Files.write(seedPath$1, writtenJs$1.getBytes(), new OpenOption[0]);
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(24).append("Wrote encrypted seed to ").append(seedPath$1).toString());
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$readJsonFromDisk$1(Path seedPath$2) {
        return new StringBuilder(23).append("Read raw mnemonic from ").append(seedPath$2).toString();
    }

    public static final /* synthetic */ Value $anonfun$readJsonFromDisk$2(String rawJson$1) {
        return ujson.package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(rawJson$1), ujson.package$.MODULE$.read$default$2());
    }

    public static final /* synthetic */ String $anonfun$readJsonFromDisk$3(Path seedPath$2) {
        return new StringBuilder(23).append("Parsed ").append(seedPath$2).append(" into valid json").toString();
    }

    public static final /* synthetic */ String $anonfun$readJsonFromDisk$4(Path seedPath$2) {
        return new StringBuilder(22).append("Mnemonic not found at ").append(seedPath$2).toString();
    }

    public static final /* synthetic */ ByteVector $anonfun$readEncryptedMnemonicFromJson$7(ByteVector x$1) {
        return ((AesSalt)AesSalt$.MODULE$.apply(x$1)).bytes();
    }

    public static final /* synthetic */ Instant $anonfun$readEncryptedMnemonicFromJson$10(long x$1) {
        return Instant.ofEpochSecond(x$1);
    }

    public static final /* synthetic */ EncryptedSeed $anonfun$readEncryptedMnemonicFromJson$8(ByteVector cipherText$1, ByteVector iv$1, long rawCreationTime$1, Option rawBackupTime$1, boolean rawImported$1, ByteVector salt) {
        MODULE$.logger().debug((Function0 & Serializable)() -> "Parsed contents into an EncryptedMnemonic");
        return new EncryptedSeed(new AesEncryptedData(cipherText$1, iv$1), salt, Instant.ofEpochSecond(rawCreationTime$1), (Option<Instant>)rawBackupTime$1.map((Function1 & Serializable)x$1 -> WalletStorage$.$anonfun$readEncryptedMnemonicFromJson$10(BoxesRunTime.unboxToLong((Object)x$1))), rawImported$1);
    }

    public static final /* synthetic */ Option $anonfun$readEncryptedMnemonicFromJson$5(String rawCipherText$1, String rawSalt$1, long rawCreationTime$1, Option rawBackupTime$1, boolean rawImported$1, ByteVector iv) {
        return ByteVector$.MODULE$.fromHex(rawCipherText$1, ByteVector$.MODULE$.fromHex$default$2()).flatMap((Function1 & Serializable)cipherText -> ByteVector$.MODULE$.fromHex(rawSalt$1, ByteVector$.MODULE$.fromHex$default$2()).map((Function1 & Serializable)x$1 -> new AesSalt(WalletStorage$.$anonfun$readEncryptedMnemonicFromJson$7(x$1))).map((Function1 & Serializable)salt -> WalletStorage$.$anonfun$readEncryptedMnemonicFromJson$8(cipherText, iv, rawCreationTime$1, rawBackupTime$1, rawImported$1, ((AesSalt)salt).bytes())));
    }

    public static final /* synthetic */ Instant $anonfun$readUnencryptedMnemonicFromJson$7(long x$1) {
        return Instant.ofEpochSecond(x$1);
    }

    public static final /* synthetic */ Instant $anonfun$readUnencryptedSeedFromJson$5(long x$1) {
        return Instant.ofEpochSecond(x$1);
    }

    private WalletStorage$() {
    }
}

