/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager;

import java.io.Serializable;
import java.nio.file.Path;
import java.time.Instant;
import org.bitcoins.core.crypto.ExtKeyPrivVersion;
import org.bitcoins.core.crypto.ExtPrivateKeyHardened;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.keymanager.DecryptedExtPrivKey;
import org.bitcoins.keymanager.DecryptedMnemonic;
import org.bitcoins.keymanager.DecryptedSeedState;
import org.bitcoins.keymanager.EncryptedSeed;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.SeedState;
import org.bitcoins.keymanager.WalletStorage$;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r]w!B.]\u0011\u0003\u0019g!B3]\u0011\u00031\u0007\"\u00029\u0002\t\u0003\t\bb\u0002:\u0002\u0005\u0004%\ta\u001d\u0005\u0007\u007f\u0006\u0001\u000b\u0011\u0002;\t\u0011\u0005\u0005\u0011A1A\u0005\u0002MDq!a\u0001\u0002A\u0003%A\u000fC\u0005\u0002\u0006\u0005\u0011\r\u0011\"\u0001\u0002\b!A\u0011qB\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0012\u0005\u0011\r\u0011\"\u0001\u0002\b!A\u00111C\u0001!\u0002\u0013\tI\u0001C\u0004\u0002\u0016\u0005!\t!a\u0006\b\u000f\u0005]\u0012\u0001#\u0003\u0002:\u00199\u0011QH\u0001\t\n\u0005}\u0002B\u00029\u000e\t\u0003\t\t\u0005C\u0005\u0002D5\u0011\r\u0011\"\u0001\u0002F!A\u0011\u0011K\u0007!\u0002\u0013\t9\u0005C\u0005\u0002T5\u0011\r\u0011\"\u0001\u0002F!A\u0011QK\u0007!\u0002\u0013\t9\u0005C\u0005\u0002X5\u0011\r\u0011\"\u0001\u0002F!A\u0011\u0011L\u0007!\u0002\u0013\t9\u0005C\u0005\u0002\\5\u0011\r\u0011\"\u0001\u0002F!A\u0011QL\u0007!\u0002\u0013\t9\u0005C\u0005\u0002`5\u0011\r\u0011\"\u0001\u0002F!A\u0011\u0011M\u0007!\u0002\u0013\t9\u0005C\u0005\u0002d5\u0011\r\u0011\"\u0001\u0002F!A\u0011QM\u0007!\u0002\u0013\t9\u0005C\u0005\u0002h5\u0011\r\u0011\"\u0001\u0002F!A\u0011\u0011N\u0007!\u0002\u0013\t9\u0005C\u0005\u0002l5\u0011\r\u0011\"\u0001\u0002F!A\u0011QN\u0007!\u0002\u0013\t9\u0005C\u0004\u0002p\u0005!\t!!\u001d\t\u000f\u0005=\u0014\u0001\"\u0001\u0002\u0000!9\u0011qN\u0001\u0005\u0002\u0005-\u0005bBA8\u0003\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003O\u000bA\u0011BAU\u0011\u001d\ti,\u0001C\u0005\u0003\u007fCq!a3\u0002\t\u0013\ti\rC\u0004\u0002X\u0006!I!!7\t\u000f\u0005u\u0017\u0001\"\u0003\u0002`\u001a1\u00111`\u0001A\u0003{D\u0011Ba\u0003)\u0005+\u0007I\u0011A:\t\u0013\t5\u0001F!E!\u0002\u0013!\b\"\u0003B\bQ\tU\r\u0011\"\u0001t\u0011%\u0011\t\u0002\u000bB\tB\u0003%A\u000fC\u0005\u0003\u0014!\u0012)\u001a!C\u0001g\"I!Q\u0003\u0015\u0003\u0012\u0003\u0006I\u0001\u001e\u0005\u000b\u0005/A#Q3A\u0005\u0002\u0005\u001d\u0001B\u0003B\rQ\tE\t\u0015!\u0003\u0002\n!Q!1\u0004\u0015\u0003\u0016\u0004%\tA!\b\t\u0015\t}\u0001F!E!\u0002\u0013\ty\r\u0003\u0006\u0003\"!\u0012)\u001a!C\u0001\u0005GA!B!\n)\u0005#\u0005\u000b\u0011BA\r\u0011\u0019\u0001\b\u0006\"\u0001\u0003(!I!q\u0007\u0015\u0002\u0002\u0013\u0005!\u0011\b\u0005\n\u0005\u000fB\u0013\u0013!C\u0001\u0005\u0013B\u0011Ba\u0018)#\u0003%\tA!\u0013\t\u0013\t\u0005\u0004&%A\u0005\u0002\t%\u0003\"\u0003B2QE\u0005I\u0011\u0001B3\u0011%\u0011I\u0007KI\u0001\n\u0003\u0011Y\u0007C\u0005\u0003p!\n\n\u0011\"\u0001\u0003r!I!Q\u000f\u0015\u0002\u0002\u0013\u0005\u0013Q\t\u0005\n\u0005oB\u0013\u0011!C\u0001\u0005sB\u0011B!!)\u0003\u0003%\tAa!\t\u0013\t=\u0005&!A\u0005B\tE\u0005\"\u0003BPQ\u0005\u0005I\u0011\u0001BQ\u0011%\u0011)\u000bKA\u0001\n\u0003\u00129\u000bC\u0005\u0003,\"\n\t\u0011\"\u0011\u0003.\"I!q\u0016\u0015\u0002\u0002\u0013\u0005#\u0011\u0017\u0005\n\u0005gC\u0013\u0011!C!\u0005k;\u0011B!/\u0002\u0003\u0003E\tAa/\u0007\u0013\u0005m\u0018!!A\t\u0002\tu\u0006B\u00029H\t\u0003\u0011)\u000eC\u0005\u00030\u001e\u000b\t\u0011\"\u0012\u00032\"I!q[$\u0002\u0002\u0013\u0005%\u0011\u001c\u0005\n\u0005O<\u0015\u0011!CA\u0005SD\u0011Ba>H\u0003\u0003%IA!?\t\u000f\r\u0005\u0011\u0001\"\u0003\u0004\u0004!91\u0011B\u0001\u0005\n\r-\u0001bBB\t\u0003\u0011%11\u0003\u0005\b\u00073\tA\u0011BB\u000e\u0011\u001d\u0019I$\u0001C\u0001\u0007w1aa!\u0012\u0002\u0001\r\u001d\u0003\"CB(%\n\u0005\t\u0015!\u0003u\u0011\u0019\u0001(\u000b\"\u0001\u0004R!91qK\u0001\u0005\u0002\re\u0003bBB9\u0003\u0011\u000511\u000f\u0005\b\u0007\u0003\u000bA\u0011ABB\u0011\u001d\u0019I*\u0001C\u0001\u00077Cqaa*\u0002\t\u0013\u0019I\u000bC\u0004\u00042\u0006!\taa-\u0002\u001b]\u000bG\u000e\\3u'R|'/Y4f\u0015\tif,\u0001\u0006lKfl\u0017M\\1hKJT!a\u00181\u0002\u0011\tLGoY8j]NT\u0011!Y\u0001\u0004_J<7\u0001\u0001\t\u0003I\u0006i\u0011\u0001\u0018\u0002\u000e/\u0006dG.\u001a;Ti>\u0014\u0018mZ3\u0014\u0007\u00059W\u000e\u0005\u0002iW6\t\u0011NC\u0001k\u0003\u0015\u00198-\u00197b\u0013\ta\u0017N\u0001\u0004B]f\u0014VM\u001a\t\u0003I:L!a\u001c/\u0003!-+\u00170T1oC\u001e,'\u000fT8hO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001d\u0003A\u0019V)\u0012#`\r>cE)\u0012*`\u001d\u0006kU)F\u0001u!\t)HP\u0004\u0002wuB\u0011q/[\u0007\u0002q*\u0011\u0011PY\u0001\u0007yI|w\u000e\u001e \n\u0005mL\u0017A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a_5\u0002#M+U\tR0G\u001f2#UIU0O\u00036+\u0005%\u0001\rF\u001d\u000e\u0013\u0016\f\u0015+F\t~\u001bV)\u0012#`\r&cUi\u0018(B\u001b\u0016\u000b\u0011$\u0012(D%f\u0003F+\u0012#`'\u0016+Ei\u0018$J\u0019\u0016{f*Q'FA\u0005aq)\u0012(F'&\u001bv\fV%N\u000bV\u0011\u0011\u0011\u0002\t\u0004Q\u0006-\u0011bAA\u0007S\n!Aj\u001c8h\u000359UIT#T\u0013N{F+S'FA\u0005Yb)\u0013*T)~\u0013\u0015\nV\"P\u0013:{6kX,B\u00192+Ek\u0018+J\u001b\u0016\u000bADR%S'R{&)\u0013+D\u001f&sulU0X\u00032cU\tV0U\u00136+\u0005%\u0001\u0006tK\u0016$W\t_5tiN$B!!\u0007\u0002 A\u0019\u0001.a\u0007\n\u0007\u0005u\u0011NA\u0004C_>dW-\u00198\t\u000f\u0005\u00052\u00021\u0001\u0002$\u0005A1/Z3e!\u0006$\b\u000e\u0005\u0003\u0002&\u0005MRBAA\u0014\u0015\u0011\tI#a\u000b\u0002\t\u0019LG.\u001a\u0006\u0005\u0003[\ty#A\u0002oS>T!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003k\t9C\u0001\u0003QCRD\u0017\u0001E'oK6|g.[2Kg>t7*Z=t!\r\tY$D\u0007\u0002\u0003\t\u0001RJ\\3n_:L7MS:p].+\u0017p]\n\u0003\u001b\u001d$\"!!\u000f\u0002\u0005%3VCAA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#\u0002BA'\u0003_\tA\u0001\\1oO&\u0019Q0a\u0013\u0002\u0007%3\u0006%A\u0006D\u0013BCUIU0U\u000bb#\u0016\u0001D\"J!\"+%k\u0018+F1R\u0003\u0013\u0001B*B\u0019R\u000bQaU!M)\u0002\nQb\u0011*F\u0003RKuJT0U\u00136+\u0015AD\"S\u000b\u0006#\u0016j\u0014(`)&kU\tI\u0001\u000e\u001b:+Uj\u0014(J\u0007~\u001bV)\u0012#\u0002\u001d5sU)T(O\u0013\u000e{6+R#EA\u0005!\u0001\f\u0015*W\u0003\u0015A\u0006K\u0015,!\u0003-\u0011\u0015iQ&V!~#\u0016*T#\u0002\u0019\t\u000b5iS+Q?RKU*\u0012\u0011\u0002\u0011%k\u0005k\u0014*U\u000b\u0012\u000b\u0011\"S'Q\u001fJ#V\t\u0012\u0011\u0002\u001f]\u0014\u0018\u000e^3TK\u0016$Gk\u001c#jg.$b!a\t\u0002t\u0005U\u0004bBA\u0011?\u0001\u0007\u00111\u0005\u0005\b\u0003oz\u0002\u0019AA=\u0003\u0011\u0019X-\u001a3\u0011\u0007\u0011\fY(C\u0002\u0002~q\u0013\u0011bU3fIN#\u0018\r^3\u0015\r\u0005\r\u0012\u0011QAB\u0011\u001d\t\t\u0003\ta\u0001\u0003GAq!a\u001e!\u0001\u0004\t)\tE\u0002e\u0003\u000fK1!!#]\u00055)en\u0019:zaR,GmU3fIR1\u00111EAG\u0003\u001fCq!!\t\"\u0001\u0004\t\u0019\u0003C\u0004\u0002\u0012\u0006\u0002\r!a%\u0002\u00115tW-\\8oS\u000e\u00042\u0001ZAK\u0013\r\t9\n\u0018\u0002\u0012\t\u0016\u001c'/\u001f9uK\u0012le.Z7p]&\u001cGCBA\u0012\u00037\u000bi\nC\u0004\u0002\"\t\u0002\r!a\t\t\u000f\u0005}%\u00051\u0001\u0002\"\u00061Q\r\u001f;LKf\u00042\u0001ZAR\u0013\r\t)\u000b\u0018\u0002\u0014\t\u0016\u001c'/\u001f9uK\u0012,\u0005\u0010\u001e)sSZ\\U-_\u0001\u0014oJLG/Z*fK\u0012T5o\u001c8U_\u0012K7o\u001b\u000b\u0007\u0003G\tY+!,\t\u000f\u0005\u00052\u00051\u0001\u0002$!9\u0011qV\u0012A\u0002\u0005E\u0016\u0001\u00036t\u001f\nTWm\u0019;\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS!!a.\u0002\u000bUT7o\u001c8\n\t\u0005m\u0016Q\u0017\u0002\u0004\u001f\nT\u0017!\u00059beN,7I]3bi&|g\u000eV5nKR!\u0011\u0011BAa\u0011\u001d\t\u0019\r\na\u0001\u0003\u000b\fAA[:p]B!\u00111WAd\u0013\u0011\tI-!.\u0003\u000bY\u000bG.^3\u0002\u001fA\f'o]3CC\u000e\\W\u000f\u001d+j[\u0016$B!a4\u0002VB)\u0001.!5\u0002\n%\u0019\u00111[5\u0003\r=\u0003H/[8o\u0011\u001d\t\u0019-\na\u0001\u0003\u000b\fQ\u0002]1sg\u0016LU\u000e]8si\u0016$G\u0003BA\r\u00037Dq!a1'\u0001\u0004\t)-\u0001\tsK\u0006$'j]8o\rJ|W\u000eR5tWR!\u0011\u0011]A}!!\t\u0019/!<\u0002t\u0006\u0015g\u0002BAs\u0003St1a^At\u0013\u0005Q\u0017bAAvS\u00069\u0001/Y2lC\u001e,\u0017\u0002BAx\u0003c\u0014a!R5uQ\u0016\u0014(bAAvSB\u0019A-!>\n\u0007\u0005]HLA\tSK\u0006$WJ\\3n_:L7-\u0012:s_JDq!!\t(\u0001\u0004\t\u0019C\u0001\tSC^,en\u0019:zaR,GmU3fIN1\u0001fZA\u0000\u0005\u000b\u00012\u0001\u001bB\u0001\u0013\r\u0011\u0019!\u001b\u0002\b!J|G-^2u!\u0011\t\u0019Oa\u0002\n\t\t%\u0011\u0011\u001f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006e\u0006<\u0018J^\u0001\u0007e\u0006<\u0018J\u001e\u0011\u0002\u001bI\fwoQ5qQ\u0016\u0014H+\u001a=u\u00039\u0011\u0018m^\"ja\",'\u000fV3yi\u0002\nqA]1x'\u0006dG/\u0001\u0005sC^\u001c\u0016\r\u001c;!\u0003=\u0011\u0018m^\"sK\u0006$\u0018n\u001c8US6,\u0017\u0001\u0005:bo\u000e\u0013X-\u0019;j_:$\u0016.\\3!\u00035\u0011\u0018m\u001e\"bG.,\b\u000fV5nKV\u0011\u0011qZ\u0001\u000fe\u0006<()Y2lkB$\u0016.\\3!\u0003-\u0011\u0018m^%na>\u0014H/\u001a3\u0016\u0005\u0005e\u0011\u0001\u0004:bo&k\u0007o\u001c:uK\u0012\u0004CC\u0004B\u0015\u0005W\u0011iCa\f\u00032\tM\"Q\u0007\t\u0004\u0003wA\u0003B\u0002B\u0006k\u0001\u0007A\u000f\u0003\u0004\u0003\u0010U\u0002\r\u0001\u001e\u0005\u0007\u0005')\u0004\u0019\u0001;\t\u000f\t]Q\u00071\u0001\u0002\n!9!1D\u001bA\u0002\u0005=\u0007b\u0002B\u0011k\u0001\u0007\u0011\u0011D\u0001\u0005G>\u0004\u0018\u0010\u0006\b\u0003*\tm\"Q\bB \u0005\u0003\u0012\u0019E!\u0012\t\u0011\t-a\u0007%AA\u0002QD\u0001Ba\u00047!\u0003\u0005\r\u0001\u001e\u0005\t\u0005'1\u0004\u0013!a\u0001i\"I!q\u0003\u001c\u0011\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u000571\u0004\u0013!a\u0001\u0003\u001fD\u0011B!\t7!\u0003\u0005\r!!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\n\u0016\u0004i\n53F\u0001B(!\u0011\u0011\tFa\u0017\u000e\u0005\tM#\u0002\u0002B+\u0005/\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te\u0013.\u0001\u0006b]:|G/\u0019;j_:LAA!\u0018\u0003T\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005ORC!!\u0003\u0003N\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B7U\u0011\tyM!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!1\u000f\u0016\u0005\u00033\u0011i%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005w\u00022\u0001\u001bB?\u0013\r\u0011y(\u001b\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u000b\u0013Y\tE\u0002i\u0005\u000fK1A!#j\u0005\r\te.\u001f\u0005\n\u0005\u001b{\u0014\u0011!a\u0001\u0005w\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BJ!\u0019\u0011)Ja'\u0003\u00066\u0011!q\u0013\u0006\u0004\u00053K\u0017AC2pY2,7\r^5p]&!!Q\u0014BL\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e!1\u0015\u0005\n\u0005\u001b\u000b\u0015\u0011!a\u0001\u0005\u000b\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011q\tBU\u0011%\u0011iIQA\u0001\u0002\u0004\u0011Y(\u0001\u0005iCND7i\u001c3f)\t\u0011Y(\u0001\u0005u_N#(/\u001b8h)\t\t9%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00033\u00119\fC\u0005\u0003\u000e\u0016\u000b\t\u00111\u0001\u0003\u0006\u0006\u0001\"+Y<F]\u000e\u0014\u0018\u0010\u001d;fIN+W\r\u001a\t\u0004\u0003w95#B$\u0003@\n-\u0007c\u0004Ba\u0005\u000f$H\u000f^A\u0005\u0003\u001f\fIB!\u000b\u000e\u0005\t\r'b\u0001BcS\u00069!/\u001e8uS6,\u0017\u0002\u0002Be\u0005\u0007\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87!\u0011\u0011iMa5\u000e\u0005\t='\u0002\u0002Bi\u0003_\t!![8\n\t\t%!q\u001a\u000b\u0003\u0005w\u000bQ!\u00199qYf$bB!\u000b\u0003\\\nu'q\u001cBq\u0005G\u0014)\u000f\u0003\u0004\u0003\f)\u0003\r\u0001\u001e\u0005\u0007\u0005\u001fQ\u0005\u0019\u0001;\t\r\tM!\n1\u0001u\u0011\u001d\u00119B\u0013a\u0001\u0003\u0013AqAa\u0007K\u0001\u0004\ty\rC\u0004\u0003\")\u0003\r!!\u0007\u0002\u000fUt\u0017\r\u001d9msR!!1\u001eBz!\u0015A\u0017\u0011\u001bBw!1A'q\u001e;ui\u0006%\u0011qZA\r\u0013\r\u0011\t0\u001b\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\tU8*!AA\u0002\t%\u0012a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1 \t\u0005\u0003\u0013\u0012i0\u0003\u0003\u0003\u0000\u0006-#AB(cU\u0016\u001cG/A\u000fsK\u0006$WI\\2ssB$X\rZ'oK6|g.[2Ge>l'j]8o)\u0011\u0019)aa\u0002\u0011\u0011\u0005\r\u0018Q^Az\u0003\u000bCq!a1N\u0001\u0004\t)-A\u0010sK\u0006$WK\\3oGJL\b\u000f^3e\u001b:,Wn\u001c8jG\u001a\u0013x.\u001c&t_:$Ba!\u0004\u0004\u0010AA\u00111]Aw\u0003g\f\u0019\nC\u0004\u0002D:\u0003\r!!2\u00027I,\u0017\rZ+oK:\u001c'/\u001f9uK\u0012\u001cV-\u001a3Ge>l'j]8o)\u0011\u0019)ba\u0006\u0011\u0011\u0005\r\u0018Q^Az\u0003CCq!a1P\u0001\u0004\t)-A\u0006eK\u000e\u0014\u0018\u0010\u001d;TK\u0016$GCBB\u000f\u0007K\u0019I\u0003\u0005\u0005\u0002d\u00065\u00181_B\u0010!\r!7\u0011E\u0005\u0004\u0007Ga&A\u0005#fGJL\b\u000f^3e'\u0016,Gm\u0015;bi\u0016Dqaa\nQ\u0001\u0004\t))A\u0005f]\u000e\u0014\u0018\u0010\u001d;fI\"911\u0006)A\u0002\r5\u0012A\u00039bgN\u0004\bN]1tKB!1qFB\u001b\u001b\t\u0019\tDC\u0002\u00044y\u000baa\u0019:zaR|\u0017\u0002BB\u001c\u0007c\u00111\"Q3t!\u0006\u001c8o^8sI\u0006\u0019B-Z2ssB$8+Z3e\rJ|W\u000eR5tWR11QDB\u001f\u0007\u007fAq!!\tR\u0001\u0004\t\u0019\u0003C\u0004\u0004BE\u0003\raa\u0011\u0002\u001bA\f7o\u001d9ie\u0006\u001cXm\u00149u!\u0015A\u0017\u0011[B\u0017\u0005a\tEN]3bIf\u0014\u0015mY6fIV\u0003X\t_2faRLwN\\\n\u0004%\u000e%\u0003\u0003BA%\u0007\u0017JAa!\u0014\u0002L\t\t2+Z2ve&$\u00180\u0012=dKB$\u0018n\u001c8\u0002\u00075\u001cx\r\u0006\u0003\u0004T\rU\u0003cAA\u001e%\"11q\n+A\u0002Q\f\u0001E]3bI\u0012+7M]=qi\u0016$7+Z3e!\"\u0014\u0018m]3G_J\u0014\u0015mY6vaR111LB7\u0007_\u0002ba!\u0018\u0004d\r\u001dTBAB0\u0015\r\u0019\t'[\u0001\u0005kRLG.\u0003\u0003\u0004f\r}#a\u0001+ssB)\u00111]B5i&!11NAy\u0005\u00191Vm\u0019;pe\"9\u0011\u0011E+A\u0002\u0005\r\u0002bBB!+\u0002\u000711I\u0001\u0013[\u0006\u00148nU3fI\u0006\u001b()Y2lK\u0012,\u0006\u000f\u0006\u0004\u0004v\ru4q\u0010\t\u0007\u0007;\u001a\u0019ga\u001e\u0011\u0007!\u001cI(C\u0002\u0004|%\u0014A!\u00168ji\"9\u0011\u0011\u0005,A\u0002\u0005\r\u0002bBB!-\u0002\u000711I\u0001\u0012O\u0016$8+Z3e\u0005\u0006\u001c7.\u001e9US6,GCBBC\u0007+\u001b9\n\u0005\u0004\u0004^\r\r4q\u0011\t\u0006Q\u0006E7\u0011\u0012\t\u0005\u0007\u0017\u001b\t*\u0004\u0002\u0004\u000e*!1qRA\u0018\u0003\u0011!\u0018.\\3\n\t\rM5Q\u0012\u0002\b\u0013:\u001cH/\u00198u\u0011\u001d\t\tc\u0016a\u0001\u0003GAqa!\u0011X\u0001\u0004\u0019\u0019%A\tdQ\u0006tw-Z!fgB\u000b7o]<pe\u0012$\u0002\"!\u001f\u0004\u001e\u000e}51\u0015\u0005\b\u0003CA\u0006\u0019AA\u0012\u0011\u001d\u0019\t\u000b\u0017a\u0001\u0007\u0007\nab\u001c7e!\u0006\u001c8o^8sI>\u0003H\u000fC\u0004\u0004&b\u0003\raa\u0011\u0002\u001d9,w\u000fU1tg^|'\u000fZ(qi\u0006qqO]5uKN+W\rZ*uCR,GCBA=\u0007W\u001bi\u000bC\u0004\u0002\"e\u0003\r!a\t\t\u000f\r=\u0016\f1\u0001\u0002z\u00059Ao\\,sSR,\u0017!F4fiB\u0013\u0018N^1uK.+\u0017P\u0012:p[\u0012K7o\u001b\u000b\u000b\u0007k\u001b\u0019m!2\u0004P\u000eE\u0007\u0003BB\\\u0007\u007fk!a!/\u000b\t\rM21\u0018\u0006\u0004\u0007{s\u0016\u0001B2pe\u0016LAa!1\u0004:\n)R\t\u001f;Qe&4\u0018\r^3LKfD\u0015M\u001d3f]\u0016$\u0007bBA\u00115\u0002\u0007\u00111\u0005\u0005\b\u0007\u000fT\u0006\u0019ABe\u00039\u0001(/\u001b<LKf4VM]:j_:\u0004Baa.\u0004L&!1QZB]\u0005E)\u0005\u0010^&fsB\u0013\u0018N\u001e,feNLwN\u001c\u0005\b\u0007\u0003R\u0006\u0019AB\"\u0011\u001d\u0019\u0019N\u0017a\u0001\u0007+\f\u0001CY5qge\u0002\u0016m]:x_J$w\n\u001d;\u0011\t!\f\t\u000e\u001e")
public final class WalletStorage {
    public static ExtPrivateKeyHardened getPrivateKeyFromDisk(Path seedPath, ExtKeyPrivVersion privKeyVersion, Option<AesPassword> passphraseOpt, Option<String> bip39PasswordOpt) {
        return WalletStorage$.MODULE$.getPrivateKeyFromDisk(seedPath, privKeyVersion, passphraseOpt, bip39PasswordOpt);
    }

    public static SeedState changeAesPassword(Path seedPath, Option<AesPassword> oldPasswordOpt, Option<AesPassword> newPasswordOpt) {
        return WalletStorage$.MODULE$.changeAesPassword(seedPath, oldPasswordOpt, newPasswordOpt);
    }

    public static Try<Option<Instant>> getSeedBackupTime(Path seedPath, Option<AesPassword> passphraseOpt) {
        return WalletStorage$.MODULE$.getSeedBackupTime(seedPath, passphraseOpt);
    }

    public static Try<BoxedUnit> markSeedAsBackedUp(Path seedPath, Option<AesPassword> passphraseOpt) {
        return WalletStorage$.MODULE$.markSeedAsBackedUp(seedPath, passphraseOpt);
    }

    public static Try<Vector<String>> readDecryptedSeedPhraseForBackup(Path seedPath, Option<AesPassword> passphraseOpt) {
        return WalletStorage$.MODULE$.readDecryptedSeedPhraseForBackup(seedPath, passphraseOpt);
    }

    public static Either<ReadMnemonicError, DecryptedSeedState> decryptSeedFromDisk(Path seedPath, Option<AesPassword> passphraseOpt) {
        return WalletStorage$.MODULE$.decryptSeedFromDisk(seedPath, passphraseOpt);
    }

    public static Path writeSeedToDisk(Path seedPath, DecryptedExtPrivKey extKey) {
        return WalletStorage$.MODULE$.writeSeedToDisk(seedPath, extKey);
    }

    public static Path writeSeedToDisk(Path seedPath, DecryptedMnemonic mnemonic) {
        return WalletStorage$.MODULE$.writeSeedToDisk(seedPath, mnemonic);
    }

    public static Path writeSeedToDisk(Path seedPath, EncryptedSeed seed) {
        return WalletStorage$.MODULE$.writeSeedToDisk(seedPath, seed);
    }

    public static Path writeSeedToDisk(Path seedPath, SeedState seed) {
        return WalletStorage$.MODULE$.writeSeedToDisk(seedPath, seed);
    }

    public static boolean seedExists(Path seedPath) {
        return WalletStorage$.MODULE$.seedExists(seedPath);
    }

    public static long FIRST_BITCOIN_S_WALLET_TIME() {
        return WalletStorage$.MODULE$.FIRST_BITCOIN_S_WALLET_TIME();
    }

    public static long GENESIS_TIME() {
        return WalletStorage$.MODULE$.GENESIS_TIME();
    }

    public static String ENCRYPTED_SEED_FILE_NAME() {
        return WalletStorage$.MODULE$.ENCRYPTED_SEED_FILE_NAME();
    }

    public static String SEED_FOLDER_NAME() {
        return WalletStorage$.MODULE$.SEED_FOLDER_NAME();
    }

    public static class AlreadyBackedUpException
    extends SecurityException {
        public AlreadyBackedUpException(String msg) {
            super(msg);
        }
    }

    public static class RawEncryptedSeed
    implements Product,
    Serializable {
        private final String rawIv;
        private final String rawCipherText;
        private final String rawSalt;
        private final long rawCreationTime;
        private final Option<Object> rawBackupTime;
        private final boolean rawImported;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String rawIv() {
            return this.rawIv;
        }

        public String rawCipherText() {
            return this.rawCipherText;
        }

        public String rawSalt() {
            return this.rawSalt;
        }

        public long rawCreationTime() {
            return this.rawCreationTime;
        }

        public Option<Object> rawBackupTime() {
            return this.rawBackupTime;
        }

        public boolean rawImported() {
            return this.rawImported;
        }

        public RawEncryptedSeed copy(String rawIv, String rawCipherText, String rawSalt, long rawCreationTime, Option<Object> rawBackupTime, boolean rawImported) {
            return new RawEncryptedSeed(rawIv, rawCipherText, rawSalt, rawCreationTime, rawBackupTime, rawImported);
        }

        public String copy$default$1() {
            return this.rawIv();
        }

        public String copy$default$2() {
            return this.rawCipherText();
        }

        public String copy$default$3() {
            return this.rawSalt();
        }

        public long copy$default$4() {
            return this.rawCreationTime();
        }

        public Option<Object> copy$default$5() {
            return this.rawBackupTime();
        }

        public boolean copy$default$6() {
            return this.rawImported();
        }

        public String productPrefix() {
            return "RawEncryptedSeed";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.rawIv();
                    break;
                }
                case 1: {
                    object = this.rawCipherText();
                    break;
                }
                case 2: {
                    object = this.rawSalt();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.rawCreationTime());
                    break;
                }
                case 4: {
                    object = this.rawBackupTime();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.rawImported());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RawEncryptedSeed;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "rawIv";
                    break;
                }
                case 1: {
                    string = "rawCipherText";
                    break;
                }
                case 2: {
                    string = "rawSalt";
                    break;
                }
                case 3: {
                    string = "rawCreationTime";
                    break;
                }
                case 4: {
                    string = "rawBackupTime";
                    break;
                }
                case 5: {
                    string = "rawImported";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rawIv()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rawCipherText()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rawSalt()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.rawCreationTime()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rawBackupTime()));
            n = Statics.mix((int)n, (int)(this.rawImported() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RawEncryptedSeed)) return false;
            boolean bl = true;
            if (!bl) return false;
            RawEncryptedSeed rawEncryptedSeed = (RawEncryptedSeed)x$1;
            if (this.rawCreationTime() != rawEncryptedSeed.rawCreationTime()) return false;
            if (this.rawImported() != rawEncryptedSeed.rawImported()) return false;
            String string = this.rawIv();
            String string2 = rawEncryptedSeed.rawIv();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.rawCipherText();
            String string4 = rawEncryptedSeed.rawCipherText();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.rawSalt();
            String string6 = rawEncryptedSeed.rawSalt();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Option<Object> option = this.rawBackupTime();
            Option<Object> option2 = rawEncryptedSeed.rawBackupTime();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!rawEncryptedSeed.canEqual(this)) return false;
            return true;
        }

        public RawEncryptedSeed(String rawIv, String rawCipherText, String rawSalt, long rawCreationTime, Option<Object> rawBackupTime, boolean rawImported) {
            this.rawIv = rawIv;
            this.rawCipherText = rawCipherText;
            this.rawSalt = rawSalt;
            this.rawCreationTime = rawCreationTime;
            this.rawBackupTime = rawBackupTime;
            this.rawImported = rawImported;
            Product.$init$((Product)this);
        }
    }
}

