/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager.bip39;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import org.bitcoins.core.api.keymanager.BIP39KeyManagerCreateApi;
import org.bitcoins.core.api.keymanager.KeyManagerApi;
import org.bitcoins.core.crypto.BIP39Seed;
import org.bitcoins.core.crypto.BIP39Seed$;
import org.bitcoins.core.crypto.ExtKeyPrivVersion;
import org.bitcoins.core.crypto.ExtPrivateKey;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.core.crypto.MnemonicCode$;
import org.bitcoins.core.util.HDUtil$;
import org.bitcoins.core.util.TimeUtil$;
import org.bitcoins.core.wallet.keymanagement.InitializeKeyManagerError;
import org.bitcoins.core.wallet.keymanagement.KeyManagerInitializeError;
import org.bitcoins.core.wallet.keymanagement.KeyManagerParams;
import org.bitcoins.core.wallet.keymanagement.KeyManagerUnlockError;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.crypto.AesPassword$;
import org.bitcoins.keymanager.DecryptedExtPrivKey;
import org.bitcoins.keymanager.DecryptedMnemonic;
import org.bitcoins.keymanager.DecryptedSeedState;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.SeedState;
import org.bitcoins.keymanager.WalletStorage$;
import org.bitcoins.keymanager.bip39.BIP39KeyManager;
import org.bitcoins.keymanager.bip39.BIP39LockedKeyManager$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try$;
import scodec.bits.BitVector;

public final class BIP39KeyManager$
implements BIP39KeyManagerCreateApi<BIP39KeyManager>,
Logging {
    public static final BIP39KeyManager$ MODULE$ = new BIP39KeyManager$();
    private static final AesPassword badPassphrase;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        BIP39KeyManagerCreateApi.$init$((BIP39KeyManagerCreateApi)MODULE$);
        Logging.$init$((Logging)MODULE$);
        badPassphrase = AesPassword$.MODULE$.fromString("changeMe");
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public final Either<KeyManagerInitializeError, BIP39KeyManager> initialize(Option<AesPassword> aesPasswordOpt, KeyManagerParams kmParams, Option<String> bip39PasswordOpt) {
        return BIP39KeyManagerCreateApi.initialize$((BIP39KeyManagerCreateApi)this, aesPasswordOpt, (KeyManagerParams)kmParams, bip39PasswordOpt);
    }

    public final Either<KeyManagerInitializeError, BIP39KeyManager> initializeWithMnemonic(Option<AesPassword> aesPasswordOpt, MnemonicCode mnemonicCode, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        return BIP39KeyManagerCreateApi.initializeWithMnemonic$((BIP39KeyManagerCreateApi)this, aesPasswordOpt, (MnemonicCode)mnemonicCode, bip39PasswordOpt, (KeyManagerParams)kmParams);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BIP39KeyManager$ bIP39KeyManager$ = this;
        synchronized (bIP39KeyManager$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    public BIP39KeyManager fromMnemonic(MnemonicCode mnemonic, KeyManagerParams kmParams, Option<String> bip39PasswordOpt, Instant creationTime, boolean imported) {
        BIP39Seed seed = BIP39Seed$.MODULE$.fromMnemonic(mnemonic, bip39PasswordOpt);
        ExtKeyPrivVersion privVersion = HDUtil$.MODULE$.getXprivVersion(kmParams.purpose(), kmParams.network());
        ExtPrivateKey rootExtPrivKey = seed.toExtPrivateKey(privVersion);
        return new BIP39KeyManager(rootExtPrivKey, kmParams, creationTime, imported);
    }

    public AesPassword badPassphrase() {
        return badPassphrase;
    }

    /*
     * Unable to fully structure code
     */
    public Either<KeyManagerInitializeError, BIP39KeyManager> initializeWithEntropy(Option<AesPassword> aesPasswordOpt, BitVector entropy, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        block15: {
            block14: {
                seedPath = kmParams.seedPath();
                this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$1(java.nio.file.Path ), ()Ljava/lang/String;)((Path)seedPath));
                time = TimeUtil$.MODULE$.now();
                if (!Files.notExists(seedPath, new LinkOption[0])) break block14;
                this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$2(java.nio.file.Path ), ()Ljava/lang/String;)((Path)seedPath));
                Files.createDirectories(seedPath.getParent(), new FileAttribute[0]);
                var13_8 = mnemonicT = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$3(scodec.bits.BitVector ), ()Lorg/bitcoins/core/crypto/MnemonicCode;)((BitVector)entropy));
                if (var13_8 instanceof Success) {
                    var14_9 = (Success)var13_8;
                    mnemonic = (MnemonicCode)var14_9.value();
                    this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$4(), ()Ljava/lang/String;)());
                    var7_11 = package$.MODULE$.Right().apply((Object)mnemonic);
                } else if (var13_8 instanceof Failure) {
                    var16_12 = (Failure)var13_8;
                    err = var16_12.exception();
                    this.logger().error((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$5(java.lang.Throwable ), ()Ljava/lang/String;)((Throwable)err));
                    var7_11 = package$.MODULE$.Left().apply((Object)InitializeKeyManagerError.BadEntropy$.MODULE$);
                } else {
                    throw new MatchError((Object)var13_8);
                }
                mnemonicE = var7_11;
                writableMnemonicE = mnemonicE.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$initializeWithEntropy$6(java.time.Instant scala.Option org.bitcoins.core.crypto.MnemonicCode ), (Lorg/bitcoins/core/crypto/MnemonicCode;)Lorg/bitcoins/keymanager/SeedState;)((Instant)time, aesPasswordOpt));
                v0 = mnemonicE.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$initializeWithEntropy$7(scala.util.Either java.nio.file.Path org.bitcoins.core.wallet.keymanagement.KeyManagerParams scala.Option java.time.Instant org.bitcoins.core.crypto.MnemonicCode ), (Lorg/bitcoins/core/crypto/MnemonicCode;)Lscala/util/Either;)((Either)writableMnemonicE, (Path)seedPath, (KeyManagerParams)kmParams, bip39PasswordOpt, (Instant)time));
                break block15;
            }
            this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$10(java.nio.file.Path ), ()Ljava/lang/String;)((Path)seedPath));
            var19_16 = false;
            var20_17 = null;
            var21_18 = WalletStorage$.MODULE$.decryptSeedFromDisk(kmParams.seedPath(), aesPasswordOpt);
            if (!(var21_18 instanceof Right)) ** GOTO lbl-1000
            var19_16 = true;
            var20_17 = (Right)var21_18;
            mnemonic = (DecryptedSeedState)var20_17.value();
            if (mnemonic instanceof DecryptedMnemonic) {
                var23_20 = (DecryptedMnemonic)mnemonic;
                var6_21 = package$.MODULE$.Right().apply((Object)this.fromMnemonic(var23_20.mnemonicCode(), kmParams, bip39PasswordOpt, var23_20.creationTime(), var23_20.imported()));
            } else if (var19_16 && (xprv = (DecryptedSeedState)var20_17.value()) instanceof DecryptedExtPrivKey) {
                var25_23 = (DecryptedExtPrivKey)xprv;
                km = new BIP39KeyManager(var25_23.xprv(), kmParams, var25_23.creationTime(), var25_23.imported());
                var6_21 = package$.MODULE$.Right().apply((Object)km);
            } else if (var21_18 instanceof Left) {
                var27_25 = (Left)var21_18;
                err = (ReadMnemonicError)var27_25.value();
                var6_21 = package$.MODULE$.Left().apply((Object)new InitializeKeyManagerError.FailedToReadWrittenSeed((KeyManagerUnlockError)new KeyManagerUnlockError.JsonParsingError(err.toString())));
            } else {
                throw new MatchError(var21_18);
            }
            v0 = var6_21;
        }
        writtenToDiskE = v0;
        unlocked = BIP39LockedKeyManager$.MODULE$.unlock(aesPasswordOpt, bip39PasswordOpt, kmParams);
        var31_30 = biasedFinalE = writtenToDiskE.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$initializeWithEntropy$11(scala.util.Either org.bitcoins.core.api.keymanager.KeyManagerApi ), (Lorg/bitcoins/core/api/keymanager/KeyManagerApi;)Lscala/util/Either;)(unlocked));
        if (var31_30 instanceof Right) {
            var32_31 = (Right)var31_30;
            initSuccess = (BIP39KeyManager)var32_31.value();
            this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$14(), ()Ljava/lang/String;)());
            var5_33 = package$.MODULE$.Right().apply((Object)initSuccess);
        } else if (var31_30 instanceof Left) {
            var34_34 = (Left)var31_30;
            err = (KeyManagerInitializeError)var34_34.value();
            this.logger().error((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initializeWithEntropy$15(org.bitcoins.core.wallet.keymanagement.KeyManagerInitializeError ), ()Ljava/lang/String;)((KeyManagerInitializeError)err));
            var5_33 = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)var31_30);
        }
        return var5_33;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<ReadMnemonicError, BIP39KeyManager> fromParams(KeyManagerParams kmParams, Option<AesPassword> passwordOpt, Option<String> bip39PasswordOpt) {
        DecryptedSeedState xprv;
        Either<ReadMnemonicError, DecryptedSeedState> mnemonicCodeE = WalletStorage$.MODULE$.decryptSeedFromDisk(kmParams.seedPath(), passwordOpt);
        boolean bl = false;
        Right right = null;
        Either<ReadMnemonicError, DecryptedSeedState> either = mnemonicCodeE;
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            DecryptedSeedState mnemonic = (DecryptedSeedState)right.value();
            if (mnemonic instanceof DecryptedMnemonic) {
                DecryptedMnemonic decryptedMnemonic = (DecryptedMnemonic)mnemonic;
                return package$.MODULE$.Right().apply((Object)this.fromMnemonic(decryptedMnemonic.mnemonicCode(), kmParams, bip39PasswordOpt, decryptedMnemonic.creationTime(), decryptedMnemonic.imported()));
            }
        }
        if (bl && (xprv = (DecryptedSeedState)right.value()) instanceof DecryptedExtPrivKey) {
            DecryptedExtPrivKey decryptedExtPrivKey = (DecryptedExtPrivKey)xprv;
            BIP39KeyManager km = new BIP39KeyManager(decryptedExtPrivKey.xprv(), kmParams, decryptedExtPrivKey.creationTime(), decryptedExtPrivKey.imported());
            return package$.MODULE$.Right().apply((Object)km);
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Left left = (Left)either;
        ReadMnemonicError v = (ReadMnemonicError)left.value();
        return package$.MODULE$.Left().apply((Object)v);
    }

    public static final /* synthetic */ String $anonfun$initializeWithEntropy$1(Path seedPath$1) {
        return new StringBuilder(34).append("Initializing wallet with seedPath=").append(seedPath$1).toString();
    }

    public static final /* synthetic */ String $anonfun$initializeWithEntropy$2(Path seedPath$1) {
        return new StringBuilder(52).append("Seed path parent directory does not exist, creating ").append(seedPath$1.getParent()).toString();
    }

    public static final /* synthetic */ MnemonicCode $anonfun$initializeWithEntropy$3(BitVector entropy$1) {
        return MnemonicCode$.MODULE$.fromEntropy(entropy$1);
    }

    public static final /* synthetic */ String $anonfun$initializeWithEntropy$4() {
        return "Created mnemonic from entropy";
    }

    public static final /* synthetic */ String $anonfun$initializeWithEntropy$5(Throwable err$1) {
        return new StringBuilder(40).append("Could not create mnemonic from entropy! ").append(err$1).toString();
    }

    public static final /* synthetic */ SeedState $anonfun$initializeWithEntropy$6(Instant time$1, Option aesPasswordOpt$1, MnemonicCode mnemonic) {
        Product product;
        DecryptedMnemonic decryptedMnemonic = new DecryptedMnemonic(mnemonic, time$1, (Option<Instant>)None$.MODULE$, false);
        Option option = aesPasswordOpt$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            AesPassword aesPassword = (AesPassword)some.value();
            product = decryptedMnemonic.encrypt(aesPassword);
        } else if (None$.MODULE$.equals(option)) {
            product = decryptedMnemonic;
        } else {
            throw new MatchError((Object)option);
        }
        return product;
    }

    public static final /* synthetic */ Either $anonfun$initializeWithEntropy$7(Either writableMnemonicE$1, Path seedPath$1, KeyManagerParams kmParams$1, Option bip39PasswordOpt$1, Instant time$1, MnemonicCode mnemonic) {
        return writableMnemonicE$1.map((Function1 & Serializable)writable -> {
            Path mnemonicPath = WalletStorage$.MODULE$.writeSeedToDisk(seedPath$1, (SeedState)writable);
            MODULE$.logger().info((Function0 & Serializable)() -> new StringBuilder(25).append("Saved wallet mnemonic to ").append(mnemonicPath).toString());
            return MODULE$.fromMnemonic(mnemonic, kmParams$1, (Option<String>)bip39PasswordOpt$1, time$1, writable.imported());
        });
    }

    public static final /* synthetic */ String $anonfun$initializeWithEntropy$10(Path seedPath$1) {
        return new StringBuilder(76).append("Seed file already exists, attempting to initialize form existing seed file=").append(seedPath$1).append(".").toString();
    }

    public static final /* synthetic */ Either $anonfun$initializeWithEntropy$11(Either unlocked$1, KeyManagerApi kmBeforeWrite) {
        Left left;
        Either either = unlocked$1;
        if (either instanceof Right) {
            BIP39KeyManager unlockedKeyManager;
            Right right = (Right)either;
            BIP39KeyManager bIP39KeyManager = unlockedKeyManager = (BIP39KeyManager)right.value();
            KeyManagerApi keyManagerApi = kmBeforeWrite;
            Predef$.MODULE$.require(!(bIP39KeyManager != null ? !((Object)bIP39KeyManager).equals(keyManagerApi) : keyManagerApi != null), (Function0 & Serializable)() -> new StringBuilder(53).append("We could not read the key manager we just wrote! ").append(kmBeforeWrite).append(" != ").append(unlockedKeyManager).toString());
            left = package$.MODULE$.Right().apply((Object)unlockedKeyManager);
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            KeyManagerUnlockError err = (KeyManagerUnlockError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new InitializeKeyManagerError.FailedToReadWrittenSeed(err));
        } else {
            throw new MatchError((Object)either);
        }
        return left.map((Function1 & Serializable)invariant -> invariant);
    }

    public static final /* synthetic */ String $anonfun$initializeWithEntropy$14() {
        return "Successfully initialized wallet";
    }

    public static final /* synthetic */ String $anonfun$initializeWithEntropy$15(KeyManagerInitializeError err$2) {
        return new StringBuilder(42).append("Failed to initialize key manager with err=").append(err$2).toString();
    }

    private BIP39KeyManager$() {
    }
}

