/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager.bip39;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.time.Instant;
import org.bitcoins.core.api.keymanager.BIP39KeyManagerApi;
import org.bitcoins.core.crypto.ExtPrivateKey;
import org.bitcoins.core.crypto.ExtPublicKey;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.core.hd.BIP32Path;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDPath;
import org.bitcoins.core.wallet.keymanagement.KeyManagerInitializeError;
import org.bitcoins.core.wallet.keymanagement.KeyManagerParams;
import org.bitcoins.crypto.AdaptorSign;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.keymanager.KeyManagerLogger;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.bip39.BIP39KeyManager$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Try;
import scodec.bits.BitVector;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\f\u0018\u0001\u0001B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011)\u0019!C\u0001y!AQ\t\u0001B\u0001B\u0003%Q\b\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001H\u0011!\u0001\u0006A!A!\u0002\u0013A\u0005\u0002C)\u0001\u0005\u000b\u0007I\u0011\u0001*\t\u0011Y\u0003!\u0011!Q\u0001\nMCQa\u0016\u0001\u0005\u0002aCQa\u0018\u0001\u0005B\u0001DQA\u001a\u0001\u0005\u0002\u001dDQ!\u001e\u0001\u0005\u0002YD\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u000f\u0005=\u0001\u0001)A\u0005{\u001e9\u0011\u0011C\f\t\u0002\u0005MaA\u0002\f\u0018\u0011\u0003\t)\u0002\u0003\u0004X\u001f\u0011\u0005\u0011Q\u0006\u0005\b\u0003_yA\u0011AA\u0019\u0011%\t\u0019g\u0004b\u0001\n\u0003\t)\u0007\u0003\u0005\u0002n=\u0001\u000b\u0011BA4\u0011\u001d\tyg\u0004C!\u0003cBq!!+\u0010\t\u0003\tYKA\bC\u0013B\u001b\u0014hS3z\u001b\u0006t\u0017mZ3s\u0015\tA\u0012$A\u0003cSB\u001c\u0014H\u0003\u0002\u001b7\u0005Q1.Z=nC:\fw-\u001a:\u000b\u0005qi\u0012\u0001\u00032ji\u000e|\u0017N\\:\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0011(aA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001\u000b\u0018\u000e\u0003%R!A\u0007\u0016\u000b\u0005-b\u0013aA1qS*\u0011QfG\u0001\u0005G>\u0014X-\u0003\u00020S\t\u0011\")\u0013)4s-+\u00170T1oC\u001e,'/\u00119j!\t\t$'D\u0001\u001a\u0013\t\u0019\u0014D\u0001\tLKfl\u0015M\\1hKJdunZ4fe\u0006q!o\\8u\u000bb$\bK]5w\u0017\u0016L\bC\u0001\u001c:\u001b\u00059$B\u0001\u001d-\u0003\u0019\u0019'/\u001f9u_&\u0011!h\u000e\u0002\u000e\u000bb$\bK]5wCR,7*Z=\u0002\u0011-l\u0007+\u0019:b[N,\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bQb[3z[\u0006t\u0017mZ3nK:$(B\u0001\"-\u0003\u00199\u0018\r\u001c7fi&\u0011Ai\u0010\u0002\u0011\u0017\u0016LX*\u00198bO\u0016\u0014\b+\u0019:b[N\f\u0011b[7QCJ\fWn\u001d\u0011\u0002\u0019\r\u0014X-\u0019;j_:$\u0016.\\3\u0016\u0003!\u0003\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\tQLW.\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%JA\u0004J]N$\u0018M\u001c;\u0002\u001b\r\u0014X-\u0019;j_:$\u0016.\\3!\u0003!IW\u000e]8si\u0016$W#A*\u0011\u0005\t\"\u0016BA+$\u0005\u001d\u0011un\u001c7fC:\f\u0011\"[7q_J$X\r\u001a\u0011\u0002\rqJg.\u001b;?)\u0015I6\fX/_!\tQ\u0006!D\u0001\u0018\u0011\u0015!\u0004\u00021\u00016\u0011\u0015Y\u0004\u00021\u0001>\u0011\u00151\u0005\u00021\u0001I\u0011\u0015\t\u0006\u00021\u0001T\u0003\u0019)\u0017/^1mgR\u00111+\u0019\u0005\u0006E&\u0001\raY\u0001\u0006_RDWM\u001d\t\u0003E\u0011L!!Z\u0012\u0003\u0007\u0005s\u00170\u0001\u0004u_NKwM\u001c\u000b\u0003Q6\u0004\"![6\u000e\u0003)T!\u0001O\u000e\n\u00051T'aC!eCB$xN]*jO:DQA\u001c\u0006A\u0002=\f1\u0002\u001d:jm.+\u0017\u0010U1uQB\u0011\u0001o]\u0007\u0002c*\u0011!\u000fL\u0001\u0003Q\u0012L!\u0001^9\u0003\r!#\u0005+\u0019;i\u0003)!WM]5wKb\u0003VO\u0019\u000b\u0004o\u0006\u0005\u0001c\u0001=|{6\t\u0011P\u0003\u0002{G\u0005!Q\u000f^5m\u0013\ta\u0018PA\u0002Uef\u0004\"A\u000e@\n\u0005}<$\u0001D#yiB+(\r\\5d\u0017\u0016L\bbBA\u0002\u0017\u0001\u0007\u0011QA\u0001\bC\u000e\u001cw.\u001e8u!\r\u0001\u0018qA\u0005\u0004\u0003\u0013\t(!\u0003%E\u0003\u000e\u001cw.\u001e8u\u0003-9W\r\u001e*p_RD\u0006+\u001e2\u0016\u0003u\fAbZ3u%>|G\u000f\u0017)vE\u0002\nqBQ%QgeZU-_'b]\u0006<WM\u001d\t\u00035>\u0019baD\u0011\u0002\u0018\u0005u\u0001\u0003\u0002\u0015\u0002\u001aeK1!a\u0007*\u0005a\u0011\u0015\nU\u001a:\u0017\u0016LX*\u00198bO\u0016\u00148I]3bi\u0016\f\u0005/\u001b\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0015\u0019HN\u001a\u001bk\u0015\t\t9#\u0001\u0005he&T(\u0010\\3e\u0013\u0011\tY#!\t\u0003\u000f1{wmZ5oOR\u0011\u00111C\u0001\rMJ|W.\u00148f[>t\u0017n\u0019\u000b\f3\u0006M\u0012QHA \u0003?\n\t\u0007C\u0004\u00026E\u0001\r!a\u000e\u0002\u00115tW-\\8oS\u000e\u00042ANA\u001d\u0013\r\tYd\u000e\u0002\r\u001b:,Wn\u001c8jG\u000e{G-\u001a\u0005\u0006wE\u0001\r!\u0010\u0005\b\u0003\u0003\n\u0002\u0019AA\"\u0003A\u0011\u0017\u000e]\u001a:!\u0006\u001c8o^8sI>\u0003H\u000fE\u0003#\u0003\u000b\nI%C\u0002\u0002H\r\u0012aa\u00149uS>t\u0007\u0003BA&\u00033rA!!\u0014\u0002VA\u0019\u0011qJ\u0012\u000e\u0005\u0005E#bAA*?\u00051AH]8pizJ1!a\u0016$\u0003\u0019\u0001&/\u001a3fM&!\u00111LA/\u0005\u0019\u0019FO]5oO*\u0019\u0011qK\u0012\t\u000b\u0019\u000b\u0002\u0019\u0001%\t\u000bE\u000b\u0002\u0019A*\u0002\u001b\t\fG\rU1tgBD'/Y:f+\t\t9\u0007E\u0002j\u0003SJ1!a\u001bk\u0005-\tUm\u001d)bgN<xN\u001d3\u0002\u001d\t\fG\rU1tgBD'/Y:fA\u0005)\u0012N\\5uS\u0006d\u0017N_3XSRDWI\u001c;s_BLHCCA:\u0003\u0017\u000b\t*!*\u0002(B9\u0011QOA@\u0003\u000bKf\u0002BA<\u0003wrA!a\u0014\u0002z%\tA%C\u0002\u0002~\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0006\r%AB#ji\",'OC\u0002\u0002~\r\u00022APAD\u0013\r\tIi\u0010\u0002\u001a\u0017\u0016LX*\u00198bO\u0016\u0014\u0018J\\5uS\u0006d\u0017N_3FeJ|'\u000fC\u0004\u0002\u000eR\u0001\r!a$\u0002\u001d\u0005,7\u000fU1tg^|'\u000fZ(qiB)!%!\u0012\u0002h!9\u00111\u0013\u000bA\u0002\u0005U\u0015aB3oiJ|\u0007/\u001f\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\u0011\u0011\u0017\u000e^:\u000b\u0005\u0005}\u0015AB:d_\u0012,7-\u0003\u0003\u0002$\u0006e%!\u0003\"jiZ+7\r^8s\u0011\u001d\t\t\u0005\u0006a\u0001\u0003\u0007BQa\u000f\u000bA\u0002u\n!B\u001a:p[B\u000b'/Y7t)!\ti+!.\u00028\u0006m\u0006cBA;\u0003\u007f\ny+\u0017\t\u0004c\u0005E\u0016bAAZ3\t\t\"+Z1e\u001b:,Wn\u001c8jG\u0016\u0013(o\u001c:\t\u000bm*\u0002\u0019A\u001f\t\u000f\u0005eV\u00031\u0001\u0002\u0010\u0006Y\u0001/Y:to>\u0014Hm\u00149u\u0011\u001d\t\t%\u0006a\u0001\u0003\u0007\u0002")
public class BIP39KeyManager
implements BIP39KeyManagerApi,
KeyManagerLogger {
    private final ExtPrivateKey rootExtPrivKey;
    private final KeyManagerParams kmParams;
    private final Instant creationTime;
    private final boolean imported;
    private final ExtPublicKey getRootXPub;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static Either<ReadMnemonicError, BIP39KeyManager> fromParams(KeyManagerParams kmParams, Option<AesPassword> passwordOpt, Option<String> bip39PasswordOpt) {
        return BIP39KeyManager$.MODULE$.fromParams(kmParams, passwordOpt, bip39PasswordOpt);
    }

    public static Either<KeyManagerInitializeError, BIP39KeyManager> initializeWithEntropy(Option<AesPassword> aesPasswordOpt, BitVector entropy, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        return BIP39KeyManager$.MODULE$.initializeWithEntropy(aesPasswordOpt, entropy, bip39PasswordOpt, kmParams);
    }

    public static AesPassword badPassphrase() {
        return BIP39KeyManager$.MODULE$.badPassphrase();
    }

    public static BIP39KeyManager fromMnemonic(MnemonicCode mnemonic, KeyManagerParams kmParams, Option<String> bip39PasswordOpt, Instant creationTime, boolean imported) {
        return BIP39KeyManager$.MODULE$.fromMnemonic(mnemonic, kmParams, bip39PasswordOpt, creationTime, imported);
    }

    public static Either<KeyManagerInitializeError, BIP39KeyManager> initializeWithMnemonic(Option<AesPassword> aesPasswordOpt, MnemonicCode mnemonicCode, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        return BIP39KeyManager$.MODULE$.initializeWithMnemonic(aesPasswordOpt, mnemonicCode, bip39PasswordOpt, kmParams);
    }

    public static Either<KeyManagerInitializeError, BIP39KeyManager> initialize(Option<AesPassword> aesPasswordOpt, KeyManagerParams kmParams, Option<String> bip39PasswordOpt) {
        return BIP39KeyManager$.MODULE$.initialize(aesPasswordOpt, kmParams, bip39PasswordOpt);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BIP39KeyManager bIP39KeyManager = this;
        synchronized (bIP39KeyManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public KeyManagerParams kmParams() {
        return this.kmParams;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public boolean imported() {
        return this.imported;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof BIP39KeyManager)) return other.equals(this);
        BIP39KeyManager bIP39KeyManager = (BIP39KeyManager)object;
        ExtPublicKey extPublicKey = this.getRootXPub();
        ExtPublicKey extPublicKey2 = bIP39KeyManager.getRootXPub();
        if (extPublicKey == null) {
            if (extPublicKey2 != null) {
                return false;
            }
        } else if (!extPublicKey.equals(extPublicKey2)) return false;
        KeyManagerParams keyManagerParams = this.kmParams();
        KeyManagerParams keyManagerParams2 = bIP39KeyManager.kmParams();
        if (keyManagerParams == null) {
            if (keyManagerParams2 != null) {
                return false;
            }
        } else if (!keyManagerParams.equals(keyManagerParams2)) return false;
        if (this.creationTime().getEpochSecond() != bIP39KeyManager.creationTime().getEpochSecond()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public AdaptorSign toSign(HDPath privKeyPath) {
        void var2_2;
        ExtPrivateKey xpriv = this.rootExtPrivKey.deriveChildPrivKey((BIP32Path)privKeyPath);
        return var2_2;
    }

    public Try<ExtPublicKey> deriveXPub(HDAccount account) {
        return this.rootExtPrivKey.deriveChildPubKey((BIP32Path)account);
    }

    public ExtPublicKey getRootXPub() {
        return this.getRootXPub;
    }

    public BIP39KeyManager(ExtPrivateKey rootExtPrivKey, KeyManagerParams kmParams, Instant creationTime, boolean imported) {
        this.rootExtPrivKey = rootExtPrivKey;
        this.kmParams = kmParams;
        this.creationTime = creationTime;
        this.imported = imported;
        Logging.$init$((Logging)this);
        this.getRootXPub = rootExtPrivKey.extPublicKey();
    }
}

