/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager.bip39;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.bitcoins.core.wallet.keymanagement.KeyManagerParams;
import org.bitcoins.core.wallet.keymanagement.KeyManagerUnlockError;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.keymanager.DecryptedExtPrivKey;
import org.bitcoins.keymanager.DecryptedMnemonic;
import org.bitcoins.keymanager.DecryptedSeedState;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.ReadMnemonicError$DecryptionError$;
import org.bitcoins.keymanager.ReadMnemonicError$NotFoundError$;
import org.bitcoins.keymanager.WalletStorage$;
import org.bitcoins.keymanager.bip39.BIP39KeyManager;
import org.bitcoins.keymanager.bip39.BIP39KeyManager$;
import org.slf4j.Marker;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BIP39LockedKeyManager$
implements Logging {
    public static final BIP39LockedKeyManager$ MODULE$ = new BIP39LockedKeyManager$();
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BIP39LockedKeyManager$ bIP39LockedKeyManager$ = this;
        synchronized (bIP39LockedKeyManager$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<KeyManagerUnlockError, BIP39KeyManager> unlock(Option<AesPassword> passphraseOpt, Option<String> bip39PasswordOpt, KeyManagerParams kmParams) {
        Left left;
        DecryptedSeedState xprv;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Trying to unlock wallet with seedPath=").append(kmParams.seedPath()).toString());
        Either<ReadMnemonicError, DecryptedSeedState> resultE = WalletStorage$.MODULE$.decryptSeedFromDisk(kmParams.seedPath(), passphraseOpt);
        boolean bl = false;
        Right right = null;
        Either<ReadMnemonicError, DecryptedSeedState> either = resultE;
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            DecryptedSeedState mnemonic = (DecryptedSeedState)right.value();
            if (mnemonic instanceof DecryptedMnemonic) {
                DecryptedMnemonic decryptedMnemonic = (DecryptedMnemonic)mnemonic;
                return package$.MODULE$.Right().apply((Object)BIP39KeyManager$.MODULE$.fromMnemonic(decryptedMnemonic.mnemonicCode(), kmParams, bip39PasswordOpt, decryptedMnemonic.creationTime(), decryptedMnemonic.imported()));
            }
        }
        if (bl && (xprv = (DecryptedSeedState)right.value()) instanceof DecryptedExtPrivKey) {
            DecryptedExtPrivKey decryptedExtPrivKey = (DecryptedExtPrivKey)xprv;
            BIP39KeyManager km = new BIP39KeyManager(decryptedExtPrivKey.xprv(), kmParams, decryptedExtPrivKey.creationTime(), decryptedExtPrivKey.imported());
            return package$.MODULE$.Right().apply((Object)km);
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Left left2 = (Left)either;
        ReadMnemonicError result = (ReadMnemonicError)left2.value();
        ReadMnemonicError readMnemonicError = result;
        if (ReadMnemonicError$DecryptionError$.MODULE$.equals(readMnemonicError)) {
            this.logger().error((Function0 & Serializable)() -> "Bad password for unlocking wallet!");
            left = package$.MODULE$.Left().apply((Object)KeyManagerUnlockError.BadPassword$.MODULE$);
            return left;
        } else if (readMnemonicError instanceof ReadMnemonicError.JsonParsingError) {
            ReadMnemonicError.JsonParsingError jsonParsingError = (ReadMnemonicError.JsonParsingError)readMnemonicError;
            String message = jsonParsingError.message();
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(42).append("JSON parsing error when unlocking wallet: ").append(message).toString());
            left = package$.MODULE$.Left().apply((Object)new KeyManagerUnlockError.JsonParsingError(message));
            return left;
        } else {
            if (!ReadMnemonicError$NotFoundError$.MODULE$.equals(readMnemonicError)) throw new MatchError((Object)readMnemonicError);
            this.logger().error((Function0 & Serializable)() -> "Encrypted mnemonic not found when unlocking the wallet!");
            left = package$.MODULE$.Left().apply((Object)KeyManagerUnlockError.MnemonicNotFound$.MODULE$);
        }
        return left;
    }

    private BIP39LockedKeyManager$() {
    }
}

