/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.keymanager.config;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import org.bitcoins.commons.config.AppConfig;
import org.bitcoins.commons.config.package;
import org.bitcoins.commons.config.package$;
import org.bitcoins.core.api.commons.ArgumentSource;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.crypto.ExtPublicKey;
import org.bitcoins.core.crypto.MnemonicCode;
import org.bitcoins.core.crypto.MnemonicCode$;
import org.bitcoins.core.hd.HDPurpose;
import org.bitcoins.core.hd.HDPurposes$;
import org.bitcoins.core.wallet.keymanagement.KeyManagerInitializeError;
import org.bitcoins.core.wallet.keymanagement.KeyManagerParams;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.crypto.AesPassword$;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.WalletStorage$;
import org.bitcoins.keymanager.bip39.BIP39KeyManager;
import org.bitcoins.keymanager.bip39.BIP39KeyManager$;
import org.bitcoins.keymanager.config.KeyManagerAppConfig$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;

@ScalaSignature(bytes="\u0006\u0005\rma\u0001B#G\u0001>C\u0001\"\u001b\u0001\u0003\u0016\u0004%\tA\u001b\u0005\tk\u0002\u0011\t\u0012)A\u0005W\"Aa\u000f\u0001BK\u0002\u0013\u0005q\u000fC\u0005\u0002\n\u0001\u0011\t\u0012)A\u0005q\"Q\u00111\u0002\u0001\u0003\u0016\u0004%\t!!\u0004\t\u0015\u0005]\u0002A!E!\u0002\u0013\ty\u0001\u0003\u0006\u0002:\u0001\u0011)\u001a!C\u0001\u0003wA!\"!\u0014\u0001\u0005#\u0005\u000b\u0011BA\u001f\u0011)\ty\u0005\u0001BK\u0002\u0013\u0005\u0011\u0011\u000b\u0005\u000b\u0003+\u0002!\u0011#Q\u0001\n\u0005M\u0003BCA,\u0001\t\u0015\r\u0011b\u0001\u0002Z!Q\u0011q\r\u0001\u0003\u0002\u0003\u0006I!a\u0017\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u00151\u0011q\u0010\u0001!\u0003_Bq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002\n\u0002!\t%a#\t\u0015\u00055\u0005\u0001#b\u0001\n\u0003\ty\t\u0003\u0006\u0002\u001c\u0002A)\u0019!C\u0001\u0003\u0017C\u0011\"!(\u0001\u0011\u000b\u0007I\u0011\u00016\t\u0013\u0005}\u0005\u0001#b\u0001\n\u0003Q\u0007\"CAQ\u0001\t\u0007I\u0011BAF\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005\u001d\u0002BCAS\u0001!\u0015\r\u0011\"\u0003\u0002(\"Q\u0011Q\u0017\u0001\t\u0006\u0004%I!!\u0015\t\u0013\u0005]\u0006A1A\u0005\n\u0005e\u0006\u0002CAf\u0001\u0001\u0006I!a/\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\"9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0007bBAq\u0001\u0011\u0005\u00131\u001b\u0005\u000b\u0003G\u0004\u0001R1A\u0005\u0002\u0005\u0015\bBCAu\u0001!\u0015\r\u0011\"\u0001\u0002R!9\u00111\u001e\u0001\u0005\u0002\u00055\bbBA{\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0005\u000b\u0001A\u0011BAj\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013A\u0011Ba\u0006\u0001\u0003\u0003%\tA!\u0007\t\u0013\t%\u0002!%A\u0005\u0002\t-\u0002\"\u0003B!\u0001E\u0005I\u0011\u0001B\"\u0011%\u00119\u0005AI\u0001\n\u0003\u0011I\u0005C\u0005\u0003N\u0001\t\n\u0011\"\u0001\u0003P!I!1\u000b\u0001\u0012\u0002\u0013\u0005!Q\u000b\u0005\n\u00053\u0002\u0011\u0011!C!\u00057B\u0011Ba\u001a\u0001\u0003\u0003%\tA!\u001b\t\u0013\tE\u0004!!A\u0005\u0002\tM\u0004\"\u0003B@\u0001\u0005\u0005I\u0011\tBA\u0011%\u0011y\tAA\u0001\n\u0003\u0011\t\nC\u0005\u0003\u0016\u0002\t\t\u0011\"\u0011\u0003\u0018\"I!1\u0014\u0001\u0002\u0002\u0013\u0005#Q\u0014\u0005\n\u0005?\u0003\u0011\u0011!C!\u0005CC\u0011Ba)\u0001\u0003\u0003%\tE!*\b\u000f\t%f\t#\u0001\u0003,\u001a1QI\u0012E\u0001\u0005[Cq!!\u001b5\t\u0003\u0011)\rC\u0005\u0003HR\u0012\r\u0011\"\u0002\u0002\f\"A!\u0011\u001a\u001b!\u0002\u001b\t9\u0003C\u0005\u0002\nR\u0012\r\u0011\"\u0011\u0002\f\"A!1\u001a\u001b!\u0002\u0013\t9\u0003C\u0004\u0003NR\"\tEa4\t\u000f\tuG\u0007\"\u0001\u0003`\"I!1\u001d\u001b\u0002\u0002\u0013\u0005%Q\u001d\u0005\n\u0005k$\u0014\u0013!C\u0001\u0005\u0013B\u0011Ba>5#\u0003%\tAa\u0014\t\u0013\teH'%A\u0005\u0002\tU\u0003\"\u0003B~i\u0005\u0005I\u0011\u0011B\u007f\u0011%\u0019Y\u0001NI\u0001\n\u0003\u0011I\u0005C\u0005\u0004\u000eQ\n\n\u0011\"\u0001\u0003P!I1q\u0002\u001b\u0012\u0002\u0013\u0005!Q\u000b\u0005\n\u0007#!\u0014\u0011!C\u0005\u0007'\u00111cS3z\u001b\u0006t\u0017mZ3s\u0003B\u00048i\u001c8gS\u001eT!a\u0012%\u0002\r\r|gNZ5h\u0015\tI%*\u0001\u0006lKfl\u0017M\\1hKJT!a\u0013'\u0002\u0011\tLGoY8j]NT\u0011!T\u0001\u0004_J<7\u0001A\n\u0005\u0001A;V\f\u0005\u0002R+6\t!K\u0003\u0002H'*\u0011AKS\u0001\bG>lWn\u001c8t\u0013\t1&KA\u0005BaB\u001cuN\u001c4jOB\u0011\u0001lW\u0007\u00023*\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\n9\u0001K]8ek\u000e$\bC\u00010g\u001d\tyFM\u0004\u0002aG6\t\u0011M\u0003\u0002c\u001d\u00061AH]8pizJ\u0011AW\u0005\u0003Kf\u000bq\u0001]1dW\u0006<W-\u0003\u0002hQ\na1+\u001a:jC2L'0\u00192mK*\u0011Q-W\u0001\fE\u0006\u001cX\rR1uC\u0012L'/F\u0001l!\ta7/D\u0001n\u0015\tqw.\u0001\u0003gS2,'B\u00019r\u0003\rq\u0017n\u001c\u0006\u0002e\u0006!!.\u0019<b\u0013\t!XN\u0001\u0003QCRD\u0017\u0001\u00042bg\u0016$\u0015\r^1eSJ\u0004\u0013aD2p]\u001aLwm\u0014<feJLG-Z:\u0016\u0003a\u00042AX=|\u0013\tQ\bN\u0001\u0004WK\u000e$xN\u001d\t\u0004y\u0006\u0015Q\"A?\u000b\u0005\u001ds(bA@\u0002\u0002\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002\u0004\u0005\u00191m\\7\n\u0007\u0005\u001dQP\u0001\u0004D_:4\u0017nZ\u0001\u0011G>tg-[4Pm\u0016\u0014(/\u001b3fg\u0002\n!c^1mY\u0016$h*Y7f\u001fZ,'O]5eKV\u0011\u0011q\u0002\t\u00061\u0006E\u0011QC\u0005\u0004\u0003'I&AB(qi&|g\u000e\u0005\u0004\u0002\u0018\u0005\r\u0012qE\u0007\u0003\u00033Q1\u0001VA\u000e\u0015\u0011\ti\"a\b\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002\")\u000bAaY8sK&!\u0011QEA\r\u00059\t%oZ;nK:$8k\\;sG\u0016\u0004B!!\u000b\u000229!\u00111FA\u0017!\t\u0001\u0017,C\u0002\u00020e\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001a\u0003k\u0011aa\u0015;sS:<'bAA\u00183\u0006\u0019r/\u00197mKRt\u0015-\\3Pm\u0016\u0014(/\u001b3fA\u0005\u0019\u0012-Z:QCN\u001cxo\u001c:e\u001fZ,'O]5eKV\u0011\u0011Q\b\t\u00061\u0006E\u0011q\b\t\u0007\u0003/\t\u0019#!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012K\u0003\u0019\u0019'/\u001f9u_&!\u00111JA#\u0005-\tUm\u001d)bgN<xN\u001d3\u0002)\u0005,7\u000fU1tg^|'\u000fZ(wKJ\u0014\u0018\u000eZ3!\u0003U\u0011\u0017\u000e]\u001a:!\u0006\u001c8o^8sI>3XM\u001d:jI\u0016,\"!a\u0015\u0011\u000ba\u000b\t\"a\n\u0002-\tL\u0007oM\u001dQCN\u001cxo\u001c:e\u001fZ,'O]5eK\u0002\n!!Z2\u0016\u0005\u0005m\u0003\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005\u0014,\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u001a\u0002`\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004K\u000e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0007\u0002n\u0005U\u0014qOA=\u0003w\ni\b\u0006\u0003\u0002p\u0005M\u0004cAA9\u00015\ta\tC\u0004\u0002X5\u0001\u001d!a\u0017\t\u000b%l\u0001\u0019A6\t\u000bYl\u0001\u0019\u0001=\t\u0013\u0005-Q\u0002%AA\u0002\u0005=\u0001\"CA\u001d\u001bA\u0005\t\u0019AA\u001f\u0011%\ty%\u0004I\u0001\u0002\u0004\t\u0019F\u0001\u0006D_:4\u0017n\u001a+za\u0016\fqB\\3x\u0007>tg-[4PMRK\b/\u001a\u000b\u0005\u0003_\n)\t\u0003\u0004\u0002\b>\u0001\r\u0001_\u0001\bG>tg-[4t\u0003)iw\u000eZ;mK:\u000bW.Z\u000b\u0003\u0003O\t\u0011C\\3uo>\u00148\u000eU1sC6,G/\u001a:t+\t\t\t\n\u0005\u0003\u0002\u0014\u0006]UBAAK\u0015\r9\u0015qD\u0005\u0005\u00033\u000b)JA\tOKR<xN]6QCJ\fW.\u001a;feN\f!b^1mY\u0016$h*Y7f\u0003)\u0019X-\u001a3G_2$WM]\u0001\tg\u0016,G\rU1uQ\u0006a1/Z3e\r&dWMT1nK\u0006i1/Z3e\r&dWMT1nK\u0002\n!\u0003Z3gCVdG/Q2d_VtGoS5oIV\u0011\u0011\u0011\u0016\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*!\u0011qVA\u0010\u0003\tAG-\u0003\u0003\u00024\u00065&!\u0003%E!V\u0014\bo\\:f\u0003=)\u0007\u0010^3s]\u0006dWI\u001c;s_BL\u0018\u0001C6n!\u0006\u0014\u0018-\\:\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u000fl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u000eW\u0016LX.\u00198bO\u0016lWM\u001c;\u000b\t\u0005\u0015\u0017qD\u0001\u0007o\u0006dG.\u001a;\n\t\u0005%\u0017q\u0018\u0002\u0011\u0017\u0016LX*\u00198bO\u0016\u0014\b+\u0019:b[N\f\u0011b[7QCJ\fWn\u001d\u0011\u0002\u001d\u001d,Go\u00147e'\u0016,G\rU1uQR\t1.A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002VB1\u0011QLAl\u00037LA!!7\u0002`\t1a)\u001e;ve\u0016\u00042\u0001WAo\u0013\r\ty.\u0017\u0002\u0005+:LG/\u0001\u0003ti>\u0004\u0018AD1fgB\u000b7o]<pe\u0012|\u0005\u000f^\u000b\u0003\u0003O\u0004R\u0001WA\t\u0003\u0003\n\u0001CY5qge\u0002\u0016m]:x_J$w\n\u001d;\u0002\u0015M,W\rZ#ySN$8\u000f\u0006\u0002\u0002pB\u0019\u0001,!=\n\u0007\u0005M\u0018LA\u0004C_>dW-\u00198\u0002#Q|')\u001b94s-+\u00170T1oC\u001e,'/\u0006\u0002\u0002zB!\u00111 B\u0001\u001b\t\tiPC\u0002\u0002\u0000\"\u000bQAY5qgeJAAa\u0001\u0002~\ny!)\u0013)4s-+\u00170T1oC\u001e,'/\u0001\u000bj]&$\u0018.\u00197ju\u0016\\U-_'b]\u0006<WM]\u0001\rGJ,\u0017\r^5p]RKW.Z\u000b\u0003\u0005\u0017\u0001BA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0004\u0005#\t\u0018\u0001\u0002;j[\u0016LAA!\u0006\u0003\u0010\t9\u0011J\\:uC:$\u0018\u0001B2paf$BBa\u0007\u0003 \t\u0005\"1\u0005B\u0013\u0005O!B!a\u001c\u0003\u001e!9\u0011q\u000b\u0013A\u0004\u0005m\u0003bB5%!\u0003\u0005\ra\u001b\u0005\bm\u0012\u0002\n\u00111\u0001y\u0011%\tY\u0001\nI\u0001\u0002\u0004\ty\u0001C\u0005\u0002:\u0011\u0002\n\u00111\u0001\u0002>!I\u0011q\n\u0013\u0011\u0002\u0003\u0007\u00111K\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iCK\u0002l\u0005_Y#A!\r\u0011\t\tM\"QH\u0007\u0003\u0005kQAAa\u000e\u0003:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005wI\u0016AC1o]>$\u0018\r^5p]&!!q\bB\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)EK\u0002y\u0005_\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003L)\"\u0011q\u0002B\u0018\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\u0015+\t\u0005u\"qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u00119F\u000b\u0003\u0002T\t=\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003^A!!q\fB3\u001b\t\u0011\tGC\u0002\u0003dE\fA\u0001\\1oO&!\u00111\u0007B1\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011Y\u0007E\u0002Y\u0005[J1Aa\u001cZ\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)Ha\u001f\u0011\u0007a\u00139(C\u0002\u0003ze\u00131!\u00118z\u0011%\u0011i\bLA\u0001\u0002\u0004\u0011Y'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0007\u0003bA!\"\u0003\f\nUTB\u0001BD\u0015\r\u0011I)W\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BG\u0005\u000f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q\u001eBJ\u0011%\u0011iHLA\u0001\u0002\u0004\u0011)(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B/\u00053C\u0011B! 0\u0003\u0003\u0005\rAa\u001b\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u001b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0018\u0002\r\u0015\fX/\u00197t)\u0011\tyOa*\t\u0013\tu$'!AA\u0002\tU\u0014aE&fs6\u000bg.Y4fe\u0006\u0003\boQ8oM&<\u0007cAA9iM9AGa,\u00036\nm\u0006c\u0001-\u00032&\u0019!1W-\u0003\r\u0005s\u0017PU3g!\u0015\t&qWA8\u0013\r\u0011IL\u0015\u0002\u0011\u0003B\u00048i\u001c8gS\u001e4\u0015m\u0019;pef\u0004BA!0\u0003D6\u0011!q\u0018\u0006\u0004\u0005\u0003\f\u0018AA5p\u0013\r9'q\u0018\u000b\u0003\u0005W\u000b1\u0003R#G\u0003VcEkX,B\u00192+Ek\u0018(B\u001b\u0016\u000bA\u0003R#G\u0003VcEkX,B\u00192+Ek\u0018(B\u001b\u0016\u0003\u0013aC7pIVdWMT1nK\u0002\n1B\u001a:p[\u0012\u000bG/\u00193jeR1!\u0011\u001bBk\u00053$B!a\u001c\u0003T\"9\u0011q\u000b\u001eA\u0004\u0005m\u0003B\u0002Blu\u0001\u00071.A\u0004eCR\fG-\u001b:\t\u0011\tm'\b%AA\u0002a\fQaY8oMN\f!C^1mS\u0012\fG/Z,bY2,GOT1nKR!\u0011q\u001eBq\u0011\u001d\tYj\u000fa\u0001\u0003O\tQ!\u00199qYf$BBa:\u0003l\n5(q\u001eBy\u0005g$B!a\u001c\u0003j\"9\u0011q\u000b\u001fA\u0004\u0005m\u0003\"B5=\u0001\u0004Y\u0007\"\u0002<=\u0001\u0004A\b\"CA\u0006yA\u0005\t\u0019AA\b\u0011%\tI\u0004\u0010I\u0001\u0002\u0004\ti\u0004C\u0005\u0002Pq\u0002\n\u00111\u0001\u0002T\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u007f\u001c9\u0001E\u0003Y\u0003#\u0019\t\u0001E\u0006Y\u0007\u0007Y\u00070a\u0004\u0002>\u0005M\u0013bAB\u00033\n1A+\u001e9mKVB\u0011b!\u0003A\u0003\u0003\u0005\r!a\u001c\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019)\u0002\u0005\u0003\u0003`\r]\u0011\u0002BB\r\u0005C\u0012aa\u00142kK\u000e$\b")
public class KeyManagerAppConfig
extends AppConfig
implements Product,
Serializable {
    private NetworkParameters networkParameters;
    private String walletName;
    private Path seedFolder;
    private Path seedPath;
    private HDPurpose defaultAccountKind;
    private Option<String> externalEntropy;
    private Option<AesPassword> aesPasswordOpt;
    private Option<String> bip39PasswordOpt;
    private final Path baseDatadir;
    private final Vector<Config> configOverrides;
    private final Option<ArgumentSource<String>> walletNameOverride;
    private final Option<ArgumentSource<AesPassword>> aesPasswordOverride;
    private final Option<String> bip39PasswordOverride;
    private final ExecutionContext ec;
    private final String seedFileName;
    private final KeyManagerParams kmParams;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$5() {
        return KeyManagerAppConfig$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<ArgumentSource<AesPassword>> $lessinit$greater$default$4() {
        return KeyManagerAppConfig$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<ArgumentSource<String>> $lessinit$greater$default$3() {
        return KeyManagerAppConfig$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple5<Path, Vector<Config>, Option<ArgumentSource<String>>, Option<ArgumentSource<AesPassword>>, Option<String>>> unapply(KeyManagerAppConfig x$0) {
        return KeyManagerAppConfig$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$5() {
        return KeyManagerAppConfig$.MODULE$.apply$default$5();
    }

    public static Option<ArgumentSource<AesPassword>> apply$default$4() {
        return KeyManagerAppConfig$.MODULE$.apply$default$4();
    }

    public static Option<ArgumentSource<String>> apply$default$3() {
        return KeyManagerAppConfig$.MODULE$.apply$default$3();
    }

    public static KeyManagerAppConfig apply(Path baseDatadir, Vector<Config> configOverrides, Option<ArgumentSource<String>> walletNameOverride, Option<ArgumentSource<AesPassword>> aesPasswordOverride, Option<String> bip39PasswordOverride, ExecutionContext ec) {
        return KeyManagerAppConfig$.MODULE$.apply(baseDatadir, configOverrides, walletNameOverride, aesPasswordOverride, bip39PasswordOverride, ec);
    }

    public static boolean validateWalletName(String walletName) {
        return KeyManagerAppConfig$.MODULE$.validateWalletName(walletName);
    }

    public static KeyManagerAppConfig fromDatadir(Path datadir, Vector<Config> confs, ExecutionContext ec) {
        return KeyManagerAppConfig$.MODULE$.fromDatadir(datadir, confs, ec);
    }

    public static String DEFAULT_WALLET_NAME() {
        return KeyManagerAppConfig$.MODULE$.DEFAULT_WALLET_NAME();
    }

    public static Vector<Config> fromDatadir$default$2() {
        return KeyManagerAppConfig$.MODULE$.fromDatadir$default$2();
    }

    public static Vector<Config> fromDefaultDatadir$default$1() {
        return KeyManagerAppConfig$.MODULE$.fromDefaultDatadir$default$1();
    }

    public static AppConfig fromDefaultDatadir(Vector confs, Object i) {
        return KeyManagerAppConfig$.MODULE$.fromDefaultDatadir(confs, i);
    }

    public static AppConfig fromClassPathConfig(Object i) {
        return KeyManagerAppConfig$.MODULE$.fromClassPathConfig(i);
    }

    public static AppConfig fromConfig(Config config, Object i) {
        return KeyManagerAppConfig$.MODULE$.fromConfig(config, i);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Path baseDatadir() {
        return this.baseDatadir;
    }

    public Vector<Config> configOverrides() {
        return this.configOverrides;
    }

    public Option<ArgumentSource<String>> walletNameOverride() {
        return this.walletNameOverride;
    }

    public Option<ArgumentSource<AesPassword>> aesPasswordOverride() {
        return this.aesPasswordOverride;
    }

    public Option<String> bip39PasswordOverride() {
        return this.bip39PasswordOverride;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public KeyManagerAppConfig newConfigOfType(Vector<Config> configs) {
        return new KeyManagerAppConfig(this.baseDatadir(), configs, KeyManagerAppConfig$.MODULE$.apply$default$3(), KeyManagerAppConfig$.MODULE$.apply$default$4(), KeyManagerAppConfig$.MODULE$.apply$default$5(), this.ec());
    }

    public String moduleName() {
        return KeyManagerAppConfig$.MODULE$.moduleName();
    }

    private NetworkParameters networkParameters$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.networkParameters = this.chain().network();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.networkParameters;
    }

    public NetworkParameters networkParameters() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.networkParameters$lzycompute() : this.networkParameters;
    }

    private String walletName$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Option option;
                Some some;
                ArgumentSource argumentSource;
                Option configWalletName = package.ConfigOps$.MODULE$.getStringOrNone$extension(package$.MODULE$.ConfigOps(this.config()), "bitcoin-s.wallet.walletName");
                Option<ArgumentSource<String>> option2 = this.walletNameOverride();
                if (option2 instanceof Some && (argumentSource = (ArgumentSource)(some = (Some)option2).value()) instanceof ArgumentSource.RpcArgument) {
                    ArgumentSource.RpcArgument rpcArgument = (ArgumentSource.RpcArgument)argumentSource;
                    String walletName2 = (String)rpcArgument.arg();
                    option = new Some((Object)walletName2);
                } else {
                    Some some2;
                    ArgumentSource argumentSource2;
                    boolean bl = option2 instanceof Some && ArgumentSource.NoArgument$.MODULE$.equals(argumentSource2 = (ArgumentSource)(some2 = (Some)option2).value()) ? true : None$.MODULE$.equals(option2);
                    if (bl) {
                        option = configWalletName;
                    } else {
                        throw new MatchError(option2);
                    }
                }
                Option nameOpt = option;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)nameOpt.map((Function1 & Serializable)walletName -> BoxesRunTime.boxToBoolean((boolean)KeyManagerAppConfig$.MODULE$.validateWalletName(walletName))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)), (Function0 & Serializable)() -> new StringBuilder(51).append("Invalid wallet name, only alphanumeric with _, got=").append(nameOpt).toString());
                this.walletName = (String)nameOpt.getOrElse((Function0 & Serializable)() -> KeyManagerAppConfig$.MODULE$.DEFAULT_WALLET_NAME());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.walletName;
    }

    public String walletName() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.walletName$lzycompute() : this.walletName;
    }

    private Path seedFolder$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.seedFolder = this.baseDatadir().resolve(WalletStorage$.MODULE$.SEED_FOLDER_NAME());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.seedFolder;
    }

    public Path seedFolder() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.seedFolder$lzycompute() : this.seedFolder;
    }

    private Path seedPath$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.seedPath = this.seedFolder().resolve(this.seedFileName());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.seedPath;
    }

    public Path seedPath() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.seedPath$lzycompute() : this.seedPath;
    }

    private String seedFileName() {
        return this.seedFileName;
    }

    private HDPurpose defaultAccountKind$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                HDPurpose hDPurpose;
                String string = this.config().getString("bitcoin-s.wallet.defaultAccountType");
                if ("legacy".equals(string)) {
                    hDPurpose = HDPurposes$.MODULE$.Legacy();
                } else if ("segwit".equals(string)) {
                    hDPurpose = HDPurposes$.MODULE$.SegWit();
                } else if ("nested-segwit".equals(string)) {
                    hDPurpose = HDPurposes$.MODULE$.NestedSegWit();
                } else {
                    if (string != null) {
                        String string2 = string;
                        throw new RuntimeException(new StringBuilder(29).append(string2).append(" is not a valid account type!").toString());
                    }
                    throw new MatchError((Object)string);
                }
                this.defaultAccountKind = hDPurpose;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.defaultAccountKind;
    }

    private HDPurpose defaultAccountKind() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.defaultAccountKind$lzycompute() : this.defaultAccountKind;
    }

    /*
     * WARNING - void declaration
     */
    private Option<String> externalEntropy$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                void var2_2;
                Option opt = package.ConfigOps$.MODULE$.getStringOrNone$extension(package$.MODULE$.ConfigOps(this.config()), "bitcoin-s.keymanager.entropy");
                this.externalEntropy = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.externalEntropy;
    }

    private Option<String> externalEntropy() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.externalEntropy$lzycompute() : this.externalEntropy;
    }

    private KeyManagerParams kmParams() {
        return this.kmParams;
    }

    private Path getOldSeedPath() {
        return this.baseDatadir().resolve(this.seedFileName());
    }

    public Future<BoxedUnit> start() {
        Future future;
        Path oldDefaultFile = this.getOldSeedPath();
        Path newDefaultFile = this.seedPath();
        if (!Files.exists(newDefaultFile, new LinkOption[0]) && Files.exists(oldDefaultFile, new LinkOption[0])) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(34).append("Copying seed file to seeds folder ").append(newDefaultFile).toString());
            Files.createDirectories(newDefaultFile.getParent(), new FileAttribute[0]);
            Files.copy(oldDefaultFile, newDefaultFile, new CopyOption[0]);
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(34).append("Migrated keymanager seed from=").append(oldDefaultFile.toAbsolutePath()).append(" to=").append(newDefaultFile.toAbsolutePath()).toString());
            future = Future$.MODULE$.unit();
        } else if (!Files.exists(newDefaultFile, new LinkOption[0])) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(22).append("No seed file found at=").append(newDefaultFile.toAbsolutePath()).toString());
            future = this.initializeKeyManager();
        } else if (this.externalEntropy().isDefined() && this.seedExists()) {
            BitVector bitVec = BitVector$.MODULE$.fromValidHex((String)this.externalEntropy().get(), BitVector$.MODULE$.fromValidHex$default$2());
            if (!CryptoUtil$.MODULE$.checkEntropy(bitVec)) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(77).append("The entropy used by bitcoin-s does not pass basic entropy sanity checks, got=").append(this.externalEntropy()).toString());
            }
            MnemonicCode mnemonicEntropy = MnemonicCode$.MODULE$.fromEntropy(bitVec);
            BIP39KeyManager kmEntropy = BIP39KeyManager$.MODULE$.fromMnemonic(mnemonicEntropy, this.kmParams(), this.bip39PasswordOpt(), Instant.now(), false);
            ExtPublicKey kmRootXpub = this.toBip39KeyManager().getRootXPub();
            ExtPublicKey extPublicKey = kmEntropy.getRootXPub();
            ExtPublicKey extPublicKey2 = kmRootXpub;
            Predef$.MODULE$.require(!(extPublicKey != null ? !extPublicKey.equals(extPublicKey2) : extPublicKey2 != null), (Function0 & Serializable)() -> new StringBuilder(70).append("Xpubs were different, generated from entropy=").append(kmEntropy.getRootXPub()).append(" keymanager xpub on disk=").append(kmRootXpub).toString());
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(46).append("Starting key manager with seedPath=").append(this.seedPath().toAbsolutePath()).append(", rootXpub=").append(kmRootXpub).toString());
            future = Future$.MODULE$.unit();
        } else {
            ExtPublicKey kmRootXpub = this.toBip39KeyManager().getRootXPub();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(45).append("Starting keymanager with seedPath=").append(this.seedPath().toAbsolutePath()).append(", rootXpub=").append(kmRootXpub).toString());
            future = Future$.MODULE$.unit();
        }
        return future;
    }

    public Future<BoxedUnit> stop() {
        return Future$.MODULE$.unit();
    }

    private Option<AesPassword> aesPasswordOpt$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                Option option;
                Option<ArgumentSource<AesPassword>> option2 = this.aesPasswordOverride();
                if (None$.MODULE$.equals(option2)) {
                    Option passOpt = package.ConfigOps$.MODULE$.getStringOrNone$extension(package$.MODULE$.ConfigOps(this.config()), new StringBuilder(22).append("bitcoin-s.").append(this.moduleName()).append(".aesPassword").toString());
                    option = passOpt.flatMap((Function1 & Serializable)string -> AesPassword$.MODULE$.fromStringOpt(string));
                } else if (option2 instanceof Some) {
                    None$ none$;
                    Some some = (Some)option2;
                    ArgumentSource argument = (ArgumentSource)some.value();
                    ArgumentSource argumentSource = argument;
                    if (argumentSource instanceof ArgumentSource.RpcArgument) {
                        ArgumentSource.RpcArgument rpcArgument = (ArgumentSource.RpcArgument)argumentSource;
                        AesPassword arg = (AesPassword)rpcArgument.arg();
                        none$ = new Some((Object)arg);
                    } else if (ArgumentSource.NoArgument$.MODULE$.equals(argumentSource)) {
                        none$ = None$.MODULE$;
                    } else {
                        throw new MatchError((Object)argumentSource);
                    }
                    option = none$;
                } else {
                    throw new MatchError(option2);
                }
                this.aesPasswordOpt = option;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.aesPasswordOpt;
    }

    public Option<AesPassword> aesPasswordOpt() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.aesPasswordOpt$lzycompute() : this.aesPasswordOpt;
    }

    private Option<String> bip39PasswordOpt$lzycompute() {
        KeyManagerAppConfig keyManagerAppConfig = this;
        synchronized (keyManagerAppConfig) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                Some some;
                Option<String> option = this.bip39PasswordOverride();
                if (None$.MODULE$.equals(option)) {
                    some = package.ConfigOps$.MODULE$.getStringOrNone$extension(package$.MODULE$.ConfigOps(this.config()), new StringBuilder(24).append("bitcoin-s.").append(this.moduleName()).append(".bip39password").toString());
                } else if (option instanceof Some) {
                    Some some2 = (Some)option;
                    String pass = (String)some2.value();
                    some = new Some((Object)pass);
                } else {
                    throw new MatchError(option);
                }
                this.bip39PasswordOpt = some;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.bip39PasswordOpt;
    }

    public Option<String> bip39PasswordOpt() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.bip39PasswordOpt$lzycompute() : this.bip39PasswordOpt;
    }

    public boolean seedExists() {
        return WalletStorage$.MODULE$.seedExists(this.seedPath());
    }

    public BIP39KeyManager toBip39KeyManager() {
        BIP39KeyManager km;
        Either<ReadMnemonicError, BIP39KeyManager> kmE = BIP39KeyManager$.MODULE$.fromParams(this.kmParams(), this.aesPasswordOpt(), this.bip39PasswordOpt());
        Either<ReadMnemonicError, BIP39KeyManager> either = kmE;
        if (either instanceof Left) {
            Left left = (Left)either;
            ReadMnemonicError err = (ReadMnemonicError)left.value();
            throw scala.sys.package$.MODULE$.error(new StringBuilder(69).append("Could not create a BIP39KeyManager from the KeyManagerAppConfig, err=").append(err).toString());
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        BIP39KeyManager bIP39KeyManager = km = (BIP39KeyManager)right.value();
        return bIP39KeyManager;
    }

    private Future<BoxedUnit> initializeKeyManager() {
        Future future;
        BitVector bitVector;
        Option<String> option = this.externalEntropy();
        if (option instanceof Some) {
            BitVector hex;
            Option hexOpt;
            Some some = (Some)option;
            String entropy = (String)some.value();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(61).append("Initializing new mnemonic seed at path=").append(this.seedPath().toAbsolutePath()).append(" with external entropy").toString());
            Option option2 = hexOpt = BitVector$.MODULE$.fromHex(entropy, BitVector$.MODULE$.fromHex$default$2());
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw scala.sys.package$.MODULE$.error(new StringBuilder(72).append("Entropy provided by bitcoin-s.keymanager.entropy was not valid hex, got=").append(entropy).toString());
                }
                throw new MatchError((Object)option2);
            }
            Some some2 = (Some)option2;
            BitVector bitVector2 = hex = (BitVector)some2.value();
            bitVector = bitVector2;
        } else if (None$.MODULE$.equals(option)) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(39).append("Initializing new mnemonic seed at path=").append(this.seedPath().toAbsolutePath()).toString());
            bitVector = MnemonicCode$.MODULE$.getEntropy256Bits();
        } else {
            throw new MatchError(option);
        }
        BitVector entropy = bitVector;
        if (!CryptoUtil$.MODULE$.checkEntropy(entropy)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(77).append("The entropy used by bitcoin-s does not pass basic entropy sanity checks, got=").append(entropy).toString());
        }
        Either<KeyManagerInitializeError, BIP39KeyManager> initE = BIP39KeyManager$.MODULE$.initializeWithEntropy(this.aesPasswordOpt(), entropy, this.bip39PasswordOpt(), this.kmParams());
        Either<KeyManagerInitializeError, BIP39KeyManager> either = initE;
        if (either instanceof Right) {
            Right right = (Right)either;
            BIP39KeyManager km = (BIP39KeyManager)right.value();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(52).append("Successfully initialize seed at path with root xpub=").append(km.getRootXPub()).toString());
            future = Future$.MODULE$.unit();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            KeyManagerInitializeError err = (KeyManagerInitializeError)left.value();
            future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(58).append("Failed to initialize mnemonic seed in keymanager with err=").append(err).toString()));
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    public Instant creationTime() {
        return this.toBip39KeyManager().creationTime();
    }

    public KeyManagerAppConfig copy(Path baseDatadir, Vector<Config> configOverrides, Option<ArgumentSource<String>> walletNameOverride, Option<ArgumentSource<AesPassword>> aesPasswordOverride, Option<String> bip39PasswordOverride, ExecutionContext ec) {
        return new KeyManagerAppConfig(baseDatadir, configOverrides, walletNameOverride, aesPasswordOverride, bip39PasswordOverride, ec);
    }

    public Path copy$default$1() {
        return this.baseDatadir();
    }

    public Vector<Config> copy$default$2() {
        return this.configOverrides();
    }

    public Option<ArgumentSource<String>> copy$default$3() {
        return this.walletNameOverride();
    }

    public Option<ArgumentSource<AesPassword>> copy$default$4() {
        return this.aesPasswordOverride();
    }

    public Option<String> copy$default$5() {
        return this.bip39PasswordOverride();
    }

    public String productPrefix() {
        return "KeyManagerAppConfig";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.baseDatadir();
                break;
            }
            case 1: {
                object = this.configOverrides();
                break;
            }
            case 2: {
                object = this.walletNameOverride();
                break;
            }
            case 3: {
                object = this.aesPasswordOverride();
                break;
            }
            case 4: {
                object = this.bip39PasswordOverride();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KeyManagerAppConfig;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "baseDatadir";
                break;
            }
            case 1: {
                string = "configOverrides";
                break;
            }
            case 2: {
                string = "walletNameOverride";
                break;
            }
            case 3: {
                string = "aesPasswordOverride";
                break;
            }
            case 4: {
                string = "bip39PasswordOverride";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KeyManagerAppConfig)) return false;
        boolean bl = true;
        if (!bl) return false;
        KeyManagerAppConfig keyManagerAppConfig = (KeyManagerAppConfig)x$1;
        Path path = this.baseDatadir();
        Path path2 = keyManagerAppConfig.baseDatadir();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Vector<Config> vector = this.configOverrides();
        Vector<Config> vector2 = keyManagerAppConfig.configOverrides();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        Option<ArgumentSource<String>> option = this.walletNameOverride();
        Option<ArgumentSource<String>> option2 = keyManagerAppConfig.walletNameOverride();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<ArgumentSource<AesPassword>> option3 = this.aesPasswordOverride();
        Option<ArgumentSource<AesPassword>> option4 = keyManagerAppConfig.aesPasswordOverride();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.bip39PasswordOverride();
        Option<String> option6 = keyManagerAppConfig.bip39PasswordOverride();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!keyManagerAppConfig.canEqual(this)) return false;
        return true;
    }

    public KeyManagerAppConfig(Path baseDatadir, Vector<Config> configOverrides, Option<ArgumentSource<String>> walletNameOverride, Option<ArgumentSource<AesPassword>> aesPasswordOverride, Option<String> bip39PasswordOverride, ExecutionContext ec) {
        this.baseDatadir = baseDatadir;
        this.configOverrides = configOverrides;
        this.walletNameOverride = walletNameOverride;
        this.aesPasswordOverride = aesPasswordOverride;
        this.bip39PasswordOverride = bip39PasswordOverride;
        this.ec = ec;
        Product.$init$((Product)this);
        String string = this.walletName();
        String string2 = KeyManagerAppConfig$.MODULE$.DEFAULT_WALLET_NAME();
        String prefix = !(string != null ? !string.equals(string2) : string2 != null) ? KeyManagerAppConfig$.MODULE$.DEFAULT_WALLET_NAME() : new StringBuilder(1).append(this.walletName()).append("-").toString();
        this.seedFileName = new StringBuilder(0).append(prefix).append(WalletStorage$.MODULE$.ENCRYPTED_SEED_FILE_NAME()).toString();
        this.kmParams = new KeyManagerParams(this.seedPath(), this.defaultAccountKind(), (NetworkParameters)this.network());
    }
}

