/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoin;

import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bitcoin.NativeSecp256k1Util;
import org.bitcoin.Secp256k1Context;

public class NativeSecp256k1 {
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Lock r = rwl.readLock();
    private static final Lock w = rwl.writeLock();
    private static ThreadLocal<ByteBuffer> nativeECDSABuffer = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        NativeSecp256k1Util.checkArgument(byArray.length == 32 && byArray2.length <= 520 && byArray3.length <= 520);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 520) {
            byteBuffer = ByteBuffer.allocateDirect(520);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        r.lock();
        try {
            boolean bl = NativeSecp256k1.secp256k1_ecdsa_verify(byteBuffer, Secp256k1Context.getContext(), byArray2.length, byArray3.length) == 1;
            return bl;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sign(byte[] byArray, byte[] byArray2) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray3;
        NativeSecp256k1Util.checkArgument(byArray.length == 32 && byArray2.length <= 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 64) {
            byteBuffer = ByteBuffer.allocateDirect(64);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        r.lock();
        try {
            byArray3 = NativeSecp256k1.secp256k1_ecdsa_sign(byteBuffer, Secp256k1Context.getContext());
        }
        finally {
            r.unlock();
        }
        byte[] byArray4 = byArray3[0];
        int n = new BigInteger(new byte[]{byArray3[1][0]}).intValue();
        int n2 = new BigInteger(new byte[]{byArray3[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray4.length, n, "Got bad signature length.");
        return n2 == 0 ? new byte[]{} : byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] signWithEntropy(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray4;
        NativeSecp256k1Util.checkArgument(byArray.length == 32 && byArray2.length == 32 && byArray3.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 96) {
            byteBuffer = ByteBuffer.allocateDirect(96);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        r.lock();
        try {
            byArray4 = NativeSecp256k1.secp256k1_ecdsa_sign_with_entropy(byteBuffer, Secp256k1Context.getContext());
        }
        finally {
            r.unlock();
        }
        byte[] byArray5 = byArray4[0];
        int n = new BigInteger(new byte[]{byArray4[1][0]}).intValue();
        int n2 = new BigInteger(new byte[]{byArray4[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray5.length, n, "Got bad signature length.");
        return n2 == 0 ? new byte[]{} : byArray5;
    }

    public static boolean secKeyVerify(byte[] byArray) {
        NativeSecp256k1Util.checkArgument(byArray.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        r.lock();
        try {
            boolean bl = NativeSecp256k1.secp256k1_ec_seckey_verify(byteBuffer, Secp256k1Context.getContext()) == 1;
            return bl;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computePubkey(byte[] byArray, boolean bl) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray2;
        NativeSecp256k1Util.checkArgument(byArray.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        r.lock();
        try {
            byArray2 = NativeSecp256k1.secp256k1_ec_pubkey_create(byteBuffer, Secp256k1Context.getContext(), bl);
        }
        finally {
            r.unlock();
        }
        byte[] byArray3 = byArray2[0];
        int n = new BigInteger(new byte[]{byArray2[1][0]}).intValue();
        int n2 = new BigInteger(new byte[]{byArray2[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray3.length, n, "Got bad pubkey length.");
        return n2 == 0 ? new byte[]{} : byArray3;
    }

    public static synchronized void cleanup() {
        w.lock();
        try {
            NativeSecp256k1.secp256k1_destroy_context(Secp256k1Context.getContext());
        }
        finally {
            w.unlock();
        }
    }

    public static long cloneContext() {
        r.lock();
        try {
            long l = NativeSecp256k1.secp256k1_ctx_clone(Secp256k1Context.getContext());
            return l;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] privKeyTweakMul(byte[] byArray, byte[] byArray2) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray3;
        NativeSecp256k1Util.checkArgument(byArray.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length + byArray2.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length + byArray2.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        r.lock();
        try {
            byArray3 = NativeSecp256k1.secp256k1_privkey_tweak_mul(byteBuffer, Secp256k1Context.getContext());
        }
        finally {
            r.unlock();
        }
        byte[] byArray4 = byArray3[0];
        int n = (byte)new BigInteger(new byte[]{byArray3[1][0]}).intValue() & 0xFF;
        int n2 = new BigInteger(new byte[]{byArray3[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray4.length, n, "Got bad pubkey length.");
        NativeSecp256k1Util.assertEquals(n2, 1, "Failed return value check.");
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] privKeyTweakAdd(byte[] byArray, byte[] byArray2) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray3;
        NativeSecp256k1Util.checkArgument(byArray.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length + byArray2.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length + byArray2.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        r.lock();
        try {
            byArray3 = NativeSecp256k1.secp256k1_privkey_tweak_add(byteBuffer, Secp256k1Context.getContext());
        }
        finally {
            r.unlock();
        }
        byte[] byArray4 = byArray3[0];
        int n = (byte)new BigInteger(new byte[]{byArray3[1][0]}).intValue() & 0xFF;
        int n2 = new BigInteger(new byte[]{byArray3[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray4.length, n, "Got bad pubkey length.");
        NativeSecp256k1Util.assertEquals(n2, 1, "Failed return value check.");
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] pubKeyTweakAdd(byte[] byArray, byte[] byArray2, boolean bl) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray3;
        NativeSecp256k1Util.checkArgument(byArray.length == 33 || byArray.length == 65);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length + byArray2.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length + byArray2.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        r.lock();
        try {
            byArray3 = NativeSecp256k1.secp256k1_pubkey_tweak_add(byteBuffer, Secp256k1Context.getContext(), byArray.length, bl);
        }
        finally {
            r.unlock();
        }
        byte[] byArray4 = byArray3[0];
        int n = (byte)new BigInteger(new byte[]{byArray3[1][0]}).intValue() & 0xFF;
        int n2 = new BigInteger(new byte[]{byArray3[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray4.length, n, "Got bad pubkey length.");
        NativeSecp256k1Util.assertEquals(n2, 1, "Failed return value check.");
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] pubKeyTweakMul(byte[] byArray, byte[] byArray2, boolean bl) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray3;
        NativeSecp256k1Util.checkArgument(byArray.length == 33 || byArray.length == 65);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length + byArray2.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length + byArray2.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        r.lock();
        try {
            byArray3 = NativeSecp256k1.secp256k1_pubkey_tweak_mul(byteBuffer, Secp256k1Context.getContext(), byArray.length, bl);
        }
        finally {
            r.unlock();
        }
        byte[] byArray4 = byArray3[0];
        int n = (byte)new BigInteger(new byte[]{byArray3[1][0]}).intValue() & 0xFF;
        int n2 = new BigInteger(new byte[]{byArray3[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray4.length, n, "Got bad pubkey length.");
        NativeSecp256k1Util.assertEquals(n2, 1, "Failed return value check.");
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] pubKeyCombine(byte[][] byArray, boolean bl) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray2;
        int n = byArray.length;
        NativeSecp256k1Util.checkArgument(n > 0);
        int n2 = byArray[0].length;
        NativeSecp256k1Util.checkArgument(n2 == 33 || n2 == 65);
        for (byte[] byArray3 : byArray) {
            NativeSecp256k1Util.checkArgument(byArray3.length == n2);
        }
        Object object = nativeECDSABuffer.get();
        if (object == null || ((Buffer)object).capacity() < n * n2) {
            object = ByteBuffer.allocateDirect(n * n2);
            ((ByteBuffer)object).order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set((ByteBuffer)object);
        }
        NativeSecp256k1.safeRewind((ByteBuffer)object);
        for (byte[] byArray4 : byArray) {
            ((ByteBuffer)object).put(byArray4);
        }
        r.lock();
        try {
            byArray2 = NativeSecp256k1.secp256k1_ec_pubkey_combine((ByteBuffer)object, Secp256k1Context.getContext(), n2, n, bl);
        }
        finally {
            r.unlock();
        }
        byte[] byArray5 = byArray2[0];
        int n3 = (byte)new BigInteger(new byte[]{byArray2[1][0]}).intValue() & 0xFF;
        int n4 = new BigInteger(new byte[]{byArray2[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray5.length, n3, "Got bad pubkey length.");
        NativeSecp256k1Util.assertEquals(n4, 1, "Failed return value check.");
        return byArray5;
    }

    public static byte[] decompress(byte[] byArray) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray2;
        NativeSecp256k1Util.checkArgument(byArray.length == 33 || byArray.length == 65);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        r.lock();
        try {
            byArray2 = NativeSecp256k1.secp256k1_ec_pubkey_decompress(byteBuffer, Secp256k1Context.getContext(), byArray.length);
        }
        finally {
            r.unlock();
        }
        byte[] byArray3 = byArray2[0];
        int n = (byte)new BigInteger(new byte[]{byArray2[1][0]}).intValue() & 0xFF;
        int n2 = new BigInteger(new byte[]{byArray2[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray3.length, n, "Got bad pubkey length.");
        NativeSecp256k1Util.assertEquals(n2, 1, "Failed return value check.");
        return byArray3;
    }

    public static boolean isValidPubKey(byte[] byArray) {
        byte[][] byArray2;
        if (byArray.length != 33 && byArray.length != 65) {
            return false;
        }
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        r.lock();
        try {
            byArray2 = NativeSecp256k1.secp256k1_ec_pubkey_decompress(byteBuffer, Secp256k1Context.getContext(), byArray.length);
        }
        finally {
            r.unlock();
        }
        int n = new BigInteger(new byte[]{byArray2[1][1]}).intValue();
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createECDHSecret(byte[] byArray, byte[] byArray2) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray3;
        NativeSecp256k1Util.checkArgument(byArray.length <= 32 && byArray2.length <= 65);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 32 + byArray2.length) {
            byteBuffer = ByteBuffer.allocateDirect(32 + byArray2.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        r.lock();
        try {
            byArray3 = NativeSecp256k1.secp256k1_ecdh(byteBuffer, Secp256k1Context.getContext(), byArray2.length);
        }
        finally {
            r.unlock();
        }
        byte[] byArray4 = byArray3[0];
        int n = new BigInteger(new byte[]{byArray3[1][0]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray4.length, 32, "Got bad result length.");
        NativeSecp256k1Util.assertEquals(n, 1, "Failed return value check.");
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] schnorrSign(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray4;
        NativeSecp256k1Util.checkArgument(byArray.length == 32 && byArray2.length == 32 && byArray3.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 96) {
            byteBuffer = ByteBuffer.allocateDirect(96);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        r.lock();
        try {
            byArray4 = NativeSecp256k1.secp256k1_schnorrsig_sign(byteBuffer, Secp256k1Context.getContext());
        }
        finally {
            r.unlock();
        }
        byte[] byArray5 = byArray4[0];
        int n = new BigInteger(new byte[]{byArray4[1][0]}).intValue();
        NativeSecp256k1Util.assertEquals(n, 1, "Failed return value check.");
        return byArray5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] schnorrSignWithNonce(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray4;
        NativeSecp256k1Util.checkArgument(byArray.length == 32 && byArray2.length == 32 && byArray3.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 96) {
            byteBuffer = ByteBuffer.allocateDirect(96);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        r.lock();
        try {
            byArray4 = NativeSecp256k1.secp256k1_schnorrsig_sign_with_nonce(byteBuffer, Secp256k1Context.getContext());
        }
        finally {
            r.unlock();
        }
        byte[] byArray5 = byArray4[0];
        int n = new BigInteger(new byte[]{byArray4[1][0]}).intValue();
        NativeSecp256k1Util.assertEquals(n, 1, "Failed return value check.");
        return byArray5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean schnorrVerify(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NativeSecp256k1Util.AssertFailException {
        NativeSecp256k1Util.checkArgument(byArray.length == 64 && byArray2.length == 32 && byArray3.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 128) {
            byteBuffer = ByteBuffer.allocateDirect(128);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        r.lock();
        try {
            boolean bl = NativeSecp256k1.secp256k1_schnorrsig_verify(byteBuffer, Secp256k1Context.getContext()) == 1;
            return bl;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] adaptorSign(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray5;
        NativeSecp256k1Util.checkArgument(byArray.length == 32 && byArray3.length == 32 && (byArray2.length == 33 || byArray2.length == 65) && byArray4.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 64 + byArray2.length + 32) {
            byteBuffer = ByteBuffer.allocateDirect(64 + byArray2.length + 32);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        byteBuffer.put(byArray4);
        r.lock();
        try {
            byArray5 = NativeSecp256k1.secp256k1_ecdsa_adaptor_sign(byteBuffer, Secp256k1Context.getContext(), byArray2.length);
        }
        finally {
            r.unlock();
        }
        byte[] byArray6 = byArray5[0];
        int n = new BigInteger(new byte[]{byArray5[1][0]}).intValue();
        if (n == 0) {
            return new byte[0];
        }
        return byArray6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean adaptorVerify(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws NativeSecp256k1Util.AssertFailException {
        NativeSecp256k1Util.checkArgument(byArray3.length == 32 && byArray.length == 162 && (byArray2.length == 33 || byArray2.length == 65) && byArray4.length == byArray2.length);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        int n = 194 + byArray2.length + byArray4.length;
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocateDirect(n);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        byteBuffer.put(byArray4);
        r.lock();
        try {
            boolean bl = NativeSecp256k1.secp256k1_ecdsa_adaptor_sig_verify(byteBuffer, Secp256k1Context.getContext(), byArray2.length) == 1;
            return bl;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] adaptorAdapt(byte[] byArray, byte[] byArray2) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray3;
        NativeSecp256k1Util.checkArgument(byArray.length == 32 && byArray2.length == 162);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < 194) {
            byteBuffer = ByteBuffer.allocateDirect(194);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        r.lock();
        try {
            byArray3 = NativeSecp256k1.secp256k1_ecdsa_adaptor_adapt(byteBuffer, Secp256k1Context.getContext());
        }
        finally {
            r.unlock();
        }
        byte[] byArray4 = byArray3[0];
        int n = new BigInteger(new byte[]{byArray3[1][0]}).intValue();
        int n2 = new BigInteger(new byte[]{byArray3[1][1]}).intValue();
        NativeSecp256k1Util.assertEquals(byArray4.length, n, "Got bad signature length.");
        return n2 == 0 ? new byte[]{} : byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] adaptorExtractSecret(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NativeSecp256k1Util.AssertFailException {
        byte[][] byArray4;
        NativeSecp256k1Util.checkArgument(byArray.length <= 520 && (byArray3.length == 33 || byArray3.length == 65) && byArray2.length == 162);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length + byArray3.length + 162) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length + byArray3.length + 162);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        r.lock();
        try {
            byArray4 = NativeSecp256k1.secp256k1_ecdsa_adaptor_extract_secret(byteBuffer, Secp256k1Context.getContext(), byArray.length, byArray3.length);
        }
        finally {
            r.unlock();
        }
        byte[] byArray5 = byArray4[0];
        int n = new BigInteger(new byte[]{byArray4[1][0]}).intValue();
        return n == 0 ? new byte[]{} : byArray5;
    }

    public static synchronized boolean randomize(byte[] byArray) throws NativeSecp256k1Util.AssertFailException {
        NativeSecp256k1Util.checkArgument(byArray.length == 32);
        ByteBuffer byteBuffer = nativeECDSABuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuffer);
        }
        NativeSecp256k1.safeRewind(byteBuffer);
        byteBuffer.put(byArray);
        w.lock();
        try {
            boolean bl = NativeSecp256k1.secp256k1_context_randomize(byteBuffer, Secp256k1Context.getContext()) == 1;
            return bl;
        }
        finally {
            w.unlock();
        }
    }

    private static void safeRewind(ByteBuffer byteBuffer) {
        ((Buffer)byteBuffer).rewind();
    }

    private static native long secp256k1_ctx_clone(long var0);

    private static native int secp256k1_context_randomize(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_privkey_tweak_add(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_privkey_tweak_mul(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_pubkey_tweak_add(ByteBuffer var0, long var1, int var3, boolean var4);

    private static native byte[][] secp256k1_pubkey_tweak_mul(ByteBuffer var0, long var1, int var3, boolean var4);

    private static native void secp256k1_destroy_context(long var0);

    private static native int secp256k1_ecdsa_verify(ByteBuffer var0, long var1, int var3, int var4);

    private static native byte[][] secp256k1_ecdsa_sign(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_ecdsa_sign_with_entropy(ByteBuffer var0, long var1);

    private static native int secp256k1_ec_seckey_verify(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_ec_pubkey_create(ByteBuffer var0, long var1, boolean var3);

    private static native byte[][] secp256k1_ec_pubkey_combine(ByteBuffer var0, long var1, int var3, int var4, boolean var5);

    private static native byte[][] secp256k1_ec_pubkey_decompress(ByteBuffer var0, long var1, int var3);

    private static native byte[][] secp256k1_ecdh(ByteBuffer var0, long var1, int var3);

    private static native byte[][] secp256k1_schnorrsig_sign(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_schnorrsig_sign_with_nonce(ByteBuffer var0, long var1);

    private static native int secp256k1_schnorrsig_verify(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_ecdsa_adaptor_sign(ByteBuffer var0, long var1, int var3);

    private static native int secp256k1_ecdsa_adaptor_sig_verify(ByteBuffer var0, long var1, int var3);

    private static native byte[][] secp256k1_ecdsa_adaptor_adapt(ByteBuffer var0, long var1);

    private static native byte[][] secp256k1_ecdsa_adaptor_extract_secret(ByteBuffer var0, long var1, int var3, int var4);
}

