/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoin;

import java.io.IOException;
import org.scijava.nativelib.NativeLoader;

public class Secp256k1Context {
    private static final boolean enabled;
    private static final long context;

    public static boolean isEnabled() {
        return enabled;
    }

    public static long getContext() {
        if (!enabled) {
            return -1L;
        }
        return context;
    }

    private static native long secp256k1_init_context();

    static {
        boolean bl = true;
        long l = -1L;
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                NativeLoader.loadLibrary((String)"libsecp256k1-0", (String[])new String[0]);
            } else {
                NativeLoader.loadLibrary((String)"secp256k1", (String[])new String[0]);
            }
            l = Secp256k1Context.secp256k1_init_context();
        }
        catch (IOException | UnsatisfiedLinkError throwable) {
            System.out.println("UnsatisfiedLinkError: " + throwable.toString());
            bl = false;
        }
        enabled = bl;
        context = l;
    }
}

