/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.server;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.commons.config.AppConfig$;
import org.bitcoins.commons.util.ServerArgParser;
import org.bitcoins.node.config.NodeAppConfig;
import org.bitcoins.rpc.config.BitcoindRpcAppConfig;
import org.bitcoins.server.BitcoinSAppConfig;
import org.bitcoins.wallet.config.WalletAppConfig;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;

public final class BitcoinSAppConfig$
implements Logging,
scala.Serializable {
    public static BitcoinSAppConfig$ MODULE$;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new BitcoinSAppConfig$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BitcoinSAppConfig$ bitcoinSAppConfig$ = this;
        synchronized (bitcoinSAppConfig$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public BitcoinSAppConfig fromConfig(Config config, ActorSystem system) {
        Path configDataDir = Paths.get(config.getString("bitcoin-s.datadir"), new String[0]);
        return new BitcoinSAppConfig(configDataDir, (Vector<Config>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{config}))), system);
    }

    public BitcoinSAppConfig fromClassPathConfig(ActorSystem system) {
        return this.fromConfig(ConfigFactory.load(), system);
    }

    public BitcoinSAppConfig fromDatadir(Path datadir, Seq<Config> confs, ActorSystem system) {
        return new BitcoinSAppConfig(datadir, (Vector<Config>)confs.toVector(), system);
    }

    public BitcoinSAppConfig fromDatadirWithServerArgs(Path datadir, ServerArgParser serverArgsParser, ActorSystem system) {
        return this.fromDatadir(datadir, (Seq<Config>)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{serverArgsParser.toConfig()}), system);
    }

    public BitcoinSAppConfig fromDefaultDatadir(Seq<Config> confs, ActorSystem system) {
        return new BitcoinSAppConfig(AppConfig$.MODULE$.DEFAULT_BITCOIN_S_DATADIR(), (Vector<Config>)confs.toVector(), system);
    }

    public BitcoinSAppConfig fromDefaultDatadirWithBundleConf(Vector<Config> confs, ActorSystem system) {
        return this.fromDatadirWithBundleConf(AppConfig$.MODULE$.DEFAULT_BITCOIN_S_DATADIR(), confs, system);
    }

    public Vector<Config> fromDefaultDatadirWithBundleConf$default$1() {
        return package$.MODULE$.Vector().empty();
    }

    public BitcoinSAppConfig fromDatadirWithBundleConf(Path datadir, Vector<Config> confs, ActorSystem system) {
        Config extraConfig;
        Config config;
        BitcoinSAppConfig baseConf = this.fromDatadir(datadir, (Seq<Config>)confs, system);
        Path bundleConfFile = this.toChainConf(baseConf).baseDatadir().resolve("bitcoin-s-bundle.conf");
        if (Files.isReadable(bundleConfFile)) {
            config = ConfigFactory.parseFile((File)bundleConfFile.toFile());
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "No saved bundle config found");
            config = ConfigFactory.empty();
        }
        Config config2 = extraConfig = config;
        return baseConf.copyWithConfig((Vector<Config>)((Vector)confs.$plus$colon((Object)config2, Vector$.MODULE$.canBuildFrom())));
    }

    public Vector<Config> fromDatadirWithBundleConf$default$2() {
        return package$.MODULE$.Vector().empty();
    }

    public BitcoinSAppConfig fromDatadirWithBundleConfWithServerArgs(Path datadir, ServerArgParser serverArgParser, ActorSystem system) {
        return this.fromDatadirWithBundleConf(datadir, (Vector<Config>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{serverArgParser.toConfig()}))), system);
    }

    public BitcoinSAppConfig fromDefaultDatadirWithServerArgs(ServerArgParser serverArgParser, ActorSystem system) {
        Config config = serverArgParser.toConfig();
        return this.fromConfig(config, system);
    }

    public WalletAppConfig toWalletConf(BitcoinSAppConfig conf) {
        return conf.walletConf();
    }

    public ChainAppConfig toChainConf(BitcoinSAppConfig conf) {
        return conf.chainConf();
    }

    public NodeAppConfig toNodeConf(BitcoinSAppConfig conf) {
        return conf.nodeConf();
    }

    public BitcoindRpcAppConfig toBitcoindRpcConf(BitcoinSAppConfig conf) {
        return conf.bitcoindRpcConf();
    }

    public BitcoinSAppConfig apply(Path baseDatadir, Vector<Config> configOverrides, ActorSystem system) {
        return new BitcoinSAppConfig(baseDatadir, configOverrides, system);
    }

    public Option<Tuple2<Path, Vector<Config>>> unapply(BitcoinSAppConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.baseDatadir(), x$0.configOverrides()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BitcoinSAppConfig$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

