/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.server;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.commons.config.AppConfig;
import org.bitcoins.commons.config.AppConfig$;
import org.bitcoins.commons.config.package;
import org.bitcoins.commons.util.ServerArgParser;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.util.StartStopAsync;
import org.bitcoins.core.util.TimeUtil$;
import org.bitcoins.db.DbAppConfig;
import org.bitcoins.dlc.node.config.DLCNodeAppConfig;
import org.bitcoins.dlc.wallet.DLCAppConfig;
import org.bitcoins.dlc.wallet.DLCAppConfig$;
import org.bitcoins.keymanager.config.KeyManagerAppConfig;
import org.bitcoins.keymanager.config.KeyManagerAppConfig$;
import org.bitcoins.node.config.NodeAppConfig;
import org.bitcoins.rpc.config.BitcoindRpcAppConfig;
import org.bitcoins.server.BitcoinSAppConfig$;
import org.bitcoins.server.util.AppConfigMarker;
import org.bitcoins.server.util.StartedBitcoinSAppConfig;
import org.bitcoins.server.util.StoppedBitcoinSAppConfig$;
import org.bitcoins.tor.config.TorAppConfig;
import org.bitcoins.wallet.config.WalletAppConfig;
import org.bitcoins.wallet.config.WalletAppConfig$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001\u0002\u001f>\u0001\u0012C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\te\u0002\u0011\t\u0012)A\u0005Q\"A1\u000f\u0001BK\u0002\u0013\u0005A\u000fC\u0005\u0002\u0018\u0001\u0011\t\u0012)A\u0005k\"Q\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006Y!a\u0007\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!Q\u00111\b\u0001\t\u0006\u0004%\t!!\u0010\t\u0015\u00055\u0003\u0001#b\u0001\n\u0003\ty\u0005\u0003\u0006\u0002`\u0001A)\u0019!C\u0001\u0003CB!\"!\u001d\u0001\u0011\u000b\u0007I\u0011AA:\u0011)\t\u0019\t\u0001EC\u0002\u0013\u0005\u0011Q\u0011\u0005\u000b\u0003+\u0003\u0001R1A\u0005\u0002\u0005]\u0005BCAS\u0001!\u0015\r\u0011\"\u0001\u0002(\"Q\u0011q\u0017\u0001\t\u0006\u0004%\t!!/\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"Q\u0011\u0011\u001b\u0001\t\u0006\u0004%\t!a5\t\u000f\u0005}\u0007\u0001\"\u0011\u0002b\"9\u0011Q\u001f\u0001\u0005B\u0005]\bBCA\u0005\u0001!\u0015\r\u0011\"\u0001\u0003\u0002!9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\u0007\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005CAqA!\u000f\u0001\t\u0003\u0011\t\u0003C\u0004\u0003<\u0001!\tA!\u0010\t\u000f\t}\u0002\u0001\"\u0001\u0003B!9!\u0011\n\u0001\u0005\u0002\t-\u0003\"\u0003B)\u0001\u0005\u0005I\u0011\u0001B*\u0011%\u0011i\u0006AI\u0001\n\u0003\u0011y\u0006C\u0005\u0003v\u0001\t\n\u0011\"\u0001\u0003x!I!1\u0010\u0001\u0002\u0002\u0013\u0005#Q\u0010\u0005\n\u0005\u0013\u0003\u0011\u0011!C\u0001\u0005\u000bA\u0011Ba#\u0001\u0003\u0003%\tA!$\t\u0013\te\u0005!!A\u0005B\tm\u0005\"\u0003BU\u0001\u0005\u0005I\u0011\u0001BV\u0011%\u0011y\u000bAA\u0001\n\u0003\u0012\t\fC\u0005\u00034\u0002\t\t\u0011\"\u0011\u00036\"I!q\u0017\u0001\u0002\u0002\u0013\u0005#\u0011X\u0004\b\u0005{k\u0004\u0012\u0001B`\r\u0019aT\b#\u0001\u0003B\"9\u00111\u0006\u0015\u0005\u0002\t\r\u0007b\u0002BcQ\u0011\u0005!q\u0019\u0005\b\u0005\u001fDC\u0011\u0001Bi\u0011\u001d\u00119\u000e\u000bC\u0001\u00053DqA!<)\t\u0003\u0011y\u000fC\u0004\u0004\n!\"\taa\u0003\t\u000f\rM\u0001\u0006\"\u0001\u0004\u0016!I1Q\u0004\u0015\u0012\u0002\u0013\u0005!q\u000f\u0005\b\u0007?AC\u0011AB\u0011\u0011%\u0019Y\u0003KI\u0001\n\u0003\u00119\bC\u0004\u0004.!\"\taa\f\t\u000f\rm\u0002\u0006\"\u0001\u0004>!91Q\t\u0015\u0005\u0002\r\u001d\u0003bBB'Q\u0011\u00051q\n\u0005\b\u0007'BC\u0011AB+\u0011\u001d\u0019I\u0006\u000bC\u0001\u00077B\u0011ba\u0018)\u0003\u0003%\ti!\u0019\t\u0013\r-\u0004&!A\u0005\u0002\u000e5\u0004\"CB>Q\u0005\u0005I\u0011BB?\u0005E\u0011\u0015\u000e^2pS:\u001c\u0016\t\u001d9D_:4\u0017n\u001a\u0006\u0003}}\naa]3sm\u0016\u0014(B\u0001!B\u0003!\u0011\u0017\u000e^2pS:\u001c(\"\u0001\"\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001)5\n\u00171d!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fMB\u0019A*U*\u000e\u00035S!AT(\u0002\tU$\u0018\u000e\u001c\u0006\u0003!~\nAaY8sK&\u0011!+\u0014\u0002\u000f'R\f'\u000f^*u_B\f5/\u001f8d!\t!f+D\u0001V\u0015\tqU(\u0003\u0002X+\ny\u0011\t\u001d9D_:4\u0017nZ'be.,'\u000f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006)1\u000f\u001c45U*\tQ,\u0001\u0005he&T(\u0010\\3e\u0013\ty&LA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0019\u000b\u0017B\u00012H\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u00123\n\u0005\u0015<%\u0001D*fe&\fG.\u001b>bE2,\u0017a\u00032bg\u0016$\u0015\r^1eSJ,\u0012\u0001\u001b\t\u0003SBl\u0011A\u001b\u0006\u0003W2\fAAZ5mK*\u0011QN\\\u0001\u0004]&|'\"A8\u0002\t)\fg/Y\u0005\u0003c*\u0014A\u0001U1uQ\u0006a!-Y:f\t\u0006$\u0018\rZ5sA\u0005y1m\u001c8gS\u001e|e/\u001a:sS\u0012,7/F\u0001v!\u00111h0a\u0001\u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>D\u0003\u0019a$o\\8u}%\t\u0001*\u0003\u0002~\u000f\u00069\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\t1a+Z2u_JT!!`$\u0011\t\u0005\u0015\u00111C\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u000511m\u001c8gS\u001eTA!!\u0004\u0002\u0010\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002\u0012\u0005\u00191m\\7\n\t\u0005U\u0011q\u0001\u0002\u0007\u0007>tg-[4\u0002!\r|gNZ5h\u001fZ,'O]5eKN\u0004\u0013AB:zgR,W\u000e\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005\u0015\u0012\u0001B1lW\u0006LA!!\u000b\u0002 \tY\u0011i\u0019;peNK8\u000f^3n\u0003\u0019a\u0014N\\5u}Q1\u0011qFA\u001c\u0003s!B!!\r\u00026A\u0019\u00111\u0007\u0001\u000e\u0003uBq!!\u0007\u0007\u0001\b\tY\u0002C\u0003g\r\u0001\u0007\u0001\u000eC\u0003t\r\u0001\u0007Q/\u0001\u0006xC2dW\r^\"p]\u001a,\"!a\u0010\u0011\t\u0005\u0005\u0013\u0011J\u0007\u0003\u0003\u0007RA!!\u0003\u0002F)\u0019\u0011qI \u0002\r]\fG\u000e\\3u\u0013\u0011\tY%a\u0011\u0003\u001f]\u000bG\u000e\\3u\u0003B\u00048i\u001c8gS\u001e\f\u0001B\\8eK\u000e{gNZ\u000b\u0003\u0003#\u0002B!a\u0015\u0002\\5\u0011\u0011Q\u000b\u0006\u0005\u0003\u0013\t9FC\u0002\u0002Z}\nAA\\8eK&!\u0011QLA+\u00055qu\u000eZ3BaB\u001cuN\u001c4jO\u0006I1\r[1j]\u000e{gNZ\u000b\u0003\u0003G\u0002B!!\u001a\u0002n5\u0011\u0011q\r\u0006\u0005\u0003\u0013\tIGC\u0002\u0002l}\nQa\u00195bS:LA!a\u001c\u0002h\tq1\t[1j]\u0006\u0003\boQ8oM&<\u0017a\u00023mG\u000e{gNZ\u000b\u0003\u0003k\u0002B!a\u001e\u0002\u00005\u0011\u0011\u0011\u0010\u0006\u0005\u0003\u000f\nYHC\u0002\u0002~}\n1\u0001\u001a7d\u0013\u0011\t\t)!\u001f\u0003\u0019\u0011c5)\u00119q\u0007>tg-[4\u0002\u000fQ|'oQ8oMV\u0011\u0011q\u0011\t\u0005\u0003\u0013\u000b\t*\u0004\u0002\u0002\f*!\u0011\u0011BAG\u0015\r\tyiP\u0001\u0004i>\u0014\u0018\u0002BAJ\u0003\u0017\u0013A\u0002V8s\u0003B\u00048i\u001c8gS\u001e\f1\u0002\u001a7d\u001d>$WmQ8oMV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*!\u0011\u0011BAP\u0015\u0011\tI&a\u001f\n\t\u0005\r\u0016Q\u0014\u0002\u0011\t2\u001bej\u001c3f\u0003B\u00048i\u001c8gS\u001e\faa[7D_:4WCAAU!\u0011\tY+a-\u000e\u0005\u00055&\u0002BA\u0005\u0003_S1!!-@\u0003)YW-_7b]\u0006<WM]\u0005\u0005\u0003k\u000biKA\nLKfl\u0015M\\1hKJ\f\u0005\u000f]\"p]\u001aLw-A\bcSR\u001cw.\u001b8e%B\u001c7i\u001c8g+\t\tY\f\u0005\u0003\u0002>\u0006\u0015WBAA`\u0015\u0011\tI!!1\u000b\u0007\u0005\rw(A\u0002sa\u000eLA!a2\u0002@\n!\")\u001b;d_&tGM\u00159d\u0003B\u00048i\u001c8gS\u001e\fabY8qs^KG\u000f[\"p]\u001aLw\r\u0006\u0003\u00022\u00055\u0007BBAh\u001f\u0001\u0007Q/\u0001\u0005oK^\u001cuN\u001c4t\u0003\u001dqW\r^<pe.,\"!!6\u0011\t\u0005]\u00171\\\u0007\u0003\u00033T1!!\u0003P\u0013\u0011\ti.!7\u0003#9+Go^8sWB\u000b'/Y7fi\u0016\u00148/A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002dB1\u0011Q]Av\u0003_l!!a:\u000b\u0007\u0005%x)\u0001\u0006d_:\u001cWO\u001d:f]RLA!!<\u0002h\n1a)\u001e;ve\u0016\u00042\u0001VAy\u0013\r\t\u00190\u0016\u0002\u0019'R\f'\u000f^3e\u0005&$8m\\5o'\u0006\u0003\boQ8oM&<\u0017\u0001B:u_B$\"!!?\u0011\r\u0005\u0015\u00181^A~\u001d\r!\u0016Q`\u0005\u0004\u0003\u007f,\u0016\u0001G*u_B\u0004X\r\u001a\"ji\u000e|\u0017N\\*BaB\u001cuN\u001c4jOV\u0011\u00111A\u0001\beB\u001c\u0007k\u001c:u+\t\u00119\u0001E\u0002G\u0005\u0013I1Aa\u0003H\u0005\rIe\u000e^\u0001\u0007oN\u0004vN\u001d;\u0002'Q,'/\\5oCRLwN\u001c#fC\u0012d\u0017N\\3\u0016\u0005\tM\u0001\u0003\u0002B\u000b\u00057i!Aa\u0006\u000b\t\te\u0011q]\u0001\tIV\u0014\u0018\r^5p]&!!Q\u0004B\f\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f!B\u001d9d\u0005&tGm\u00149u+\t\u0011\u0019\u0003E\u0003G\u0005K\u0011I#C\u0002\u0003(\u001d\u0013aa\u00149uS>t\u0007\u0003\u0002B\u0016\u0005gqAA!\f\u00030A\u0011\u0001pR\u0005\u0004\u0005c9\u0015A\u0002)sK\u0012,g-\u0003\u0003\u00036\t]\"AB*ue&twMC\u0002\u00032\u001d\u000b\u0011b^:CS:$w\n\u001d;\u0002\u0017I\u00048\rU1tg^|'\u000fZ\u000b\u0003\u0005S\ta!\u001a=jgR\u001cHC\u0001B\"!\r1%QI\u0005\u0004\u0005\u000f:%a\u0002\"p_2,\u0017M\\\u0001\u000eo&$\bn\u0014<feJLG-Z:\u0015\t\u0005E\"Q\n\u0005\u0007\u0005\u001fZ\u0002\u0019A;\u0002\u000f\r|gNZ5hg\u0006!1m\u001c9z)\u0019\u0011)F!\u0017\u0003\\Q!\u0011\u0011\u0007B,\u0011\u001d\tI\u0002\ba\u0002\u00037AqA\u001a\u000f\u0011\u0002\u0003\u0007\u0001\u000eC\u0004t9A\u0005\t\u0019A;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\r\u0016\u0004Q\n\r4F\u0001B3!\u0011\u00119G!\u001d\u000e\u0005\t%$\u0002\u0002B6\u0005[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=t)\u0001\u0006b]:|G/\u0019;j_:LAAa\u001d\u0003j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0010\u0016\u0004k\n\r\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0000A!!\u0011\u0011BD\u001b\t\u0011\u0019IC\u0002\u0003\u0006:\fA\u0001\\1oO&!!Q\u0007BB\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa$\u0003\u0016B\u0019aI!%\n\u0007\tMuIA\u0002B]fD\u0011Ba&\"\u0003\u0003\u0005\rAa\u0002\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\n\u0005\u0004\u0003 \n\u0015&qR\u0007\u0003\u0005CS1Aa)H\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005O\u0013\tK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\"\u0005[C\u0011Ba&$\u0003\u0003\u0005\rAa$\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u0002\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa \u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019Ea/\t\u0013\t]e%!AA\u0002\t=\u0015!\u0005\"ji\u000e|\u0017N\\*BaB\u001cuN\u001c4jOB\u0019\u00111\u0007\u0015\u0014\t!*\u0005l\u0019\u000b\u0003\u0005\u007f\u000b!B\u001a:p[\u000e{gNZ5h)\u0011\u0011IM!4\u0015\t\u0005E\"1\u001a\u0005\b\u00033Q\u00039AA\u000e\u0011\u001d\tIA\u000ba\u0001\u0003\u0007\t1C\u001a:p[\u000ec\u0017m]:QCRD7i\u001c8gS\u001e$\"Aa5\u0015\t\u0005E\"Q\u001b\u0005\b\u00033Y\u00039AA\u000e\u0003-1'o\\7ECR\fG-\u001b:\u0015\r\tm'q\u001cBr)\u0011\t\tD!8\t\u000f\u0005eA\u0006q\u0001\u0002\u001c!1!\u0011\u001d\u0017A\u0002!\fq\u0001Z1uC\u0012L'\u000fC\u0004\u0003f2\u0002\rAa:\u0002\u000b\r|gNZ:\u0011\u000b\u0019\u0013I/a\u0001\n\u0007\t-xI\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n\u0011D\u001a:p[\u0012\u000bG/\u00193je^KG\u000f[*feZ,'/\u0011:hgR1!\u0011\u001fB{\u0005o$B!!\r\u0003t\"9\u0011\u0011D\u0017A\u0004\u0005m\u0001B\u0002Bq[\u0001\u0007\u0001\u000eC\u0004\u0003z6\u0002\rAa?\u0002!M,'O^3s\u0003J<7\u000fU1sg\u0016\u0014\b\u0003\u0002B\u007f\u0007\u000bi!Aa@\u000b\u00079\u001b\tAC\u0002\u0004\u0004}\nqaY8n[>t7/\u0003\u0003\u0004\b\t}(aD*feZ,'/\u0011:h!\u0006\u00148/\u001a:\u0002%\u0019\u0014x.\u001c#fM\u0006,H\u000e\u001e#bi\u0006$\u0017N\u001d\u000b\u0005\u0007\u001b\u0019\t\u0002\u0006\u0003\u00022\r=\u0001bBA\r]\u0001\u000f\u00111\u0004\u0005\b\u0005Kt\u0003\u0019\u0001Bt\u0003\u00012'o\\7EK\u001a\fW\u000f\u001c;ECR\fG-\u001b:XSRD')\u001e8eY\u0016\u001cuN\u001c4\u0015\t\r]11\u0004\u000b\u0005\u0003c\u0019I\u0002C\u0004\u0002\u001a=\u0002\u001d!a\u0007\t\u0011\t\u0015x\u0006%AA\u0002U\f!F\u001a:p[\u0012+g-Y;mi\u0012\u000bG/\u00193je^KG\u000f\u001b\"v]\u0012dWmQ8oM\u0012\"WMZ1vYR$\u0013'A\rge>lG)\u0019;bI&\u0014x+\u001b;i\u0005VtG\r\\3D_:4GCBB\u0012\u0007O\u0019I\u0003\u0006\u0003\u00022\r\u0015\u0002bBA\rc\u0001\u000f\u00111\u0004\u0005\u0007\u0005C\f\u0004\u0019\u00015\t\u0011\t\u0015\u0018\u0007%AA\u0002U\f1E\u001a:p[\u0012\u000bG/\u00193je^KG\u000f\u001b\"v]\u0012dWmQ8oM\u0012\"WMZ1vYR$#'A\u0014ge>lG)\u0019;bI&\u0014x+\u001b;i\u0005VtG\r\\3D_:4w+\u001b;i'\u0016\u0014h/\u001a:Be\u001e\u001cHCBB\u0019\u0007k\u00199\u0004\u0006\u0003\u00022\rM\u0002bBA\rg\u0001\u000f\u00111\u0004\u0005\u0007\u0005C\u001c\u0004\u0019\u00015\t\u000f\re2\u00071\u0001\u0003|\u0006y1/\u001a:wKJ\f%o\u001a)beN,'/\u0001\u0011ge>lG)\u001a4bk2$H)\u0019;bI&\u0014x+\u001b;i'\u0016\u0014h/\u001a:Be\u001e\u001cH\u0003BB \u0007\u0007\"B!!\r\u0004B!9\u0011\u0011\u0004\u001bA\u0004\u0005m\u0001bBB\u001di\u0001\u0007!1`\u0001\ri><\u0016\r\u001c7fi\u000e{gN\u001a\u000b\u0005\u0003\u007f\u0019I\u0005C\u0004\u0004LU\u0002\r!!\r\u0002\t\r|gNZ\u0001\fi>\u001c\u0005.Y5o\u0007>tg\r\u0006\u0003\u0002d\rE\u0003bBB&m\u0001\u0007\u0011\u0011G\u0001\u000bi>tu\u000eZ3D_:4G\u0003BA)\u0007/Bqaa\u00138\u0001\u0004\t\t$A\tu_\nKGoY8j]\u0012\u0014\u0006oY\"p]\u001a$B!a/\u0004^!911\n\u001dA\u0002\u0005E\u0012!B1qa2LHCBB2\u0007O\u001aI\u0007\u0006\u0003\u00022\r\u0015\u0004bBA\rs\u0001\u000f\u00111\u0004\u0005\u0006Mf\u0002\r\u0001\u001b\u0005\u0006gf\u0002\r!^\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019yga\u001e\u0011\u000b\u0019\u0013)c!\u001d\u0011\u000b\u0019\u001b\u0019\b[;\n\u0007\rUtI\u0001\u0004UkBdWM\r\u0005\n\u0007sR\u0014\u0011!a\u0001\u0003c\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r}\u0004\u0003\u0002BA\u0007\u0003KAaa!\u0003\u0004\n1qJ\u00196fGR\u0004")
public class BitcoinSAppConfig
implements StartStopAsync<AppConfigMarker>,
Logging,
Product,
scala.Serializable {
    private WalletAppConfig walletConf;
    private NodeAppConfig nodeConf;
    private ChainAppConfig chainConf;
    private DLCAppConfig dlcConf;
    private TorAppConfig torConf;
    private DLCNodeAppConfig dlcNodeConf;
    private KeyManagerAppConfig kmConf;
    private BitcoindRpcAppConfig bitcoindRpcConf;
    private NetworkParameters network;
    private Config config;
    private final Path baseDatadir;
    private final Vector<Config> configOverrides;
    private final ActorSystem system;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Path, Vector<Config>>> unapply(BitcoinSAppConfig bitcoinSAppConfig) {
        return BitcoinSAppConfig$.MODULE$.unapply(bitcoinSAppConfig);
    }

    public static BitcoinSAppConfig apply(Path path, Vector<Config> vector, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.apply(path, vector, actorSystem);
    }

    public static BitcoindRpcAppConfig toBitcoindRpcConf(BitcoinSAppConfig bitcoinSAppConfig) {
        return BitcoinSAppConfig$.MODULE$.toBitcoindRpcConf(bitcoinSAppConfig);
    }

    public static NodeAppConfig toNodeConf(BitcoinSAppConfig bitcoinSAppConfig) {
        return BitcoinSAppConfig$.MODULE$.toNodeConf(bitcoinSAppConfig);
    }

    public static ChainAppConfig toChainConf(BitcoinSAppConfig bitcoinSAppConfig) {
        return BitcoinSAppConfig$.MODULE$.toChainConf(bitcoinSAppConfig);
    }

    public static WalletAppConfig toWalletConf(BitcoinSAppConfig bitcoinSAppConfig) {
        return BitcoinSAppConfig$.MODULE$.toWalletConf(bitcoinSAppConfig);
    }

    public static BitcoinSAppConfig fromDefaultDatadirWithServerArgs(ServerArgParser serverArgParser, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromDefaultDatadirWithServerArgs(serverArgParser, actorSystem);
    }

    public static BitcoinSAppConfig fromDatadirWithBundleConfWithServerArgs(Path path, ServerArgParser serverArgParser, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromDatadirWithBundleConfWithServerArgs(path, serverArgParser, actorSystem);
    }

    public static Vector<Config> fromDatadirWithBundleConf$default$2() {
        return BitcoinSAppConfig$.MODULE$.fromDatadirWithBundleConf$default$2();
    }

    public static BitcoinSAppConfig fromDatadirWithBundleConf(Path path, Vector<Config> vector, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromDatadirWithBundleConf(path, vector, actorSystem);
    }

    public static Vector<Config> fromDefaultDatadirWithBundleConf$default$1() {
        return BitcoinSAppConfig$.MODULE$.fromDefaultDatadirWithBundleConf$default$1();
    }

    public static BitcoinSAppConfig fromDefaultDatadirWithBundleConf(Vector<Config> vector, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromDefaultDatadirWithBundleConf(vector, actorSystem);
    }

    public static BitcoinSAppConfig fromDefaultDatadir(Seq<Config> seq, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromDefaultDatadir(seq, actorSystem);
    }

    public static BitcoinSAppConfig fromDatadirWithServerArgs(Path path, ServerArgParser serverArgParser, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromDatadirWithServerArgs(path, serverArgParser, actorSystem);
    }

    public static BitcoinSAppConfig fromDatadir(Path path, Seq<Config> seq, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromDatadir(path, seq, actorSystem);
    }

    public static BitcoinSAppConfig fromClassPathConfig(ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromClassPathConfig(actorSystem);
    }

    public static BitcoinSAppConfig fromConfig(Config config, ActorSystem actorSystem) {
        return BitcoinSAppConfig$.MODULE$.fromConfig(config, actorSystem);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Path baseDatadir() {
        return this.baseDatadir;
    }

    public Vector<Config> configOverrides() {
        return this.configOverrides;
    }

    private WalletAppConfig walletConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 1) == 0) {
                this.walletConf = new WalletAppConfig(this.baseDatadir(), this.configOverrides(), WalletAppConfig$.MODULE$.apply$default$3(), this.system);
                this.bitmap$0 |= 1;
            }
        }
        return this.walletConf;
    }

    public WalletAppConfig walletConf() {
        return (this.bitmap$0 & 1) == 0 ? this.walletConf$lzycompute() : this.walletConf;
    }

    private NodeAppConfig nodeConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 2) == 0) {
                this.nodeConf = new NodeAppConfig(this.baseDatadir(), this.configOverrides(), this.system);
                this.bitmap$0 |= 2;
            }
        }
        return this.nodeConf;
    }

    public NodeAppConfig nodeConf() {
        return (this.bitmap$0 & 2) == 0 ? this.nodeConf$lzycompute() : this.nodeConf;
    }

    private ChainAppConfig chainConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 4) == 0) {
                this.chainConf = new ChainAppConfig(this.baseDatadir(), this.configOverrides(), (ExecutionContext)this.system.dispatcher());
                this.bitmap$0 |= 4;
            }
        }
        return this.chainConf;
    }

    public ChainAppConfig chainConf() {
        return (this.bitmap$0 & 4) == 0 ? this.chainConf$lzycompute() : this.chainConf;
    }

    private DLCAppConfig dlcConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 8) == 0) {
                this.dlcConf = new DLCAppConfig(this.baseDatadir(), this.configOverrides(), DLCAppConfig$.MODULE$.apply$default$3(), this.system);
                this.bitmap$0 |= 8;
            }
        }
        return this.dlcConf;
    }

    public DLCAppConfig dlcConf() {
        return (this.bitmap$0 & 8) == 0 ? this.dlcConf$lzycompute() : this.dlcConf;
    }

    private TorAppConfig torConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.torConf = new TorAppConfig(this.baseDatadir(), (Option)None$.MODULE$, this.configOverrides(), (ExecutionContext)this.system.dispatcher());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.torConf;
    }

    public TorAppConfig torConf() {
        return (this.bitmap$0 & 0x10) == 0 ? this.torConf$lzycompute() : this.torConf;
    }

    private DLCNodeAppConfig dlcNodeConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.dlcNodeConf = new DLCNodeAppConfig(this.baseDatadir(), this.configOverrides(), (ExecutionContext)this.system.dispatcher());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.dlcNodeConf;
    }

    public DLCNodeAppConfig dlcNodeConf() {
        return (this.bitmap$0 & 0x20) == 0 ? this.dlcNodeConf$lzycompute() : this.dlcNodeConf;
    }

    private KeyManagerAppConfig kmConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.kmConf = new KeyManagerAppConfig(this.baseDatadir(), this.configOverrides(), KeyManagerAppConfig$.MODULE$.apply$default$3(), KeyManagerAppConfig$.MODULE$.apply$default$4(), KeyManagerAppConfig$.MODULE$.apply$default$5(), (ExecutionContext)this.system.dispatcher());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.kmConf;
    }

    public KeyManagerAppConfig kmConf() {
        return (this.bitmap$0 & 0x40) == 0 ? this.kmConf$lzycompute() : this.kmConf;
    }

    private BitcoindRpcAppConfig bitcoindRpcConf$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.bitcoindRpcConf = new BitcoindRpcAppConfig(this.baseDatadir(), this.configOverrides(), this.system);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.bitcoindRpcConf;
    }

    public BitcoindRpcAppConfig bitcoindRpcConf() {
        return (this.bitmap$0 & 0x80) == 0 ? this.bitcoindRpcConf$lzycompute() : this.bitcoindRpcConf;
    }

    public BitcoinSAppConfig copyWithConfig(Vector<Config> newConfs) {
        Vector configs = (Vector)newConfs.$plus$plus(this.configOverrides(), Vector$.MODULE$.canBuildFrom());
        return new BitcoinSAppConfig(this.baseDatadir(), (Vector<Config>)configs, this.system);
    }

    private NetworkParameters network$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.network = this.chainConf().network();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.network;
    }

    public NetworkParameters network() {
        return (this.bitmap$0 & 0x100) == 0 ? this.network$lzycompute() : this.network;
    }

    public Future<StartedBitcoinSAppConfig> start() {
        long start = TimeUtil$.MODULE$.currentEpochMs();
        Vector nonTorConfigs = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AppConfig[]{this.kmConf(), this.chainConf(), this.walletConf()}));
        Future torConfig = this.torConf().start();
        Vector torDependentConfigs = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AppConfig[]{this.nodeConf(), this.bitcoindRpcConf(), this.dlcConf(), this.dlcNodeConf()}));
        Vector dbConfigs = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DbAppConfig[]{this.chainConf(), this.walletConf(), this.nodeConf(), this.dlcConf()}));
        Vector _3 = (Vector)dbConfigs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.migrate(), Vector$.MODULE$.canBuildFrom());
        Future startedTorDependentConfigsF = torConfig.flatMap((Function1 & Serializable & scala.Serializable)_2 -> Future$.MODULE$.sequence((TraversableOnce)torDependentConfigs.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.start(), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom(), (ExecutionContext)$this.system.dispatcher()).map((Function1 & Serializable & scala.Serializable)_ -> {
            BitcoinSAppConfig.$anonfun$start$4(_);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
        Future startedNonTorConfigs = Future$.MODULE$.sequence((TraversableOnce)nonTorConfigs.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.start(), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom(), (ExecutionContext)this.system.dispatcher());
        return startedNonTorConfigs.map((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Done starting BitcoinSAppConfig, it took=").append(TimeUtil$.MODULE$.currentEpochMs() - start).append("ms").toString());
            return new StartedBitcoinSAppConfig(startedTorDependentConfigsF.map((Function1 & Serializable & scala.Serializable)x$4 -> {
                BitcoinSAppConfig.$anonfun$start$8(x$4);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)$this.system.dispatcher()));
        }, (ExecutionContext)this.system.dispatcher());
    }

    public Future<StoppedBitcoinSAppConfig$> stop() {
        return this.nodeConf().stop().flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.dlcNodeConf().stop().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.dlcConf().stop().flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.walletConf().stop().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.kmConf().stop().flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.chainConf().stop().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.bitcoindRpcConf().stop().flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.torConf().stop().map((Function1 & Serializable & scala.Serializable)_ -> StoppedBitcoinSAppConfig$.MODULE$, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    /*
     * WARNING - void declaration
     */
    private Config config$lzycompute() {
        BitcoinSAppConfig bitcoinSAppConfig = this;
        synchronized (bitcoinSAppConfig) {
            if ((this.bitmap$0 & 0x200) == 0) {
                void var3_3;
                Config finalConfig = AppConfig$.MODULE$.getBaseConfig(this.baseDatadir(), this.configOverrides());
                Config resolved = finalConfig.resolve();
                resolved.checkValid(ConfigFactory.defaultReference(), new String[]{"bitcoin-s"});
                this.config = var3_3;
                this.bitmap$0 |= 0x200;
            }
        }
        return this.config;
    }

    public Config config() {
        return (this.bitmap$0 & 0x200) == 0 ? this.config$lzycompute() : this.config;
    }

    public int rpcPort() {
        return this.config().getInt("bitcoin-s.server.rpcport");
    }

    public int wsPort() {
        return package.ConfigOps$.MODULE$.getIntOrElse$extension(org.bitcoins.commons.config.package$.MODULE$.ConfigOps(this.config()), "bitcoin-s.server.wsport", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 19999);
    }

    public FiniteDuration terminationDeadline() {
        FiniteDuration finiteDuration;
        Option opt = package.ConfigOps$.MODULE$.getDurationOpt$extension(org.bitcoins.commons.config.package$.MODULE$.ConfigOps(this.config()), "bitcoin-s.server.termination-deadline");
        Option option = opt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Duration duration = (Duration)some.value();
            if (!duration.isFinite()) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(62).append("Can only have a finite duration for termination deadline, got=").append(duration).toString());
            }
            finiteDuration = new FiniteDuration(duration.toNanos(), TimeUnit.NANOSECONDS);
        } else if (None$.MODULE$.equals(option)) {
            finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds();
        } else {
            throw new MatchError((Object)option);
        }
        return finiteDuration;
    }

    public Option<String> rpcBindOpt() {
        return this.config().hasPath("bitcoin-s.server.rpcbind") ? new Some((Object)this.config().getString("bitcoin-s.server.rpcbind")) : None$.MODULE$;
    }

    public Option<String> wsBindOpt() {
        return this.config().hasPath("bitcoin-s.server.wsbind") ? new Some((Object)this.config().getString("bitcoin-s.server.wsbind")) : None$.MODULE$;
    }

    public String rpcPassword() {
        return this.config().getString("bitcoin-s.server.password");
    }

    public boolean exists() {
        return this.baseDatadir().resolve("bitcoin-s.conf").toFile().isFile();
    }

    public BitcoinSAppConfig withOverrides(Vector<Config> configs) {
        return new BitcoinSAppConfig(this.baseDatadir(), (Vector<Config>)((Vector)configs.$plus$plus(this.configOverrides(), Vector$.MODULE$.canBuildFrom())), this.system);
    }

    public BitcoinSAppConfig copy(Path baseDatadir, Vector<Config> configOverrides, ActorSystem system) {
        return new BitcoinSAppConfig(baseDatadir, configOverrides, system);
    }

    public Path copy$default$1() {
        return this.baseDatadir();
    }

    public Vector<Config> copy$default$2() {
        return this.configOverrides();
    }

    public String productPrefix() {
        return "BitcoinSAppConfig";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Vector<Config> vector;
        int n = x$1;
        switch (n) {
            case 0: {
                vector = this.baseDatadir();
                break;
            }
            case 1: {
                vector = this.configOverrides();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return vector;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitcoinSAppConfig;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitcoinSAppConfig)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitcoinSAppConfig bitcoinSAppConfig = (BitcoinSAppConfig)x$1;
        Path path = this.baseDatadir();
        Path path2 = bitcoinSAppConfig.baseDatadir();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Vector<Config> vector = this.configOverrides();
        Vector<Config> vector2 = bitcoinSAppConfig.configOverrides();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        if (!bitcoinSAppConfig.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$start$4(Vector _) {
    }

    public static final /* synthetic */ void $anonfun$start$8(BoxedUnit x$4) {
    }

    public BitcoinSAppConfig(Path baseDatadir, Vector<Config> configOverrides, ActorSystem system) {
        this.baseDatadir = baseDatadir;
        this.configOverrides = configOverrides;
        this.system = system;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
    }
}

