/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.server;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.ClassicActorSystemProvider;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.BroadcastHub$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.SourceQueueWithComplete;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.SQLException;
import java.time.Instant;
import org.bitcoins.asyncutil.AsyncUtil;
import org.bitcoins.asyncutil.AsyncUtil$;
import org.bitcoins.chain.ChainCallbacks;
import org.bitcoins.chain.blockchain.ChainHandler;
import org.bitcoins.chain.blockchain.ChainHandler$;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.commons.config.AppConfig;
import org.bitcoins.commons.jsonmodels.bitcoind.GetBlockChainInfoResult;
import org.bitcoins.commons.jsonmodels.ws.WsNotification;
import org.bitcoins.commons.util.DatadirParser;
import org.bitcoins.commons.util.ServerArgParser;
import org.bitcoins.core.api.callback.ModuleCallbacks;
import org.bitcoins.core.api.chain.ChainApi;
import org.bitcoins.core.api.chain.ChainQueryApi;
import org.bitcoins.core.api.dlc.node.DLCNodeApi;
import org.bitcoins.core.api.dlc.wallet.DLCWalletApi;
import org.bitcoins.core.api.feeprovider.FeeRateApi;
import org.bitcoins.core.api.node.InternalImplementationNodeType;
import org.bitcoins.core.api.node.NodeApi;
import org.bitcoins.core.api.node.NodeType;
import org.bitcoins.core.api.wallet.NeutrinoHDWalletApi;
import org.bitcoins.core.api.wallet.SyncHeightDescriptor;
import org.bitcoins.core.api.wallet.WalletApi;
import org.bitcoins.core.config.BitcoinNetwork;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.util.TimeUtil$;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.dlc.node.DLCNode;
import org.bitcoins.dlc.node.config.DLCNodeAppConfig;
import org.bitcoins.dlc.wallet.DLCAppConfig;
import org.bitcoins.dlc.wallet.DLCWalletCallbacks;
import org.bitcoins.feeprovider.FeeProviderFactory$;
import org.bitcoins.feeprovider.MempoolSpaceProvider;
import org.bitcoins.feeprovider.MempoolSpaceTarget;
import org.bitcoins.node.NodeCallbacks;
import org.bitcoins.node.config.NodeAppConfig;
import org.bitcoins.node.models.NodeStateDescriptorDAO;
import org.bitcoins.rpc.BitcoindException;
import org.bitcoins.rpc.client.common.BitcoindRpcClient;
import org.bitcoins.rpc.config.BitcoindRpcAppConfig;
import org.bitcoins.rpc.config.ZmqConfig;
import org.bitcoins.rpc.config.ZmqConfig$;
import org.bitcoins.server.BitcoinSAppConfig;
import org.bitcoins.server.BitcoinSServerMain$;
import org.bitcoins.server.BitcoindRpcBackendUtil$;
import org.bitcoins.server.ChainRoutes;
import org.bitcoins.server.CoreRoutes;
import org.bitcoins.server.DLCRoutes;
import org.bitcoins.server.DLCWalletBitcoindBackendLoader;
import org.bitcoins.server.DLCWalletLoaderApi;
import org.bitcoins.server.DLCWalletNeutrinoBackendLoader;
import org.bitcoins.server.NodeRoutes;
import org.bitcoins.server.WalletRoutes;
import org.bitcoins.server.bitcoind.BitcoindSyncState;
import org.bitcoins.server.routes.BitcoinSRunner;
import org.bitcoins.server.routes.BitcoinSServerRunner;
import org.bitcoins.server.routes.CommonRoutes;
import org.bitcoins.server.routes.Server;
import org.bitcoins.server.util.BitcoindPollingCancellabe;
import org.bitcoins.server.util.BitcoindPollingCancellabe$;
import org.bitcoins.server.util.ServerBindings;
import org.bitcoins.server.util.StartedBitcoinSAppConfig;
import org.bitcoins.server.util.WebsocketUtil$;
import org.bitcoins.server.util.WsServerConfig;
import org.bitcoins.tor.TorCallbacks;
import org.bitcoins.tor.config.TorAppConfig;
import org.bitcoins.wallet.WalletCallbacks;
import org.bitcoins.wallet.WalletHolder;
import org.bitcoins.wallet.WalletHolder$;
import org.bitcoins.wallet.config.WalletAppConfig;
import org.bitcoins.wallet.config.WalletAppConfig$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001\u0002\u00180\u0001YB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tE\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0017\"AA\u000b\u0001BC\u0002\u0013\rS\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003W\u0011!y\u0006A!b\u0001\n\u0007\u0001\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u000b\u0019\u0004A\u0011A4\t\u00115\u0004\u0001R1A\u0005\u00049D\u0001b\u001e\u0001\t\u0006\u0004%\u0019\u0001\u001f\u0005\u000b\u0003\u0003\u0001\u0001R1A\u0005\u0004\u0005\r\u0001BCA\u000b\u0001!\u0015\r\u0011b\u0001\u0002\u0018!Q\u0011q\u0005\u0001\t\u0006\u0004%\u0019!!\u000b\t\u0015\u0005e\u0002\u0001#b\u0001\n\u0003\tY\u0004C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u0011\u0011\u0012\u0001\u0005B\u00055\u0003bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fD\u0001B!\t\u0001A\u0003&!1\u0005\u0005\t\u0005_\u0001\u0001\u0015)\u0003\u00032!9!Q\b\u0001\u0005\u0002\t}\u0002\"\u0003B\"\u0001\u0001\u0007I\u0011\u0002B#\u0011%\u0011\u0019\u0006\u0001a\u0001\n\u0013\u0011)\u0006\u0003\u0005\u0003\\\u0001\u0001\u000b\u0015\u0002B$\u0011\u001d\u0011i\u0006\u0001C\u0005\u0005?BqA!.\u0001\t\u0013\u00119\fC\u0004\u0003X\u0002!IA!7\t\u000f\t\u0015\b\u0001\"\u0003\u0003h\"Q1q\u0001\u0001\t\u0006\u0004%Ia!\u0003\t\u000f\r]\u0001\u0001\"\u0003\u0004\u001a\u001d91QG\u0018\t\u0002\r]bA\u0002\u00180\u0011\u0003\u0019I\u0004\u0003\u0004gC\u0011\u00051\u0011\t\u0005\n\u0007\u0007\n#\u0019!C!\u0007\u000bB\u0001ba\u0012\"A\u0003%1q\u0004\u0005\n\u0007\u0013\n#\u0019!C!\u0007\u0017B\u0001b!\u0014\"A\u0003%1Q\u0004\u0005\t\u0005/\u000b#\u0019!C\u0001\u0015\"91qJ\u0011!\u0002\u0013Y\u0005\"CB)C\t\u0007I\u0011AB*\u0011!\u0019Y&\tQ\u0001\n\rU\u0003\u0002C0\"\u0011\u000b\u0007I1\u00011\t\u0013\ru\u0013E1A\u0005\u0002\r}\u0003bBB1C\u0001\u0006I!\u001b\u0002\u0013\u0005&$8m\\5o'N+'O^3s\u001b\u0006LgN\u0003\u00021c\u000511/\u001a:wKJT!AM\u001a\u0002\u0011\tLGoY8j]NT\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0004\u0001]j\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g\rE\u0002?\u0003\u000ek\u0011a\u0010\u0006\u0003\u0001>\naA]8vi\u0016\u001c\u0018B\u0001\"@\u0005Q\u0011\u0015\u000e^2pS:\u001c6+\u001a:wKJ\u0014VO\u001c8feB\u0011AiR\u0007\u0002\u000b*\u0011a)M\u0001\u0007o\u0006dG.\u001a;\n\u0005!+%\u0001D,bY2,G\u000fS8mI\u0016\u0014\u0018aD:feZ,'/\u0011:h!\u0006\u00148/\u001a:\u0016\u0003-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\tU$\u0018\u000e\u001c\u0006\u0003!F\nqaY8n[>t7/\u0003\u0002S\u001b\ny1+\u001a:wKJ\f%o\u001a)beN,'/\u0001\ttKJ4XM]!sOB\u000b'o]3sA\u000511/_:uK6,\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bQ!Y2u_JT\u0011aW\u0001\u0005C.\\\u0017-\u0003\u0002^1\nY\u0011i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\nAaY8oMV\t\u0011\r\u0005\u0002cG6\tq&\u0003\u0002e_\t\t\")\u001b;d_&t7+\u00119q\u0007>tg-[4\u0002\u000b\r|gN\u001a\u0011\u0002\rqJg.\u001b;?)\tAG\u000eF\u0002jU.\u0004\"A\u0019\u0001\t\u000bQ;\u00019\u0001,\t\u000b};\u00019A1\t\u000b%;\u0001\u0019A&\u0002\u00119|G-Z\"p]\u001a,\u0012a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\faaY8oM&<'B\u0001;2\u0003\u0011qw\u000eZ3\n\u0005Y\f(!\u0004(pI\u0016\f\u0005\u000f]\"p]\u001aLw-A\u0005dQ\u0006LgnQ8oMV\t\u0011\u0010\u0005\u0002{}6\t1P\u0003\u0002sy*\u0011Q0M\u0001\u0006G\"\f\u0017N\\\u0005\u0003\u007fn\u0014ab\u00115bS:\f\u0005\u000f]\"p]\u001aLw-A\u0006eY\u000etu\u000eZ3D_:4WCAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!b\u0001:\u0002\f)\u0019A/!\u0004\u000b\u0007\u0005=\u0011'A\u0002eY\u000eLA!a\u0005\u0002\n\t\u0001B\tT\"O_\u0012,\u0017\t\u001d9D_:4\u0017nZ\u0001\u0010E&$8m\\5oIJ\u00038mQ8oMV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\u0019#\u0004\u0002\u0002\u001e)\u0019!/a\b\u000b\u0007\u0005\u0005\u0012'A\u0002sa\u000eLA!!\n\u0002\u001e\t!\")\u001b;d_&tGM\u00159d\u0003B\u00048i\u001c8gS\u001e\fq\u0001^8s\u0007>tg-\u0006\u0002\u0002,A!\u0011QFA\u001b\u001b\t\tyCC\u0002s\u0003cQ1!a\r2\u0003\r!xN]\u0005\u0005\u0003o\tyC\u0001\u0007U_J\f\u0005\u000f]\"p]\u001aLw-A\u0004oKR<xN]6\u0016\u0005\u0005u\u0002\u0003BA \u0003\u000fj!!!\u0011\u000b\u0007I\f\u0019EC\u0002\u0002FE\nAaY8sK&!\u0011\u0011JA!\u00059\u0011\u0015\u000e^2pS:tU\r^<pe.\fQa\u001d;beR$\"!a\u0014\u0011\u000b\u0005E\u0013qK\"\u000e\u0005\u0005M#bAA+s\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00131\u000b\u0002\u0007\rV$XO]3\u0002)%t\u0017\u000e^5bY&TXm\u00115bS:\u001cF/\u0019;f)\u0019\ty&a\u001a\u0002xA1\u0011\u0011KA,\u0003C\u00022\u0001OA2\u0013\r\t)'\u000f\u0002\u0005+:LG\u000fC\u0004\u0002j=\u0001\r!a\u001b\u0002\u0019\rD\u0017-\u001b8IC:$G.\u001a:\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d}\u0003)\u0011Gn\\2lG\"\f\u0017N\\\u0005\u0005\u0003k\nyG\u0001\u0007DQ\u0006Lg\u000eS1oI2,'\u000fC\u0004\u0002z=\u0001\r!a\u001f\u0002\u00119|G-\u001a+za\u0016\u0004B!! \u0002\u00066\u0011\u0011q\u0010\u0006\u0004i\u0006\u0005%\u0002BAB\u0003\u0007\n1!\u00199j\u0013\u0011\t9)a \u0003\u00119{G-\u001a+za\u0016\fAa\u001d;pa\u0006!2\u000f^1si\nKGoY8j]N\u0013\u0015mY6f]\u0012$B!a\u0014\u0002\u0010\"9\u0011\u0011S\tA\u0002\u0005}\u0013!E:uCJ$X\r\u001a+pe\u000e{gNZ5h\r\u00061\"-^5mI:+W\u000f\u001e:j]>\u001c\u0015\r\u001c7cC\u000e\\7\u000f\u0006\u0006\u0002b\u0005]\u00151[Aq\u0003_Dq!!'\u0013\u0001\u0004\tY*A\u0004xgF+X-^3\u0011\r\u0005u\u0015qUAV\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016\u0001C:dC2\fGm\u001d7\u000b\u0007\u0005\u0015&,\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003S\u000byJA\fT_V\u00148-Z)vKV,w+\u001b;i\u0007>l\u0007\u000f\\3uKB\"\u0011QVAa!\u0019\ty+!/\u0002>6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0002xg*\u0019\u0011qW(\u0002\u0015)\u001cxN\\7pI\u0016d7/\u0003\u0003\u0002<\u0006E&AD,t\u001d>$\u0018NZ5dCRLwN\u001c\t\u0005\u0003\u007f\u000b\t\r\u0004\u0001\u0005\u0019\u0005\r\u0017qSA\u0001\u0002\u0003\u0015\t!!2\u0003\u0007}#3'\u0005\u0003\u0002H\u00065\u0007c\u0001\u001d\u0002J&\u0019\u00111Z\u001d\u0003\u000f9{G\u000f[5oOB\u0019\u0001(a4\n\u0007\u0005E\u0017HA\u0002B]fDq!!6\u0013\u0001\u0004\t9.\u0001\u0005dQ\u0006Lg.\u00119j!\u0011\tI.!8\u000e\u0005\u0005m'bA?\u0002\u0002&!\u0011q\\An\u0005!\u0019\u0005.Y5o\u0003BL\u0007bBAr%\u0001\u0007\u0011Q]\u0001\u000bo\u0006dG.\u001a;D_:4\u0007\u0003BAt\u0003Wl!!!;\u000b\u0005I,\u0015\u0002BAw\u0003S\u0014qbV1mY\u0016$\u0018\t\u001d9D_:4\u0017n\u001a\u0005\b\u0003c\u0014\u0002\u0019AAz\u0003\u001d!GnY\"p]\u001a\u0004B!!>\u0002z6\u0011\u0011q\u001f\u0006\u0004\r\u00065\u0011\u0002BA~\u0003o\u0014A\u0002\u0012'D\u0003B\u00048i\u001c8gS\u001e\f\u0011cZ3u\u00052|7m[\"iC&t\u0017J\u001c4p)\u0011\u0011\tAa\u0004\u0011\r\u0005E\u0013q\u000bB\u0002!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003k\u000b\u0001BY5uG>Lg\u000eZ\u0005\u0005\u0005\u001b\u00119AA\fHKR\u0014En\\2l\u0007\"\f\u0017N\\%oM>\u0014Vm];mi\"9!\u0011C\nA\u0002\tM\u0011AB2mS\u0016tG\u000f\u0005\u0003\u0003\u0016\tuQB\u0001B\f\u0015\u0011\u0011IBa\u0007\u0002\r\r|W.\\8o\u0015\u0011\u0011\t\"a\b\n\t\t}!q\u0003\u0002\u0012\u0005&$8m\\5oIJ\u00038m\u00117jK:$\u0018AE<bY2,G\u000fT8bI\u0016\u0014\u0018\t]5PaR\u0004R\u0001\u000fB\u0013\u0005SI1Aa\n:\u0005\u0019y\u0005\u000f^5p]B\u0019!Ma\u000b\n\u0007\t5rF\u0001\nE\u0019\u000e;\u0016\r\u001c7fi2{\u0017\rZ3s\u0003BL\u0017\u0001\u00062ji\u000e|\u0017N\u001c3Ts:\u001c7\u000b^1uK>\u0003H\u000fE\u00039\u0005K\u0011\u0019\u0004\u0005\u0003\u00036\teRB\u0001B\u001c\u0015\r\u0011IaL\u0005\u0005\u0005w\u00119DA\tCSR\u001cw.\u001b8e'ft7m\u0015;bi\u0016\fAc\u001d;beR\u0014\u0015\u000e^2pS:$')Y2lK:$G\u0003BA(\u0005\u0003Bq!!%\u0017\u0001\u0004\ty&A\ttKJ4XM\u001d\"j]\u0012LgnZ:PaR,\"Aa\u0012\u0011\u000ba\u0012)C!\u0013\u0011\t\t-#qJ\u0007\u0003\u0005\u001bR!AT\u0018\n\t\tE#Q\n\u0002\u000f'\u0016\u0014h/\u001a:CS:$\u0017N\\4t\u0003U\u0019XM\u001d<fe\nKg\u000eZ5oON|\u0005\u000f^0%KF$B!!\u0019\u0003X!I!\u0011\f\r\u0002\u0002\u0003\u0007!qI\u0001\u0004q\u0012\n\u0014AE:feZ,'OQ5oI&twm](qi\u0002\nqb\u001d;beRDE\u000f\u001e9TKJ4XM\u001d\u000b\u0011\u0005C\u0012yGa\u001f\u0003~\t\r%\u0011\u0013BK\u00053#bAa\u0019\u0003l\t5\u0004CBA)\u0003/\u0012)\u0007E\u0002?\u0005OJ1A!\u001b@\u0005\u0019\u0019VM\u001d<fe\")AK\u0007a\u0002-\")qL\u0007a\u0002C\"9!\u0011\u000f\u000eA\u0002\tM\u0014\u0001\u00038pI\u0016\f\u0005/\u001b$\u0011\r\u0005E\u0013q\u000bB;!\u0011\tiHa\u001e\n\t\te\u0014q\u0010\u0002\b\u001d>$W-\u00119j\u0011\u001d\t)N\u0007a\u0001\u0003/DqAa \u001b\u0001\u0004\u0011\t)A\u0007xC2dW\r\u001e'pC\u0012,'O\u0012\t\u0007\u0003#\n9F!\u000b\t\u000f\t\u0015%\u00041\u0001\u0003\b\u0006AA\r\\2O_\u0012,g\t\u0005\u0004\u0002R\u0005]#\u0011\u0012\t\u0005\u0005\u0017\u0013i)\u0004\u0002\u0002\f%!!qRA\u0006\u0005\u001d!Ej\u0011(pI\u0016DqAa%\u001b\u0001\u0004\ty&\u0001\bu_J\u001cuN\u001c4Ti\u0006\u0014H/\u001a3\t\r\t]%\u00041\u0001L\u0003E\u0019XM\u001d<fe\u000ekG\rT5oK\u0006\u0013xm\u001d\u0005\b\u00057S\u0002\u0019\u0001BO\u0003!98oU8ve\u000e,\u0007\u0003CAO\u0005?\u0013\u0019K!,\n\t\t\u0005\u0016q\u0014\u0002\u0007'>,(oY31\t\t\u0015&\u0011\u0016\t\u0007\u0003_\u000bILa*\u0011\t\u0005}&\u0011\u0016\u0003\r\u0005W\u0013I*!A\u0001\u0002\u000b\u0005\u0011Q\u0019\u0002\u0004?\u00122\u0004\u0003\u0002BX\u0005ck\u0011AW\u0005\u0004\u0005gS&a\u0002(piV\u001bX\rZ\u0001&gft7mV1mY\u0016$x+\u001b;i\u0005&$8m\\5oI\u0006sGm\u0015;beR\u0004v\u000e\u001c7j]\u001e$\u0002B!/\u0003<\nu&\u0011\u001a\t\u0007\u0003#\n9Fa\r\t\u000f\t%1\u00041\u0001\u0003\u0014!1ai\u0007a\u0001\u0005\u007f\u0003BA!1\u0003F6\u0011!1\u0019\u0006\u0004\r\u0006\u0005\u0015\u0002\u0002Bd\u0005\u0007\u00141CT3viJLgn\u001c%E/\u0006dG.\u001a;Ba&DqAa3\u001c\u0001\u0004\u0011i-A\tdQ\u0006LgnQ1mY\n\f7m[:PaR\u0004R\u0001\u000fB\u0013\u0005\u001f\u0004BA!5\u0003T6\tA0C\u0002\u0003Vr\u0014ab\u00115bS:\u001c\u0015\r\u001c7cC\u000e\\7/\u0001\u0011iC:$G.\u001a)pi\u0016tG/[1m\u0005&$8m\\5oI2{7\u000f\u001e\"m_\u000e\\GCBA0\u00057\u0014i\u000eC\u0004\u0003\nq\u0001\rAa\u0005\t\r\u0019c\u0002\u0019\u0001Bp!\u0011\u0011\tM!9\n\t\t\r(1\u0019\u0002\n/\u0006dG.\u001a;Ba&\fQBY;jY\u0012<6oU8ve\u000e,WC\u0001Bu!\u001dA$1\u001eBx\u0005wL1A!<:\u0005\u0019!V\u000f\u001d7feA1\u0011QTAT\u0005c\u0004DAa=\u0003xB1\u0011qVA]\u0005k\u0004B!a0\u0003x\u0012Y!\u0011`\u000f\u0002\u0002\u0003\u0005)\u0011AAc\u0005\ryFe\u000e\t\t\u0003;\u0013yJ!@\u0003.B\"!q`B\u0002!\u0019\ty+!/\u0004\u0002A!\u0011qXB\u0002\t-\u0019)!HA\u0001\u0002\u0003\u0015\t!!2\u0003\u0007}#\u0003(\u0001\u0007o_\u0012,7\u000b^1uK\u0012\u000bu*\u0006\u0002\u0004\fA!1QBB\n\u001b\t\u0019yAC\u0002\u0004\u0012M\fa!\\8eK2\u001c\u0018\u0002BB\u000b\u0007\u001f\u0011aCT8eKN#\u0018\r^3EKN\u001c'/\u001b9u_J$\u0015iT\u0001\u0018O\u0016$H*Y:u\u0019>\fG-\u001a3XC2dW\r\u001e(b[\u0016$\"aa\u0007\u0011\r\u0005E\u0013qKB\u000f!\u0015A$QEB\u0010!\u0011\u0019\tca\f\u000f\t\r\r21\u0006\t\u0004\u0007KITBAB\u0014\u0015\r\u0019I#N\u0001\u0007yI|w\u000e\u001e \n\u0007\r5\u0012(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007c\u0019\u0019D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0007[I\u0014A\u0005\"ji\u000e|\u0017N\\*TKJ4XM]'bS:\u0004\"AY\u0011\u0014\t\u0005:41\b\t\u0005\u0005\u0017\u001ai$\u0003\u0003\u0004@\t5#A\u0006\"ji\u000e|\u0017N\\*BaB\u001c6-\u00197b\t\u0006,Wn\u001c8\u0015\u0005\r]\u0012aD1di>\u00148+_:uK6t\u0015-\\3\u0016\u0005\r}\u0011\u0001E1di>\u00148+_:uK6t\u0015-\\3!\u0003E\u0019Wo\u001d;p[\u001aKg.\u00197ESJ|\u0005\u000f^\u000b\u0003\u0007;\t!cY;ti>lg)\u001b8bY\u0012K'o\u00149uA\u0005\u00112/\u001a:wKJ\u001cU\u000e\u001a'j]\u0016\f%oZ:!\u00035!\u0017\r^1eSJ\u0004\u0016M]:feV\u00111Q\u000b\t\u0004\u0019\u000e]\u0013bAB-\u001b\niA)\u0019;bI&\u0014\b+\u0019:tKJ\fa\u0002Z1uC\u0012L'\u000fU1sg\u0016\u0014\b%A\u0001n+\u0005I\u0017AA7!\u0001")
public class BitcoinSServerMain
implements BitcoinSServerRunner<WalletHolder> {
    private NodeAppConfig nodeConf;
    private ChainAppConfig chainConf;
    private DLCNodeAppConfig dlcNodeConf;
    private BitcoindRpcAppConfig bitcoindRpcConf;
    private TorAppConfig torConf;
    private BitcoinNetwork network;
    private NodeStateDescriptorDAO nodeStateDAO;
    private final ServerArgParser serverArgParser;
    private final ActorSystem system;
    private final BitcoinSAppConfig conf;
    private Option<DLCWalletLoaderApi> walletLoaderApiOpt;
    private Option<BitcoindSyncState> bitcoindSyncStateOpt;
    private Option<ServerBindings> serverBindingsOpt;
    private ExecutionContext ec;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static BitcoinSServerMain m() {
        return BitcoinSServerMain$.MODULE$.m();
    }

    public static DatadirParser datadirParser() {
        return BitcoinSServerMain$.MODULE$.datadirParser();
    }

    public static ServerArgParser serverCmdLineArgs() {
        return BitcoinSServerMain$.MODULE$.serverCmdLineArgs();
    }

    public static Option<String> customFinalDirOpt() {
        return BitcoinSServerMain$.MODULE$.customFinalDirOpt();
    }

    public static String actorSystemName() {
        return BitcoinSServerMain$.MODULE$.actorSystemName();
    }

    public static String[] commandLineArgs() {
        return BitcoinSServerMain$.MODULE$.commandLineArgs();
    }

    public static void main(String[] stringArray) {
        BitcoinSServerMain$.MODULE$.main(stringArray);
    }

    public static void delayedInit(Function0<BoxedUnit> function0) {
        BitcoinSServerMain$.MODULE$.delayedInit(function0);
    }

    public static long executionStart() {
        return BitcoinSServerMain$.MODULE$.executionStart();
    }

    public final Future<WalletHolder> run() {
        return BitcoinSRunner.run$((BitcoinSRunner)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private ExecutionContext ec$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.ec = BitcoinSRunner.ec$((BitcoinSRunner)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.ec;
    }

    public ExecutionContext ec() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.ec$lzycompute() : this.ec;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ServerArgParser serverArgParser() {
        return this.serverArgParser;
    }

    public ActorSystem system() {
        return this.system;
    }

    public BitcoinSAppConfig conf() {
        return this.conf;
    }

    private NodeAppConfig nodeConf$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.nodeConf = this.conf().nodeConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.nodeConf;
    }

    public NodeAppConfig nodeConf() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.nodeConf$lzycompute() : this.nodeConf;
    }

    private ChainAppConfig chainConf$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.chainConf = this.conf().chainConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.chainConf;
    }

    public ChainAppConfig chainConf() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.chainConf$lzycompute() : this.chainConf;
    }

    private DLCNodeAppConfig dlcNodeConf$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dlcNodeConf = this.conf().dlcNodeConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dlcNodeConf;
    }

    public DLCNodeAppConfig dlcNodeConf() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dlcNodeConf$lzycompute() : this.dlcNodeConf;
    }

    private BitcoindRpcAppConfig bitcoindRpcConf$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.bitcoindRpcConf = this.conf().bitcoindRpcConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.bitcoindRpcConf;
    }

    public BitcoindRpcAppConfig bitcoindRpcConf() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.bitcoindRpcConf$lzycompute() : this.bitcoindRpcConf;
    }

    private TorAppConfig torConf$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.torConf = this.conf().torConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.torConf;
    }

    public TorAppConfig torConf() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.torConf$lzycompute() : this.torConf;
    }

    private BitcoinNetwork network$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.network = this.conf().walletConf().network();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.network;
    }

    public BitcoinNetwork network() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.network$lzycompute() : this.network;
    }

    public Future<WalletHolder> start() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Starting appServer");
        long startTime = TimeUtil$.MODULE$.currentEpochMs();
        Future<StartedBitcoinSAppConfig> startedConfigF = this.conf().start();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Start on network ").append(this.network()).toString());
        startedConfigF.failed().foreach((Function1 & Serializable & scala.Serializable)err -> {
            BitcoinSServerMain.$anonfun$start$3(this, err);
            return BoxedUnit.UNIT;
        }, this.ec());
        return startedConfigF.map((Function1 & Serializable & scala.Serializable)startedConfig -> {
            ChainHandler chainApi = ChainHandler$.MODULE$.fromDatabase(this.ec(), this.chainConf());
            NodeType nodeType = this.nodeConf().nodeType();
            return new Tuple3(startedConfig, (Object)chainApi, (Object)nodeType);
        }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            StartedBitcoinSAppConfig startedConfig = (StartedBitcoinSAppConfig)tuple3._1();
            ChainHandler chainApi = (ChainHandler)tuple3._2();
            NodeType nodeType = (NodeType)tuple3._3();
            Future future = this.initializeChainState(chainApi, nodeType).flatMap((Function1 & Serializable & scala.Serializable)_ -> {
                Future<WalletHolder> future;
                NodeType nodeType = nodeType;
                if (nodeType instanceof InternalImplementationNodeType) {
                    future = this.startBitcoinSBackend((Future<BoxedUnit>)startedConfig.torStartedF());
                } else if (NodeType.BitcoindBackend$.MODULE$.equals(nodeType)) {
                    future = this.startBitcoindBackend((Future<BoxedUnit>)startedConfig.torStartedF());
                } else {
                    throw new MatchError((Object)nodeType);
                }
                return future.map((Function1 & Serializable & scala.Serializable)start -> {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Done start BitcoinSServerMain, it took=").append(TimeUtil$.MODULE$.currentEpochMs() - startTime).append("ms").toString());
                    return start;
                }, this.ec());
            }, this.ec());
            return future;
        }, this.ec());
    }

    private Future<BoxedUnit> initializeChainState(ChainHandler chainHandler, NodeType nodeType) {
        Future future;
        Future syncF = chainHandler.setSyncing(true);
        Future blockCountF = chainHandler.getBlockCount();
        NodeType nodeType2 = nodeType;
        if (NodeType.NeutrinoNode$.MODULE$.equals(nodeType2)) {
            future = blockCountF.flatMap((Function1 & Serializable & scala.Serializable)blockCount -> BitcoinSServerMain.$anonfun$initializeChainState$1(this, chainHandler, BoxesRunTime.unboxToInt((Object)blockCount)), this.ec());
        } else if (NodeType.BitcoindBackend$.MODULE$.equals(nodeType2)) {
            future = syncF.map((Function1 & Serializable & scala.Serializable)x$3 -> {
                BitcoinSServerMain.$anonfun$initializeChainState$3(x$3);
                return BoxedUnit.UNIT;
            }, this.ec());
        } else {
            if (NodeType.FullNode$.MODULE$.equals(nodeType2)) {
                throw scala.sys.package$.MODULE$.error("Full not is not implemented, not sure what to do with chainstate");
            }
            throw new MatchError((Object)nodeType2);
        }
        return future;
    }

    public Future<WalletHolder> stop() {
        Future<BoxedUnit> future;
        this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Exiting process");
        Option<BitcoindSyncState> option = this.bitcoindSyncStateOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            BitcoindSyncState bitcoindSyncState = (BitcoindSyncState)some.value();
            future = bitcoindSyncState.stop();
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.unit();
        } else {
            throw new MatchError(option);
        }
        return future.flatMap((Function1 & Serializable & scala.Serializable)_ -> this.conf().stop().flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
            Future<BoxedUnit> future;
            Option<DLCWalletLoaderApi> option = $this.walletLoaderApiOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                DLCWalletLoaderApi l = (DLCWalletLoaderApi)some.value();
                future = l.stop();
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.unit();
            } else {
                throw new MatchError(option);
            }
            return future.flatMap((Function1 & Serializable & scala.Serializable)_ -> {
                Future future;
                Option<ServerBindings> option = this.serverBindingsOpt();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ServerBindings bindings = (ServerBindings)some.value();
                    future = bindings.stop(this.ec());
                } else if (None$.MODULE$.equals(option)) {
                    future = Future$.MODULE$.unit();
                } else {
                    throw new MatchError(option);
                }
                return future.map((Function1 & Serializable & scala.Serializable)x$4 -> {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Stopped ").append(this.nodeConf().nodeType().shortName()).append(" node").toString());
                    BoxedUnit x$5 = BoxedUnit.UNIT;
                    return new Tuple2(x$4, (Object)x$5);
                }, this.ec()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
                    Tuple2 tuple2 = x$6;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    WalletHolder walletHolder = WalletHolder$.MODULE$.empty(this.ec());
                    return walletHolder;
                }, this.ec());
            }, this.ec());
        }, this.ec()), this.ec());
    }

    public Future<WalletHolder> startBitcoinSBackend(Future<BoxedUnit> startedTorConfigF) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "startBitcoinSBackend()");
        long start = System.currentTimeMillis();
        ChainHandler chainApi = ChainHandler$.MODULE$.fromDatabase(this.ec(), this.chainConf());
        Instant creationTime = this.conf().walletConf().creationTime();
        Future nodeF = this.nodeConf().createNode(scala.package$.MODULE$.Vector().empty(), (Option)new Some((Object)creationTime), this.chainConf(), this.system());
        MempoolSpaceProvider defaultApi = new MempoolSpaceProvider((MempoolSpaceTarget)MempoolSpaceTarget.HourFeeTarget$.MODULE$, this.network(), this.torConf().socks5ProxyParams(), this.system());
        FeeRateApi feeProvider = FeeProviderFactory$.MODULE$.getFeeProviderOrElse((Function0 & Serializable & scala.Serializable)() -> defaultApi, this.conf().walletConf().feeProviderNameOpt(), this.conf().walletConf().feeProviderTargetOpt(), this.torConf().socks5ProxyParams(), this.network(), this.system());
        WalletHolder walletHolder = WalletHolder$.MODULE$.empty(this.ec());
        Future neutrinoWalletLoaderF = nodeF.map((Function1 & Serializable & scala.Serializable)node -> {
            DLCWalletNeutrinoBackendLoader l = new DLCWalletNeutrinoBackendLoader(walletHolder, (ChainQueryApi)chainApi, (NodeApi)node, feeProvider, this.conf(), this.system());
            $this.walletLoaderApiOpt = new Some((Object)l);
            return l;
        }, this.ec());
        Future configuredWalletF = this.getLastLoadedWalletName().flatMap((Function1 & Serializable & scala.Serializable)walletNameOpt -> neutrinoWalletLoaderF.flatMap((Function1 & Serializable & scala.Serializable)neutrinoWalletLoader -> neutrinoWalletLoader.load((Option<String>)walletNameOpt, (Option<AesPassword>)this.conf().walletConf().aesPasswordOpt()).map((Function1 & Serializable & scala.Serializable)walletWithConfigs -> walletWithConfigs, this.ec()), this.ec()), this.ec());
        Future configuredNodeF = nodeF.flatMap((Function1 & Serializable & scala.Serializable)node -> configuredWalletF.map((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Done configuring node, it took=").append(System.currentTimeMillis() - start).append("ms").toString());
            return node;
        }, this.ec()), this.ec());
        Future dlcNodeF = configuredWalletF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BitcoinSServerMain.$anonfun$startBitcoinSBackend$10(check$ifrefutable$1)), this.ec()).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple3 tuple3 = x$8;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            WalletHolder wallet = (WalletHolder)tuple3._1();
            DLCNode node = this.dlcNodeConf().createDLCNode((DLCWalletApi)wallet, this.system());
            Tuple2 tuple2 = new Tuple2((Object)tuple3, (Object)node);
            return tuple2;
        }, this.ec()).map((Function1 & Serializable & scala.Serializable)x$9 -> {
            DLCNode node;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$9;
                    if (tuple2 == null) break block2;
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    node = (DLCNode)tuple2._2();
                    if (tuple3 != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            DLCNode dLCNode = node;
            return dLCNode;
        }, this.ec());
        Tuple2<SourceQueueWithComplete<WsNotification<?>>, Source<WsNotification<?>, NotUsed>> tuple = this.buildWsSource();
        SourceQueueWithComplete wsQueue = (SourceQueueWithComplete)tuple._1();
        Source wsSource = (Source)tuple._2();
        Future callbacksF = configuredWalletF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BitcoinSServerMain.$anonfun$startBitcoinSBackend$13(check$ifrefutable$2)), this.ec()).map((Function1 & Serializable & scala.Serializable)x$10 -> {
            BitcoinSServerMain.$anonfun$startBitcoinSBackend$14(this, wsQueue, chainApi, x$10);
            return BoxedUnit.UNIT;
        }, this.ec());
        TorCallbacks torCallbacks = WebsocketUtil$.MODULE$.buildTorCallbacks(wsQueue, this.ec());
        this.torConf().addCallbacks((ModuleCallbacks)torCallbacks);
        Future isTorStartedF = this.torConf().torProvided() ? ((TorCallbacks)this.torConf().callBacks()).executeOnTorStarted(this.ec()) : Future$.MODULE$.unit();
        Future startedNodeF = startedTorConfigF.flatMap((Function1 & Serializable & scala.Serializable)_2 -> isTorStartedF.flatMap((Function1 & Serializable & scala.Serializable)_ -> configuredNodeF.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.start(), this.ec()).map((Function1 & Serializable & scala.Serializable)started -> started, this.ec()), this.ec()), this.ec());
        Future startedDLCNodeF = dlcNodeF.flatMap((Function1 & Serializable & scala.Serializable)dlcNode -> dlcNode.start().map((Function1 & Serializable & scala.Serializable)_ -> dlcNode, this.ec()), this.ec());
        Future startedF = configuredWalletF.flatMap((Function1 & Serializable & scala.Serializable)_ -> this.startHttpServer((Future<NodeApi>)startedNodeF, (ChainApi)chainApi, (Future<DLCWalletLoaderApi>)neutrinoWalletLoaderF, (Future<DLCNode>)startedDLCNodeF, startedTorConfigF, this.serverArgParser(), wsSource, this.system(), this.conf()).map((Function1 & Serializable & scala.Serializable)x$12 -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Starting ").append(this.nodeConf().nodeType().shortName()).append(" node sync, it took=").append(System.currentTimeMillis() - start).append("ms").toString());
            BoxedUnit x$13 = BoxedUnit.UNIT;
            return new Tuple2(x$12, (Object)x$13);
        }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = callbacksF.flatMap((Function1 & Serializable & scala.Serializable)_ -> startedNodeF.flatMap((Function1 & Serializable & scala.Serializable)node -> startedTorConfigF.flatMap((Function1 & Serializable & scala.Serializable)_2 -> node.sync().map((Function1 & Serializable & scala.Serializable)_ -> {
                BitcoinSServerMain.$anonfun$startBitcoinSBackend$28(this, start, _);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec()), this.ec()), this.ec());
            return future;
        }, this.ec()), this.ec());
        return startedF.flatMap((Function1 & Serializable & scala.Serializable)_ -> configuredWalletF.map((Function1 & Serializable & scala.Serializable)x$15 -> (WalletHolder)x$15._1(), this.ec()).map((Function1 & Serializable & scala.Serializable)walletHolder -> walletHolder, this.ec()), this.ec());
    }

    private void buildNeutrinoCallbacks(SourceQueueWithComplete<WsNotification<?>> wsQueue, ChainApi chainApi, WalletAppConfig walletConf, DLCAppConfig dlcConf) {
        ChainCallbacks chainCallbacks = WebsocketUtil$.MODULE$.buildChainCallbacks(wsQueue, chainApi, this.ec(), this.chainConf());
        this.chainConf().addCallbacks((ModuleCallbacks)chainCallbacks);
        WalletCallbacks walletCallbacks = WebsocketUtil$.MODULE$.buildWalletCallbacks(wsQueue, walletConf.walletName(), this.ec());
        walletConf.addCallbacks((ModuleCallbacks)walletCallbacks);
        DLCWalletCallbacks dlcWalletCallbacks = WebsocketUtil$.MODULE$.buildDLCWalletCallbacks(wsQueue, this.ec());
        dlcConf.addCallbacks(dlcWalletCallbacks);
        TorCallbacks torCallbacks = WebsocketUtil$.MODULE$.buildTorCallbacks(wsQueue, this.ec());
        this.torConf().addCallbacks((ModuleCallbacks)torCallbacks);
    }

    private Future<GetBlockChainInfoResult> getBlockChainInfo(BitcoindRpcClient client) {
        Promise promise = Promise$.MODULE$.apply();
        FiniteDuration interval = new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
        int maxTries = 12;
        Function0 & Serializable & scala.Serializable x$1 = (Function0 & Serializable & scala.Serializable)() -> {
            Future infoF = client.getBlockChainInfo();
            Future res = infoF.map((Function1 & Serializable & scala.Serializable)value -> promise.success(value), this.ec()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)BitcoinSServerMain.$anonfun$getBlockChainInfo$3(x$16)), this.ec());
            return res.recover((PartialFunction)new scala.Serializable(this, interval){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BitcoinSServerMain $outer;
                private final FiniteDuration interval$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof BitcoindException.InWarmUp) {
                        this.$outer.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Bitcoind still in warmup, trying again in ").append($this.interval$1).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)false);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof BitcoindException.InWarmUp;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.interval$1 = interval$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.bitcoins.server.BitcoinSServerMain$$anonfun$$nestedInanonfun$getBlockChainInfo$1$1 )}, serializedLambda);
                }
            }, this.ec());
        };
        AsyncUtil.Exponential$ x$2 = AsyncUtil$.MODULE$.Exponential();
        FiniteDuration x$3 = interval;
        int x$4 = maxTries;
        return AsyncUtil$.MODULE$.retryUntilSatisfiedF((Function0)x$1, x$3, x$4, (AsyncUtil.RetryMode)x$2, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)_ -> promise.future().map((Function1 & Serializable & scala.Serializable)info -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Retrieved blockchainInfo=").append(info).toString());
            return info;
        }, this.ec()), this.ec());
    }

    public Future<WalletHolder> startBitcoindBackend(Future<BoxedUnit> startedTorConfigF) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "startBitcoindBackend()");
        Future bitcoindF = this.bitcoindRpcConf().clientF().flatMap((Function1 & Serializable & scala.Serializable)client -> client.start().map((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Started bitcoind");
            return client;
        }, this.ec()), this.ec());
        Tuple2<SourceQueueWithComplete<WsNotification<?>>, Source<WsNotification<?>, NotUsed>> tuple = this.buildWsSource();
        SourceQueueWithComplete wsQueue = (SourceQueueWithComplete)tuple._1();
        Source wsSource = (Source)tuple._2();
        TorCallbacks torCallbacks = WebsocketUtil$.MODULE$.buildTorCallbacks(wsQueue, this.ec());
        TorCallbacks _2 = (TorCallbacks)this.torConf().addCallbacks((ModuleCallbacks)torCallbacks);
        Future isTorStartedF = this.torConf().torProvided() ? ((TorCallbacks)this.torConf().callBacks()).executeOnTorStarted(this.ec()) : Future$.MODULE$.unit();
        Future walletNameF = this.getLastLoadedWalletName().map((Function1 & Serializable & scala.Serializable)lastLoadedWallet -> {
            String walletName = (String)lastLoadedWallet.getOrElse((Function0 & Serializable & scala.Serializable)() -> WalletAppConfig$.MODULE$.DEFAULT_WALLET_NAME());
            return new Tuple2(lastLoadedWallet, (Object)walletName);
        }, this.ec()).map((Function1 & Serializable & scala.Serializable)x$17 -> {
            String walletName;
            Tuple2 tuple2 = x$17;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = walletName = (String)tuple2._2();
            return string;
        }, this.ec());
        WalletHolder walletHolder = WalletHolder$.MODULE$.empty(this.ec());
        Future chainCallbacksF = bitcoindF.map((Function1 & Serializable & scala.Serializable)bitcoind -> WebsocketUtil$.MODULE$.buildChainCallbacks(wsQueue, (ChainApi)bitcoind, this.ec(), this.chainConf()), this.ec());
        Future nodeApiF = bitcoindF.flatMap((Function1 & Serializable & scala.Serializable)bitcoind -> chainCallbacksF.map((Function1 & Serializable & scala.Serializable)chainCallbacks -> BitcoindRpcBackendUtil$.MODULE$.buildBitcoindNodeApi((BitcoindRpcClient)bitcoind, (Future<WalletApi>)Future$.MODULE$.successful((Object)walletHolder), (Option<ChainCallbacks>)new Some(chainCallbacks), this.system()), this.ec()), this.ec());
        Future feeProviderF = bitcoindF.map((Function1 & Serializable & scala.Serializable)bitcoind -> FeeProviderFactory$.MODULE$.getFeeProviderOrElse((Function0 & Serializable & scala.Serializable)() -> bitcoind, this.conf().walletConf().feeProviderNameOpt(), this.conf().walletConf().feeProviderTargetOpt(), this.torConf().socks5ProxyParams(), this.network(), this.system()), this.ec());
        Future loadWalletApiF = bitcoindF.flatMap((Function1 & Serializable & scala.Serializable)bitcoind -> nodeApiF.flatMap((Function1 & Serializable & scala.Serializable)nodeApi -> feeProviderF.map((Function1 & Serializable & scala.Serializable)feeProvider -> {
            DLCWalletBitcoindBackendLoader l = new DLCWalletBitcoindBackendLoader(walletHolder, (BitcoindRpcClient)bitcoind, (NodeApi)nodeApi, (FeeRateApi)feeProvider, this.conf(), this.system());
            $this.walletLoaderApiOpt = new Some((Object)l);
            return l;
        }, this.ec()), this.ec()), this.ec());
        Future walletF = isTorStartedF.flatMap((Function1 & Serializable & scala.Serializable)_ -> loadWalletApiF.flatMap((Function1 & Serializable & scala.Serializable)loadWalletApi -> walletNameF.flatMap((Function1 & Serializable & scala.Serializable)walletName -> loadWalletApi.load((Option<String>)new Some(walletName), (Option<AesPassword>)this.conf().walletConf().aesPasswordOpt()).map((Function1 & Serializable & scala.Serializable)result -> result, this.ec()), this.ec()), this.ec()), this.ec());
        Future dlcNodeF = walletF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BitcoinSServerMain.$anonfun$startBitcoindBackend$20(check$ifrefutable$3)), this.ec()).map((Function1 & Serializable & scala.Serializable)x$19 -> {
            Tuple3 tuple3 = x$19;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            WalletHolder wallet = (WalletHolder)tuple3._1();
            DLCNode dlcNode = this.dlcNodeConf().createDLCNode((DLCWalletApi)wallet, this.system());
            Tuple2 tuple2 = new Tuple2((Object)tuple3, (Object)dlcNode);
            return tuple2;
        }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
            DLCNode dlcNode;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$20;
                    if (tuple2 == null) break block2;
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    dlcNode = (DLCNode)tuple2._2();
                    if (tuple3 != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Future future = dlcNode.start().map((Function1 & Serializable & scala.Serializable)_ -> dlcNode, this.ec());
            return future;
        }, this.ec());
        Future bitcoindSyncStateF = bitcoindF.flatMap((Function1 & Serializable & scala.Serializable)bitcoind -> this.getBlockChainInfo((BitcoindRpcClient)bitcoind).flatMap((Function1 & Serializable & scala.Serializable)blockchainInfo -> bitcoind.setSyncing(blockchainInfo.initialblockdownload()).map((Function1 & Serializable & scala.Serializable)x$21 -> {
            NetworkParameters bitcoindNetwork;
            NetworkParameters networkParameters = bitcoindNetwork = blockchainInfo.chain();
            BitcoinNetwork bitcoinNetwork = this.network();
            Predef$.MODULE$.require(!(networkParameters != null ? !networkParameters.equals(bitcoinNetwork) : bitcoinNetwork != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("bitcoind (").append(bitcoindNetwork).append(") on different network than wallet (").append(this.network()).append(")").toString());
            BoxedUnit x$22 = BoxedUnit.UNIT;
            return new Tuple3(x$21, (Object)bitcoindNetwork, (Object)x$22);
        }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$31 -> {
            Tuple3 tuple3 = x$31;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Future future = this.startHttpServer((Future<NodeApi>)Future$.MODULE$.successful(bitcoind), (ChainApi)bitcoind, (Future<DLCWalletLoaderApi>)loadWalletApiF, (Future<DLCNode>)dlcNodeF, startedTorConfigF, this.serverArgParser(), wsSource, this.system(), this.conf()).flatMap((Function1 & Serializable & scala.Serializable)_ -> walletNameF.map((Function1 & Serializable & scala.Serializable)walletName -> {
                WalletCallbacks walletCallbacks = WebsocketUtil$.MODULE$.buildWalletCallbacks((SourceQueueWithComplete<WsNotification<?>>)wsQueue, (String)walletName, this.ec());
                return new Tuple2(walletName, (Object)walletCallbacks);
            }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$30 -> {
                Tuple2 tuple2 = x$30;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                WalletCallbacks walletCallbacks = (WalletCallbacks)tuple2._2();
                Future future = chainCallbacksF.flatMap((Function1 & Serializable & scala.Serializable)chainCallbacks -> walletF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BitcoinSServerMain.$anonfun$startBitcoindBackend$33(check$ifrefutable$4)), this.ec()).map((Function1 & Serializable & scala.Serializable)x$25 -> {
                    Tuple3 tuple3 = x$25;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    WalletAppConfig walletConfig = (WalletAppConfig)tuple3._2();
                    WalletCallbacks x$24 = (WalletCallbacks)walletConfig.addCallbacks((ModuleCallbacks)walletCallbacks);
                    Tuple2 tuple2 = new Tuple2((Object)tuple3, (Object)x$24);
                    return tuple2;
                }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$29 -> {
                    Tuple3 tuple3;
                    Tuple2 tuple2 = x$29;
                    if (tuple2 == null || (tuple3 = (Tuple3)tuple2._1()) == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    WalletHolder wallet = (WalletHolder)tuple3._1();
                    DLCAppConfig dlcConfig = (DLCAppConfig)tuple3._3();
                    Future future = this.syncWalletWithBitcoindAndStartPolling((BitcoindRpcClient)bitcoind, (NeutrinoHDWalletApi)wallet, (Option<ChainCallbacks>)new Some(chainCallbacks)).map((Function1 & Serializable & scala.Serializable)bitcoindSyncState -> {
                        $this.bitcoindSyncStateOpt = new Some(bitcoindSyncState);
                        BoxedUnit x$26 = BoxedUnit.UNIT;
                        DLCWalletCallbacks dlcWalletCallbacks = WebsocketUtil$.MODULE$.buildDLCWalletCallbacks(wsQueue, this.ec());
                        DLCWalletCallbacks x$27 = dlcConfig.addCallbacks(dlcWalletCallbacks);
                        return new Tuple4(bitcoindSyncState, (Object)x$26, (Object)dlcWalletCallbacks, (Object)x$27);
                    }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$28 -> {
                        Tuple4 tuple4 = x$28;
                        if (tuple4 == null) {
                            throw new MatchError((Object)tuple4);
                        }
                        BitcoindSyncState bitcoindSyncState = (BitcoindSyncState)tuple4._1();
                        Future future = startedTorConfigF.map((Function1 & Serializable & scala.Serializable)_ -> {
                            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Done starting Main!");
                            return bitcoindSyncState;
                        }, this.ec());
                        return future;
                    }, this.ec());
                    return future;
                }, this.ec()), this.ec());
                return future;
            }, this.ec()), this.ec());
            return future;
        }, this.ec()), this.ec()), this.ec());
        return bitcoindSyncStateF.flatMap((Function1 & Serializable & scala.Serializable)_ -> walletF.map((Function1 & Serializable & scala.Serializable)x$32 -> (WalletHolder)x$32._1(), this.ec()).map((Function1 & Serializable & scala.Serializable)walletHolder -> walletHolder, this.ec()), this.ec());
    }

    private Option<ServerBindings> serverBindingsOpt() {
        return this.serverBindingsOpt;
    }

    private void serverBindingsOpt_$eq(Option<ServerBindings> x$1) {
        this.serverBindingsOpt = x$1;
    }

    private Future<Server> startHttpServer(Future<NodeApi> nodeApiF, ChainApi chainApi, Future<DLCWalletLoaderApi> walletLoaderF, Future<DLCNode> dlcNodeF, Future<BoxedUnit> torConfStarted, ServerArgParser serverCmdLineArgs, Source<WsNotification<?>, NotUsed> wsSource, ActorSystem system, BitcoinSAppConfig conf) {
        Server server;
        int n;
        Some some;
        Some some2;
        NodeAppConfig nodeConf = conf.nodeConf();
        WalletAppConfig walletConf = conf.walletConf();
        Future walletRoutesF = walletLoaderF.map((Function1 & Serializable & scala.Serializable)w -> new WalletRoutes((DLCWalletLoaderApi)w, system, walletConf), this.ec());
        Future nodeRoutesF = nodeApiF.map((Function1 & Serializable & scala.Serializable)x$33 -> new NodeRoutes((NodeApi)x$33, system), this.ec());
        ChainRoutes chainRoutes = new ChainRoutes(chainApi, nodeConf.network(), torConfStarted, system);
        CoreRoutes coreRoutes = new CoreRoutes(system, conf);
        Future dlcRoutesF = dlcNodeF.map((Function1 & Serializable & scala.Serializable)x$34 -> new DLCRoutes((DLCNodeApi)x$34, system), this.ec());
        CommonRoutes commonRoutes = new CommonRoutes(conf.baseDatadir());
        Seq handlers = (Seq)new .colon.colon((Object)walletRoutesF, (List)new .colon.colon((Object)nodeRoutesF, (List)new .colon.colon((Object)Future$.MODULE$.successful((Object)chainRoutes), (List)new .colon.colon((Object)Future$.MODULE$.successful((Object)coreRoutes), (List)new .colon.colon((Object)dlcRoutesF, (List)new .colon.colon((Object)Future$.MODULE$.successful((Object)commonRoutes), (List)Nil$.MODULE$))))));
        Option option = serverCmdLineArgs.rpcBindOpt();
        if (option instanceof Some) {
            Some some3 = (Some)option;
            String rpcbind = (String)some3.value();
            some2 = new Some((Object)rpcbind);
        } else if (None$.MODULE$.equals(option)) {
            some2 = conf.rpcBindOpt();
        } else {
            throw new MatchError((Object)option);
        }
        Some rpcBindConfOpt = some2;
        Option option2 = serverCmdLineArgs.wsBindOpt();
        if (option2 instanceof Some) {
            Some some4 = (Some)option2;
            String wsbind = (String)some4.value();
            some = new Some((Object)wsbind);
        } else if (None$.MODULE$.equals(option2)) {
            some = conf.wsBindOpt();
        } else {
            throw new MatchError((Object)option2);
        }
        Some wsBindConfOpt = some;
        Option option3 = serverCmdLineArgs.wsPortOpt();
        if (option3 instanceof Some) {
            int wsPort;
            Some some5 = (Some)option3;
            n = wsPort = BoxesRunTime.unboxToInt((Object)some5.value());
        } else if (None$.MODULE$.equals(option3)) {
            n = conf.wsPort();
        } else {
            throw new MatchError((Object)option3);
        }
        int wsPort = n;
        WsServerConfig wsServerConfig = new WsServerConfig((String)wsBindConfOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "localhost"), wsPort);
        Option option4 = serverCmdLineArgs.rpcPortOpt();
        if (option4 instanceof Some) {
            Some some6 = (Some)option4;
            int rpcport = BoxesRunTime.unboxToInt((Object)some6.value());
            server = new Server((AppConfig)nodeConf, handlers, (Option)rpcBindConfOpt, rpcport, conf.rpcPassword(), (Option)new Some((Object)wsServerConfig), wsSource, system);
        } else if (None$.MODULE$.equals(option4)) {
            server = new Server((AppConfig)nodeConf, handlers, (Option)rpcBindConfOpt, conf.rpcPort(), conf.rpcPassword(), (Option)new Some((Object)wsServerConfig), wsSource, system);
        } else {
            throw new MatchError((Object)option4);
        }
        Server server2 = server;
        Future bindingF = server2.start();
        return bindingF.map((Function1 & Serializable & scala.Serializable)bindings -> {
            this.serverBindingsOpt_$eq((Option<ServerBindings>)new Some(bindings));
            return server2;
        }, this.ec());
    }

    private Future<BitcoindSyncState> syncWalletWithBitcoindAndStartPolling(BitcoindRpcClient bitcoind, NeutrinoHDWalletApi wallet, Option<ChainCallbacks> chainCallbacksOpt) {
        Future f = this.handlePotentialBitcoindLostBlock(bitcoind, (WalletApi)wallet).map((Function1 & Serializable & scala.Serializable)x$37 -> {
            Future<BoxedUnit> syncF = BitcoindRpcBackendUtil$.MODULE$.syncWalletToBitcoind(bitcoind, wallet, chainCallbacksOpt, this.system());
            Future x$38 = syncF.map((Function1 & Serializable & scala.Serializable)x$35 -> wallet.updateUtxoPendingStates(), this.ec());
            return new Tuple3(x$37, syncF, (Object)x$38);
        }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$39 -> {
            Tuple3 tuple3 = x$39;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Future syncF = (Future)tuple3._2();
            Future future = syncF.flatMap((Function1 & Serializable & scala.Serializable)x$36 -> {
                Future future;
                ZmqConfig zmqConfig = this.bitcoindRpcConf().zmqConfig();
                ZmqConfig zmqConfig2 = ZmqConfig$.MODULE$.empty();
                if (!(zmqConfig != null ? !zmqConfig.equals(zmqConfig2) : zmqConfig2 != null)) {
                    Cancellable blockingPollingCancellable = BitcoindRpcBackendUtil$.MODULE$.startBitcoindBlockPolling((WalletApi)wallet, bitcoind, chainCallbacksOpt, BitcoindRpcBackendUtil$.MODULE$.startBitcoindBlockPolling$default$4(), this.system());
                    Cancellable mempoolCancellable = BitcoindRpcBackendUtil$.MODULE$.startBitcoindMempoolPolling((WalletApi)wallet, bitcoind, BitcoindRpcBackendUtil$.MODULE$.startBitcoindMempoolPolling$default$3(), (Function1<Transaction, Future<BoxedUnit>>)(Function1 & Serializable & scala.Serializable)tx -> ((NodeCallbacks)this.nodeConf().callBacks()).executeOnTxReceivedCallbacks(tx, this.ec()), this.system(), this.ec());
                    BitcoindPollingCancellabe combinedCancellable = new BitcoindPollingCancellabe(blockingPollingCancellable, mempoolCancellable);
                    future = Future$.MODULE$.successful((Object)combinedCancellable);
                } else {
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                        BitcoindRpcBackendUtil$.MODULE$.startZMQWalletCallbacks((WalletApi)wallet, this.bitcoindRpcConf().zmqConfig());
                        return BitcoindPollingCancellabe$.MODULE$.none();
                    }, this.ec());
                }
                return future;
            }, this.ec()).map((Function1 & Serializable & scala.Serializable)pollingCancellable -> new BitcoindSyncState((Future<BoxedUnit>)syncF, (BitcoindPollingCancellabe)pollingCancellable), this.ec());
            return future;
        }, this.ec());
        f.failed().foreach((Function1 & Serializable & scala.Serializable)err -> {
            BitcoinSServerMain.$anonfun$syncWalletWithBitcoindAndStartPolling$8(this, err);
            return BoxedUnit.UNIT;
        }, this.ec());
        return f;
    }

    private Future<BoxedUnit> handlePotentialBitcoindLostBlock(BitcoindRpcClient bitcoind, WalletApi wallet) {
        Function0 & Serializable & scala.Serializable x$1 = (Function0 & Serializable & scala.Serializable)() -> bitcoind.getBlockCount().flatMap((Function1 & Serializable & scala.Serializable)bitcoindHeight -> BitcoinSServerMain.$anonfun$handlePotentialBitcoindLostBlock$2(this, wallet, BoxesRunTime.unboxToInt((Object)bitcoindHeight)), this.ec());
        AsyncUtil.Exponential$ x$2 = AsyncUtil$.MODULE$.Exponential();
        FiniteDuration x$3 = new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
        int x$4 = 12;
        return AsyncUtil$.MODULE$.retryUntilSatisfiedF((Function0)x$1, x$3, x$4, (AsyncUtil.RetryMode)x$2, this.ec());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<SourceQueueWithComplete<WsNotification<?>>, Source<WsNotification<?>, NotUsed>> buildWsSource() {
        void var2_2;
        int maxBufferSize = 25;
        Tuple2 tuple = (Tuple2)Source$.MODULE$.queue(maxBufferSize, OverflowStrategy$.MODULE$.dropHead()).toMat((Graph)BroadcastHub$.MODULE$.sink(), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system()));
        Future _ = (Future)((Source)tuple._2()).runWith((Graph)Sink$.MODULE$.ignore(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system()));
        return var2_2;
    }

    private NodeStateDescriptorDAO nodeStateDAO$lzycompute() {
        BitcoinSServerMain bitcoinSServerMain = this;
        synchronized (bitcoinSServerMain) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.nodeStateDAO = new NodeStateDescriptorDAO(this.ec(), this.nodeConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.nodeStateDAO;
    }

    private NodeStateDescriptorDAO nodeStateDAO() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.nodeStateDAO$lzycompute() : this.nodeStateDAO;
    }

    private Future<Option<String>> getLastLoadedWalletName() {
        return this.nodeStateDAO().getWalletName().recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof SQLException ? None$.MODULE$ : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof SQLException;
                return bl;
            }
        }, this.ec()).map((Function1 & Serializable & scala.Serializable)x$41 -> x$41.map((Function1 & Serializable & scala.Serializable)x$42 -> x$42.walletName()), this.ec());
    }

    public static final /* synthetic */ void $anonfun$start$3(BitcoinSServerMain $this, Throwable err) {
        $this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Failed to initialize configuration for BitcoinServerMain", (Function0 & Serializable & scala.Serializable)() -> err);
    }

    public static final /* synthetic */ void $anonfun$initializeChainState$2(ChainApi x$2) {
    }

    public static final /* synthetic */ Future $anonfun$initializeChainState$1(BitcoinSServerMain $this, ChainHandler chainHandler$1, int blockCount) {
        return blockCount == 0 ? chainHandler$1.setIBD(true).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            BitcoinSServerMain.$anonfun$initializeChainState$2(x$2);
            return BoxedUnit.UNIT;
        }, $this.ec()) : Future$.MODULE$.unit();
    }

    public static final /* synthetic */ void $anonfun$initializeChainState$3(ChainApi x$3) {
    }

    public static final /* synthetic */ boolean $anonfun$startBitcoinSBackend$10(Tuple3 check$ifrefutable$1) {
        Tuple3 tuple3 = check$ifrefutable$1;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$startBitcoinSBackend$13(Tuple3 check$ifrefutable$2) {
        Tuple3 tuple3 = check$ifrefutable$2;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$startBitcoinSBackend$14(BitcoinSServerMain $this, SourceQueueWithComplete wsQueue$1, ChainHandler chainApi$1, Tuple3 x$10) {
        Tuple3 tuple3 = x$10;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        WalletAppConfig walletConfig = (WalletAppConfig)tuple3._2();
        DLCAppConfig dlcConfig = (DLCAppConfig)tuple3._3();
        $this.buildNeutrinoCallbacks(wsQueue$1, (ChainApi)chainApi$1, walletConfig, dlcConfig);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$startBitcoinSBackend$28(BitcoinSServerMain $this, long start$1, BoxedUnit _) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Done starting Main! It took ").append(System.currentTimeMillis() - start$1).append("ms").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getBlockChainInfo$3(Promise x$16) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$startBitcoindBackend$20(Tuple3 check$ifrefutable$3) {
        Tuple3 tuple3 = check$ifrefutable$3;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$startBitcoindBackend$33(Tuple3 check$ifrefutable$4) {
        Tuple3 tuple3 = check$ifrefutable$4;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$syncWalletWithBitcoindAndStartPolling$8(BitcoinSServerMain $this, Throwable err) {
        $this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Error syncing bitcoin-s wallet with bitcoind", (Function0 & Serializable & scala.Serializable)() -> err);
    }

    public static final /* synthetic */ boolean $anonfun$handlePotentialBitcoindLostBlock$4(int bitcoindHeight$1, SyncHeightDescriptor x$40) {
        return bitcoindHeight$1 >= x$40.height();
    }

    public static final /* synthetic */ Future $anonfun$handlePotentialBitcoindLostBlock$2(BitcoinSServerMain $this, WalletApi wallet$2, int bitcoindHeight) {
        return wallet$2.getSyncDescriptorOpt().map((Function1 & Serializable & scala.Serializable)walletStateOpt -> BoxesRunTime.boxToBoolean((boolean)walletStateOpt.forall((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)BitcoinSServerMain.$anonfun$handlePotentialBitcoindLostBlock$4(bitcoindHeight$1, x$40)))), $this.ec());
    }

    public BitcoinSServerMain(ServerArgParser serverArgParser, ActorSystem system, BitcoinSAppConfig conf) {
        this.serverArgParser = serverArgParser;
        this.system = system;
        this.conf = conf;
        Logging.$init$((Logging)this);
        BitcoinSRunner.$init$((BitcoinSRunner)this);
        this.walletLoaderApiOpt = None$.MODULE$;
        this.bitcoindSyncStateOpt = None$.MODULE$;
        this.serverBindingsOpt = None$.MODULE$;
    }
}

