/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.server;

import akka.Done;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.ClassicActorSystemProvider;
import akka.stream.BoundedSourceQueue;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.RunnableGraph;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bitcoins.chain.ChainCallbacks;
import org.bitcoins.commons.jsonmodels.bitcoind.GetBlockChainInfoResult;
import org.bitcoins.commons.jsonmodels.bitcoind.GetBlockHeaderResult;
import org.bitcoins.core.api.chain.ChainQueryApi;
import org.bitcoins.core.api.node.NodeApi;
import org.bitcoins.core.api.wallet.BlockSyncState;
import org.bitcoins.core.api.wallet.NeutrinoHDWalletApi;
import org.bitcoins.core.api.wallet.SyncHeightDescriptor;
import org.bitcoins.core.api.wallet.WalletApi;
import org.bitcoins.core.api.wallet.db.TransactionDb;
import org.bitcoins.core.gcs.FilterType;
import org.bitcoins.core.protocol.blockchain.Block;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.util.FutureUtil$;
import org.bitcoins.crypto.DoubleSha256Digest;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.dlc.wallet.DLCWallet;
import org.bitcoins.dlc.wallet.DLCWallet$;
import org.bitcoins.rpc.client.common.BitcoindRpcClient;
import org.bitcoins.rpc.client.v19.V19BlockFilterRpc;
import org.bitcoins.rpc.config.ZmqConfig;
import org.bitcoins.rpc.config.ZmqConfig$;
import org.bitcoins.rpc.util.BitcoindStreamUtil$;
import org.bitcoins.server.BitcoindRpcBackendUtil$;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.Wallet$;
import org.bitcoins.zmq.ZMQSubscriber;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.util.Try;

public final class BitcoindRpcBackendUtil$
implements Logging {
    public static BitcoindRpcBackendUtil$ MODULE$;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new BitcoindRpcBackendUtil$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BitcoindRpcBackendUtil$ bitcoindRpcBackendUtil$ = this;
        synchronized (bitcoindRpcBackendUtil$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Future<BoxedUnit> syncWalletToBitcoind(BitcoindRpcClient bitcoind, NeutrinoHDWalletApi wallet, Option<ChainCallbacks> chainCallbacksOpt, ActorSystem system) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Syncing wallet to bitcoind");
        Future streamF = this.setSyncingFlag(true, bitcoind, chainCallbacksOpt, (ExecutionContext)system.dispatcher()).flatMap((Function1 & Serializable & scala.Serializable)_ -> bitcoind.getBlockCount().flatMap((Function1 & Serializable & scala.Serializable)bitcoindHeight -> BitcoindRpcBackendUtil$.$anonfun$syncWalletToBitcoind$3(wallet, bitcoind, system, BoxesRunTime.unboxToInt((Object)bitcoindHeight)), (ExecutionContext)system.dispatcher()), (ExecutionContext)system.dispatcher());
        Future res = streamF.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Future)x$4.run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system)), (ExecutionContext)system.dispatcher());
        res.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_ = x0$1;
            Future<Object> isBitcoindInSyncF = MODULE$.isBitcoindInSync(bitcoind, (ExecutionContext)system.dispatcher());
            Future future = isBitcoindInSyncF.flatMap((Function1 & Serializable & scala.Serializable)isBitcoindInSync -> BitcoindRpcBackendUtil$.$anonfun$syncWalletToBitcoind$12(bitcoind, chainCallbacksOpt, system, BoxesRunTime.unboxToBoolean((Object)isBitcoindInSync)), (ExecutionContext)system.dispatcher());
            return future;
        }, (ExecutionContext)system.dispatcher());
        return res.map((Function1 & Serializable & scala.Serializable)x$5 -> {
            BitcoindRpcBackendUtil$.$anonfun$syncWalletToBitcoind$14(x$5);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)system.dispatcher());
    }

    private Future<Range.Inclusive> getHeightRangeNoWalletState(NeutrinoHDWalletApi wallet, BitcoindRpcClient bitcoind, int bitcoindHeight, ExecutionContext ex) {
        return wallet.listTransactions().map((Function1 & Serializable & scala.Serializable)txDbs -> {
            Option lastConfirmedOpt = ((TraversableLike)txDbs.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)BitcoindRpcBackendUtil$.$anonfun$getHeightRangeNoWalletState$2(x$6)))).lastOption();
            return new Tuple2(txDbs, (Object)lastConfirmedOpt);
        }, ex).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Future future;
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option lastConfirmedOpt = (Option)tuple2._2();
            Option option = lastConfirmedOpt;
            if (None$.MODULE$.equals(option)) {
                Range.Inclusive range2 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(bitcoindHeight - 1), bitcoindHeight);
                future = Future$.MODULE$.successful((Object)range2);
                return future.map((Function1 & Serializable & scala.Serializable)range -> range, ex);
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                TransactionDb txDb = (TransactionDb)some.value();
                future = bitcoind.getBlockHeight((DoubleSha256DigestBE)txDb.blockHashOpt().get()).flatMap((Function1 & Serializable & scala.Serializable)heightOpt -> {
                    Future future;
                    Option option = heightOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int height = BoxesRunTime.unboxToInt((Object)some.value());
                        MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Last tx occurred at block ").append(height).append(", syncing from there").toString());
                        Range.Inclusive range2 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(height), bitcoindHeight);
                        future = Future$.MODULE$.successful((Object)range2);
                    } else if (None$.MODULE$.equals(option)) {
                        Range.Inclusive range3 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(bitcoindHeight - 1), bitcoindHeight);
                        future = Future$.MODULE$.successful((Object)range3);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return future.map((Function1 & Serializable & scala.Serializable)range -> range, ex);
                }, ex);
            }
            return future.map((Function1 & Serializable & scala.Serializable)range -> range, ex);
        }, ex);
    }

    private Future<BoxedUnit> setSyncingFlag(boolean syncing, BitcoindRpcClient bitcoind, Option<ChainCallbacks> chainCallbacksOpt, ExecutionContext ec) {
        Future oldSyncingFlagF = bitcoind.isSyncing();
        return oldSyncingFlagF.flatMap((Function1 & Serializable & scala.Serializable)oldFlag -> BitcoindRpcBackendUtil$.$anonfun$setSyncingFlag$1(bitcoind, syncing, chainCallbacksOpt, ec, BoxesRunTime.unboxToBoolean((Object)oldFlag)), ec);
    }

    private Future<Sink<Object, Future<NeutrinoHDWalletApi>>> buildBitcoindSyncSink(BitcoindRpcClient bitcoind, NeutrinoHDWalletApi wallet, ActorSystem system) {
        Future hasFiltersF = bitcoind.getBlockHash(0).flatMap((Function1 & Serializable & scala.Serializable)hash -> bitcoind.getFilter(hash), (ExecutionContext)system.dispatcher()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)BitcoindRpcBackendUtil$.$anonfun$buildBitcoindSyncSink$2(x$9)), (ExecutionContext)system.dispatcher()).recover((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 != null ? BoxesRunTime.boxToBoolean((boolean)false) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
        }, (ExecutionContext)system.dispatcher());
        int numParallelism = FutureUtil$.MODULE$.getParallelism();
        Future syncWalletSinkF = hasFiltersF.map((Function1 & Serializable & scala.Serializable)hasFilters -> BitcoindRpcBackendUtil$.$anonfun$buildBitcoindSyncSink$3(bitcoind, wallet, system, BoxesRunTime.unboxToBoolean((Object)hasFilters)), (ExecutionContext)system.dispatcher());
        Flow fetchBlockHashesFlow = (Flow)Flow$.MODULE$.apply().mapAsync(numParallelism, (Function1 & Serializable & scala.Serializable)x0$1 -> BitcoindRpcBackendUtil$.$anonfun$buildBitcoindSyncSink$8(bitcoind, system, BoxesRunTime.unboxToInt((Object)x0$1)));
        return syncWalletSinkF.map((Function1 & Serializable & scala.Serializable)syncWalletSink -> fetchBlockHashesFlow.toMat((Graph)syncWalletSink, Keep$.MODULE$.right()), (ExecutionContext)system.dispatcher());
    }

    public Wallet createWalletWithBitcoindCallbacks(BitcoindRpcClient bitcoind, Wallet wallet, Option<ChainCallbacks> chainCallbacksOpt, ActorSystem system) {
        Promise walletCallbackP = Promise$.MODULE$.apply();
        NodeApi nodeApi = this.buildBitcoindNodeApi(bitcoind, (Future<WalletApi>)walletCallbackP.future(), chainCallbacksOpt, system);
        Wallet pairedWallet = Wallet$.MODULE$.apply(nodeApi, (ChainQueryApi)bitcoind, wallet.feeRateApi(), wallet.walletConfig());
        walletCallbackP.success((Object)pairedWallet);
        return pairedWallet;
    }

    public void startZMQWalletCallbacks(WalletApi wallet, ZmqConfig zmqConfig) {
        ZmqConfig zmqConfig2 = zmqConfig;
        ZmqConfig zmqConfig3 = ZmqConfig$.MODULE$.empty();
        Predef$.MODULE$.require(zmqConfig2 == null ? zmqConfig3 != null : !zmqConfig2.equals(zmqConfig3), (Function0 & Serializable & scala.Serializable)() -> "Must have the zmq raw configs defined to setup ZMQ callbacks");
        zmqConfig.rawTx().foreach((Function1 & Serializable & scala.Serializable)zmq -> {
            BitcoindRpcBackendUtil$.$anonfun$startZMQWalletCallbacks$2(wallet, zmq);
            return BoxedUnit.UNIT;
        });
        zmqConfig.rawBlock().foreach((Function1 & Serializable & scala.Serializable)zmq -> {
            BitcoindRpcBackendUtil$.$anonfun$startZMQWalletCallbacks$5(wallet, zmq);
            return BoxedUnit.UNIT;
        });
    }

    public DLCWallet createDLCWalletWithBitcoindCallbacks(BitcoindRpcClient bitcoind, DLCWallet wallet, Option<ChainCallbacks> chainCallbacksOpt, ActorSystem system) {
        Promise walletCallbackP = Promise$.MODULE$.apply();
        DLCWallet pairedWallet = DLCWallet$.MODULE$.apply(this.buildBitcoindNodeApi(bitcoind, (Future<WalletApi>)walletCallbackP.future(), chainCallbacksOpt, system), (ChainQueryApi)bitcoind, wallet.feeRateApi(), wallet.walletConfig(), wallet.dlcConfig());
        walletCallbackP.success((Object)pairedWallet);
        return pairedWallet;
    }

    private Sink<DoubleSha256Digest, Future<NeutrinoHDWalletApi>> filterSyncSink(V19BlockFilterRpc bitcoindRpcClient, NeutrinoHDWalletApi wallet, ActorSystem system) {
        int numParallelism = FutureUtil$.MODULE$.getParallelism();
        Sink sink = ((Flow)Flow$.MODULE$.apply().mapAsync(numParallelism, (Function1 & Serializable & scala.Serializable)hash -> bitcoindRpcClient.getBlockFilter(hash.flip(), (FilterType)FilterType.Basic$.MODULE$).map((Function1 & Serializable & scala.Serializable)res -> new Tuple2(hash, (Object)res.filter()), (ExecutionContext)system.dispatcher())).batch(1000L, (Function1 & Serializable & scala.Serializable)filter -> (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{filter})), (Function2 & Serializable & scala.Serializable)(x$15, x$16) -> (Vector)x$15.$colon$plus(x$16, Vector$.MODULE$.canBuildFrom())).foldAsync((Object)wallet, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NeutrinoHDWalletApi wallet = (NeutrinoHDWalletApi)tuple2._1();
            Vector filterRes = (Vector)tuple2._2();
            Future future = wallet.processCompactFilters(filterRes);
            return future;
        })).toMat((Graph)Sink$.MODULE$.last(), Keep$.MODULE$.right());
        return sink;
    }

    public NodeApi buildBitcoindNodeApi(BitcoindRpcClient bitcoindRpcClient, Future<WalletApi> walletF, Option<ChainCallbacks> chainCallbacksOpt, ActorSystem system) {
        return new NodeApi(bitcoindRpcClient, system, walletF, chainCallbacksOpt){
            private final BitcoindRpcClient bitcoindRpcClient$2;
            private final ActorSystem system$4;
            private final Future walletF$1;
            private final Option chainCallbacksOpt$3;

            public Future<BoxedUnit> broadcastTransaction(Transaction transaction) {
                return NodeApi.broadcastTransaction$((NodeApi)this, (Transaction)transaction);
            }

            public Future<BoxedUnit> downloadBlocks(Vector<DoubleSha256Digest> blockHashes) {
                BitcoindRpcBackendUtil$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Fetching ").append(blockHashes.length()).append(" blocks from bitcoind").toString());
                int numParallelism = FutureUtil$.MODULE$.getParallelism();
                Source source = Source$.MODULE$.apply(blockHashes);
                Flow fetchBlocksFlow = BitcoindStreamUtil$.MODULE$.fetchBlocksBitcoind(this.bitcoindRpcClient$2, numParallelism, (ExecutionContext)this.system$4.dispatcher());
                Future sinkF = this.walletF$1.map((Function1 & Serializable & scala.Serializable)initWallet -> Sink$.MODULE$.foldAsync(initWallet, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Future executeCallbackF;
                    Block block;
                    GetBlockHeaderResult blockHeaderResult;
                    WalletApi walletApi;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 == null) break block2;
                            WalletApi wallet2 = (WalletApi)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (wallet2 == null) break block2;
                            walletApi = wallet2;
                            if (tuple22 == null) break block2;
                            Block block2 = (Block)tuple22._1();
                            blockHeaderResult = (GetBlockHeaderResult)tuple22._2();
                            if (block2 == null) break block2;
                            block = block2;
                            if (blockHeaderResult != null) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    GetBlockHeaderResult getBlockHeaderResult = blockHeaderResult;
                    Future blockProcessedF = walletApi.processBlock(block);
                    Future future = executeCallbackF = blockProcessedF.flatMap((Function1 & Serializable & scala.Serializable)wallet -> BitcoindRpcBackendUtil$.MODULE$.org$bitcoins$server$BitcoindRpcBackendUtil$$handleChainCallbacks((Option<ChainCallbacks>)$this.chainCallbacksOpt$3, getBlockHeaderResult, (ExecutionContext)$this.system$4.dispatcher()).map((Function1 & Serializable & scala.Serializable)_ -> wallet, (ExecutionContext)$this.system$4.dispatcher()), (ExecutionContext)$this.system$4.dispatcher());
                    return future;
                }), (ExecutionContext)this.system$4.dispatcher());
                Future doneF = sinkF.flatMap((Function1 & Serializable & scala.Serializable)sink -> (Future)source.via((Graph)fetchBlocksFlow).toMat((Graph)sink, Keep$.MODULE$.right()).run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system$4)), (ExecutionContext)this.system$4.dispatcher());
                return doneF.flatMap((Function1 & Serializable & scala.Serializable)w -> w.updateUtxoPendingStates().map((Function1 & Serializable & scala.Serializable)_ -> {
                    anon.1.$anonfun$downloadBlocks$8(_);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)$this.system$4.dispatcher()), (ExecutionContext)this.system$4.dispatcher());
            }

            public Future<BoxedUnit> broadcastTransactions(Vector<Transaction> transactions) {
                return this.bitcoindRpcClient$2.broadcastTransactions(transactions);
            }

            public static final /* synthetic */ void $anonfun$downloadBlocks$8(Vector _) {
            }
            {
                this.bitcoindRpcClient$2 = bitcoindRpcClient$2;
                this.system$4 = system$4;
                this.walletF$1 = walletF$1;
                this.chainCallbacksOpt$3 = chainCallbacksOpt$3;
                NodeApi.$init$((NodeApi)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$downloadBlocks$1(scala.collection.immutable.Vector ), $anonfun$downloadBlocks$2(org.bitcoins.server.BitcoindRpcBackendUtil$$anon$1 org.bitcoins.core.api.wallet.WalletApi ), $anonfun$downloadBlocks$6(org.bitcoins.server.BitcoindRpcBackendUtil$$anon$1 akka.stream.scaladsl.Source akka.stream.scaladsl.Flow akka.stream.scaladsl.Sink ), $anonfun$downloadBlocks$7(org.bitcoins.server.BitcoindRpcBackendUtil$$anon$1 org.bitcoins.core.api.wallet.WalletApi ), $anonfun$downloadBlocks$5(org.bitcoins.core.api.wallet.WalletApi scala.runtime.BoxedUnit ), $anonfun$downloadBlocks$4(org.bitcoins.server.BitcoindRpcBackendUtil$$anon$1 org.bitcoins.commons.jsonmodels.bitcoind.GetBlockHeaderResult org.bitcoins.core.api.wallet.WalletApi ), $anonfun$downloadBlocks$3(org.bitcoins.server.BitcoindRpcBackendUtil$$anon$1 org.bitcoins.core.api.wallet.WalletApi scala.Tuple2 ), $anonfun$downloadBlocks$8$adapted(scala.collection.immutable.Vector )}, serializedLambda);
            }
        };
    }

    public Future<BoxedUnit> org$bitcoins$server$BitcoindRpcBackendUtil$$handleChainCallbacks(Option<ChainCallbacks> chainCallbacksOpt, GetBlockHeaderResult blockHeaderResult, ExecutionContext ec) {
        Future future;
        Option<ChainCallbacks> option = chainCallbacksOpt;
        if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.unit();
        } else if (option instanceof Some) {
            Future f;
            Some some = (Some)option;
            ChainCallbacks callback = (ChainCallbacks)some.value();
            Vector headerWithHeights = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)blockHeaderResult.height()), (Object)blockHeaderResult.blockHeader())}));
            future = f = callback.executeOnBlockHeaderConnectedCallbacks(headerWithHeights, ec);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    public Cancellable startBitcoindBlockPolling(WalletApi wallet, BitcoindRpcClient bitcoind, Option<ChainCallbacks> chainCallbacksOpt, FiniteDuration interval, ActorSystem system) {
        AtomicBoolean processingBitcoindBlocks = new AtomicBoolean(false);
        return system.scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), interval, () -> {
            Future<Object> isBitcoindSyncedF = MODULE$.isBitcoindInSync(bitcoind, (ExecutionContext)system.dispatcher());
            isBitcoindSyncedF.map((Function1 & Serializable & scala.Serializable)isBitcoindSynced -> {
                BitcoindRpcBackendUtil$.$anonfun$startBitcoindBlockPolling$2(processingBitcoindBlocks, wallet, bitcoind, chainCallbacksOpt, system, BoxesRunTime.unboxToBoolean((Object)isBitcoindSynced));
                return BoxedUnit.UNIT;
            }, (ExecutionContext)system.dispatcher());
        }, (ExecutionContext)system.dispatcher());
    }

    public FiniteDuration startBitcoindBlockPolling$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds();
    }

    private Future<Option<Future<Done>>> pollBitcoind(WalletApi wallet, BitcoindRpcClient bitcoind, Option<ChainCallbacks> chainCallbacksOpt, int prevCount, ActorSystem system) {
        AtomicInteger atomicPrevCount = new AtomicInteger(prevCount);
        Source queueSource = Source$.MODULE$.queue(100);
        int numParallelism = FutureUtil$.MODULE$.getParallelism();
        Flow fetchBlocksFlow = BitcoindStreamUtil$.MODULE$.fetchBlocksBitcoind(bitcoind, numParallelism, (ExecutionContext)system.dispatcher());
        Sink processBlockSink = Sink$.MODULE$.foreachAsync(1, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Block block = (Block)tuple2._1();
            GetBlockHeaderResult blockHeaderResult = (GetBlockHeaderResult)tuple2._2();
            Future processBlocksF = wallet.processBlock(block);
            processBlocksF.failed().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BitcoindRpcBackendUtil$.$anonfun$pollBitcoind$2(atomicPrevCount, prevCount, x0$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)system.dispatcher());
            Future future = processBlocksF.flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.org$bitcoins$server$BitcoindRpcBackendUtil$$handleChainCallbacks(chainCallbacksOpt, blockHeaderResult, (ExecutionContext)system.dispatcher()).map((Function1 & Serializable & scala.Serializable)_ -> {
                BitcoindRpcBackendUtil$.$anonfun$pollBitcoind$6(_);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)system.dispatcher()), (ExecutionContext)system.dispatcher());
            return future;
        });
        Sink fetchAndProcessBlockSink = fetchBlocksFlow.toMat((Graph)processBlockSink, Keep$.MODULE$.right());
        Tuple2 tuple2 = (Tuple2)((Source)queueSource.mapAsync(numParallelism, (Function1 & Serializable & scala.Serializable)height -> BitcoindRpcBackendUtil$.$anonfun$pollBitcoind$7(bitcoind, system, BoxesRunTime.unboxToInt((Object)height))).map((Function1 & Serializable & scala.Serializable)hash -> {
            int _ = atomicPrevCount.incrementAndGet();
            return hash;
        })).toMat((Graph)fetchAndProcessBlockSink, Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BoundedSourceQueue queue = (BoundedSourceQueue)tuple2._1();
        Future doneF = (Future)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)queue, (Object)doneF);
        Tuple2 tuple23 = tuple22;
        BoundedSourceQueue queue2 = (BoundedSourceQueue)tuple23._1();
        Future doneF2 = (Future)tuple23._2();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Polling bitcoind for block count");
        Future resF = bitcoind.getBlockCount().flatMap((Function1 & Serializable & scala.Serializable)count -> BitcoindRpcBackendUtil$.$anonfun$pollBitcoind$11(prevCount, bitcoind, chainCallbacksOpt, system, queue2, BoxesRunTime.unboxToInt((Object)count)), (ExecutionContext)system.dispatcher());
        return resF.map((Function1 & Serializable & scala.Serializable)x$21 -> new Some((Object)doneF2), (ExecutionContext)system.dispatcher());
    }

    public Cancellable startBitcoindMempoolPolling(WalletApi wallet, BitcoindRpcClient bitcoind, FiniteDuration interval, Function1<Transaction, Future<BoxedUnit>> processTx, ActorSystem system, ExecutionContext ec) {
        VolatileObjectRef prevMempool = VolatileObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        AtomicBoolean processingMempool = new AtomicBoolean(false);
        return system.scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), interval, () -> {
            Future f = wallet.isRescanning().flatMap((Function1 & Serializable & scala.Serializable)rescanning -> BitcoindRpcBackendUtil$.$anonfun$startBitcoindMempoolPolling$13(this, ec, processingMempool, processTx, bitcoind, system, prevMempool, BoxesRunTime.unboxToBoolean((Object)rescanning)), ec);
            f.failed().foreach((Function1 & Serializable & scala.Serializable)err -> {
                BitcoindRpcBackendUtil$.$anonfun$startBitcoindMempoolPolling$16(err);
                return BoxedUnit.UNIT;
            }, ec);
        }, ec);
    }

    public FiniteDuration startBitcoindMempoolPolling$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds();
    }

    private Future<Object> isBitcoindInSync(BitcoindRpcClient bitcoind, ExecutionContext ec) {
        return bitcoind.getBlockChainInfo().map((Function1 & Serializable & scala.Serializable)blockchainInfo -> BoxesRunTime.boxToBoolean((boolean)BitcoindRpcBackendUtil$.$anonfun$isBitcoindInSync$1(blockchainInfo)), ec);
    }

    public static final /* synthetic */ Future $anonfun$syncWalletToBitcoind$3(NeutrinoHDWalletApi wallet$1, BitcoindRpcClient bitcoind$1, ActorSystem system$1, int bitcoindHeight) {
        return wallet$1.getSyncDescriptorOpt().flatMap((Function1 & Serializable & scala.Serializable)walletStateOpt -> {
            Future future;
            Option option = walletStateOpt;
            if (None$.MODULE$.equals(option)) {
                future = MODULE$.getHeightRangeNoWalletState(wallet$1, bitcoind$1, bitcoindHeight, (ExecutionContext)system$1.dispatcher());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                SyncHeightDescriptor walletState = (SyncHeightDescriptor)some.value();
                Range range = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(walletState.height()), bitcoindHeight).tail();
                future = Future$.MODULE$.successful((Object)range);
            } else {
                throw new MatchError((Object)option);
            }
            return future.map((Function1 & Serializable & scala.Serializable)heightRange -> {
                MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Syncing from bitcoind with bitcoindHeight=").append(bitcoindHeight).append(" walletHeight=").append(heightRange.start()).toString());
                BoxedUnit x$1 = BoxedUnit.UNIT;
                return new Tuple2(heightRange, (Object)x$1);
            }, (ExecutionContext)system$1.dispatcher()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Range heightRange = (Range)tuple2._1();
                Future future = MODULE$.buildBitcoindSyncSink(bitcoind$1, wallet$1, system$1).map((Function1 & Serializable & scala.Serializable)syncFlow -> {
                    RunnableGraph stream = Source$.MODULE$.apply((Iterable)heightRange).toMat((Graph)syncFlow, Keep$.MODULE$.right());
                    return new Tuple2(syncFlow, (Object)stream);
                }, (ExecutionContext)system$1.dispatcher()).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                    RunnableGraph stream;
                    Tuple2 tuple2 = x$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    RunnableGraph runnableGraph = stream = (RunnableGraph)tuple2._2();
                    return runnableGraph;
                }, (ExecutionContext)system$1.dispatcher());
                return future;
            }, (ExecutionContext)system$1.dispatcher());
        }, (ExecutionContext)system$1.dispatcher());
    }

    public static final /* synthetic */ Future $anonfun$syncWalletToBitcoind$12(BitcoindRpcClient bitcoind$1, Option chainCallbacksOpt$1, ActorSystem system$1, boolean isBitcoindInSync) {
        Future<BoxedUnit> future;
        if (isBitcoindInSync) {
            future = MODULE$.setSyncingFlag(false, bitcoind$1, (Option<ChainCallbacks>)chainCallbacksOpt$1, (ExecutionContext)system$1.dispatcher());
        } else {
            MODULE$.logger().warn((Function0 & Serializable & scala.Serializable)() -> "We synced against bitcoind, but bitcoind is not in sync with the network.");
            future = Future$.MODULE$.unit();
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$syncWalletToBitcoind$14(NeutrinoHDWalletApi x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$getHeightRangeNoWalletState$2(TransactionDb x$6) {
        return x$6.blockHashOpt().isDefined();
    }

    public static final /* synthetic */ void $anonfun$setSyncingFlag$4(BoxedUnit _) {
    }

    public static final /* synthetic */ Future $anonfun$setSyncingFlag$1(BitcoindRpcClient bitcoind$3, boolean syncing$1, Option chainCallbacksOpt$2, ExecutionContext ec$1, boolean oldFlag) {
        return bitcoind$3.setSyncing(syncing$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
            Future future;
            if (oldFlag != syncing$1) {
                Future future2;
                Option executeCallbackOpt = chainCallbacksOpt$2.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.executeOnSyncFlagChanged(syncing$1, ec$1));
                Option option = executeCallbackOpt;
                if (option instanceof Some) {
                    Future f;
                    Some some = (Some)option;
                    future2 = f = (Future)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    future2 = Future$.MODULE$.unit();
                } else {
                    throw new MatchError((Object)option);
                }
                future = future2;
            } else {
                future = Future$.MODULE$.unit();
            }
            return future.map((Function1 & Serializable & scala.Serializable)_ -> {
                BitcoindRpcBackendUtil$.$anonfun$setSyncingFlag$4(_);
                return BoxedUnit.UNIT;
            }, ec$1);
        }, ec$1);
    }

    public static final /* synthetic */ boolean $anonfun$buildBitcoindSyncSink$2(Option x$9) {
        return true;
    }

    public static final /* synthetic */ Sink $anonfun$buildBitcoindSyncSink$3(BitcoindRpcClient bitcoind$4, NeutrinoHDWalletApi wallet$2, ActorSystem system$2, boolean hasFilters) {
        return hasFilters ? MODULE$.filterSyncSink((V19BlockFilterRpc)bitcoind$4, wallet$2, system$2) : ((Flow)Flow$.MODULE$.apply().batch(100L, (Function1 & Serializable & scala.Serializable)hash -> (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DoubleSha256Digest[]{hash})), (Function2 & Serializable & scala.Serializable)(x$10, x$11) -> (Vector)x$10.$colon$plus(x$11, Vector$.MODULE$.canBuildFrom())).mapAsync(1, (Function1 & Serializable & scala.Serializable)x$12 -> wallet$2.nodeApi().downloadBlocks(x$12).map((Function1 & Serializable & scala.Serializable)x$13 -> wallet$2, (ExecutionContext)system$2.dispatcher()))).toMat((Graph)Sink$.MODULE$.last(), Keep$.MODULE$.right());
    }

    public static final /* synthetic */ Future $anonfun$buildBitcoindSyncSink$8(BitcoindRpcClient bitcoind$4, ActorSystem system$2, int x0$1) {
        int n = x0$1;
        Future future = bitcoind$4.getBlockHash(n).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.flip(), (ExecutionContext)system$2.dispatcher());
        return future;
    }

    public static final /* synthetic */ void $anonfun$startZMQWalletCallbacks$3(WalletApi wallet$3, Transaction tx) {
        MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Received tx ").append(tx.txIdBE().hex()).append(", processing").toString());
        wallet$3.processTransaction(tx, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$startZMQWalletCallbacks$2(WalletApi wallet$3, InetSocketAddress zmq) {
        Some rawTxListener = new Some((Function1 & Serializable & scala.Serializable)tx -> {
            BitcoindRpcBackendUtil$.$anonfun$startZMQWalletCallbacks$3(wallet$3, tx);
            return BoxedUnit.UNIT;
        });
        new ZMQSubscriber(zmq, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)rawTxListener, (Option)None$.MODULE$).start();
    }

    public static final /* synthetic */ void $anonfun$startZMQWalletCallbacks$6(WalletApi wallet$3, Block block) {
        MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Received block ").append(block.blockHeader().hashBE().hex()).append(", processing").toString());
        wallet$3.processBlock(block);
    }

    public static final /* synthetic */ void $anonfun$startZMQWalletCallbacks$5(WalletApi wallet$3, InetSocketAddress zmq) {
        Some rawBlockListener = new Some((Function1 & Serializable & scala.Serializable)block -> {
            BitcoindRpcBackendUtil$.$anonfun$startZMQWalletCallbacks$6(wallet$3, block);
            return BoxedUnit.UNIT;
        });
        new ZMQSubscriber(zmq, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)rawBlockListener).start();
    }

    public static final /* synthetic */ Future $anonfun$startBitcoindBlockPolling$5(WalletApi wallet$5, BitcoindRpcClient bitcoind$5, Option chainCallbacksOpt$4, BlockSyncState walletSyncState$1, ActorSystem system$5, boolean rescanning) {
        Future future;
        if (!rescanning) {
            Future<Option<Future<Done>>> pollFOptF = MODULE$.pollBitcoind(wallet$5, bitcoind$5, (Option<ChainCallbacks>)chainCallbacksOpt$4, walletSyncState$1.height(), system$5);
            future = pollFOptF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Future future;
                Option option = x0$1;
                if (option instanceof Some) {
                    Future pollF;
                    Some some = (Some)option;
                    future = pollF = (Future)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    future = Future$.MODULE$.unit();
                } else {
                    throw new MatchError((Object)option);
                }
                return future;
            }, (ExecutionContext)system$5.dispatcher());
        } else {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> "Skipping scanning the blockchain during wallet rescan");
            future = Future$.MODULE$.unit();
        }
        return future.map((Function1 & Serializable & scala.Serializable)res -> res, (ExecutionContext)system$5.dispatcher());
    }

    public static final /* synthetic */ void $anonfun$startBitcoindBlockPolling$10(Throwable err) {
        MODULE$.logger().error((Function0 & Serializable & scala.Serializable)() -> "Failed to poll bitcoind", (Function0 & Serializable & scala.Serializable)() -> err);
    }

    public static final /* synthetic */ void $anonfun$startBitcoindBlockPolling$2(AtomicBoolean processingBitcoindBlocks$1, WalletApi wallet$5, BitcoindRpcClient bitcoind$5, Option chainCallbacksOpt$4, ActorSystem system$5, boolean isBitcoindSynced) {
        if (!isBitcoindSynced) {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> "Bitcoind is not synced, waiting for IBD to complete.");
        } else if (processingBitcoindBlocks$1.compareAndSet(false, true)) {
            Future f = wallet$5.getSyncState().flatMap((Function1 & Serializable & scala.Serializable)walletSyncState -> wallet$5.isRescanning().flatMap((Function1 & Serializable & scala.Serializable)rescanning -> BitcoindRpcBackendUtil$.$anonfun$startBitcoindBlockPolling$5(wallet$5, bitcoind$5, chainCallbacksOpt$4, walletSyncState, system$5, BoxesRunTime.unboxToBoolean((Object)rescanning)), (ExecutionContext)system$5.dispatcher()), (ExecutionContext)system$5.dispatcher());
            f.onComplete((Function1 & Serializable & scala.Serializable)x$17 -> {
                processingBitcoindBlocks$1.set(false);
                return MODULE$.setSyncingFlag(false, bitcoind$5, (Option<ChainCallbacks>)chainCallbacksOpt$4, (ExecutionContext)system$5.dispatcher());
            }, (ExecutionContext)system$5.dispatcher());
            f.failed().foreach((Function1 & Serializable & scala.Serializable)err -> {
                BitcoindRpcBackendUtil$.$anonfun$startBitcoindBlockPolling$10(err);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)system$5.dispatcher());
        } else {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> "Previous bitcoind polling still running");
        }
    }

    public static final /* synthetic */ void $anonfun$pollBitcoind$2(AtomicInteger atomicPrevCount$1, int prevCount$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        int failedCount = atomicPrevCount$1.get();
        atomicPrevCount$1.set(prevCount$1);
        MODULE$.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Processing blocks from bitcoind polling failed, range=[").append(prevCount$1).append(", ").append(failedCount).append("]").toString(), (Function0 & Serializable & scala.Serializable)() -> throwable);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$pollBitcoind$6(BoxedUnit _) {
    }

    public static final /* synthetic */ Future $anonfun$pollBitcoind$7(BitcoindRpcClient bitcoind$6, ActorSystem system$6, int height) {
        return bitcoind$6.getBlockHash(height).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.flip(), (ExecutionContext)system$6.dispatcher());
    }

    public static final /* synthetic */ void $anonfun$pollBitcoind$13(int prevCount$1, int count$1, BoundedSourceQueue queue$1, BoxedUnit x$20) {
        Range range = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(prevCount$1), count$1).tail();
        range.foreach((Function1 & Serializable & scala.Serializable)r -> queue$1.offer((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)r))));
    }

    public static final /* synthetic */ Future $anonfun$pollBitcoind$11(int prevCount$1, BitcoindRpcClient bitcoind$6, Option chainCallbacksOpt$5, ActorSystem system$6, BoundedSourceQueue queue$1, int count) {
        Future future;
        if (prevCount$1 < count) {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Bitcoind has new block(s), requesting... ").append(count - prevCount$1).append(" blocks").toString());
            Future<BoxedUnit> setSyncFlagF = MODULE$.setSyncingFlag(true, bitcoind$6, (Option<ChainCallbacks>)chainCallbacksOpt$5, (ExecutionContext)system$6.dispatcher());
            future = setSyncFlagF.map((Function1 & Serializable & scala.Serializable)x$20 -> {
                BitcoindRpcBackendUtil$.$anonfun$pollBitcoind$13(prevCount$1, count, queue$1, x$20);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)system$6.dispatcher());
        } else if (prevCount$1 > count) {
            future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(55).append("Bitcoind is at a block height (").append(count).append(") before the wallet's (").append(prevCount$1).append(")").toString()));
        } else {
            MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("In sync ").append(prevCount$1).append(" count=").append(count).toString());
            future = Future$.MODULE$.unit();
        }
        return future.map((Function1 & Serializable & scala.Serializable)retval -> {
            queue$1.complete();
            return BoxedUnit.UNIT;
        }, (ExecutionContext)system$6.dispatcher());
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized Set getDiffAndReplace$1(Set newMempool, VolatileObjectRef prevMempool$1) {
        void var3_3;
        Set txids = (Set)newMempool.diff((GenSet)((Set)prevMempool$1.elem));
        prevMempool$1.elem = newMempool;
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$startBitcoindMempoolPolling$8(Set newTxIds$2, Done _) {
        MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Done processing ").append(newTxIds$2.size()).append(" new mempool transactions").toString());
    }

    private final Future pollMempool$1(AtomicBoolean processingMempool$1, Function1 processTx$1, BitcoindRpcClient bitcoind$7, ExecutionContext ec$2, ActorSystem system$7, VolatileObjectRef prevMempool$1) {
        Future future;
        if (processingMempool$1.compareAndSet(false, true)) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Polling bitcoind for mempool");
            int numParallelism = FutureUtil$.MODULE$.getParallelism();
            Sink processTxFlow = Sink$.MODULE$.foreachAsync(1, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                Future future;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Transaction tx = (Transaction)some.value();
                    future = (Future)processTx$1.apply((Object)tx);
                } else if (None$.MODULE$.equals(option)) {
                    future = Future$.MODULE$.unit();
                } else {
                    throw new MatchError((Object)option);
                }
                return future;
            });
            Future res = bitcoind$7.getRawMemPool().map((Function1 & Serializable & scala.Serializable)mempool -> {
                Set newTxIds = this.getDiffAndReplace$1(mempool.toSet(), prevMempool$1);
                MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Found ").append(newTxIds.size()).append(" new mempool transactions").toString());
                BoxedUnit x$23 = BoxedUnit.UNIT;
                return new Tuple3(mempool, (Object)newTxIds, (Object)x$23);
            }, ec$2).flatMap((Function1 & Serializable & scala.Serializable)x$24 -> {
                Tuple3 tuple3 = x$24;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Set newTxIds = (Set)tuple3._2();
                Future future = ((Future)((Source)Source$.MODULE$.apply((Iterable)newTxIds).mapAsync(numParallelism, (Function1 & Serializable & scala.Serializable)txid -> bitcoind$7.getRawTransactionRaw(txid, bitcoind$7.getRawTransactionRaw$default$2()).map((Function1 & Serializable & scala.Serializable)x$22 -> Option$.MODULE$.apply(x$22), ec$2).recover((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = A1 != null ? None$.MODULE$ : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable != null;
                        return bl;
                    }
                }, ec$2))).toMat((Graph)processTxFlow, Keep$.MODULE$.right()).run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system$7))).map((Function1 & Serializable & scala.Serializable)_ -> {
                    BitcoindRpcBackendUtil$.$anonfun$startBitcoindMempoolPolling$8(newTxIds, _);
                    return BoxedUnit.UNIT;
                }, ec$2);
                return future;
            }, ec$2);
            res.onComplete((Function1 & Serializable & scala.Serializable)x$25 -> {
                processingMempool$1.set(false);
                return BoxedUnit.UNIT;
            }, ec$2);
            future = res;
        } else {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Skipping scanning the mempool since a previously scheduled task is still running");
            future = Future$.MODULE$.unit();
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$startBitcoindMempoolPolling$15(BoxedUnit res) {
    }

    public static final /* synthetic */ Future $anonfun$startBitcoindMempoolPolling$13(BitcoindRpcBackendUtil$ $this, ExecutionContext ec$2, AtomicBoolean processingMempool$1, Function1 processTx$1, BitcoindRpcClient bitcoind$7, ActorSystem system$7, VolatileObjectRef prevMempool$1, boolean rescanning) {
        Future future;
        if (!rescanning) {
            future = $this.pollMempool$1(processingMempool$1, processTx$1, bitcoind$7, ec$2, system$7, prevMempool$1);
        } else {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> "Skipping scanning the mempool during wallet rescan");
            future = Future$.MODULE$.unit();
        }
        return future.map((Function1 & Serializable & scala.Serializable)res -> {
            BitcoindRpcBackendUtil$.$anonfun$startBitcoindMempoolPolling$15(res);
            return BoxedUnit.UNIT;
        }, ec$2);
    }

    public static final /* synthetic */ void $anonfun$startBitcoindMempoolPolling$16(Throwable err) {
        MODULE$.logger().error((Function0 & Serializable & scala.Serializable)() -> "Failed to poll mempool", (Function0 & Serializable & scala.Serializable)() -> err);
    }

    public static final /* synthetic */ boolean $anonfun$isBitcoindInSync$1(GetBlockChainInfoResult blockchainInfo) {
        return blockchainInfo.headers() == blockchainInfo.blocks();
    }

    private BitcoindRpcBackendUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

