/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.server.util;

import akka.stream.QueueOfferResult;
import akka.stream.scaladsl.SourceQueueWithComplete;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.bitcoins.chain.ChainCallbacks;
import org.bitcoins.chain.ChainCallbacks$;
import org.bitcoins.chain.OnBlockHeaderConnected;
import org.bitcoins.chain.OnSyncFlagChanged;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.commons.jsonmodels.bitcoind.GetBlockHeaderResult;
import org.bitcoins.commons.jsonmodels.ws.ChainNotification;
import org.bitcoins.commons.jsonmodels.ws.TorNotification;
import org.bitcoins.commons.jsonmodels.ws.WalletNotification;
import org.bitcoins.commons.jsonmodels.ws.WalletWsType;
import org.bitcoins.commons.jsonmodels.ws.WsNotification;
import org.bitcoins.core.api.chain.ChainApi;
import org.bitcoins.core.protocol.blockchain.BlockHeader;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.util.FutureUtil$;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.dlc.wallet.DLCWalletCallbacks;
import org.bitcoins.dlc.wallet.DLCWalletCallbacks$;
import org.bitcoins.dlc.wallet.OnDLCOfferAdd;
import org.bitcoins.dlc.wallet.OnDLCOfferRemove;
import org.bitcoins.dlc.wallet.OnDLCStateChange;
import org.bitcoins.server.util.ChainUtil$;
import org.bitcoins.tor.OnTorStarted;
import org.bitcoins.tor.TorCallbacks;
import org.bitcoins.tor.TorCallbacks$;
import org.bitcoins.wallet.OnFeeRateChanged;
import org.bitcoins.wallet.OnNewAddressGenerated;
import org.bitcoins.wallet.OnRescanComplete;
import org.bitcoins.wallet.OnReservedUtxos;
import org.bitcoins.wallet.OnTransactionBroadcast;
import org.bitcoins.wallet.OnTransactionProcessed;
import org.bitcoins.wallet.WalletCallbacks;
import org.bitcoins.wallet.WalletCallbacks$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WebsocketUtil$
implements Logging {
    public static WebsocketUtil$ MODULE$;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new WebsocketUtil$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WebsocketUtil$ websocketUtil$ = this;
        synchronized (websocketUtil$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ChainCallbacks buildChainCallbacks(SourceQueueWithComplete<WsNotification<?>> queue, ChainApi chainApi, ExecutionContext ec, ChainAppConfig chainAppConfig) {
        OnBlockHeaderConnected onBlockProcessed = x0$1 -> {
            Vector vector = x0$1;
            if (vector == null) {
                throw new MatchError((Object)vector);
            }
            Vector vector2 = vector;
            Vector hashes = (Vector)vector2.map((Function1 & Serializable & scala.Serializable)x$1 -> ((BlockHeader)x$1._2()).hashBE(), Vector$.MODULE$.canBuildFrom());
            Future<Vector<GetBlockHeaderResult>> resultsF = ChainUtil$.MODULE$.getBlockHeaderResult((Vector<DoubleSha256DigestBE>)hashes, chainApi, ec);
            Future isIBDF = chainApi.isIBD();
            boolean emitBlockProccessedWhileIBDOnGoing = chainAppConfig.ibdBlockProcessedEvents();
            Future future = isIBDF.flatMap((Function1 & Serializable & scala.Serializable)isIBD -> WebsocketUtil$.$anonfun$buildChainCallbacks$3(emitBlockProccessedWhileIBDOnGoing, resultsF, ec, queue, BoxesRunTime.unboxToBoolean((Object)isIBD)), ec);
            return future;
        };
        OnSyncFlagChanged onSyncFlagChanged = syncing -> WebsocketUtil$.$anonfun$buildChainCallbacks$10(queue, ec, BoxesRunTime.unboxToBoolean((Object)syncing));
        return ChainCallbacks$.MODULE$.onBlockHeaderConnected(onBlockProcessed).$plus(ChainCallbacks$.MODULE$.onOnSyncFlagChanged(onSyncFlagChanged));
    }

    public WalletCallbacks buildWalletCallbacks(SourceQueueWithComplete<WsNotification<?>> walletQueue, String walletName, ExecutionContext ec) {
        OnNewAddressGenerated onAddressCreated = addr -> {
            WalletNotification.NewAddressNotification notification = new WalletNotification.NewAddressNotification(addr);
            Future offerF = walletQueue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$4 -> {
                WebsocketUtil$.$anonfun$buildWalletCallbacks$2(x$4);
                return BoxedUnit.UNIT;
            }, ec);
        };
        OnTransactionProcessed onTxProcessed = tx -> MODULE$.buildTxNotification((WalletWsType)WalletWsType.TxProcessed$.MODULE$, (Transaction)tx, walletQueue, ec);
        OnTransactionBroadcast onTxBroadcast = tx -> MODULE$.buildTxNotification((WalletWsType)WalletWsType.TxBroadcast$.MODULE$, (Transaction)tx, walletQueue, ec);
        OnReservedUtxos onReservedUtxo = utxos -> {
            WalletNotification.ReservedUtxosNotification notification = new WalletNotification.ReservedUtxosNotification(utxos);
            Future offerF = walletQueue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$5 -> {
                WebsocketUtil$.$anonfun$buildWalletCallbacks$6(x$5);
                return BoxedUnit.UNIT;
            }, ec);
        };
        OnRescanComplete onRescanComplete = x$6 -> {
            WalletNotification.RescanComplete notification = new WalletNotification.RescanComplete(walletName);
            Future offerF = walletQueue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$7 -> {
                WebsocketUtil$.$anonfun$buildWalletCallbacks$8(x$7);
                return BoxedUnit.UNIT;
            }, ec);
        };
        OnFeeRateChanged onFeeRate = feeRate -> {
            WalletNotification.FeeRateChange notification = new WalletNotification.FeeRateChange(feeRate);
            Future offerF = walletQueue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$8 -> {
                WebsocketUtil$.$anonfun$buildWalletCallbacks$10(x$8);
                return BoxedUnit.UNIT;
            }, ec);
        };
        return WalletCallbacks$.MODULE$.apply((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OnTransactionProcessed[]{onTxProcessed})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OnTransactionBroadcast[]{onTxBroadcast})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OnReservedUtxos[]{onReservedUtxo})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OnNewAddressGenerated[]{onAddressCreated})), package$.MODULE$.Vector().empty(), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OnRescanComplete[]{onRescanComplete})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OnFeeRateChanged[]{onFeeRate})));
    }

    public TorCallbacks buildTorCallbacks(SourceQueueWithComplete<WsNotification<?>> queue, ExecutionContext ec) {
        OnTorStarted onTorStarted = x$9 -> {
            TorNotification.TorStartedNotification$ notification = TorNotification.TorStartedNotification$.MODULE$;
            Future offerF = queue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$10 -> {
                WebsocketUtil$.$anonfun$buildTorCallbacks$2(x$10);
                return BoxedUnit.UNIT;
            }, ec);
        };
        return TorCallbacks$.MODULE$.apply(onTorStarted);
    }

    private Future<BoxedUnit> buildTxNotification(WalletWsType wsType, Transaction tx, SourceQueueWithComplete<WsNotification<?>> walletQueue, ExecutionContext ec) {
        WalletNotification.TxProcessedNotification txProcessedNotification;
        WalletWsType walletWsType = wsType;
        if (WalletWsType.TxProcessed$.MODULE$.equals(walletWsType)) {
            txProcessedNotification = new WalletNotification.TxProcessedNotification(tx);
        } else if (WalletWsType.TxBroadcast$.MODULE$.equals(walletWsType)) {
            txProcessedNotification = new WalletNotification.TxBroadcastNotification(tx);
        } else {
            boolean bl = WalletWsType.NewAddress$.MODULE$.equals(walletWsType) ? true : (WalletWsType.ReservedUtxos$.MODULE$.equals(walletWsType) ? true : (WalletWsType.DLCStateChange$.MODULE$.equals(walletWsType) ? true : (WalletWsType.DLCOfferAdd$.MODULE$.equals(walletWsType) ? true : (WalletWsType.DLCOfferRemove$.MODULE$.equals(walletWsType) ? true : (WalletWsType.RescanComplete$.MODULE$.equals(walletWsType) ? true : WalletWsType.FeeRateChange$.MODULE$.equals(walletWsType))))));
            if (bl) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(33).append("Cannot build tx notification for ").append(walletWsType).toString());
            }
            throw new MatchError((Object)walletWsType);
        }
        WalletNotification.TxProcessedNotification notification = txProcessedNotification;
        Future offerF = walletQueue.offer((Object)notification);
        return offerF.map((Function1 & Serializable & scala.Serializable)x$11 -> {
            WebsocketUtil$.$anonfun$buildTxNotification$1(x$11);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public DLCWalletCallbacks buildDLCWalletCallbacks(SourceQueueWithComplete<WsNotification<?>> walletQueue, ExecutionContext ec) {
        OnDLCStateChange onStateChange = status -> {
            WalletNotification.DLCStateChangeNotification notification = new WalletNotification.DLCStateChangeNotification(status);
            Future offerF = walletQueue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$12 -> {
                WebsocketUtil$.$anonfun$buildDLCWalletCallbacks$2(x$12);
                return BoxedUnit.UNIT;
            }, ec);
        };
        OnDLCOfferAdd onOfferAdd = offerDb -> {
            WalletNotification.DLCOfferAddNotification notification = new WalletNotification.DLCOfferAddNotification(offerDb);
            Future offerF = walletQueue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$13 -> {
                WebsocketUtil$.$anonfun$buildDLCWalletCallbacks$4(x$13);
                return BoxedUnit.UNIT;
            }, ec);
        };
        OnDLCOfferRemove onOfferRemove = offerHash -> {
            WalletNotification.DLCOfferRemoveNotification notification = new WalletNotification.DLCOfferRemoveNotification(offerHash);
            Future offerF = walletQueue.offer((Object)notification);
            return offerF.map((Function1 & Serializable & scala.Serializable)x$14 -> {
                WebsocketUtil$.$anonfun$buildDLCWalletCallbacks$6(x$14);
                return BoxedUnit.UNIT;
            }, ec);
        };
        return DLCWalletCallbacks$.MODULE$.onDLCStateChange(onStateChange).$plus(DLCWalletCallbacks$.MODULE$.onDLCOfferAdd(onOfferAdd)).$plus(DLCWalletCallbacks$.MODULE$.onDLCOfferRemove(onOfferRemove));
    }

    public static final /* synthetic */ void $anonfun$buildChainCallbacks$8(QueueOfferResult x$2) {
    }

    public static final /* synthetic */ void $anonfun$buildChainCallbacks$9(Vector _) {
    }

    public static final /* synthetic */ Future $anonfun$buildChainCallbacks$3(boolean emitBlockProccessedWhileIBDOnGoing$1, Future resultsF$1, ExecutionContext ec$1, SourceQueueWithComplete queue$1, boolean isIBD) {
        Future f;
        return isIBD && !emitBlockProccessedWhileIBDOnGoing$1 ? Future$.MODULE$.unit() : (f = resultsF$1.map((Function1 & Serializable & scala.Serializable)results -> {
            Vector notifications = (Vector)results.map((Function1 & Serializable & scala.Serializable)result -> new ChainNotification.BlockProcessedNotification(result), Vector$.MODULE$.canBuildFrom());
            return new Tuple2(results, (Object)notifications);
        }, ec$1).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector notifications = (Vector)tuple2._2();
            Future future = FutureUtil$.MODULE$.sequentially((Iterable)notifications, (Function1 & Serializable & scala.Serializable)x0$2 -> {
                Future x;
                ChainNotification.BlockProcessedNotification blockProcessedNotification = x0$2;
                Future future = x = queue$1.offer((Object)blockProcessedNotification).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                    WebsocketUtil$.$anonfun$buildChainCallbacks$8(x$2);
                    return BoxedUnit.UNIT;
                }, ec$1);
                return future;
            }, ec$1).map((Function1 & Serializable & scala.Serializable)_ -> {
                WebsocketUtil$.$anonfun$buildChainCallbacks$9(_);
                return BoxedUnit.UNIT;
            }, ec$1);
            return future;
        }, ec$1));
    }

    public static final /* synthetic */ void $anonfun$buildChainCallbacks$11(QueueOfferResult _) {
    }

    public static final /* synthetic */ Future $anonfun$buildChainCallbacks$10(SourceQueueWithComplete queue$1, ExecutionContext ec$1, boolean syncing) {
        ChainNotification.SyncFlagChangedNotification notification = new ChainNotification.SyncFlagChangedNotification(syncing);
        return queue$1.offer((Object)notification).map((Function1 & Serializable & scala.Serializable)_ -> {
            WebsocketUtil$.$anonfun$buildChainCallbacks$11(_);
            return BoxedUnit.UNIT;
        }, ec$1);
    }

    public static final /* synthetic */ void $anonfun$buildWalletCallbacks$2(QueueOfferResult x$4) {
    }

    public static final /* synthetic */ void $anonfun$buildWalletCallbacks$6(QueueOfferResult x$5) {
    }

    public static final /* synthetic */ void $anonfun$buildWalletCallbacks$8(QueueOfferResult x$7) {
    }

    public static final /* synthetic */ void $anonfun$buildWalletCallbacks$10(QueueOfferResult x$8) {
    }

    public static final /* synthetic */ void $anonfun$buildTorCallbacks$2(QueueOfferResult x$10) {
    }

    public static final /* synthetic */ void $anonfun$buildTxNotification$1(QueueOfferResult x$11) {
    }

    public static final /* synthetic */ void $anonfun$buildDLCWalletCallbacks$2(QueueOfferResult x$12) {
    }

    public static final /* synthetic */ void $anonfun$buildDLCWalletCallbacks$4(QueueOfferResult x$13) {
    }

    public static final /* synthetic */ void $anonfun$buildDLCWalletCallbacks$6(QueueOfferResult x$14) {
    }

    private WebsocketUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

