/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.tools;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Date;
import java.util.TreeMap;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.CheckpointManager;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.listeners.NewBestBlockListener;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.tools.NetworkEnum;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.utils.Threading;

public class BuildCheckpoints {
    private static NetworkParameters params;

    public static void main(String[] args) throws Exception {
        InetAddress ipAddress;
        String suffix;
        BriefLogFormatter.initWithSilentBitcoinJ();
        OptionParser parser = new OptionParser();
        parser.accepts("help");
        ArgumentAcceptingOptionSpec netFlag = parser.accepts("net").withRequiredArg().ofType(NetworkEnum.class).defaultsTo((Object)NetworkEnum.MAIN, (Object[])new NetworkEnum[0]);
        parser.accepts("peer").withRequiredArg();
        ArgumentAcceptingOptionSpec daysFlag = parser.accepts("days").withRequiredArg().ofType(Integer.class).defaultsTo((Object)30, (Object[])new Integer[0]);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            System.out.println(Resources.toString((URL)BuildCheckpoints.class.getResource("build-checkpoints-help.txt"), (Charset)Charsets.UTF_8));
            return;
        }
        switch ((NetworkEnum)((Object)netFlag.value(options))) {
            case MAIN: 
            case PROD: {
                params = MainNetParams.get();
                suffix = "";
                break;
            }
            case TEST: {
                params = TestNet3Params.get();
                suffix = "-testnet";
                break;
            }
            case REGTEST: {
                params = RegTestParams.get();
                suffix = "-regtest";
                break;
            }
            default: {
                throw new RuntimeException("Unreachable.");
            }
        }
        if (options.has("peer")) {
            String peerFlag = (String)options.valueOf("peer");
            try {
                ipAddress = InetAddress.getByName(peerFlag);
            }
            catch (UnknownHostException e) {
                System.err.println("Could not understand peer domain name/IP address: " + peerFlag + ": " + e.getMessage());
                System.exit(1);
                return;
            }
        } else {
            ipAddress = InetAddress.getLocalHost();
        }
        PeerAddress peerAddress = new PeerAddress(ipAddress, params.getPort());
        final TreeMap<Integer, StoredBlock> checkpoints = new TreeMap<Integer, StoredBlock>();
        MemoryBlockStore store = new MemoryBlockStore(params);
        BlockChain chain = new BlockChain(params, (BlockStore)store);
        PeerGroup peerGroup = new PeerGroup(params, (AbstractBlockChain)chain);
        System.out.println("Connecting to " + peerAddress + "...");
        peerGroup.addAddress(peerAddress);
        long now = new Date().getTime() / 1000L;
        peerGroup.setFastCatchupTimeSecs(now);
        final long timeAgo = now - (long)(86400 * (Integer)options.valueOf((OptionSpec)daysFlag));
        System.out.println("Checkpointing up to " + Utils.dateTimeFormat((long)(timeAgo * 1000L)));
        chain.addNewBestBlockListener(Threading.SAME_THREAD, new NewBestBlockListener(){

            public void notifyNewBestBlock(StoredBlock block) throws VerificationException {
                int height = block.getHeight();
                if (height % params.getInterval() == 0 && block.getHeader().getTimeSeconds() <= timeAgo) {
                    System.out.println(String.format("Checkpointing block %s at height %d, time %s", block.getHeader().getHash(), block.getHeight(), Utils.dateTimeFormat((Date)block.getHeader().getTime())));
                    checkpoints.put(height, block);
                }
            }
        });
        peerGroup.start();
        peerGroup.downloadBlockChain();
        Preconditions.checkState((checkpoints.size() > 0 ? 1 : 0) != 0);
        File plainFile = new File("checkpoints" + suffix);
        File textFile = new File("checkpoints" + suffix + ".txt");
        BuildCheckpoints.writeBinaryCheckpoints(checkpoints, plainFile);
        BuildCheckpoints.writeTextualCheckpoints(checkpoints, textFile);
        peerGroup.stop();
        store.close();
        BuildCheckpoints.sanityCheck(plainFile, checkpoints.size());
        BuildCheckpoints.sanityCheck(textFile, checkpoints.size());
    }

    private static void writeBinaryCheckpoints(TreeMap<Integer, StoredBlock> checkpoints, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        MessageDigest digest = Sha256Hash.newDigest();
        DigestOutputStream digestOutputStream = new DigestOutputStream(fileOutputStream, digest);
        digestOutputStream.on(false);
        DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
        dataOutputStream.writeBytes("CHECKPOINTS 1");
        dataOutputStream.writeInt(0);
        digestOutputStream.on(true);
        dataOutputStream.writeInt(checkpoints.size());
        ByteBuffer buffer = ByteBuffer.allocate(96);
        for (StoredBlock block : checkpoints.values()) {
            block.serializeCompact(buffer);
            dataOutputStream.write(buffer.array());
            buffer.position(0);
        }
        dataOutputStream.close();
        Sha256Hash checkpointsHash = Sha256Hash.wrap((byte[])digest.digest());
        System.out.println("Hash of checkpoints data is " + checkpointsHash);
        digestOutputStream.close();
        fileOutputStream.close();
        System.out.println("Checkpoints written to '" + file.getCanonicalPath() + "'.");
    }

    private static void writeTextualCheckpoints(TreeMap<Integer, StoredBlock> checkpoints, File file) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.US_ASCII));
        writer.println("TXT CHECKPOINTS 1");
        writer.println("0");
        writer.println(checkpoints.size());
        ByteBuffer buffer = ByteBuffer.allocate(96);
        for (StoredBlock block : checkpoints.values()) {
            block.serializeCompact(buffer);
            writer.println(CheckpointManager.BASE64.encode(buffer.array()));
            buffer.position(0);
        }
        writer.close();
        System.out.println("Checkpoints written to '" + file.getCanonicalPath() + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sanityCheck(File file, int expectedSize) throws IOException {
        CheckpointManager manager;
        try (FileInputStream fis = new FileInputStream(file);){
            manager = new CheckpointManager(params, (InputStream)fis);
        }
        Preconditions.checkState((manager.numCheckpoints() == expectedSize ? 1 : 0) != 0);
        if (params.getId().equals("org.bitcoin.production")) {
            StoredBlock test = manager.getCheckpointBefore(1390500000L);
            Preconditions.checkState((test.getHeight() == 280224 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)test.getHeader().getHashAsString().equals("00000000000000000b5d59a15f831e1c45cb688a4db6b0a60054d49a9997fa34"));
        } else if (params.getId().equals("org.bitcoin.test")) {
            StoredBlock test = manager.getCheckpointBefore(1390500000L);
            Preconditions.checkState((test.getHeight() == 167328 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)test.getHeader().getHashAsString().equals("0000000000035ae7d5025c2538067fe7adb1cf5d5d9c31b024137d9090ed13a9"));
        }
    }
}

