/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.tools;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.listeners.OnTransactionBroadcastListener;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.wallet.DefaultRiskAnalysis;
import org.bitcoinj.wallet.RiskAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchMempool {
    private static Logger log = LoggerFactory.getLogger(WatchMempool.class);
    private static final NetworkParameters PARAMS = MainNetParams.get();
    private static final ImmutableList<Transaction> NO_DEPS = ImmutableList.of();
    private static final Map<String, Integer> counters = new HashMap<String, Integer>();
    private static final String TOTAL_KEY = "TOTAL";
    private static final long START_MS = System.currentTimeMillis();
    private static final long STATISTICS_FREQUENCY_MS = 5000L;

    public static void main(String[] args) throws InterruptedException {
        BriefLogFormatter.init();
        PeerGroup peerGroup = new PeerGroup(PARAMS);
        peerGroup.setMaxConnections(32);
        peerGroup.addPeerDiscovery((PeerDiscovery)new DnsDiscovery(PARAMS));
        peerGroup.addOnTransactionBroadcastListener(new OnTransactionBroadcastListener(){

            public void onTransaction(Peer peer, Transaction tx) {
                RiskAnalysis.Result result = DefaultRiskAnalysis.FACTORY.create(null, tx, (List)NO_DEPS).analyze();
                WatchMempool.incrementCounter(WatchMempool.TOTAL_KEY);
                log.info("tx {} result {}", (Object)tx.getHash(), (Object)result);
                WatchMempool.incrementCounter(result.name());
                if (result == RiskAnalysis.Result.NON_STANDARD) {
                    WatchMempool.incrementCounter(RiskAnalysis.Result.NON_STANDARD + "-" + DefaultRiskAnalysis.isStandard((Transaction)tx));
                }
            }
        });
        peerGroup.start();
        while (true) {
            Thread.sleep(5000L);
            WatchMempool.printCounters();
        }
    }

    private static synchronized void incrementCounter(String name) {
        Integer count = counters.get(name);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        counters.put(name, count);
    }

    private static synchronized void printCounters() {
        System.out.printf("Runtime: %d minutes\n", (System.currentTimeMillis() - START_MS) / 1000L / 60L);
        Integer total = counters.get(TOTAL_KEY);
        if (total == null) {
            return;
        }
        for (Map.Entry<String, Integer> counter : counters.entrySet()) {
            System.out.printf("  %-40s%6d  (%d%% of total)\n", counter.getKey(), counter.getValue(), counter.getValue() * 100 / total);
        }
    }
}

