/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Cell;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitNodeCryptoState;

public class CircuitNodeImpl
implements CircuitNode {
    private static final int CIRCWINDOW_START = 1000;
    private static final int CIRCWINDOW_INCREMENT = 100;
    private final Router router;
    private final CircuitNodeCryptoState cryptoState;
    private final CircuitNode previousNode;
    private final Object windowLock;
    private int packageWindow;
    private int deliverWindow;

    public static CircuitNode createAnonymous(CircuitNode previous, byte[] keyMaterial, byte[] verifyDigest) {
        return CircuitNodeImpl.createNode(null, previous, keyMaterial, verifyDigest);
    }

    public static CircuitNode createFirstHop(Router r, byte[] keyMaterial, byte[] verifyDigest) {
        return CircuitNodeImpl.createNode(r, null, keyMaterial, verifyDigest);
    }

    public static CircuitNode createNode(Router r, CircuitNode previous, byte[] keyMaterial, byte[] verifyDigest) {
        CircuitNodeCryptoState cs = CircuitNodeCryptoState.createFromKeyMaterial(keyMaterial, verifyDigest);
        return new CircuitNodeImpl(r, previous, cs);
    }

    private CircuitNodeImpl(Router router, CircuitNode previous, CircuitNodeCryptoState cryptoState) {
        this.previousNode = previous;
        this.router = router;
        this.cryptoState = cryptoState;
        this.windowLock = new Object();
        this.packageWindow = 1000;
        this.deliverWindow = 1000;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    @Override
    public CircuitNode getPreviousNode() {
        return this.previousNode;
    }

    @Override
    public void encryptForwardCell(RelayCell cell) {
        this.cryptoState.encryptForwardCell(cell);
    }

    @Override
    public boolean decryptBackwardCell(Cell cell) {
        return this.cryptoState.decryptBackwardCell(cell);
    }

    @Override
    public void updateForwardDigest(RelayCell cell) {
        this.cryptoState.updateForwardDigest(cell);
    }

    @Override
    public byte[] getForwardDigestBytes() {
        return this.cryptoState.getForwardDigestBytes();
    }

    public String toString() {
        if (this.router != null) {
            return "|" + this.router.getNickname() + "|";
        }
        return "|()|";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementDeliverWindow() {
        Object object = this.windowLock;
        synchronized (object) {
            --this.deliverWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean considerSendingSendme() {
        Object object = this.windowLock;
        synchronized (object) {
            if (this.deliverWindow <= 900) {
                this.deliverWindow += 100;
                return true;
            }
            return false;
        }
    }

    @Override
    public void waitForSendWindow() {
        this.waitForSendWindow(false);
    }

    @Override
    public void waitForSendWindowAndDecrement() {
        this.waitForSendWindow(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSendWindow(boolean decrement) {
        Object object = this.windowLock;
        synchronized (object) {
            while (this.packageWindow == 0) {
                try {
                    this.windowLock.wait();
                }
                catch (InterruptedException e) {
                    throw new TorException("Thread interrupted while waiting for circuit send window");
                }
            }
            if (decrement) {
                --this.packageWindow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementSendWindow() {
        Object object = this.windowLock;
        synchronized (object) {
            this.packageWindow += 100;
            this.windowLock.notifyAll();
        }
    }
}

