/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.config;

import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.config.TorConfigInterval;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TorConfigParser {
    public Object parseValue(String value, TorConfig.ConfigVarType type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case INTERVAL: {
                return this.parseIntervalValue(value);
            }
            case PATH: {
                return this.parseFileValue(value);
            }
            case PORTLIST: {
                return this.parseIntegerList(value);
            }
            case STRING: {
                return value;
            }
            case STRINGLIST: {
                return this.parseCSV(value);
            }
            case AUTOBOOL: {
                return this.parseAutoBool(value);
            }
        }
        throw new IllegalArgumentException();
    }

    private File parseFileValue(String value) {
        if (value.startsWith("~/")) {
            File home = new File(System.getProperty("user.home"));
            return new File(home, value.substring(2));
        }
        return new File(value);
    }

    private TorConfigInterval parseIntervalValue(String value) {
        return TorConfigInterval.createFrom(value);
    }

    private List<Integer> parseIntegerList(String value) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String s : value.split(",")) {
            list.add(Integer.parseInt(s));
        }
        return list;
    }

    private List<String> parseCSV(String value) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : value.split(",")) {
            list.add(s);
        }
        return list;
    }

    private TorConfig.AutoBoolValue parseAutoBool(String value) {
        if ("auto".equalsIgnoreCase(value)) {
            return TorConfig.AutoBoolValue.AUTO;
        }
        if ("true".equalsIgnoreCase(value)) {
            return TorConfig.AutoBoolValue.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return TorConfig.AutoBoolValue.FALSE;
        }
        throw new IllegalArgumentException("Could not parse AutoBool value " + value);
    }
}

