/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.condition;

import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class ElementConditions {
    public static ExpectedCondition<WebElement> textMatches(final By locator, final Pattern pattern) {
        return new ExpectedCondition<WebElement>(){
            private String currentText = null;

            public WebElement apply(WebDriver driver) {
                WebElement element = driver.findElement(locator);
                if (element.isDisplayed()) {
                    this.currentText = element.getText();
                    if (pattern.matcher(this.currentText).matches()) {
                        return element;
                    }
                }
                return null;
            }

            public String toString() {
                return String.format("Current text '%s' does no match pattern '%s'.", this.currentText, pattern.toString());
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOfNestedElement(final WebElement parentElement, final By childElementLocator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement element = parentElement.findElement(childElementLocator);
                if (element.isDisplayed()) {
                    return element;
                }
                return null;
            }

            public String toString() {
                return String.format("Element '%s' was not found visible inside it's :parent element '%s'.", childElementLocator, parentElement);
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfAllNestedElementsLocatedBy(final WebElement parentElement, final By childElementLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver webDriver) {
                List foundChildren = parentElement.findElements(childElementLocator);
                boolean allChildrenAreVisible = foundChildren.stream().allMatch(WebElement::isDisplayed);
                return !foundChildren.isEmpty() && allChildrenAreVisible ? foundChildren : null;
            }

            public String toString() {
                return String.format("All elements '%s' were not found visible inside it's :parent element '%s'.", childElementLocator, parentElement);
            }
        };
    }
}

