/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.condition;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;

public class SelectConditions {
    public static ExpectedCondition<Select> hasAtLeastValues(final By locator, final Integer minValuesCount) {
        return new ExpectedCondition<Select>(){
            private int currentValueCount = 0;

            public Select apply(WebDriver driver) {
                WebElement element = driver.findElement(locator);
                if (element.isDisplayed()) {
                    Select select = new Select(element);
                    this.currentValueCount = select.getOptions().size();
                    if (this.currentValueCount >= minValuesCount) {
                        return select;
                    }
                }
                return null;
            }

            public String toString() {
                return String.format("Value count should be >= %d. Current count: %d", minValuesCount, this.currentValueCount);
            }
        };
    }
}

