/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.driver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebDriverHandle {
    public static final long DEFAULT_TIMEOUT_SECONDS = 6L;
    public static final String DEFAULT_WAIT = "default";
    public static final String DEFAULT_LIST_WAIT = "list default";
    public static final Map<String, String> DEFAULTS;
    private WebDriver driver;
    private boolean remote;
    private Map<String, String> info = new HashMap<String, String>();
    private Map<String, FluentWait<WebDriver>> waits;

    public WebDriver getDriver() {
        return this.driver;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, String> info) {
        this.info = info;
    }

    public JavascriptExecutor getJs() {
        return (JavascriptExecutor)this.getDriver();
    }

    public Map<String, FluentWait<WebDriver>> getWaits() {
        return this.waits;
    }

    public WebDriverHandle(WebDriver driver, boolean remote, Map<String, FluentWait<WebDriver>> waits) {
        this.driver = driver;
        this.remote = remote;
        this.waits = waits;
        this.addDefaultWaits();
    }

    public WebDriverHandle(WebDriver driver, boolean remote) {
        this.driver = driver;
        this.remote = remote;
        this.waits = new HashMap<String, FluentWait<WebDriver>>(1);
        this.addDefaultWaits();
    }

    protected void addDefaultWaits() {
        this.waits.putIfAbsent(DEFAULT_WAIT, (FluentWait<WebDriver>)new WebDriverWait(this.getDriver(), 6L));
        this.waits.putIfAbsent(DEFAULT_LIST_WAIT, (FluentWait<WebDriver>)new WebDriverWait(this.getDriver(), 6L));
    }

    static {
        String SELENIUM_ON_LOCALHOST = "http://127.0.0.1:4444";
        int defaultsCapacity = 2;
        HashMap<String, String> defaultsInternal = new HashMap<String, String>(defaultsCapacity);
        defaultsInternal.put("selenium.url", "http://127.0.0.1:4444");
        defaultsInternal.put("selenium.hub.url", "http://127.0.0.1:4444/wd/hub");
        DEFAULTS = Collections.unmodifiableMap(defaultsInternal);
    }
}

