/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.resolving;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.bithill.selenium.resolving.Resolvable;
import org.bithill.selenium.resolving.ResolvableList;
import org.bithill.selenium.resolving.ResolveBy;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

class FieldOfResolvable {
    FieldOfResolvable() {
    }

    protected static boolean isResolvedByAnnotated(Field field) {
        return field.isAnnotationPresent(ResolveBy.class);
    }

    protected static boolean isContainerResolvable(Field field) {
        ResolveBy resolveBy = field.getAnnotation(ResolveBy.class);
        return resolveBy != null && resolveBy.isContainer();
    }

    protected static boolean isNullableAnnotated(Field field) {
        return field.isAnnotationPresent(Nullable.class);
    }

    protected static boolean isGroupMember(Field field, String[] groups) {
        boolean result = false;
        HashSet<String> elementGroups = new HashSet<String>(Arrays.asList(field.getAnnotation(ResolveBy.class).groups()));
        for (String requestedGroup : groups) {
            if (!elementGroups.contains(requestedGroup)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected static boolean isResolvable(Field field) {
        return Resolvable.class.isAssignableFrom(field.getType());
    }

    protected static boolean isWebElement(Field field) {
        return WebElement.class.isAssignableFrom(field.getType());
    }

    protected static boolean isSelect(Field field) {
        return Select.class.isAssignableFrom(field.getType());
    }

    protected static boolean isList(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    protected static boolean isResolvableList(Field field) {
        return ResolvableList.class.isAssignableFrom(field.getType());
    }
}

