/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.resolving;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.bithill.selenium.resolving.FieldOfResolvable;
import org.bithill.selenium.resolving.Reflection;
import org.bithill.selenium.resolving.Resolvable;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class Find {
    private Find() {
    }

    public static QueryEngine in(Resolvable resolvable) {
        return new QueryEngine(resolvable);
    }

    public static class QueryEngine {
        private Resolvable searchRoot;

        public QueryEngine(Resolvable resolvable) {
            this.searchRoot = resolvable;
        }

        public List<WebElement> groupMembers(String ... groups) {
            return new ArrayList<WebElement>(this.groupMembers(this.searchRoot, groups));
        }

        private LinkedHashSet<WebElement> groupMembers(Resolvable currentSearchRoot, String ... groups) {
            LinkedHashSet<WebElement> result = new LinkedHashSet<WebElement>();
            if (currentSearchRoot != null) {
                Resolvable resolvable;
                for (Field field : Reflection.getClassFields(currentSearchRoot, Resolvable.class)) {
                    if (Reflection.getFieldValue(currentSearchRoot, field) == null || !FieldOfResolvable.isResolvedByAnnotated(field) || !FieldOfResolvable.isGroupMember(field, groups)) continue;
                    if (FieldOfResolvable.isWebElement(field)) {
                        result.add((WebElement)Reflection.getFieldValue(currentSearchRoot, field));
                    }
                    if (FieldOfResolvable.isSelect(field)) {
                        try {
                            Select select = (Select)Reflection.getFieldValue(currentSearchRoot, field);
                            Field elementField = select.getClass().getField("element");
                            WebElement element = (WebElement)Reflection.getFieldValue(select, elementField);
                            result.add(element);
                            continue;
                        }
                        catch (NoSuchFieldException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    if (FieldOfResolvable.isList(field)) {
                        List elementList = (List)Reflection.getFieldValue(currentSearchRoot, field);
                        result.addAll(elementList);
                        continue;
                    }
                    if (!FieldOfResolvable.isResolvable(field) || (resolvable = (Resolvable)Reflection.getFieldValue(currentSearchRoot, field)).getSelf() == null) continue;
                    result.add(resolvable.getSelf());
                }
                for (Field field : Reflection.getClassFields(currentSearchRoot, Resolvable.class)) {
                    if (Reflection.getFieldValue(currentSearchRoot, field) == null || !FieldOfResolvable.isResolvable(field)) continue;
                    resolvable = (Resolvable)Reflection.getFieldValue(currentSearchRoot, field);
                    result.addAll(this.groupMembers(resolvable, groups));
                }
            }
            return result;
        }
    }
}

