/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.resolving;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bithill.selenium.driver.WebDriverHandle;
import org.bithill.selenium.resolving.Resolvable;
import org.bithill.selenium.site.MinimalSiteConfig;
import org.bithill.selenium.site.Site;
import org.bithill.selenium.site.SiteConfig;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public abstract class Page
extends Resolvable
implements AutoCloseable {
    protected final Logger log = LogManager.getLogger(Page.class);
    protected SiteConfig siteConfig;
    private String[] pageUrlParams = new String[0];

    public SiteConfig getSiteConfig() {
        return this.siteConfig;
    }

    protected String[] getPageUrlParams() {
        return this.pageUrlParams;
    }

    public void setPageUrlParams(String ... pageUrlParams) {
        this.pageUrlParams = pageUrlParams;
    }

    public Page(WebDriverHandle driverHandle) {
        super(driverHandle);
        this.getSiteConfigFromAnnotation();
    }

    private void getSiteConfigFromAnnotation() {
        Site site = this.getClass().getAnnotation(Site.class);
        if (site != null) {
            try {
                this.siteConfig = site.config().newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                this.log.error((Object)ex);
            }
        } else {
            this.log.info("Class '{}' does not have SiteConfig.", this.getClass());
            this.siteConfig = new MinimalSiteConfig();
        }
    }

    public Page open() {
        this.getDriverHandle().getDriver().get(this.pageUrl());
        this.checkOpened();
        return this;
    }

    protected String pageUrl() {
        StringBuilder pageUrl = new StringBuilder(this.siteConfig.getUrl());
        for (String pageUrlParam : this.pageUrlParams) {
            pageUrl.append(pageUrlParam);
        }
        return pageUrl.toString();
    }

    @Override
    public void close() {
        this.getDriver().close();
    }

    protected abstract Page checkOpened();

    public void takeScreenshot(String screenshotFileName) {
        File screenshotDir = new File(this.siteConfig.getScreenshotDir());
        if (!screenshotDir.exists()) {
            this.log.info("Target directory '{}' does not exist. Creating a new one.", (Object)screenshotDir.getPath());
            boolean directoryCreationSucceeded = screenshotDir.mkdir();
            if (!directoryCreationSucceeded) {
                this.log.error("Failed to create directory for screenshots: " + screenshotDir);
            } else {
                File screenshotFile = new File(screenshotDir, screenshotFileName);
                try {
                    this.log.trace("Taking screenshot.");
                    byte[] screenshotData = (byte[])((TakesScreenshot)this.getDriver()).getScreenshotAs(OutputType.BYTES);
                    this.log.debug("Saving screenshot to file '{}'.", (Object)screenshotFile);
                    try (FileOutputStream imageOutputStream = new FileOutputStream(screenshotFile);){
                        imageOutputStream.write(screenshotData);
                    }
                }
                catch (ClassCastException ex) {
                    this.log.warn("Used driver '{}' does not support taking of screenshots.", this.getDriver().getClass());
                }
                catch (IOException ex) {
                    this.log.error("Unable to write screenshot to file '{}'.", (Object)screenshotFile.getPath());
                }
            }
        }
    }

    public void takeScreenshot() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss");
        String fileName = String.format("%s_%s.png", this.getClass().getSimpleName(), dateFormat.format(new Date()));
        this.takeScreenshot(fileName);
    }
}

