/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.resolving;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class Reflection {
    Reflection() {
    }

    public static Field[] getClassFields(@Nonnull Object instance, @Nullable Class rootClass) {
        Class<?> superClass;
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(instance.getClass().getDeclaredFields()));
        Class<?> currentlyProcessedClass = instance.getClass();
        while ((superClass = currentlyProcessedClass.getSuperclass()) != null && superClass != rootClass) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
            currentlyProcessedClass = superClass;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] getClassFields(@Nonnull Object instance) {
        return Reflection.getClassFields(instance, Object.class);
    }

    public static Object getFieldValue(@Nonnull Object instance, @Nonnull Field field) {
        Object result;
        field.setAccessible(true);
        try {
            result = field.get(instance);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        field.setAccessible(false);
        return result;
    }

    public static void setFieldValue(@Nonnull Object instance, @Nonnull Field field, Object value, Predicate<Field> fieldPredicate) {
        try {
            field.setAccessible(true);
            if (fieldPredicate.test(field)) {
                field.set(instance, value);
            }
            field.setAccessible(false);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(String.format("Field %s cannot be set.", field.getName()), ex);
        }
    }

    public static void setFieldValue(@Nonnull Object instance, @Nonnull Field field, Object value) {
        Reflection.setFieldValue(instance, field, value, aField -> true);
    }

    public static Object createAndSetField(@Nonnull Object instance, @Nonnull Field field, Set<Class> allowedClasses) throws IllegalAccessException {
        Object fieldValue = Reflection.getFieldValue(instance, field);
        Class<?> fieldType = field.getType();
        boolean isAllowedClass = allowedClasses.stream().anyMatch(aClass -> aClass.isAssignableFrom(fieldType));
        if (isAllowedClass && fieldValue == null) {
            try {
                Reflection.setFieldValue(instance, field, fieldType.newInstance());
                fieldValue = Reflection.getFieldValue(instance, field);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return fieldValue;
    }

    public static Type[] getFieldTypeArguments(@Nonnull Field field) {
        Type[] result = new Type[]{};
        Type genericFieldType = field.getGenericType();
        if (genericFieldType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            return aType.getActualTypeArguments();
        }
        return result;
    }
}

