/*
 * Decompiled with CFR 0.152.
 */
package org.bithill.selenium.resolving;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bithill.selenium.condition.ElementConditions;
import org.bithill.selenium.driver.WebDriverHandle;
import org.bithill.selenium.resolving.FieldOfResolvable;
import org.bithill.selenium.resolving.InvalidLocatorFormatException;
import org.bithill.selenium.resolving.Reflection;
import org.bithill.selenium.resolving.ResolvableList;
import org.bithill.selenium.resolving.ResolveBy;
import org.bithill.selenium.resolving.UnknownLocatorTypeException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;

public class Resolvable {
    private static final Logger LOG = LogManager.getLogger(Resolvable.class);
    private static final String SELECTOR_DELIMITER = "=";
    private WebElement self;
    private WebDriverHandle driverHandle;
    private boolean isContainer = false;
    private Properties placeholders;
    @Nullable
    private Resolvable parent;
    private final Set<Class> resolvableClasses = new HashSet<Class>(Arrays.asList(Resolvable.class, ResolvableList.class));

    public WebElement getSelf() {
        return this.self;
    }

    protected void setSelf(WebElement self) {
        this.self = self;
    }

    protected WebDriverHandle getDriverHandle() {
        return this.driverHandle;
    }

    protected void setDriverHandle(WebDriverHandle driverHandle) {
        this.driverHandle = driverHandle;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public void setIsContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    public WebDriver getDriver() {
        if (this.getDriverHandle() == null) {
            throw new IllegalStateException("WebDriverHandle is null.");
        }
        return this.getDriverHandle().getDriver();
    }

    public FluentWait<WebDriver> getWait() {
        return this.getWait("default");
    }

    public FluentWait<WebDriver> getWait(String waitName) {
        if (this.getDriverHandle() == null) {
            throw new IllegalStateException("WebDriverHandle is null.");
        }
        if (this.getDriverHandle().getWaits() == null) {
            throw new IllegalStateException("Map of WebDriverHandle's waits is null.");
        }
        return this.getDriverHandle().getWaits().get(waitName);
    }

    public void setWait(FluentWait<WebDriver> wait) {
        this.setWait("default", wait);
    }

    public void setWait(String waitName, FluentWait<WebDriver> wait) {
        if (this.getDriverHandle() == null) {
            throw new IllegalStateException("WebDriverHandle is null.");
        }
        if (this.getDriverHandle().getWaits() == null) {
            throw new IllegalStateException("Map of WebDriverHandle's waits is null.");
        }
        this.getDriverHandle().getWaits().put(waitName, wait);
    }

    public Properties getPlaceholders() {
        return this.placeholders;
    }

    public Resolvable setPlaceholders(Properties placeholders) {
        this.placeholders = placeholders;
        return this;
    }

    public Resolvable getParent() {
        return this.parent;
    }

    public void setParent(Resolvable parent) {
        this.parent = parent;
        if (this.getDriverHandle() == null && parent != null) {
            WebDriverHandle parentsDriverHandle = this.getParent().getDriverHandle();
            if (parentsDriverHandle != null) {
                this.setDriverHandle(parentsDriverHandle);
            } else {
                throw new NullPointerException("WebDriverHandle is null. Parent's WebDriverHandle is null too");
            }
        }
    }

    public Resolvable() {
    }

    public Resolvable(WebDriverHandle driverHandle) {
        this.prepareForResolving(driverHandle);
    }

    public Resolvable prepareForResolving(WebDriverHandle driverHandle) {
        if (driverHandle == null) {
            throw new NullPointerException("WebDriverHandle is null.");
        }
        this.setDriverHandle(driverHandle);
        return this;
    }

    public Resolvable resolve(String ... groups) {
        Field[] fields = Reflection.getClassFields(this, Resolvable.class);
        this.resolveResolveBys(fields, groups);
        this.resolveResolvables(fields, groups);
        return this;
    }

    public Resolvable resolve() {
        return this.resolve("default");
    }

    private void resolveResolvables(Field[] fields, String ... groups) {
        for (Field field : fields) {
            try {
                Object fieldValue = Reflection.createAndSetField(this, field, this.resolvableClasses);
                if (Resolvable.class.isInstance(fieldValue)) {
                    this.initAndResolveResolvable((Resolvable)fieldValue, FieldOfResolvable.isContainerResolvable(field), groups);
                    continue;
                }
                if (!ResolvableList.class.isInstance(fieldValue)) continue;
                ResolvableList resolvable = (ResolvableList)fieldValue;
                resolvable.setIsContainer(FieldOfResolvable.isContainerResolvable(field));
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(String.format("Field %s cannot be set.", field.getName()), ex);
            }
        }
    }

    private void initAndResolveResolvable(Resolvable resolvable, boolean container, String ... groups) {
        resolvable.setParent(this);
        resolvable.setIsContainer(container);
        resolvable.prepareForResolving(this.getDriverHandle());
        resolvable.resolve(groups);
    }

    private void resolveResolveBys(Field[] fields, String ... groups) {
        Class<?> resolvableClass = this.getClass();
        for (Field field : fields) {
            ResolveContext resolveContext;
            if (!FieldOfResolvable.isResolvedByAnnotated(field)) continue;
            ResolveBy resolveBy = field.getAnnotation(ResolveBy.class);
            String locatorString = resolveBy.value();
            String explicitWaitName = resolveBy.explicitWait();
            FluentWait<WebDriver> explicitWait = this.getDriverHandle().getWaits().get(explicitWaitName);
            if (explicitWait == null) {
                LOG.warn("No wait '{}' is registered in WebDriverHandle, default wait will be used.", (Object)explicitWaitName);
            }
            if (!FieldOfResolvable.isGroupMember(field, groups)) continue;
            if (FieldOfResolvable.isList(field)) {
                resolveContext = explicitWait != null ? new ResolveContext(resolvableClass, field, locatorString, explicitWait) : new ResolveContext(resolvableClass, field, locatorString, this.getWait("list default"));
                if (FieldOfResolvable.isResolvableList(field)) {
                    this.resolveResolvableList(resolveContext, groups);
                    continue;
                }
                this.resolveWebElementsList(resolveContext);
                continue;
            }
            resolveContext = explicitWait != null ? new ResolveContext(resolvableClass, field, locatorString, explicitWait) : new ResolveContext(resolvableClass, field, locatorString, this.getWait("default"));
            this.resolveWebElement(resolveContext);
        }
    }

    private void resolveWebElement(ResolveContext resolveContext) {
        try {
            this.setWebElementField(resolveContext.getField(), this.getSingleWebElementForContext(resolveContext));
        }
        catch (WebDriverException ex) {
            if (FieldOfResolvable.isNullableAnnotated(resolveContext.getField())) {
                this.setWebElementField(resolveContext.getField(), null);
            }
            ex.addInfo("field", resolveContext.getResolvableClass().getName() + " -> " + resolveContext.getField().getName());
            throw ex;
        }
    }

    private void resolveWebElementsList(ResolveContext resolveContext) {
        try {
            this.setWebElementListField(resolveContext.getField(), this.getWebElementsList(resolveContext));
        }
        catch (WebDriverException ex) {
            if (FieldOfResolvable.isNullableAnnotated(resolveContext.getField())) {
                this.setWebElementListField(resolveContext.getField(), Collections.EMPTY_LIST);
            }
            throw ex;
        }
    }

    private void resolveResolvableList(ResolveContext resolveContext, String ... groups) {
        List<WebElement> rootElements = Collections.EMPTY_LIST;
        try {
            rootElements = this.getWebElementsList(resolveContext);
        }
        catch (WebDriverException ex) {
            if (FieldOfResolvable.isNullableAnnotated(resolveContext.getField())) {
                this.setResolvableListField(resolveContext.getField(), new ResolvableList(0));
            }
            throw ex;
        }
        try {
            Class resolvableType = (Class)Reflection.getFieldTypeArguments(resolveContext.getField())[0];
            ResolvableList result = new ResolvableList();
            for (WebElement element : rootElements) {
                Constructor resolvableConstructor = resolvableType.getConstructor(WebDriverHandle.class);
                Resolvable newItem = (Resolvable)resolvableConstructor.newInstance(this.getDriverHandle());
                newItem.setSelf(element);
                this.initAndResolveResolvable(newItem, FieldOfResolvable.isContainerResolvable(resolveContext.getField()), groups);
                result.add(newItem);
            }
            Reflection.setFieldValue(this, resolveContext.getField(), result);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<WebElement> getWebElementsList(ResolveContext resolveContext) {
        List<WebElement> rootElements;
        try {
            rootElements = this.getMultipleWebElementsForContext(resolveContext);
        }
        catch (WebDriverException ex) {
            if (!FieldOfResolvable.isNullableAnnotated(resolveContext.getField())) {
                ex.addInfo("field", resolveContext.getResolvableClass().getName() + " -> " + resolveContext.getField().getName());
            }
            throw ex;
        }
        return rootElements;
    }

    private String replacePlaceholders(String locatorSpecification) {
        if (this.getPlaceholders() != null) {
            for (String propertyName : this.getPlaceholders().stringPropertyNames()) {
                locatorSpecification = locatorSpecification.replaceAll(Pattern.quote(propertyName), this.getPlaceholders().getProperty(propertyName));
            }
        }
        return locatorSpecification;
    }

    private WebElement getSingleWebElementForContext(ResolveContext resolveContext) {
        By locator = this.locatorFromString(resolveContext.getLocatorString());
        WebElement result = this.isContainer() ? (this.getSelf() != null ? (WebElement)resolveContext.getWait().until(ElementConditions.visibilityOfNestedElement(this.getSelf(), locator)) : null) : (WebElement)resolveContext.getWait().until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
        return result;
    }

    private List<WebElement> getMultipleWebElementsForContext(ResolveContext resolveContext) {
        By locator = this.locatorFromString(resolveContext.getLocatorString());
        List result = this.isContainer() ? (this.getSelf() != null ? (List)resolveContext.getWait().until(ElementConditions.visibilityOfAllNestedElementsLocatedBy(this.getSelf(), locator)) : Collections.EMPTY_LIST) : (List)resolveContext.getWait().until((Function)ExpectedConditions.visibilityOfAllElementsLocatedBy((By)locator));
        return result;
    }

    private By locatorFromString(String locatorString) {
        By locator;
        String[] locatorParts = locatorString.split(SELECTOR_DELIMITER, 2);
        if (locatorParts.length != 2) {
            throw new InvalidLocatorFormatException(String.format("Locator has invalid format: '%s'.", locatorString));
        }
        String locatorType = locatorParts[0].trim();
        String locatorSpecification = this.replacePlaceholders(locatorParts[1].trim());
        switch (locatorType) {
            case "id": {
                locator = By.id((String)locatorSpecification);
                break;
            }
            case "xpath": {
                locator = By.xpath((String)locatorSpecification);
                break;
            }
            case "css": {
                locator = By.cssSelector((String)locatorSpecification);
                break;
            }
            case "name": {
                locator = By.name((String)locatorSpecification);
                break;
            }
            case "tag": {
                locator = By.tagName((String)locatorSpecification);
                break;
            }
            case "link": {
                locator = By.linkText((String)locatorSpecification);
                break;
            }
            default: {
                throw new UnknownLocatorTypeException(String.format("Unknown locator type: '%s'.", locatorType));
            }
        }
        return locator;
    }

    private void setWebElementField(@Nonnull Field field, @Nullable WebElement webElement) {
        block9: {
            try {
                if (webElement != null) {
                    if (FieldOfResolvable.isResolvable(field)) {
                        Reflection.createAndSetField(this, field, Collections.singleton(Resolvable.class));
                        Resolvable resolvableField = (Resolvable)Reflection.getFieldValue(this, field);
                        resolvableField.setSelf(webElement);
                    } else if (FieldOfResolvable.isWebElement(field)) {
                        Reflection.setFieldValue(this, field, webElement);
                    } else if (FieldOfResolvable.isSelect(field)) {
                        Reflection.setFieldValue(this, field, new Select(webElement));
                    }
                    break block9;
                }
                if (FieldOfResolvable.isNullableAnnotated(field)) {
                    Reflection.setFieldValue(this, field, null);
                    break block9;
                }
                throw new NullPointerException(String.format("Field %s is not @Nullable but the WebElement is null.", field.getName()));
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(String.format("Field %s cannot be set.", field.getName()), ex);
            }
        }
    }

    private void setWebElementListField(Field field, List<WebElement> webElementList) {
        boolean isWebElementList = WebElement.class.isAssignableFrom((Class)Reflection.getFieldTypeArguments(field)[0]);
        Reflection.setFieldValue(this, field, webElementList, aField -> FieldOfResolvable.isList(aField) && isWebElementList);
    }

    private void setResolvableListField(Field field, ResolvableList<? extends Resolvable> resolvableList) {
        Reflection.setFieldValue(this, field, resolvableList, aField -> FieldOfResolvable.isList(aField) && FieldOfResolvable.isResolvableList(aField));
    }

    public void loadData(Properties formValues) {
        for (Field field : Reflection.getClassFields(this, Resolvable.class)) {
            String fieldName;
            if (!FieldOfResolvable.isResolvedByAnnotated(field) || !formValues.containsKey(fieldName = field.getName())) continue;
            String valueSpecification = formValues.getProperty(fieldName);
            if (FieldOfResolvable.isWebElement(field)) {
                WebElement webElement = (WebElement)Reflection.getFieldValue(this, field);
                webElement.clear();
                webElement.sendKeys(new CharSequence[]{valueSpecification});
                continue;
            }
            if (!FieldOfResolvable.isSelect(field)) continue;
            Select select = (Select)Reflection.getFieldValue(this, field);
            if (select.isMultiple()) {
                select.deselectAll();
            }
            select.selectByVisibleText(valueSpecification);
        }
    }

    private static class ResolveContext {
        private final Class resolvableClass;
        private final Field field;
        private final String locatorString;
        private final FluentWait<WebDriver> wait;

        public Class getResolvableClass() {
            return this.resolvableClass;
        }

        public Field getField() {
            return this.field;
        }

        public String getLocatorString() {
            return this.locatorString;
        }

        public FluentWait<WebDriver> getWait() {
            return this.wait;
        }

        private ResolveContext(Class resolvableClass, Field field, String locatorString, FluentWait<WebDriver> wait) {
            this.resolvableClass = resolvableClass;
            this.field = field;
            this.locatorString = locatorString;
            this.wait = wait;
        }
    }
}

