/*
 * Decompiled with CFR 0.152.
 */
package org.bithon.agent.sdk.metric;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Stream;
import org.bithon.agent.sdk.expt.SdkException;
import org.bithon.agent.sdk.metric.IMetricsRegistry;

public class MetricRegistryFactory {
    public static <T> IMetricsRegistry<T> create(String name, List<String> dimensionSpec, Class<T> metricClass) {
        return new EmptyMetricsRegistry<T>(metricClass);
    }

    static class EmptyMetricsRegistry<T>
    implements IMetricsRegistry<T> {
        final Constructor<T> defaultCtor;

        public EmptyMetricsRegistry(Class<T> metricClass) {
            this.defaultCtor = Stream.of(metricClass.getConstructors()).filter(ctor -> ctor.getParameterCount() == 0).findFirst().orElseThrow(() -> new SdkException("[%s] has no default constructor", metricClass.getName()));
        }

        @Override
        public T getOrCreateMetric(String ... dimensions) {
            System.out.println("MetricRegistryFactory is not installed correctly");
            try {
                return this.defaultCtor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SdkException("Can't instantiate metric class[%s]: %s", this.defaultCtor.getDeclaringClass().getName(), e.getMessage());
            }
        }

        @Override
        public T getPermanentMetrics(String ... dimensions) {
            System.out.println("MetricRegistryFactory is not installed correctly");
            try {
                return this.defaultCtor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SdkException("Can't instantiate metric class[%s]: %s", this.defaultCtor.getDeclaringClass().getName(), e.getMessage());
            }
        }

        @Override
        public void unregister() {
            System.out.println("MetricRegistryFactory is not installed correctly");
        }
    }
}

