/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.roaringbitmap.buffer;

import org.bitlap.roaringbitmap.PeekableCharIterator;
import org.bitlap.roaringbitmap.Util;
import org.bitlap.roaringbitmap.buffer.MappeableArrayContainer;

final class RawArrayContainerCharIterator
implements PeekableCharIterator {
    int pos;
    private MappeableArrayContainer parent;
    char[] content;

    RawArrayContainerCharIterator(MappeableArrayContainer p) {
        this.parent = p;
        if (!p.isArrayBacked()) {
            throw new RuntimeException("internal bug");
        }
        this.content = p.content.array();
        this.pos = 0;
    }

    @Override
    public void advanceIfNeeded(char minval) {
        this.pos = Util.advanceUntil(this.content, this.pos - 1, this.parent.cardinality, minval);
    }

    @Override
    public PeekableCharIterator clone() {
        try {
            return (PeekableCharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.cardinality;
    }

    @Override
    public char next() {
        return this.content[this.pos++];
    }

    @Override
    public int nextAsInt() {
        return this.content[this.pos++];
    }

    @Override
    public char peekNext() {
        return this.content[this.pos];
    }

    @Override
    public void remove() {
        this.parent.removeAtIndex(this.pos - 1);
        --this.pos;
    }
}

