/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.geocoding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bitlap.geocoding.core.Context;
import org.bitlap.geocoding.index.TermIndexBuilder;
import org.bitlap.geocoding.index.TermIndexItem;
import org.bitlap.geocoding.model.Address;
import org.bitlap.geocoding.model.RegionEntity;
import org.bitlap.geocoding.model.RegionType;
import org.bitlap.geocoding.similarity.Document;
import org.bitlap.geocoding.similarity.MatchedResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ<\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u0004J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0007J\u0010\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u0007J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001bJ\u0016\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J\u001a\u0010%\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/bitlap/geocoding/GeocodingX;", "", "()V", "strict", "", "(Z)V", "dataClassPath", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Z)V", "ctx", "Lorg/bitlap/geocoding/core/Context;", "(Lorg/bitlap/geocoding/core/Context;)V", "getCtx", "()Lorg/bitlap/geocoding/core/Context;", "addRegionEntry", "id", "", "parentId", "name", "type", "Lorg/bitlap/geocoding/model/RegionType;", "alias", "replace", "analyze", "Lorg/bitlap/geocoding/similarity/Document;", "address", "Lorg/bitlap/geocoding/model/Address;", "match", "", "Lorg/bitlap/geocoding/model/RegionEntity;", "text", "normalizing", "similarity", "", "address1", "address2", "similarityWithResult", "Lorg/bitlap/geocoding/similarity/MatchedResult;", "geocoding"})
public class GeocodingX {
    @NotNull
    private final Context ctx;

    public GeocodingX(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
    }

    @NotNull
    public final Context getCtx() {
        return this.ctx;
    }

    public GeocodingX() {
        this(false);
    }

    public GeocodingX(boolean strict) {
        this("core/region.dat", strict);
    }

    public GeocodingX(@NotNull String dataClassPath) {
        Intrinsics.checkNotNullParameter((Object)dataClassPath, (String)"dataClassPath");
        this(dataClassPath, false);
    }

    public GeocodingX(@NotNull String dataClassPath, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)dataClassPath, (String)"dataClassPath");
        this(new Context(dataClassPath, strict, null, null, null, 28, null));
    }

    @Nullable
    public final Address normalizing(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return Address.Companion.build(this.ctx.getInterpreter().interpret(address));
    }

    @Nullable
    public final Document analyze(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Address address2 = this.normalizing(address);
        if (address2 == null) {
            return null;
        }
        Address add = address2;
        return this.ctx.getComputer().analyze(add);
    }

    @Nullable
    public final Document analyze(@Nullable Address address) {
        if (address == null) {
            return null;
        }
        return this.ctx.getComputer().analyze(address);
    }

    public final double similarity(@NotNull String address1, @NotNull String address2) {
        Intrinsics.checkNotNullParameter((Object)address1, (String)"address1");
        Intrinsics.checkNotNullParameter((Object)address2, (String)"address2");
        MatchedResult compute = this.ctx.getComputer().compute(this.normalizing(address1), this.normalizing(address2));
        return compute.getSimilarity();
    }

    public final double similarity(@Nullable Address address1, @Nullable Address address2) {
        MatchedResult compute = this.ctx.getComputer().compute(address1, address2);
        return compute.getSimilarity();
    }

    @NotNull
    public final MatchedResult similarityWithResult(@NotNull String address1, @NotNull String address2) {
        Intrinsics.checkNotNullParameter((Object)address1, (String)"address1");
        Intrinsics.checkNotNullParameter((Object)address2, (String)"address2");
        return this.ctx.getComputer().compute(this.normalizing(address1), this.normalizing(address2));
    }

    @NotNull
    public final MatchedResult similarityWithResult(@Nullable Address address1, @Nullable Address address2) {
        return this.ctx.getComputer().compute(address1, address2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RegionEntity> match(@NotNull String text) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List list = this.ctx.getInterpreter().getTermIndexBuilder().fullMatch(text);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List terms = list;
        Iterable $this$mapNotNull$iv = terms;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RegionEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TermIndexItem it = (TermIndexItem)element$iv$iv;
            boolean bl2 = false;
            if (it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final GeocodingX addRegionEntry(long id, long parentId, @NotNull String name, @NotNull RegionType type, @NotNull String alias, boolean replace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (this.ctx.getPersister().getRegion(parentId) == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Parent Address is not exists, parentId is ", (Object)parentId));
        }
        if (StringsKt.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name should not be blank.");
        }
        RegionEntity region = new RegionEntity();
        region.setId(id);
        region.setParentId(parentId);
        region.setName(name);
        region.setAlias(alias);
        region.setType(type);
        this.ctx.getPersister().addRegionEntity(region);
        TermIndexBuilder indexBuilder = this.ctx.getInterpreter().getTermIndexBuilder();
        indexBuilder.indexRegions(CollectionsKt.listOf((Object)region), replace);
        return this;
    }

    public static /* synthetic */ GeocodingX addRegionEntry$default(GeocodingX geocodingX, long l, long l2, String string, RegionType regionType, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addRegionEntry");
        }
        if ((n & 8) != 0) {
            regionType = RegionType.Undefined;
        }
        if ((n & 0x10) != 0) {
            string2 = "";
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return geocodingX.addRegionEntry(l, l2, string, regionType, string2, bl);
    }
}

