/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.geocoding.core.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bitlap.geocoding.core.AddressInterpreter;
import org.bitlap.geocoding.core.AddressPersister;
import org.bitlap.geocoding.core.TermIndexVisitor;
import org.bitlap.geocoding.core.impl.RegionInterpreterVisitor;
import org.bitlap.geocoding.index.TermIndexBuilder;
import org.bitlap.geocoding.index.TermIndexItem;
import org.bitlap.geocoding.index.TermType;
import org.bitlap.geocoding.model.AddressEntity;
import org.bitlap.geocoding.model.RegionEntity;
import org.bitlap.geocoding.utils.StringHelperKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J6\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\t2\b\u0010#\u001a\u0004\u0018\u00010\t2\b\u0010$\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010(\u001a\u00020\u000bH\u0016J\u0014\u0010)\u001a\u0004\u0018\u00010\u00172\b\u0010*\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010)\u001a\u0004\u0018\u00010\u00172\b\u0010*\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u00101\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u00102\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00064"}, d2={"Lorg/bitlap/geocoding/core/impl/DefaultAddressInterpreter;", "Lorg/bitlap/geocoding/core/AddressInterpreter;", "persister", "Lorg/bitlap/geocoding/core/AddressPersister;", "strict", "", "(Lorg/bitlap/geocoding/core/AddressPersister;Z)V", "ignoringRegionNames", "", "", "indexBuilder", "Lorg/bitlap/geocoding/index/TermIndexBuilder;", "getPersister", "()Lorg/bitlap/geocoding/core/AddressPersister;", "getStrict", "()Z", "acceptTown", "", "town", "district", "Lorg/bitlap/geocoding/model/RegionEntity;", "extractBrackets", "entity", "Lorg/bitlap/geocoding/model/AddressEntity;", "extractBuildingNum", "extractRegion", "visitor", "Lorg/bitlap/geocoding/core/TermIndexVisitor;", "extractRoad", "extractTownVillage", "", "addr", "pattern", "Ljava/util/regex/Pattern;", "gz", "gx", "gc", "fixRoad", "road", "fixRoadBuilding", "getTermIndexBuilder", "interpret", "address", "isAcceptableTownFollowingChars", "matched", "text", "start", "prepare", "removeBrackets", "removeRedundancy", "removeSpecialChars", "Companion", "geocoding"})
public class DefaultAddressInterpreter
implements AddressInterpreter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AddressPersister persister;
    private final boolean strict;
    @Nullable
    private TermIndexBuilder indexBuilder;
    @NotNull
    private final List<String> ignoringRegionNames;
    @NotNull
    private static final char[] specialChars1;
    @NotNull
    private static final char[] specialChars2;
    private static final Pattern P_BUILDING_NUM0;
    private static final Pattern P_BUILDING_NUM1;
    private static final Pattern P_BUILDING_NUM_V;
    private static final Pattern P_BUILDING_NUM2;
    private static final Pattern P_BUILDING_NUM3;
    private static final Pattern BRACKET_PATTERN;
    private static final Pattern P_ROAD;
    private static final Pattern P_ROAD_BUILDING;
    private static final Pattern P_TOWN1;
    private static final Pattern P_TOWN2;
    private static final Pattern P_TOWN3;
    @NotNull
    private static Set<String> invalidTown;
    @NotNull
    private static Set<String> invalidTownFollowings;

    public DefaultAddressInterpreter(@NotNull AddressPersister persister, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)persister, (String)"persister");
        this.persister = persister;
        this.strict = strict;
        Object[] objectArray = new String[]{"\u5176\u5b83\u533a", "\u5176\u4ed6\u5730\u533a", "\u5176\u5b83\u5730\u533a", "\u5168\u5883", "\u57ce\u533a", "\u57ce\u533a\u4ee5\u5185", "\u57ce\u533a\u4ee5\u5916", "\u90ca\u533a", "\u53bf\u57ce\u5185", "\u5185\u73af\u4ee5\u5185", "\u5f00\u53d1\u533a", "\u7ecf\u6d4e\u5f00\u53d1\u533a", "\u7ecf\u6d4e\u6280\u672f\u5f00\u53d1\u533a", "\u7701\u76f4\u8f96", "\u7701\u76f4\u8f96\u5e02\u53bf", "\u5730\u533a", "\u5e02\u533a"};
        this.ignoringRegionNames = CollectionsKt.mutableListOf((Object[])objectArray);
        this.indexBuilder = new TermIndexBuilder(this.persister.getRootRegion(), this.ignoringRegionNames);
    }

    @NotNull
    public final AddressPersister getPersister() {
        return this.persister;
    }

    public final boolean getStrict() {
        return this.strict;
    }

    @Override
    @Nullable
    public AddressEntity interpret(@Nullable String address) {
        return this.interpret(address, new RegionInterpreterVisitor(this.persister, this.strict));
    }

    private final AddressEntity interpret(String address, TermIndexVisitor visitor) {
        CharSequence charSequence = address;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        AddressEntity entity = new AddressEntity(address);
        this.prepare(entity);
        this.extractBuildingNum(entity);
        this.removeSpecialChars(entity);
        String brackets = this.extractBrackets(entity);
        brackets = StringHelperKt.remove$default(brackets, specialChars2, null, 2, null);
        this.removeBrackets(entity);
        this.extractRegion(entity, visitor);
        this.removeRedundancy(entity, visitor);
        this.extractRoad(entity);
        String string = entity.getText();
        Intrinsics.checkNotNull((Object)string);
        entity.setText(StringsKt.replace$default((String)string, (String)"[0-9A-Za-z\\#]+(\u5355\u5143|\u697c|\u5ba4|\u5c42|\u7c73|\u6237|\\#)", (String)"", (boolean)false, (int)4, null));
        String string2 = entity.getText();
        Intrinsics.checkNotNull((Object)string2);
        entity.setText(StringsKt.replace$default((String)string2, (String)"[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+(\u5355\u5143|\u697c|\u5ba4|\u5c42|\u7c73|\u6237)", (String)"", (boolean)false, (int)4, null));
        if (((CharSequence)brackets).length() > 0) {
            entity.setText(Intrinsics.stringPlus((String)entity.getText(), (Object)brackets));
            CharSequence charSequence2 = entity.getRoad();
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                this.extractRoad(entity);
            }
        }
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepare(AddressEntity entity) {
        String string;
        CharSequence charSequence;
        String string2;
        CharSequence charSequence2 = entity.getText();
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            return;
        }
        Pattern p = Pattern.compile("[ \\da-zA-Z\r\n\t,\uff0c\u3002\u00b7.\uff0e;\uff1b:\uff1a\u3001\uff01@$%*^`~=+&'\"|_\\-\\/]");
        AddressEntity addressEntity = entity;
        String string3 = entity.getText();
        if (string3 == null) {
            string2 = null;
        } else {
            CharSequence charSequence3;
            AddressEntity addressEntity2;
            block6: {
                void $this$trimStart$iv;
                charSequence = string3;
                addressEntity2 = addressEntity;
                boolean $i$f$trimStart = false;
                CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
                boolean $i$f$trimStart2 = false;
                int n = 0;
                int n2 = $this$trimStart$iv$iv.length();
                while (n < n2) {
                    int index$iv$iv = n++;
                    char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (p.matcher(String.valueOf(it)).find()) continue;
                    charSequence3 = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                    break block6;
                }
                charSequence3 = "";
            }
            string2 = ((Object)charSequence3).toString();
            addressEntity = addressEntity2;
        }
        addressEntity.setText(string2);
        String string4 = entity.getText();
        if (string4 == null) {
            string = null;
        } else {
            charSequence = string4;
            Regex regex = new Regex("[\u30fc_\uff0d\u2014/]|(--)");
            String string5 = "-";
            string = regex.replace(charSequence, string5);
        }
        entity.setText(string);
    }

    private final boolean extractBuildingNum(AddressEntity entity) {
        int pos;
        int n;
        int i;
        int n2;
        int notEmptyGroups;
        CharSequence charSequence = entity.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        boolean found = false;
        String building = null;
        Matcher matcher = P_BUILDING_NUM0.matcher(entity.getText());
        while (matcher.find()) {
            if (matcher.start() == matcher.end()) continue;
            String string = entity.getText();
            Intrinsics.checkNotNull((Object)string);
            building = StringHelperKt.take(string, matcher.start(), matcher.end() - 1);
            notEmptyGroups = 0;
            int n3 = 0;
            n2 = matcher.groupCount();
            while (n3 < n2) {
                if (matcher.group(i = n3++) == null) continue;
                n = notEmptyGroups;
                notEmptyGroups = n + 1;
            }
            if (!P_BUILDING_NUM_V.matcher(building).find() || notEmptyGroups <= 3) continue;
            pos = matcher.start();
            if (StringsKt.startsWith$default((String)building, (String)"\u8def", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)building, (String)"\u8857", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)building, (String)"\u5df7", (boolean)false, (int)2, null)) {
                pos = StringsKt.contains$default((CharSequence)building, (CharSequence)"\u53f7\u697c", (boolean)false, (int)2, null) ? (pos += StringsKt.indexOf$default((CharSequence)building, (String)"\u8def", (int)0, (boolean)false, (int)6, null) + 1) : (pos += StringsKt.indexOf$default((CharSequence)building, (String)"\u53f7", (int)0, (boolean)false, (int)6, null) + 1);
                String string2 = entity.getText();
                Intrinsics.checkNotNull((Object)string2);
                building = StringHelperKt.take(string2, pos, matcher.end() - 1);
            }
            entity.setBuildingNum(building);
            String string3 = StringHelperKt.head(entity.getText(), pos);
            String string4 = entity.getText();
            Intrinsics.checkNotNull((Object)string4);
            entity.setText(Intrinsics.stringPlus((String)string3, (Object)StringHelperKt.take(string4, matcher.end())));
            found = true;
            break;
        }
        if (!found) {
            matcher = P_BUILDING_NUM1.matcher(entity.getText());
            while (matcher.find()) {
                if (matcher.start() == matcher.end()) continue;
                String string = entity.getText();
                Intrinsics.checkNotNull((Object)string);
                building = StringHelperKt.take(string, matcher.start(), matcher.end() - 1);
                notEmptyGroups = 0;
                pos = 0;
                n2 = matcher.groupCount();
                while (pos < n2) {
                    if (matcher.group(i = pos++) == null) continue;
                    n = notEmptyGroups;
                    notEmptyGroups = n + 1;
                }
                if (!P_BUILDING_NUM_V.matcher(building).find() || notEmptyGroups <= 3) continue;
                pos = matcher.start();
                if (StringsKt.startsWith$default((String)building, (String)"\u8def", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)building, (String)"\u8857", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)building, (String)"\u5df7", (boolean)false, (int)2, null)) {
                    pos += StringsKt.indexOf$default((CharSequence)building, (String)"\u53f7", (int)0, (boolean)false, (int)6, null) + 1;
                    String string5 = entity.getText();
                    Intrinsics.checkNotNull((Object)string5);
                    building = StringHelperKt.take(string5, pos, matcher.end() - 1);
                }
                entity.setBuildingNum(building);
                String string6 = StringHelperKt.head(entity.getText(), pos);
                String string7 = entity.getText();
                Intrinsics.checkNotNull((Object)string7);
                entity.setText(Intrinsics.stringPlus((String)string6, (Object)StringHelperKt.take(string7, matcher.end())));
                found = true;
                break;
            }
        }
        if (!found && (matcher = P_BUILDING_NUM2.matcher(entity.getText())).find()) {
            String string = entity.getText();
            Intrinsics.checkNotNull((Object)string);
            entity.setBuildingNum(StringHelperKt.take(string, matcher.start(), matcher.end() - 1));
            String string8 = StringHelperKt.head(entity.getText(), matcher.start());
            String string9 = entity.getText();
            Intrinsics.checkNotNull((Object)string9);
            entity.setText(Intrinsics.stringPlus((String)string8, (Object)StringHelperKt.take(string9, matcher.end())));
            found = true;
        }
        if (!found && (matcher = P_BUILDING_NUM3.matcher(entity.getText())).find()) {
            String string = entity.getText();
            Intrinsics.checkNotNull((Object)string);
            entity.setBuildingNum(StringHelperKt.take(string, matcher.start(), matcher.end() - 1));
            String string10 = StringHelperKt.head(entity.getText(), matcher.start());
            String string11 = entity.getText();
            Intrinsics.checkNotNull((Object)string11);
            entity.setText(Intrinsics.stringPlus((String)string10, (Object)StringHelperKt.take(string11, matcher.end())));
            found = true;
        }
        return found;
    }

    private final void removeSpecialChars(AddressEntity entity) {
        CharSequence charSequence = entity.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String string = entity.getText();
        Intrinsics.checkNotNull((Object)string);
        String text = string;
        text = StringHelperKt.remove$default(text, specialChars1, null, 2, null);
        text = StringHelperKt.removeRepeatNum(text, 6);
        entity.setText(text);
        String building = entity.getBuildingNum();
        CharSequence charSequence2 = building;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            return;
        }
        building = StringHelperKt.remove(building, specialChars1, "-\u4e00\uff0d_#");
        building = StringHelperKt.removeRepeatNum(building, 6);
        entity.setBuildingNum(building);
    }

    private final void removeBrackets(AddressEntity entity) {
        CharSequence charSequence = entity.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String string = entity.getText();
        Intrinsics.checkNotNull((Object)string);
        entity.setText(StringHelperKt.remove$default(string, specialChars2, null, 2, null));
    }

    private final String extractBrackets(AddressEntity entity) {
        CharSequence charSequence = entity.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "";
        }
        Matcher matcher = BRACKET_PATTERN.matcher(entity.getText());
        boolean found = false;
        StringBuilder brackets = new StringBuilder();
        while (matcher.find()) {
            String bracket = matcher.group("bracket");
            if (bracket.length() <= 2) continue;
            Intrinsics.checkNotNullExpressionValue((Object)bracket, (String)"bracket");
            brackets.append(StringHelperKt.take(bracket, 1, bracket.length() - 2));
            found = true;
        }
        if (found) {
            String string = brackets.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"brackets.toString()");
            String result = string;
            entity.setText(matcher.replaceAll(""));
            return result;
        }
        return "";
    }

    private final boolean extractRegion(AddressEntity entity, TermIndexVisitor visitor) {
        CharSequence charSequence = entity.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        visitor.reset();
        TermIndexBuilder termIndexBuilder = this.indexBuilder;
        Intrinsics.checkNotNull((Object)termIndexBuilder);
        termIndexBuilder.deepMostQuery(entity.getText(), visitor);
        entity.setProvince(visitor.devision().getProvince());
        entity.setCity(visitor.devision().getCity());
        entity.setDistrict(visitor.devision().getDistrict());
        entity.setStreet(visitor.devision().getStreet());
        entity.setTown(visitor.devision().getTown());
        entity.setVillage(visitor.devision().getVillage());
        String string = entity.getText();
        Intrinsics.checkNotNull((Object)string);
        entity.setText(StringHelperKt.take(string, visitor.endPosition() + 1));
        return visitor.hasResult();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean removeRedundancy(AddressEntity entity, TermIndexVisitor visitor) {
        var3_3 = entity.getText();
        if (var3_3 == null || StringsKt.isBlank((CharSequence)var3_3) != false || !entity.hasProvince() || !entity.hasCity()) {
            return false;
        }
        removed = false;
        v0 = entity.getText();
        Intrinsics.checkNotNull((Object)v0);
        endIndex = v0.length() - 2;
        i = 0;
        while (i < endIndex) {
            block19: {
                block18: {
                    visitor.reset();
                    v1 = this.indexBuilder;
                    Intrinsics.checkNotNull((Object)v1);
                    v1.deepMostQuery(entity.getText(), i, visitor);
                    if (visitor.matchCount() < 2 || visitor.fullMatchCount() < 1) {
                        var6_7 = i;
                        i = var6_7 + 1;
                        continue;
                    }
                    v2 = entity.getProvince();
                    Intrinsics.checkNotNull((Object)v2);
                    if (!Intrinsics.areEqual((Object)v2, (Object)visitor.devision().getProvince())) break block18;
                    v3 = entity.getCity();
                    Intrinsics.checkNotNull((Object)v3);
                    if (Intrinsics.areEqual((Object)v3, (Object)visitor.devision().getCity())) break block19;
                }
                var6_8 = i;
                i = var6_8 + 1;
                continue;
            }
            devision = visitor.devision();
            if (!entity.hasDistrict() && devision.hasDistrict()) {
                v4 = devision.getDistrict();
                Intrinsics.checkNotNull((Object)v4);
                v5 = v4.getParentId();
                v6 = entity.getCity();
                Intrinsics.checkNotNull((Object)v6);
                if (v5 == v6.getId()) {
                    entity.setDistrict(devision.getDistrict());
                }
            }
            if (entity.hasDistrict() && !entity.hasStreet() && devision.hasStreet()) {
                v7 = devision.getStreet();
                Intrinsics.checkNotNull((Object)v7);
                v8 = v7.getParentId();
                v9 = entity.getDistrict();
                Intrinsics.checkNotNull((Object)v9);
                if (v8 == v9.getId()) {
                    entity.setStreet(devision.getStreet());
                }
            }
            if (!entity.hasDistrict() || entity.hasTown() || !devision.hasTown()) ** GOTO lbl-1000
            v10 = devision.getTown();
            Intrinsics.checkNotNull((Object)v10);
            v11 = v10.getParentId();
            v12 = entity.getDistrict();
            Intrinsics.checkNotNull((Object)v12);
            if (v11 == v12.getId()) {
                entity.setTown(devision.getTown());
            } else if (entity.hasDistrict() && entity.hasTown()) {
                v13 = entity.getTown();
                Intrinsics.checkNotNull((Object)v13);
                if (Intrinsics.areEqual((Object)v13, (Object)entity.getStreet()) && devision.hasTown()) {
                    v14 = devision.getTown();
                    Intrinsics.checkNotNull((Object)v14);
                    if (!Intrinsics.areEqual((Object)v14, (Object)devision.getStreet())) {
                        v15 = devision.getTown();
                        Intrinsics.checkNotNull((Object)v15);
                        v16 = v15.getParentId();
                        v17 = entity.getDistrict();
                        Intrinsics.checkNotNull((Object)v17);
                        if (v16 == v17.getId()) {
                            entity.setTown(devision.getTown());
                        }
                    }
                }
            }
            if (entity.hasDistrict() && !entity.hasVillage() && devision.hasVillage()) {
                v18 = devision.getVillage();
                Intrinsics.checkNotNull((Object)v18);
                v19 = v18.getParentId();
                v20 = entity.getDistrict();
                Intrinsics.checkNotNull((Object)v20);
                if (v19 == v20.getId()) {
                    entity.setVillage(devision.getVillage());
                }
            }
            v21 = entity.getText();
            Intrinsics.checkNotNull((Object)v21);
            entity.setText(StringHelperKt.take(v21, visitor.endPosition() + 1));
            v22 = entity.getText();
            Intrinsics.checkNotNull((Object)v22);
            endIndex = v22.length();
            i = 0;
            removed = true;
        }
        return removed;
    }

    private final boolean extractRoad(AddressEntity entity) {
        Matcher matcher;
        CharSequence charSequence = entity.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        if (entity.getRoad() != null) {
            String string = entity.getRoad();
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                return true;
            }
        }
        if ((matcher = P_ROAD.matcher(entity.getText())).find()) {
            String string;
            String road = matcher.group("road");
            String ex = matcher.group("ex");
            String roadNum = matcher.group("roadnum");
            String string2 = ex;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = roadNum) == null) {
                string = "";
            }
            roadNum = Intrinsics.stringPlus((String)string2, (Object)string);
            String string3 = entity.getText();
            Intrinsics.checkNotNull((Object)string3);
            String leftText = StringHelperKt.take(string3, road.length() + roadNum.length());
            if (StringsKt.startsWith$default((String)leftText, (String)"\u5c0f\u533a", (boolean)false, (int)2, null)) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)road, (String)"road");
            entity.setRoad(this.fixRoad(road));
            if (roadNum.length() == 1) {
                entity.setText(Intrinsics.stringPlus((String)roadNum, (Object)leftText));
            } else {
                entity.setRoadNum(roadNum);
                entity.setText(leftText);
            }
            CharSequence charSequence2 = entity.getBuildingNum();
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                this.fixRoadBuilding(entity);
            }
            return true;
        }
        return false;
    }

    private final String fixRoad(String road) {
        if (StringsKt.isBlank((CharSequence)road) || road.length() % 2 == 1) {
            return road;
        }
        String string = road.substring(0, road.length() / 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String first = string;
        string = road.substring(road.length() / 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String second = string;
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return first;
        }
        return road;
    }

    private final boolean fixRoadBuilding(AddressEntity entity) {
        CharSequence charSequence = entity.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        Matcher matcher = P_ROAD_BUILDING.matcher(entity.getText());
        if (matcher.find() && matcher.start() == 0) {
            String string = entity.getText();
            Intrinsics.checkNotNull((Object)string);
            entity.setBuildingNum(StringHelperKt.take(string, matcher.start(), matcher.end() - 1));
            String string2 = StringHelperKt.head(entity.getText(), matcher.start());
            String string3 = entity.getText();
            Intrinsics.checkNotNull((Object)string3);
            entity.setText(Intrinsics.stringPlus((String)string2, (Object)StringHelperKt.take(string3, matcher.end())));
            return true;
        }
        return false;
    }

    private final void extractTownVillage(AddressEntity addr) {
        Pattern pattern = P_TOWN1;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"P_TOWN1");
        if (this.extractTownVillage(addr, pattern, "z", null, "c") >= 0) {
            return;
        }
        if (addr.hasTown()) {
            pattern = P_TOWN3;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"P_TOWN3");
            this.extractTownVillage(addr, pattern, null, null, "c");
        } else {
            pattern = P_TOWN2;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"P_TOWN2");
            this.extractTownVillage(addr, pattern, "z", "x", "c");
        }
    }

    private final int extractTownVillage(AddressEntity addr, Pattern pattern, String gz, String gx, String gc) {
        CharSequence charSequence = addr.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !addr.hasDistrict()) {
            return 0;
        }
        int result = -1;
        Matcher matcher = pattern.matcher(addr.getText());
        if (matcher.find()) {
            CharSequence x;
            CharSequence charSequence2;
            int ic;
            String string = addr.getText();
            Intrinsics.checkNotNull((Object)string);
            String text = string;
            String c = gc == null ? null : matcher.group("c");
            int n = ic = gc == null ? -1 : matcher.end("c");
            if (gz != null) {
                String z = matcher.group(gz);
                int iz = matcher.end(gz);
                charSequence2 = z;
                if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                    if (z.length() == 2 && StringsKt.startsWith$default((String)text, (String)"\u6751", (int)z.length(), (boolean)false, (int)4, null)) {
                        c = Intrinsics.stringPlus((String)z, (Object)"\u6751");
                        ic = iz + 1;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)z, (String)"z");
                        if (this.isAcceptableTownFollowingChars(z, text, z.length()) && this.acceptTown(z, addr.getDistrict()) >= 0) {
                            addr.setText(StringHelperKt.take(text, iz));
                            result = 1;
                        }
                    }
                }
            }
            if (gx != null) {
                x = matcher.group(gx);
                int ix = matcher.end(gx);
                charSequence2 = x;
                if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                    if (((String)x).length() == 2 && StringsKt.startsWith$default((String)text, (String)"\u6751", (int)((String)x).length(), (boolean)false, (int)4, null)) {
                        c = Intrinsics.stringPlus((String)x, (Object)"\u6751");
                        ic = ix + 1;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
                        if (this.isAcceptableTownFollowingChars((String)x, text, ((String)x).length()) && this.acceptTown((String)x, addr.getDistrict()) >= 0) {
                            addr.setText(StringHelperKt.take(text, ix));
                            result = 1;
                        }
                    }
                }
            }
            if (!((x = (CharSequence)c) == null || StringsKt.isBlank((CharSequence)x))) {
                if (StringsKt.endsWith$default((String)c, (String)"\u519c\u6751", (boolean)false, (int)2, null)) {
                    return result;
                }
                String leftString = StringHelperKt.take(text, ic);
                if (StringsKt.endsWith$default((String)c, (String)"\u6751\u6751", (boolean)false, (int)2, null)) {
                    c = StringHelperKt.head(c, c.length() - 1);
                    leftString = Intrinsics.stringPlus((String)"\u6751", (Object)leftString);
                }
                if (StringsKt.startsWith$default((String)leftString, (String)"\u59d4", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)leftString, (String)"\u6c11\u59d4\u5458", (boolean)false, (int)2, null)) {
                    leftString = Intrinsics.stringPlus((String)"\u6751", (Object)leftString);
                }
                String string2 = c;
                Intrinsics.checkNotNull((Object)string2);
                if (string2.length() >= 4 && (c.charAt(0) == '\u4e1c' || c.charAt(0) == '\u897f' || c.charAt(0) == '\u5357' || c.charAt(0) == '\u5317')) {
                    c = StringHelperKt.tail(c, c.length() - 1);
                }
                String string3 = c;
                Intrinsics.checkNotNull((Object)string3);
                if (string3.length() == 2 && !this.isAcceptableTownFollowingChars(c, leftString, 0)) {
                    return ic;
                }
                if (this.acceptTown(c, addr.getDistrict()) >= 0) {
                    addr.setText(leftString);
                    result = 1;
                }
            }
        }
        return result;
    }

    private final boolean isAcceptableTownFollowingChars(String matched, String text, int start) {
        char c;
        if (text == null || start >= text.length()) {
            return true;
        }
        if (matched.length() == 4 && (((((((c = text.charAt(start)) == '\u533a' ? true : c == '\u53bf') ? true : c == '\u4e61') ? true : c == '\u9547') ? true : c == '\u6751') ? true : c == '\u8857') ? true : c == '\u8def')) {
            return false;
        }
        String s1 = StringHelperKt.take(text, start, start + 1);
        if (invalidTownFollowings.contains(s1)) {
            return false;
        }
        s1 = StringHelperKt.take(text, start, start + 2);
        return !invalidTownFollowings.contains(s1);
    }

    private final int acceptTown(String town, RegionEntity district) {
        CharSequence charSequence = town;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || district == null) {
            return -1;
        }
        if (invalidTown.contains(town)) {
            return -1;
        }
        TermIndexBuilder termIndexBuilder = this.indexBuilder;
        Intrinsics.checkNotNull((Object)termIndexBuilder);
        List<TermIndexItem> items = termIndexBuilder.fullMatch(town);
        if (items != null) {
            for (TermIndexItem item : items) {
                RegionEntity region;
                if (item.getType() != TermType.Town && item.getType() != TermType.Street && item.getType() != TermType.Village) continue;
                if (item.getValue() == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.bitlap.geocoding.model.RegionEntity");
                }
                if (region.getParentId() != district.getId()) continue;
                return 0;
            }
        }
        if (town.length() == 4 && town.charAt(2) == '\u8857') {
            return -1;
        }
        return 1;
    }

    @Override
    @NotNull
    public TermIndexBuilder getTermIndexBuilder() {
        TermIndexBuilder termIndexBuilder = this.indexBuilder;
        Intrinsics.checkNotNull((Object)termIndexBuilder);
        return termIndexBuilder;
    }

    static {
        char[] cArray = "\u3000 \r\n\t,\uff0c\u3002\u00b7.\uff0e;\uff1b:\uff1a\u3001\uff01@$%*^`~=+&'\"|_-\\/".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        specialChars1 = cArray;
        cArray = "{}\u3010\u3011\u3008\u3009<>[]\u300c\u300d\u201c\u201d\uff08\uff09()".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        specialChars2 = cArray;
        P_BUILDING_NUM0 = Pattern.compile("((\u8def|\u8857|\u5df7)[0-9]+\u53f7([0-9A-Z\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341][\\#\\-\u4e00\uff0d\u2014/\\\\]|\u697c)?)?([0-9A-Z\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+(\u680b|\u6a66|\u5e62|\u5ea7|\u53f7\u697c|\u53f7|\u697c|\\#\u697c?)){0,1}([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u4e1c\u897f\u5357\u5317\u7532\u4e59\u4e190-9]+([\\#\\-\u4e00\uff0d\u2014/\\\\]|\u5355\u5143|\u95e8|\u68af|\u5c42|\u5ea7|\u7ec4))?([0-9]+([\\#\\-\u4e00\uff0d\u2014/\\\\]|\u5ba4|\u623f|\u5c42|\u697c|\u53f7|\u6237)?)?([0-9]+\u53f7?)?");
        P_BUILDING_NUM1 = Pattern.compile("((\u8def|\u8857|\u5df7)[0-9]+\u53f7)?([0-9A-Z\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+(\u680b|\u6a66|\u5e62|\u5ea7|\u53f7\u697c|\u53f7|\\#\u697c?)){0,1}([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u4e1c\u897f\u5357\u5317\u7532\u4e59\u4e190-9]+(\u5355\u5143|\u95e8|\u68af|\u5c42|\u5ea7))?([0-9]+(\u5ba4|\u623f)?)?");
        P_BUILDING_NUM_V = Pattern.compile("(\u680b|\u5e62|\u6a66|\u53f7\u697c|\u53f7|\\#|\\#\u697c|\u5355\u5143|\u5ba4|\u623f|\u95e8)+");
        P_BUILDING_NUM2 = Pattern.compile("[A-Za-z0-9]+([\\#\\-\u4e00\uff0d/\\\\]+[A-Za-z0-9]+)+");
        P_BUILDING_NUM3 = Pattern.compile("[0-9]+(\u7ec4|\u901a\u9053)[A-Z0-9\\-\u4e00]+\u53f7?");
        BRACKET_PATTERN = Pattern.compile("(?<bracket>([\\(\uff08\\{\\<\u3008\\[\u3010\u300c][^\\)\uff09\\}\\>\u3009\\]\u3011\u300d]*[\\)\uff09\\}\\>\u3009\\]\u3011\u300d]))");
        P_ROAD = Pattern.compile("^(?<road>([\u4e00-\u9fa5]{2,6}(\u8def|\u8857\u574a|\u8857|\u9053|\u5927\u8857|\u5927\u9053)))(?<ex>[\u7532\u4e59\u4e19\u4e01])?(?<roadnum>[0-9\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+(\u53f7\u9662|\u53f7\u697c|\u53f7\u5927\u9662|\u53f7|\u865f|\u5df7|\u5f04|\u9662|\u533a|\u6761|\\#\u9662|\\#))?");
        P_ROAD_BUILDING = Pattern.compile("[0-9A-Z\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+(\u680b|\u6a66|\u5e62|\u5ea7|\u53f7\u697c|\u53f7|\\#\u697c?)");
        P_TOWN1 = Pattern.compile("^((?<z>[\u4e00-\u9fa5]{2,2}(\u9547|\u4e61))(?<c>[\u4e00-\u9fa5]{1,3}\u6751)?)");
        P_TOWN2 = Pattern.compile("^((?<z>[\u4e00-\u9fa5]{1,3}\u9547)?(?<x>[\u4e00-\u9fa5]{1,3}\u4e61)?(?<c>[\u4e00-\u9fa5]{1,3}\u6751(?!(\u6751|\u59d4|\u516c\u8def|(\u4e1c|\u897f|\u5357|\u5317)?(\u5927\u8857|\u5927\u9053|\u8def|\u8857))))?)");
        P_TOWN3 = Pattern.compile("^(?<c>[\u4e00-\u9fa5]{1,3}\u6751(?!(\u6751|\u59d4|\u516c\u8def|(\u4e1c|\u897f|\u5357|\u5317)?(\u5927\u8857|\u5927\u9053|\u8def|\u8857))))?");
        invalidTown = new LinkedHashSet();
        invalidTownFollowings = new LinkedHashSet();
        invalidTownFollowings.add("\u653f\u5e9c");
        invalidTownFollowings.add("\u5927\u8857");
        invalidTownFollowings.add("\u5927\u9053");
        invalidTownFollowings.add("\u793e\u533a");
        invalidTownFollowings.add("\u5c0f\u533a");
        invalidTownFollowings.add("\u5c0f\u5b66");
        invalidTownFollowings.add("\u4e2d\u5b66");
        invalidTownFollowings.add("\u533b\u9662");
        invalidTownFollowings.add("\u94f6\u884c");
        invalidTownFollowings.add("\u4e2d\u5fc3");
        invalidTownFollowings.add("\u536b\u751f");
        invalidTownFollowings.add("\u4e00\u5c0f");
        invalidTownFollowings.add("\u4e00\u4e2d");
        invalidTownFollowings.add("\u653f\u5c40");
        invalidTownFollowings.add("\u4f01\u5c40");
        invalidTown.add("\u65b0\u6751");
        invalidTown.add("\u5916\u6751");
        invalidTown.add("\u5927\u6751");
        invalidTown.add("\u540e\u6751");
        invalidTown.add("\u4e1c\u6751");
        invalidTown.add("\u5357\u6751");
        invalidTown.add("\u5317\u6751");
        invalidTown.add("\u897f\u6751");
        invalidTown.add("\u4e0a\u6751");
        invalidTown.add("\u4e0b\u6751");
        invalidTown.add("\u4e00\u6751");
        invalidTown.add("\u4e8c\u6751");
        invalidTown.add("\u4e09\u6751");
        invalidTown.add("\u56db\u6751");
        invalidTown.add("\u4e94\u6751");
        invalidTown.add("\u516d\u6751");
        invalidTown.add("\u4e03\u6751");
        invalidTown.add("\u516b\u6751");
        invalidTown.add("\u4e5d\u6751");
        invalidTown.add("\u5341\u6751");
        invalidTown.add("\u4e2d\u6751");
        invalidTown.add("\u8857\u6751");
        invalidTown.add("\u5934\u6751");
        invalidTown.add("\u5e97\u6751");
        invalidTown.add("\u6865\u6751");
        invalidTown.add("\u697c\u6751");
        invalidTown.add("\u8001\u6751");
        invalidTown.add("\u6237\u6751");
        invalidTown.add("\u5c71\u6751");
        invalidTown.add("\u624d\u6751");
        invalidTown.add("\u5b50\u6751");
        invalidTown.add("\u65e7\u6751");
        invalidTown.add("\u6587\u6751");
        invalidTown.add("\u5168\u6751");
        invalidTown.add("\u548c\u6751");
        invalidTown.add("\u6e56\u6751");
        invalidTown.add("\u7532\u6751");
        invalidTown.add("\u4e59\u6751");
        invalidTown.add("\u4e19\u6751");
        invalidTown.add("\u90bb\u6751");
        invalidTown.add("\u4e61\u6751");
        invalidTown.add("\u6751\u4e8c\u6751");
        invalidTown.add("\u4e2d\u5173\u6751");
        invalidTown.add("\u57ce\u4e61");
        invalidTown.add("\u53bf\u4e61");
        invalidTown.add("\u5934\u4e61");
        invalidTown.add("\u724c\u4e61");
        invalidTown.add("\u8336\u4e61");
        invalidTown.add("\u6c34\u4e61");
        invalidTown.add("\u6e2f\u4e61");
        invalidTown.add("\u5df7\u4e61");
        invalidTown.add("\u4e03\u4e61");
        invalidTown.add("\u7ad9\u4e61");
        invalidTown.add("\u897f\u4e61");
        invalidTown.add("\u5b9d\u4e61");
        invalidTown.add("\u8fd8\u4e61");
        invalidTown.add("\u53e4\u9547");
        invalidTown.add("\u5c0f\u9547");
        invalidTown.add("\u8857\u9547");
        invalidTown.add("\u57ce\u9547");
        invalidTown.add("\u73af\u9547");
        invalidTown.add("\u6e7e\u9547");
        invalidTown.add("\u5c97\u9547");
        invalidTown.add("\u9547\u9547");
        invalidTown.add("\u573a\u9547");
        invalidTown.add("\u65b0\u9547");
        invalidTown.add("\u4e61\u9547");
        invalidTown.add("\u5c6f\u9547");
        invalidTown.add("\u5927\u9547");
        invalidTown.add("\u5357\u9547");
        invalidTown.add("\u5e97\u9547");
        invalidTown.add("\u94fa\u9547");
        invalidTown.add("\u5173\u9547");
        invalidTown.add("\u53e3\u9547");
        invalidTown.add("\u548c\u9547");
        invalidTown.add("\u5efa\u9547");
        invalidTown.add("\u96c6\u9547");
        invalidTown.add("\u5e99\u9547");
        invalidTown.add("\u6cb3\u9547");
        invalidTown.add("\u6751\u9547");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/bitlap/geocoding/core/impl/DefaultAddressInterpreter$Companion;", "", "()V", "BRACKET_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "P_BUILDING_NUM0", "P_BUILDING_NUM1", "P_BUILDING_NUM2", "P_BUILDING_NUM3", "P_BUILDING_NUM_V", "P_ROAD", "P_ROAD_BUILDING", "P_TOWN1", "P_TOWN2", "P_TOWN3", "invalidTown", "", "", "invalidTownFollowings", "specialChars1", "", "specialChars2", "geocoding"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

