/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.geocoding.core.impl;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bitlap.geocoding.core.RegionCache;
import org.bitlap.geocoding.model.RegionEntity;
import org.bitlap.geocoding.model.RegionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/bitlap/geocoding/core/impl/DefaultRegionCache;", "Lorg/bitlap/geocoding/core/RegionCache;", "dataClassPath", "", "(Ljava/lang/String;)V", "REGION_CACHE", "Ljava/util/HashMap;", "", "Lorg/bitlap/geocoding/model/RegionEntity;", "Lkotlin/collections/HashMap;", "regions", "addRegionEntity", "", "entity", "decode", "dat", "get", "getCache", "", "loadChildrenInCache", "parent", "geocoding"})
public class DefaultRegionCache
implements RegionCache {
    @Nullable
    private RegionEntity regions;
    @NotNull
    private final HashMap<Long, RegionEntity> REGION_CACHE;

    public DefaultRegionCache(@NotNull String dataClassPath) {
        Intrinsics.checkNotNullParameter((Object)dataClassPath, (String)"dataClassPath");
        this.REGION_CACHE = new HashMap();
        if (this.regions == null) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(dataClassPath);
            if (inputStream == null) {
                throw new IllegalArgumentException("Geocoding data file [" + dataClassPath + "] does not exist.");
            }
            InputStream input = inputStream;
            this.regions = (RegionEntity)new Gson().fromJson(this.decode(new String(ByteStreamsKt.readBytes((InputStream)input), Charsets.UTF_8)), RegionEntity.class);
        }
        Map map = this.REGION_CACHE;
        RegionEntity regionEntity = this.regions;
        Intrinsics.checkNotNull((Object)regionEntity);
        Long l = regionEntity.getId();
        RegionEntity regionEntity2 = this.regions;
        Intrinsics.checkNotNull((Object)regionEntity2);
        map.put(l, regionEntity2);
        this.loadChildrenInCache(this.regions);
    }

    private final void loadChildrenInCache(RegionEntity parent) {
        if (parent == null || parent.getType() == RegionType.Street || parent.getType() == RegionType.Village || parent.getType() == RegionType.PlatformL4 || parent.getType() == RegionType.Town) {
            return;
        }
        ArrayList<RegionEntity> arrayList = parent.getChildren();
        if (arrayList != null) {
            Iterable $this$forEach$iv = arrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RegionEntity it = (RegionEntity)element$iv;
                boolean bl = false;
                Map map = this.REGION_CACHE;
                Long l = it.getId();
                map.put(l, it);
                this.loadChildrenInCache(it);
            }
        }
    }

    private final String decode(String dat) {
        return new String(ByteStreamsKt.readBytes((InputStream)new GZIPInputStream(new ByteArrayInputStream(Base64.getMimeDecoder().decode(dat)))), Charsets.UTF_8);
    }

    @Override
    @NotNull
    public RegionEntity get() {
        if (this.regions == null) {
            throw new IllegalArgumentException("\u884c\u653f\u89c4\u5212\u533a\u57df\u6570\u636e\u52a0\u8f7d\u5931\u8d25!");
        }
        RegionEntity regionEntity = this.regions;
        Intrinsics.checkNotNull((Object)regionEntity);
        return regionEntity;
    }

    @Override
    @NotNull
    public Map<Long, RegionEntity> getCache() {
        return this.REGION_CACHE;
    }

    @Override
    public void addRegionEntity(@NotNull RegionEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.loadChildrenInCache(entity);
        Map map = this.REGION_CACHE;
        Long l = entity.getId();
        map.put(l, entity);
        RegionEntity regionEntity = this.REGION_CACHE.get(entity.getParentId());
        if (regionEntity != null) {
            ArrayList<RegionEntity> arrayList = regionEntity.getChildren();
            if (arrayList != null) {
                arrayList.add(entity);
            }
        }
    }
}

