/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.geocoding.core.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bitlap.geocoding.core.AddressPersister;
import org.bitlap.geocoding.core.TermIndexVisitor;
import org.bitlap.geocoding.index.TermIndexEntry;
import org.bitlap.geocoding.index.TermIndexItem;
import org.bitlap.geocoding.index.TermType;
import org.bitlap.geocoding.model.Division;
import org.bitlap.geocoding.model.RegionEntity;
import org.bitlap.geocoding.model.RegionType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 62\u00020\u0001:\u00016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0016J\"\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\b\u0010,\u001a\u00020\nH\u0016J\b\u0010-\u001a\u00020\nH\u0016J*\u0010.\u001a\u00020\n2\b\u0010/\u001a\u0004\u0018\u00010+2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002J\b\u00100\u001a\u00020\u0019H\u0016J\b\u00101\u001a\u00020\u0019H\u0016J\u0012\u00102\u001a\u00020\u00192\b\u00103\u001a\u0004\u0018\u00010+H\u0002J\u001a\u00104\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u00105\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00067"}, d2={"Lorg/bitlap/geocoding/core/impl/RegionInterpreterVisitor;", "Lorg/bitlap/geocoding/core/TermIndexVisitor;", "persister", "Lorg/bitlap/geocoding/core/AddressPersister;", "strict", "", "(Lorg/bitlap/geocoding/core/AddressPersister;Z)V", "curDivision", "Lorg/bitlap/geocoding/model/Division;", "currentLevel", "", "currentPos", "deepMostDivision", "deepMostFullMatchCount", "deepMostLevel", "deepMostPos", "fullMatchCount", "getPersister", "()Lorg/bitlap/geocoding/core/AddressPersister;", "stack", "Ljava/util/ArrayDeque;", "Lorg/bitlap/geocoding/index/TermIndexItem;", "getStrict", "()Z", "checkDeepMost", "", "devision", "endPosition", "endRound", "endVisit", "entry", "Lorg/bitlap/geocoding/index/TermIndexEntry;", "text", "", "pos", "findAcceptableItem", "hasResult", "hasThreeDivision", "isAcceptableItemType", "type", "Lorg/bitlap/geocoding/index/TermType;", "isFullMatch", "region", "Lorg/bitlap/geocoding/model/RegionEntity;", "matchCount", "position", "positioning", "acceptedRegion", "reset", "startRound", "updateCityAndProvince", "distinct", "updateCurrentDivisionState", "visit", "Companion", "geocoding"})
public class RegionInterpreterVisitor
implements TermIndexVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AddressPersister persister;
    private final boolean strict;
    private int currentLevel;
    private int deepMostLevel;
    private int currentPos;
    private int deepMostPos;
    private int fullMatchCount;
    private int deepMostFullMatchCount;
    @NotNull
    private final Division deepMostDivision;
    @NotNull
    private final Division curDivision;
    @NotNull
    private final ArrayDeque<TermIndexItem> stack;
    @NotNull
    private static final List<Character> ambiguousChars;

    public RegionInterpreterVisitor(@NotNull AddressPersister persister, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)persister, (String)"persister");
        this.persister = persister;
        this.strict = strict;
        this.currentPos = -1;
        this.deepMostPos = -1;
        this.deepMostDivision = new Division();
        this.curDivision = new Division();
        this.stack = new ArrayDeque();
    }

    @NotNull
    public final AddressPersister getPersister() {
        return this.persister;
    }

    public final boolean getStrict() {
        return this.strict;
    }

    @Override
    public void startRound() {
        int n = this.currentLevel;
        this.currentLevel = n + 1;
    }

    @Override
    public boolean visit(@NotNull TermIndexEntry entry, @NotNull String text, int pos) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermIndexItem termIndexItem = this.findAcceptableItem(entry, text, pos);
        if (termIndexItem == null) {
            return false;
        }
        TermIndexItem acceptableItem = termIndexItem;
        RegionEntity regionEntity = acceptableItem.getValue();
        RegionEntity region = regionEntity instanceof RegionEntity ? regionEntity : null;
        this.stack.push(acceptableItem);
        if (this.isFullMatch(entry, region)) {
            int n = this.fullMatchCount;
            this.fullMatchCount = n + 1;
        }
        this.currentPos = this.positioning(region, entry, text, pos);
        this.updateCurrentDivisionState(region, entry);
        return true;
    }

    private final TermIndexItem findAcceptableItem(TermIndexEntry entry, String text, int pos) {
        int mostPriority = -1;
        TermIndexItem acceptableItem = null;
        block5: for (TermIndexItem item : entry.getItems()) {
            RegionEntity region;
            block27: {
                block29: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block28: {
                                        char c;
                                        char c2;
                                        RegionType[] regionTypeArray;
                                        TermType termType = item.getType();
                                        Intrinsics.checkNotNull((Object)((Object)termType));
                                        if (!this.isAcceptableItemType(termType)) continue;
                                        if (item.getType() == TermType.Ignore) {
                                            if (acceptableItem != null) continue;
                                            mostPriority = 4;
                                            acceptableItem = item;
                                            continue;
                                        }
                                        if (item.getValue() == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type org.bitlap.geocoding.model.RegionEntity");
                                        }
                                        if (!this.curDivision.hasProvince()) {
                                            char c3;
                                            if (!this.isFullMatch(entry, region) && pos + 1 <= text.length() - 1 && (region.getType() == RegionType.Province || region.getType() == RegionType.City || region.getType() == RegionType.CityLevelDistrict || region.getType() == RegionType.District || region.getType() == RegionType.Street || region.getType() == RegionType.PlatformL4 || region.getType() == RegionType.Town) && ((((c3 = text.charAt(pos + 1)) == '\u8def' ? true : c3 == '\u8857') ? true : c3 == '\u5df7') ? true : c3 == '\u9053')) continue;
                                            if (mostPriority == -1) {
                                                mostPriority = region.getType().getValue();
                                                acceptableItem = item;
                                            }
                                            if (region.getType().getValue() >= mostPriority) continue;
                                            mostPriority = region.getType().getValue();
                                            acceptableItem = item;
                                            continue;
                                        }
                                        if (!this.isFullMatch(entry, region) && this.hasThreeDivision()) {
                                            switch (WhenMappings.$EnumSwitchMapping$0[region.getType().ordinal()]) {
                                                case 1: {
                                                    long l = region.getId();
                                                    RegionEntity regionEntity = this.curDivision.getProvince();
                                                    Intrinsics.checkNotNull((Object)regionEntity);
                                                    if (l == regionEntity.getId()) break;
                                                    continue block5;
                                                }
                                                case 2: 
                                                case 3: {
                                                    long l = region.getId();
                                                    RegionEntity regionEntity = this.curDivision.getCity();
                                                    Intrinsics.checkNotNull((Object)regionEntity);
                                                    if (l == regionEntity.getId()) break;
                                                    continue block5;
                                                }
                                                case 4: {
                                                    long l = region.getId();
                                                    RegionEntity regionEntity = this.curDivision.getDistrict();
                                                    Intrinsics.checkNotNull((Object)regionEntity);
                                                    if (l == regionEntity.getId()) break;
                                                    continue block5;
                                                }
                                            }
                                        }
                                        if (!this.isFullMatch(entry, region) && pos + 1 <= text.length() - 1 && (region.getType() == RegionType.Province || region.getType() == RegionType.City || CollectionsKt.listOf((Object[])(regionTypeArray = new RegionType[]{RegionType.CityLevelDistrict, RegionType.District})).contains((Object)region.getType()) || region.getType() == RegionType.Street || region.getType() == RegionType.Town) && ((((((((c2 = text.charAt(pos + 1)) == '\u533a' ? true : c2 == '\u53bf') ? true : c2 == '\u4e61') ? true : c2 == '\u9547') ? true : c2 == '\u6751') ? true : c2 == '\u8857') ? true : c2 == '\u8def') || c2 == '\u5927' && pos + 2 <= text.length() - 1 && ((c = text.charAt(pos + 2)) == '\u8857' || c == '\u9053'))) continue;
                                        if (region.getParentId() == this.curDivision.leastRegion().getId()) {
                                            acceptableItem = item;
                                            break;
                                        }
                                        if (mostPriority == -1 || mostPriority > 2) {
                                            RegionEntity parent = this.persister.getRegion(region.getParentId());
                                            if (!this.curDivision.hasCity() && this.curDivision.hasProvince() && region.getType() == RegionType.District) {
                                                RegionEntity regionEntity = this.curDivision.getProvince();
                                                Intrinsics.checkNotNull((Object)regionEntity);
                                                long l = regionEntity.getId();
                                                RegionEntity regionEntity2 = parent;
                                                Intrinsics.checkNotNull((Object)regionEntity2);
                                                if (l == regionEntity2.getParentId()) {
                                                    mostPriority = 2;
                                                    acceptableItem = item;
                                                    continue;
                                                }
                                            }
                                            if (!this.curDivision.hasDistrict() && this.curDivision.hasCity() && (region.getType() == RegionType.Street || region.getType() == RegionType.Town || region.getType() == RegionType.PlatformL4 || region.getType() == RegionType.Village)) {
                                                RegionEntity regionEntity = this.curDivision.getCity();
                                                Intrinsics.checkNotNull((Object)regionEntity);
                                                long l = regionEntity.getId();
                                                RegionEntity regionEntity3 = parent;
                                                Intrinsics.checkNotNull((Object)regionEntity3);
                                                if (l == regionEntity3.getParentId()) {
                                                    mostPriority = 2;
                                                    acceptableItem = item;
                                                    continue;
                                                }
                                            }
                                        }
                                        if (mostPriority != -1 && mostPriority <= 3) break block27;
                                        if (!this.curDivision.hasProvince()) break block28;
                                        RegionEntity regionEntity = this.curDivision.getProvince();
                                        Intrinsics.checkNotNull((Object)regionEntity);
                                        if (regionEntity.getId() == region.getId()) break block29;
                                    }
                                    if (!this.curDivision.hasCity()) break block30;
                                    RegionEntity regionEntity = this.curDivision.getCity();
                                    Intrinsics.checkNotNull((Object)regionEntity);
                                    if (regionEntity.getId() == region.getId()) break block29;
                                }
                                if (!this.curDivision.hasDistrict()) break block31;
                                RegionEntity regionEntity = this.curDivision.getDistrict();
                                Intrinsics.checkNotNull((Object)regionEntity);
                                if (regionEntity.getId() == region.getId()) break block29;
                            }
                            if (!this.curDivision.hasStreet()) break block32;
                            RegionEntity regionEntity = this.curDivision.getStreet();
                            Intrinsics.checkNotNull((Object)regionEntity);
                            if (regionEntity.getId() == region.getId()) break block29;
                        }
                        if (!this.curDivision.hasTown()) break block33;
                        RegionEntity regionEntity = this.curDivision.getTown();
                        Intrinsics.checkNotNull((Object)regionEntity);
                        if (regionEntity.getId() == region.getId()) break block29;
                    }
                    if (!this.curDivision.hasVillage()) break block27;
                    RegionEntity regionEntity = this.curDivision.getVillage();
                    Intrinsics.checkNotNull((Object)regionEntity);
                    if (regionEntity.getId() != region.getId()) break block27;
                }
                mostPriority = 3;
                acceptableItem = item;
                continue;
            }
            if (mostPriority == -1 || mostPriority > 4) {
                if (region.getType() == RegionType.CityLevelDistrict && this.curDivision.hasProvince()) {
                    RegionEntity regionEntity = this.curDivision.getProvince();
                    Intrinsics.checkNotNull((Object)regionEntity);
                    if (regionEntity.getId() == region.getParentId()) {
                        mostPriority = 4;
                        acceptableItem = item;
                        continue;
                    }
                }
                if (region.getType() == RegionType.District && this.curDivision.hasCity() && this.curDivision.hasProvince() && this.isFullMatch(entry, region)) {
                    RegionEntity regionEntity = this.curDivision.getCity();
                    Intrinsics.checkNotNull((Object)regionEntity);
                    if (regionEntity.getId() != region.getParentId()) {
                        RegionEntity city;
                        Intrinsics.checkNotNull((Object)this.persister.getRegion(region.getParentId()));
                        long l = city.getParentId();
                        RegionEntity regionEntity4 = this.curDivision.getProvince();
                        Intrinsics.checkNotNull((Object)regionEntity4);
                        if (l == regionEntity4.getId() && !this.hasThreeDivision()) {
                            mostPriority = 4;
                            acceptableItem = item;
                            continue;
                        }
                    }
                }
            }
            if (region.getType() != RegionType.Street && region.getType() != RegionType.Town && region.getType() != RegionType.Village && region.getType() != RegionType.PlatformL4) continue;
            if (!this.curDivision.hasDistrict()) {
                RegionEntity parent;
                RegionEntity regionEntity = parent = this.persister.getRegion(region.getParentId());
                Intrinsics.checkNotNull((Object)regionEntity);
                parent = this.persister.getRegion(regionEntity.getParentId());
                if (!this.curDivision.hasCity()) continue;
                RegionEntity regionEntity5 = this.curDivision.getCity();
                Intrinsics.checkNotNull((Object)regionEntity5);
                long l = regionEntity5.getId();
                RegionEntity regionEntity6 = parent;
                Intrinsics.checkNotNull((Object)regionEntity6);
                if (l != regionEntity6.getId()) continue;
                mostPriority = 5;
                acceptableItem = item;
                continue;
            }
            long l = region.getParentId();
            RegionEntity regionEntity = this.curDivision.getDistrict();
            Intrinsics.checkNotNull((Object)regionEntity);
            if (l != regionEntity.getId()) continue;
            mostPriority = 5;
            acceptableItem = item;
        }
        return acceptableItem;
    }

    private final boolean isFullMatch(TermIndexEntry entry, RegionEntity region) {
        if (region == null) {
            return false;
        }
        String string = entry.getKey();
        Intrinsics.checkNotNull((Object)string);
        if (string.length() == region.getName().length()) {
            return true;
        }
        if (region.getType() == RegionType.Street && StringsKt.endsWith$default((String)region.getName(), (String)"\u8857\u9053", (boolean)false, (int)2, null)) {
            int n = region.getName().length();
            String string2 = entry.getKey();
            Intrinsics.checkNotNull((Object)string2);
            if (n == string2.length() + 1) {
                return true;
            }
        }
        return false;
    }

    private final boolean isAcceptableItemType(TermType type) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasThreeDivision() {
        if (!this.curDivision.hasProvince()) return false;
        if (!this.curDivision.hasCity()) return false;
        if (!this.curDivision.hasDistrict()) return false;
        RegionEntity regionEntity = this.curDivision.getCity();
        Intrinsics.checkNotNull((Object)regionEntity);
        long l = regionEntity.getParentId();
        RegionEntity regionEntity2 = this.curDivision.getProvince();
        Intrinsics.checkNotNull((Object)regionEntity2);
        if (l != regionEntity2.getId()) return false;
        RegionEntity regionEntity3 = this.curDivision.getDistrict();
        Intrinsics.checkNotNull((Object)regionEntity3);
        long l2 = regionEntity3.getParentId();
        RegionEntity regionEntity4 = this.curDivision.getCity();
        Intrinsics.checkNotNull((Object)regionEntity4);
        if (l2 != regionEntity4.getId()) return false;
        return true;
    }

    private final int positioning(RegionEntity acceptedRegion, TermIndexEntry entry, String text, int pos) {
        if (acceptedRegion == null) {
            return pos;
        }
        if (!(acceptedRegion.getType() != RegionType.City && acceptedRegion.getType() != RegionType.District && acceptedRegion.getType() != RegionType.Street || this.isFullMatch(entry, acceptedRegion) || pos + 1 > text.length() - 1)) {
            char c = text.charAt(pos + 1);
            if (ambiguousChars.contains(Character.valueOf(c))) {
                ArrayList arrayList = acceptedRegion.getChildren();
                for (RegionEntity child : arrayList == null ? new ArrayList() : arrayList) {
                    if (child.getName().charAt(0) != c) continue;
                    return pos;
                }
                return pos + 1;
            }
            if ((this.curDivision.hasTown() || this.curDivision.hasStreet()) && !ambiguousChars.contains(Character.valueOf(c))) {
                this.deepMostPos = this.currentPos;
            }
        }
        return pos;
    }

    private final void updateCurrentDivisionState(RegionEntity region, TermIndexEntry entry) {
        if (region == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)region, (Object)this.curDivision.getProvince()) || Intrinsics.areEqual((Object)region, (Object)this.curDivision.getCity()) || Intrinsics.areEqual((Object)region, (Object)this.curDivision.getDistrict()) || Intrinsics.areEqual((Object)region, (Object)this.curDivision.getStreet()) || Intrinsics.areEqual((Object)region, (Object)this.curDivision.getTown()) || Intrinsics.areEqual((Object)region, (Object)this.curDivision.getVillage())) {
            return;
        }
        boolean needUpdateCityAndProvince = !this.strict || entry.getItems().size() == 1;
        switch (WhenMappings.$EnumSwitchMapping$0[region.getType().ordinal()]) {
            case 1: 
            case 5: {
                this.curDivision.setProvince(region);
                this.curDivision.setCity(null);
                break;
            }
            case 2: 
            case 6: {
                this.curDivision.setCity(region);
                if (this.curDivision.hasProvince()) break;
                this.curDivision.setProvince(this.persister.getRegion(region.getParentId()));
                break;
            }
            case 3: {
                this.curDivision.setCity(region);
                this.curDivision.setDistrict(region);
                if (this.curDivision.hasProvince()) break;
                this.curDivision.setProvince(this.persister.getRegion(region.getParentId()));
                break;
            }
            case 4: {
                this.curDivision.setDistrict(region);
                RegionEntity regionEntity = this.curDivision.getDistrict();
                Intrinsics.checkNotNull((Object)regionEntity);
                this.curDivision.setCity(this.persister.getRegion(regionEntity.getParentId()));
                if (this.curDivision.hasProvince()) break;
                RegionEntity regionEntity2 = this.curDivision.getCity();
                Intrinsics.checkNotNull((Object)regionEntity2);
                this.curDivision.setProvince(this.persister.getRegion(regionEntity2.getParentId()));
                break;
            }
            case 7: 
            case 8: {
                if (!this.curDivision.hasStreet()) {
                    this.curDivision.setStreet(region);
                }
                if (!this.curDivision.hasDistrict()) {
                    this.curDivision.setDistrict(this.persister.getRegion(region.getParentId()));
                }
                if (!needUpdateCityAndProvince) break;
                this.updateCityAndProvince(this.curDivision.getDistrict());
                break;
            }
            case 9: {
                if (!this.curDivision.hasTown()) {
                    this.curDivision.setTown(region);
                }
                if (!this.curDivision.hasDistrict()) {
                    this.curDivision.setDistrict(this.persister.getRegion(region.getParentId()));
                }
                if (!needUpdateCityAndProvince) break;
                this.updateCityAndProvince(this.curDivision.getDistrict());
                break;
            }
            case 10: {
                if (!this.curDivision.hasVillage()) {
                    this.curDivision.setVillage(region);
                }
                if (!this.curDivision.hasDistrict()) {
                    this.curDivision.setDistrict(this.persister.getRegion(region.getParentId()));
                }
                if (!needUpdateCityAndProvince) break;
                this.updateCityAndProvince(this.curDivision.getDistrict());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCityAndProvince(RegionEntity distinct) {
        if (distinct == null) {
            return;
        }
        if (!this.curDivision.hasCity()) {
            RegionEntity regionEntity;
            Division division = this.curDivision;
            RegionEntity regionEntity2 = this.persister.getRegion(distinct.getParentId());
            if (regionEntity2 == null) {
                regionEntity = null;
            } else {
                RegionEntity regionEntity3;
                RegionEntity regionEntity4 = regionEntity3 = regionEntity2;
                Division division2 = division;
                boolean bl = false;
                if (!this.curDivision.hasProvince()) {
                    void city;
                    this.curDivision.setProvince(this.getPersister().getRegion(city.getParentId()));
                }
                division = division2;
                regionEntity = regionEntity3;
            }
            division.setCity(regionEntity);
        }
    }

    @Override
    public int position() {
        return this.currentPos;
    }

    @Override
    public void endVisit(@NotNull TermIndexEntry entry, @NotNull String text, int pos) {
        RegionEntity region;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.checkDeepMost();
        TermIndexItem indexTerm = this.stack.pop();
        String string = entry.getKey();
        Intrinsics.checkNotNull((Object)string);
        this.currentPos = pos - string.length();
        RegionEntity regionEntity = indexTerm.getValue();
        RegionEntity regionEntity2 = region = regionEntity instanceof RegionEntity ? regionEntity : null;
        if (this.isFullMatch(entry, region)) {
            int n = this.fullMatchCount;
            this.fullMatchCount = n + 1;
        }
        if (indexTerm.getType() == TermType.Ignore) {
            return;
        }
        RegionEntity least = null;
        RegionEntity street = null;
        RegionEntity town = null;
        RegionEntity village = null;
        Iterable $this$forEach$iv = this.stack;
        boolean $i$f$forEach = false;
        block9: for (Object element$iv : $this$forEach$iv) {
            RegionEntity r;
            TermIndexItem it = (TermIndexItem)element$iv;
            boolean bl = false;
            if (it.getType() == TermType.Ignore) continue;
            if (it.getValue() == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bitlap.geocoding.model.RegionEntity");
            }
            switch (WhenMappings.$EnumSwitchMapping$0[r.getType().ordinal()]) {
                case 7: 
                case 8: {
                    street = r;
                    continue block9;
                }
                case 9: {
                    town = r;
                    continue block9;
                }
                case 10: {
                    village = r;
                    continue block9;
                }
            }
            if (least != null) continue;
            least = r;
        }
        if (street == null) {
            this.curDivision.setStreet(null);
        }
        if (town == null) {
            this.curDivision.setTown(null);
        }
        if (village == null) {
            this.curDivision.setVillage(null);
        }
        if (this.curDivision.hasStreet() || this.curDivision.hasTown() || this.curDivision.hasVillage()) {
            return;
        }
        if (least != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[least.getType().ordinal()]) {
                case 1: 
                case 5: {
                    this.curDivision.setCity(null);
                    this.curDivision.setDistrict(null);
                    return;
                }
                case 2: 
                case 6: {
                    this.curDivision.setDistrict(null);
                    return;
                }
            }
            return;
        }
        this.curDivision.setProvince(null);
        this.curDivision.setCity(null);
        this.curDivision.setDistrict(null);
    }

    @Override
    public void endRound() {
        this.checkDeepMost();
        int n = this.currentLevel;
        this.currentLevel = n + -1;
    }

    private final void checkDeepMost() {
        if (this.stack.size() > this.deepMostLevel) {
            this.deepMostLevel = this.stack.size();
            this.deepMostPos = this.currentPos;
            this.deepMostFullMatchCount = this.fullMatchCount;
            this.deepMostDivision.setProvince(this.curDivision.getProvince());
            this.deepMostDivision.setCity(this.curDivision.getCity());
            this.deepMostDivision.setDistrict(this.curDivision.getDistrict());
            this.deepMostDivision.setStreet(this.curDivision.getStreet());
            this.deepMostDivision.setTown(this.curDivision.getTown());
            this.deepMostDivision.setVillage(this.curDivision.getVillage());
        }
    }

    @Override
    public boolean hasResult() {
        return this.deepMostPos > 0 && this.deepMostDivision.hasDistrict();
    }

    @Override
    @NotNull
    public Division devision() {
        return this.deepMostDivision;
    }

    @Override
    public int matchCount() {
        return this.deepMostLevel;
    }

    @Override
    public int fullMatchCount() {
        return this.deepMostFullMatchCount;
    }

    @Override
    public int endPosition() {
        return this.deepMostPos;
    }

    @Override
    public void reset() {
        this.currentLevel = 0;
        this.deepMostLevel = 0;
        this.currentPos = -1;
        this.deepMostPos = -1;
        this.fullMatchCount = 0;
        this.deepMostFullMatchCount = 0;
        this.deepMostDivision.setProvince(null);
        this.deepMostDivision.setCity(null);
        this.deepMostDivision.setDistrict(null);
        this.deepMostDivision.setStreet(null);
        this.deepMostDivision.setTown(null);
        this.deepMostDivision.setVillage(null);
        this.curDivision.setProvince(null);
        this.curDivision.setCity(null);
        this.curDivision.setDistrict(null);
        this.curDivision.setStreet(null);
        this.curDivision.setTown(null);
        this.curDivision.setVillage(null);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('\u5e02'), Character.valueOf('\u53bf'), Character.valueOf('\u533a'), Character.valueOf('\u9547'), Character.valueOf('\u4e61')};
        ambiguousChars = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/bitlap/geocoding/core/impl/RegionInterpreterVisitor$Companion;", "", "()V", "ambiguousChars", "", "", "geocoding"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RegionType.values().length];
            nArray[RegionType.Province.ordinal()] = 1;
            nArray[RegionType.City.ordinal()] = 2;
            nArray[RegionType.CityLevelDistrict.ordinal()] = 3;
            nArray[RegionType.District.ordinal()] = 4;
            nArray[RegionType.ProvinceLevelCity1.ordinal()] = 5;
            nArray[RegionType.ProvinceLevelCity2.ordinal()] = 6;
            nArray[RegionType.Street.ordinal()] = 7;
            nArray[RegionType.PlatformL4.ordinal()] = 8;
            nArray[RegionType.Town.ordinal()] = 9;
            nArray[RegionType.Village.ordinal()] = 10;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TermType.values().length];
            nArray[TermType.Province.ordinal()] = 1;
            nArray[TermType.City.ordinal()] = 2;
            nArray[TermType.District.ordinal()] = 3;
            nArray[TermType.Street.ordinal()] = 4;
            nArray[TermType.Town.ordinal()] = 5;
            nArray[TermType.Village.ordinal()] = 6;
            nArray[TermType.Ignore.ordinal()] = 7;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

