/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.geocoding.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bitlap.geocoding.core.Computer;
import org.bitlap.geocoding.core.segment.AsciiSegmenter;
import org.bitlap.geocoding.core.segment.IKAnalyzerSegmenter;
import org.bitlap.geocoding.model.Address;
import org.bitlap.geocoding.similarity.Document;
import org.bitlap.geocoding.similarity.MatchedResult;
import org.bitlap.geocoding.similarity.MatchedTerm;
import org.bitlap.geocoding.similarity.Term;
import org.bitlap.geocoding.utils.StringHelperKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J2\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010!H\u0002J\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!0'H\u0002J\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020)0'2\b\u0010*\u001a\u0004\u0018\u00010)H\u0002J\u0012\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/bitlap/geocoding/core/impl/SimilarityComputer;", "Lorg/bitlap/geocoding/core/Computer;", "()V", "BOOST_L", "", "BOOST_M", "BOOST_S", "BOOST_XL", "BOOST_XS", "NUMBER_CN", "", "", "[Ljava/lang/Character;", "segmenter", "Lorg/bitlap/geocoding/core/segment/IKAnalyzerSegmenter;", "simpleSegmenter", "Lorg/bitlap/geocoding/core/segment/AsciiSegmenter;", "analyze", "Lorg/bitlap/geocoding/similarity/Document;", "address", "Lorg/bitlap/geocoding/model/Address;", "compute", "Lorg/bitlap/geocoding/similarity/MatchedResult;", "addr1", "addr2", "computeSimilarity", "doc1", "doc2", "getBoostValue", "forDoc", "", "qdoc", "qterm", "Lorg/bitlap/geocoding/similarity/Term;", "ddoc", "dterm", "putIdfs", "", "terms", "", "translateBuilding", "", "building", "translateRoadNum", "", "roadNum", "geocoding"})
public class SimilarityComputer
implements Computer {
    @NotNull
    private final IKAnalyzerSegmenter segmenter = new IKAnalyzerSegmenter();
    @NotNull
    private final AsciiSegmenter simpleSegmenter = new AsciiSegmenter();
    @NotNull
    private final Character[] NUMBER_CN;
    private final double BOOST_M;
    private final double BOOST_L;
    private final double BOOST_XL;
    private final double BOOST_S;
    private final double BOOST_XS;

    public SimilarityComputer() {
        Character[] characterArray = new Character[]{Character.valueOf('\u4e00'), Character.valueOf('\u4e8c'), Character.valueOf('\u4e09'), Character.valueOf('\u56db'), Character.valueOf('\u4e94'), Character.valueOf('\u516d'), Character.valueOf('\u4e03'), Character.valueOf('\u516b'), Character.valueOf('\u4e5d'), Character.valueOf('\uff10'), Character.valueOf('\uff11'), Character.valueOf('\uff12'), Character.valueOf('\uff13'), Character.valueOf('\uff14'), Character.valueOf('\uff15'), Character.valueOf('\uff16'), Character.valueOf('\uff17'), Character.valueOf('\uff18'), Character.valueOf('\uff19')};
        this.NUMBER_CN = characterArray;
        this.BOOST_M = 1.0;
        this.BOOST_L = 2.0;
        this.BOOST_XL = 4.0;
        this.BOOST_S = 0.5;
        this.BOOST_XS = 0.25;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Document analyze(@NotNull Address address) {
        void $this$mapTo$iv$iv;
        Iterable element$iv2;
        String buildingNum;
        CharSequence charSequence;
        String roadNum;
        CharSequence charSequence2;
        String road;
        CharSequence charSequence3;
        String village;
        CharSequence charSequence4;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Document doc = new Document();
        List<String> tokens = CollectionsKt.emptyList();
        CharSequence charSequence5 = address.getText();
        if (!(charSequence5 == null || StringsKt.isBlank((CharSequence)charSequence5))) {
            String string = address.getText();
            Intrinsics.checkNotNull((Object)string);
            tokens = this.segmenter.segment(string);
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        CharSequence charSequence6 = address.getTown();
        String town = !(charSequence6 == null || StringsKt.isBlank((CharSequence)charSequence6)) ? address.getTown() : address.getStreet();
        charSequence6 = town;
        if (!(charSequence6 == null || StringsKt.isBlank((CharSequence)charSequence6))) {
            doc.setTown(new Term(Term.TermType.Town, town));
            Term term = doc.getTown();
            Intrinsics.checkNotNull((Object)term);
            terms.add(term);
        }
        if (!((charSequence4 = (CharSequence)(village = address.getVillage())) == null || StringsKt.isBlank((CharSequence)charSequence4))) {
            doc.setVillage(new Term(Term.TermType.Village, village));
            Term term = doc.getVillage();
            Intrinsics.checkNotNull((Object)term);
            terms.add(term);
        }
        if (!((charSequence3 = (CharSequence)(road = address.getRoad())) == null || StringsKt.isBlank((CharSequence)charSequence3))) {
            doc.setRoad(new Term(Term.TermType.Road, road));
            Term term = doc.getRoad();
            Intrinsics.checkNotNull((Object)term);
            terms.add(term);
        }
        if (!((charSequence2 = (CharSequence)(roadNum = address.getRoadNum())) == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            Term roadNumTerm = new Term(Term.TermType.RoadNum, roadNum);
            doc.setRoadNum(roadNumTerm);
            doc.setRoadNumValue(this.translateRoadNum(roadNum));
            roadNumTerm.setRef(doc.getRoad());
            Term term = doc.getRoadNum();
            Intrinsics.checkNotNull((Object)term);
            terms.add(term);
        }
        if (!((charSequence = (CharSequence)(buildingNum = address.getBuildingNum())) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Iterable $this$forEach$iv = this.translateBuilding(buildingNum);
            boolean $i$f$forEach = false;
            for (Iterable element$iv2 : $this$forEach$iv) {
                String it = (String)((Object)element$iv2);
                boolean bl = false;
                terms.add(new Term(Term.TermType.Building, it));
            }
        }
        Iterable $this$map$iv = terms;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Term term = (Term)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getText());
        }
        List termTexts = (List)destination$iv$iv;
        Iterable $this$forEach$iv = tokens;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            String it = (String)element$iv3;
            boolean bl = false;
            if (termTexts.contains(it) || Intrinsics.areEqual((Object)town, (Object)it) || Intrinsics.areEqual((Object)village, (Object)it) || Intrinsics.areEqual((Object)road, (Object)it)) continue;
            terms.add(new Term(Term.TermType.Text, it));
        }
        this.putIdfs((List<? extends Term>)terms);
        doc.setTerms((List<? extends Term>)terms);
        return doc;
    }

    @Override
    @NotNull
    public MatchedResult compute(@Nullable Address addr1, @Nullable Address addr2) {
        if (addr1 == null || addr2 == null) {
            return new MatchedResult();
        }
        if (!(Intrinsics.areEqual((Object)addr1.getProvinceId(), (Object)addr2.getProvinceId()) && Intrinsics.areEqual((Object)addr1.getCityId(), (Object)addr2.getCityId()) && Intrinsics.areEqual((Object)addr1.getDistrictId(), (Object)addr2.getDistrictId()))) {
            return new MatchedResult();
        }
        Document doc1 = this.analyze(addr1);
        Document doc2 = this.analyze(addr2);
        MatchedResult cp1 = this.computeSimilarity(doc1, doc2);
        MatchedResult cp2 = this.computeSimilarity(doc2, doc1);
        if (cp1.getSimilarity() < cp2.getSimilarity()) {
            return cp1;
        }
        return cp2;
    }

    /*
     * Unable to fully structure code
     */
    private final int translateRoadNum(String roadNum) {
        var2_2 = roadNum;
        if (var2_2 == null || StringsKt.isBlank((CharSequence)var2_2) != false) {
            return 0;
        }
        sb = new StringBuilder();
        isTen = false;
        var4_4 = 0;
        var5_5 = roadNum.length();
        while (var4_4 < var5_5) {
            block33: {
                i = var4_4++;
                c = roadNum.charAt(i);
                if (!isTen) break block33;
                v0 = pre = ((CharSequence)sb).length() > 0;
                if (ArraysKt.contains((Object[])this.NUMBER_CN, (Object)Character.valueOf(c))) ** GOTO lbl-1000
                v1 = '0' <= c ? c < ':' : false;
                if (v1) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = post = false;
                }
                if (pre) {
                    if (!post) {
                        sb.append('0');
                    }
                } else if (post) {
                    sb.append('1');
                } else {
                    sb.append("10");
                }
                isTen = false;
            }
            if ((var8_8 = c) == '\u4e00') {
                sb.append(1);
                continue;
            }
            if (var8_8 == '\u4e8c') {
                sb.append(2);
                continue;
            }
            if (var8_8 == '\u4e09') {
                sb.append(3);
                continue;
            }
            if (var8_8 == '\u56db') {
                sb.append(4);
                continue;
            }
            if (var8_8 == '\u4e94') {
                sb.append(5);
                continue;
            }
            if (var8_8 == '\u516d') {
                sb.append(6);
                continue;
            }
            if (var8_8 == '\u4e03') {
                sb.append(7);
                continue;
            }
            if (var8_8 == '\u516b') {
                sb.append(8);
                continue;
            }
            if (var8_8 == '\u4e5d') {
                sb.append(9);
                continue;
            }
            if (var8_8 == '\u5341') {
                isTen = true;
                continue;
            }
            v3 = '0' <= c ? c < ':' : false;
            if (v3) {
                sb.append(c);
                continue;
            }
            var8_8 = c;
            if (var8_8 == '\uff10') {
                sb.append(0);
                continue;
            }
            if (var8_8 == '\uff11') {
                sb.append(1);
                continue;
            }
            if (var8_8 == '\uff12') {
                sb.append(2);
                continue;
            }
            if (var8_8 == '\uff13') {
                sb.append(3);
                continue;
            }
            if (var8_8 == '\uff14') {
                sb.append(4);
                continue;
            }
            if (var8_8 == '\uff15') {
                sb.append(5);
                continue;
            }
            if (var8_8 == '\uff16') {
                sb.append(6);
                continue;
            }
            if (var8_8 == '\uff17') {
                sb.append(7);
                continue;
            }
            if (var8_8 == '\uff18') {
                sb.append(8);
                continue;
            }
            if (var8_8 != '\uff19') continue;
            sb.append(9);
        }
        if (isTen) {
            if (((CharSequence)sb).length() > 0) {
                sb.append('0');
            } else {
                sb.append("10");
            }
        }
        if (((CharSequence)sb).length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return 0;
    }

    private final List<String> translateBuilding(String building) {
        CharSequence charSequence = building;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return CollectionsKt.emptyList();
        }
        return this.simpleSegmenter.segment(building);
    }

    private final void putIdfs(List<? extends Term> terms) {
        Iterable $this$forEach$iv = terms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Term it = (Term)element$iv;
            boolean bl = false;
            String key = it.getText();
            if (StringHelperKt.isNumericChars(key)) {
                it.setIdf(2.0);
                continue;
            }
            if (StringHelperKt.isAsciiChars(key)) {
                it.setIdf(2.0);
                continue;
            }
            it.setIdf(4.0);
        }
    }

    private final MatchedResult computeSimilarity(Document doc1, Document doc2) {
        int qTextTermCount = 0;
        int dTextTermMatchCount = 0;
        int matchStart = -1;
        int matchEnd = -1;
        List list = doc1.getTerms();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        block0: for (Term term1 : list) {
            if (term1.getType() != Term.TermType.Text) continue;
            int n = qTextTermCount;
            qTextTermCount = n + 1;
            List list2 = doc2.getTerms();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterator<Term> iterator = list2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                int i = n2++;
                Term term2 = iterator.next();
                if (term2.getType() != Term.TermType.Text || !Intrinsics.areEqual((Object)term1.getText(), (Object)term2.getText())) continue;
                int n3 = dTextTermMatchCount;
                dTextTermMatchCount = n3 + 1;
                if (matchStart == -1) {
                    matchStart = matchEnd = i;
                    continue block0;
                }
                if (i > matchEnd) {
                    matchEnd = i;
                    continue block0;
                }
                if (i >= matchStart) continue block0;
                matchStart = i;
                continue block0;
            }
        }
        double termCoord = 1.0;
        if (qTextTermCount > 0) {
            termCoord = Math.sqrt((double)dTextTermMatchCount * 1.0 / (double)qTextTermCount) * 0.5 + 0.5;
        }
        double termDensity = 1.0;
        if (qTextTermCount >= 2 && dTextTermMatchCount >= 2) {
            termDensity = Math.sqrt((double)dTextTermMatchCount * 1.0 / (double)(matchEnd - matchStart + 1)) * 0.5 + 0.5;
        }
        MatchedResult result = new MatchedResult();
        result.setDoc1(doc1);
        result.setDoc2(doc2);
        double sumQD = 0.0;
        double sumQQ = 0.0;
        double sumDD = 0.0;
        List list3 = doc1.getTerms();
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        for (Term qterm : list3) {
            double qboost = this.getBoostValue(false, doc1, qterm, doc2, null);
            Double d = qterm.getIdf();
            Intrinsics.checkNotNull((Object)d);
            double q_TF_IDF = qboost * d;
            Term dterm = doc2.getTerm(qterm.getText());
            if (dterm == null && Term.TermType.RoadNum == qterm.getType() && doc2.getRoadNum() != null && doc2.getRoad() != null && Intrinsics.areEqual((Object)doc2.getRoad(), (Object)qterm.getRef())) {
                dterm = doc2.getRoadNum();
            }
            double dboost = dterm == null ? 0.0 : this.getBoostValue(true, doc1, qterm, doc2, dterm);
            double coord = dterm != null && Term.TermType.Text == dterm.getType() ? termCoord : 1.0;
            double density = dterm != null && Term.TermType.Text == dterm.getType() ? termDensity : 1.0;
            Double d2 = dterm != null ? dterm.getIdf() : qterm.getIdf();
            Intrinsics.checkNotNull((Object)d2);
            double d_TF_IDF = d2 * dboost * coord * density;
            if (dterm != null) {
                MatchedTerm matchedTerm = new MatchedTerm(dterm);
                matchedTerm.setBoost(dboost);
                matchedTerm.setTfidf(d_TF_IDF);
                if (Term.TermType.Text == dterm.getType()) {
                    matchedTerm.setDensity(density);
                    matchedTerm.setCoord(coord);
                } else {
                    matchedTerm.setDensity(-1.0);
                    matchedTerm.setCoord(-1.0);
                }
                result.getTerms().add(matchedTerm);
            }
            sumQQ += q_TF_IDF * q_TF_IDF;
            sumQD += q_TF_IDF * d_TF_IDF;
            sumDD += d_TF_IDF * d_TF_IDF;
        }
        if (sumDD == 0.0 || sumQQ == 0.0) {
            return result;
        }
        result.setSimilarity(sumQD / Math.sqrt(sumQQ * sumDD));
        return result;
    }

    private final double getBoostValue(boolean forDoc, Document qdoc, Term qterm, Document ddoc, Term dterm) {
        Term.TermType termType;
        if (forDoc) {
            Term term = dterm;
            Intrinsics.checkNotNull((Object)term);
            termType = term.getType();
        } else {
            termType = qterm.getType();
        }
        Term.TermType termType2 = termType;
        double boost = this.BOOST_M;
        Term.TermType termType3 = termType2;
        switch (termType3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[termType3.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                boost = this.BOOST_XL;
                break;
            }
            case 4: {
                boost = this.BOOST_XS;
                break;
            }
            case 5: 
            case 6: {
                boost = this.BOOST_XS;
                if (Term.TermType.Town == termType2) {
                    if (qdoc.getTown() == null || ddoc.getTown() == null) break;
                    boost = this.BOOST_L;
                    break;
                }
                if (qdoc.getVillage() == null || ddoc.getVillage() == null || qdoc.getTown() == null) break;
                if (Intrinsics.areEqual((Object)qdoc.getTown(), (Object)ddoc.getTown())) {
                    if (Intrinsics.areEqual((Object)qdoc.getVillage(), (Object)ddoc.getVillage())) {
                        boost = this.BOOST_XL;
                        break;
                    }
                    boost = this.BOOST_L;
                    break;
                }
                if (ddoc.getTown() == null) break;
                if (!forDoc) {
                    boost = this.BOOST_L;
                    break;
                }
                boost = this.BOOST_S;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                if (qdoc.getTown() != null && qdoc.getVillage() != null) break;
                if (Term.TermType.Road == termType2) {
                    if (qdoc.getRoad() == null || ddoc.getRoad() == null) break;
                    boost = this.BOOST_L;
                    break;
                }
                if (qdoc.getRoadNumValue() <= 0 || ddoc.getRoadNumValue() <= 0 || qdoc.getRoad() == null || !Intrinsics.areEqual((Object)qdoc.getRoad(), (Object)ddoc.getRoad())) break;
                if (qdoc.getRoadNumValue() == ddoc.getRoadNumValue()) {
                    boost = 3.0;
                    break;
                }
                boost = forDoc ? 1.0 / Math.sqrt(Math.sqrt(Math.abs(qdoc.getRoadNumValue() - ddoc.getRoadNumValue()) + 1)) * this.BOOST_L : 3.0;
                break;
            }
            case 10: {
                boost = this.BOOST_M;
                break;
            }
            default: {
                boost = this.BOOST_M;
            }
        }
        return boost;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Term.TermType.values().length];
            nArray[Term.TermType.Province.ordinal()] = 1;
            nArray[Term.TermType.City.ordinal()] = 2;
            nArray[Term.TermType.District.ordinal()] = 3;
            nArray[Term.TermType.Street.ordinal()] = 4;
            nArray[Term.TermType.Town.ordinal()] = 5;
            nArray[Term.TermType.Village.ordinal()] = 6;
            nArray[Term.TermType.Road.ordinal()] = 7;
            nArray[Term.TermType.RoadNum.ordinal()] = 8;
            nArray[Term.TermType.Building.ordinal()] = 9;
            nArray[Term.TermType.Text.ordinal()] = 10;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

