/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.geocoding.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bitlap.geocoding.core.TermIndexVisitor;
import org.bitlap.geocoding.index.TermIndexEntry;
import org.bitlap.geocoding.index.TermIndexItem;
import org.bitlap.geocoding.index.TermType;
import org.bitlap.geocoding.model.RegionEntity;
import org.bitlap.geocoding.model.RegionType;
import org.bitlap.geocoding.utils.StringHelperKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002J4\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016J6\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t\u0018\u00010\u0013H\u0002J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006J\u001e\u0010\u001a\u001a\u00020\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/bitlap/geocoding/index/TermIndexBuilder;", "", "rootRegion", "Lorg/bitlap/geocoding/model/RegionEntity;", "ignoringRegionNames", "", "", "(Lorg/bitlap/geocoding/model/RegionEntity;Ljava/util/List;)V", "indexRoot", "Lorg/bitlap/geocoding/index/TermIndexEntry;", "convertRegionType", "Lorg/bitlap/geocoding/index/TermType;", "region", "deepFirstQueryRound", "", "text", "pos", "", "entries", "", "", "visitor", "Lorg/bitlap/geocoding/core/TermIndexVisitor;", "deepMostQuery", "fullMatch", "Lorg/bitlap/geocoding/index/TermIndexItem;", "indexIgnoring", "replace", "", "indexRegions", "regions", "geocoding"})
public class TermIndexBuilder {
    @NotNull
    private final TermIndexEntry indexRoot;

    public TermIndexBuilder(@NotNull RegionEntity rootRegion, @NotNull List<String> ignoringRegionNames) {
        Intrinsics.checkNotNullParameter((Object)rootRegion, (String)"rootRegion");
        Intrinsics.checkNotNullParameter(ignoringRegionNames, (String)"ignoringRegionNames");
        this.indexRoot = new TermIndexEntry();
        ArrayList<RegionEntity> arrayList = rootRegion.getChildren();
        TermIndexBuilder.indexRegions$default(this, arrayList == null ? CollectionsKt.emptyList() : (List)arrayList, false, 2, null);
        TermIndexBuilder.indexIgnoring$default(this, ignoringRegionNames, false, 2, null);
    }

    public final synchronized void indexRegions(@NotNull List<? extends RegionEntity> regions, boolean replace) {
        Intrinsics.checkNotNullParameter(regions, (String)"regions");
        if (regions.isEmpty()) {
            return;
        }
        for (RegionEntity regionEntity : regions) {
            char c;
            boolean autoAlias;
            TermIndexItem indexItem = new TermIndexItem(this.convertRegionType(regionEntity), regionEntity);
            List list = regionEntity.getOrderedNames();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (String alias : list) {
                this.indexRoot.buildIndex(alias, 0, indexItem, replace);
            }
            String rName = regionEntity.getName();
            boolean bl = rName.length() <= 5 && ((CharSequence)regionEntity.getAlias()).length() == 0 && (regionEntity.isTown() || StringsKt.endsWith$default((String)rName, (String)"\u8857\u9053", (boolean)false, (int)2, null)) ? true : (autoAlias = false);
            if (autoAlias && rName.length() == 5 && ((((((c = regionEntity.getName().charAt(2)) == '\u8def' ? true : c == '\u8857') ? true : c == '\u95e8') ? true : c == '\u9547') ? true : c == '\u6751') ? true : c == '\u533a')) {
                autoAlias = false;
            }
            if (autoAlias) {
                String shortName = null;
                if (regionEntity.isTown()) {
                    String string = StringHelperKt.head(rName, rName.length() - 1);
                    if (string == null) {
                        string = "";
                    }
                    shortName = string;
                } else {
                    String string = StringHelperKt.head(rName, rName.length() - 2);
                    if (string == null) {
                        string = shortName = "";
                    }
                }
                if (shortName.length() >= 2) {
                    this.indexRoot.buildIndex(shortName, 0, indexItem, replace);
                }
                if (StringsKt.endsWith$default((String)rName, (String)"\u8857\u9053", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)rName, (String)"\u9547", (boolean)false, (int)2, null)) {
                    this.indexRoot.buildIndex(Intrinsics.stringPlus((String)shortName, (Object)"\u4e61"), 0, indexItem, replace);
                }
                if (StringsKt.endsWith$default((String)rName, (String)"\u8857\u9053", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)rName, (String)"\u4e61", (boolean)false, (int)2, null)) {
                    this.indexRoot.buildIndex(Intrinsics.stringPlus((String)shortName, (Object)"\u9547"), 0, indexItem, replace);
                }
            }
            if (regionEntity.getChildren() == null) continue;
            ArrayList<RegionEntity> arrayList = regionEntity.getChildren();
            Intrinsics.checkNotNull(arrayList);
            if (!(!((Collection)arrayList).isEmpty())) continue;
            ArrayList<RegionEntity> arrayList2 = regionEntity.getChildren();
            Intrinsics.checkNotNull(arrayList2);
            TermIndexBuilder.indexRegions$default(this, arrayList2, false, 2, null);
        }
    }

    public static /* synthetic */ void indexRegions$default(TermIndexBuilder termIndexBuilder, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexRegions");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        termIndexBuilder.indexRegions(list, bl);
    }

    public final synchronized void indexIgnoring(@NotNull List<String> ignoringRegionNames, boolean replace) {
        Intrinsics.checkNotNullParameter(ignoringRegionNames, (String)"ignoringRegionNames");
        if (ignoringRegionNames.isEmpty()) {
            return;
        }
        for (String ignore : ignoringRegionNames) {
            this.indexRoot.buildIndex(ignore, 0, new TermIndexItem(TermType.Ignore, null), replace);
        }
    }

    public static /* synthetic */ void indexIgnoring$default(TermIndexBuilder termIndexBuilder, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexIgnoring");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        termIndexBuilder.indexIgnoring(list, bl);
    }

    private final TermType convertRegionType(RegionEntity region) {
        TermType termType;
        switch (WhenMappings.$EnumSwitchMapping$0[region.getType().ordinal()]) {
            case 1: {
                termType = TermType.Country;
                break;
            }
            case 2: 
            case 3: {
                termType = TermType.Province;
                break;
            }
            case 4: 
            case 5: {
                termType = TermType.City;
                break;
            }
            case 6: 
            case 7: {
                termType = TermType.District;
                break;
            }
            case 8: {
                termType = TermType.Street;
                break;
            }
            case 9: {
                termType = TermType.Town;
                break;
            }
            case 10: {
                termType = TermType.Village;
                break;
            }
            case 11: {
                if (region.isTown()) {
                    termType = TermType.Town;
                    break;
                }
                termType = TermType.Street;
                break;
            }
            default: {
                termType = TermType.Undefined;
            }
        }
        return termType;
    }

    public final void deepMostQuery(@Nullable String text, @NotNull TermIndexVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        if (text == null || ((CharSequence)text).length() == 0) {
            return;
        }
        int p = 0;
        if (StringsKt.startsWith$default((String)text, (String)"\u4e2d\u56fd", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"\u5929\u671d", (boolean)false, (int)2, null)) {
            p += 2;
        }
        this.deepMostQuery(text, p, visitor);
    }

    public final void deepMostQuery(@Nullable String text, int pos, @NotNull TermIndexVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        if (text == null || ((CharSequence)text).length() == 0) {
            return;
        }
        visitor.startRound();
        HashMap<Character, TermIndexEntry> hashMap = this.indexRoot.getChildren();
        this.deepFirstQueryRound(text, pos, hashMap == null ? MapsKt.emptyMap() : (Map)hashMap, visitor);
        visitor.endRound();
    }

    private final void deepFirstQueryRound(String text, int pos, Map<Character, ? extends TermIndexEntry> entries, TermIndexVisitor visitor) {
        if (pos > text.length() - 1) {
            return;
        }
        TermIndexEntry termIndexEntry = entries.get(Character.valueOf(text.charAt(pos)));
        if (termIndexEntry == null) {
            return;
        }
        TermIndexEntry entry = termIndexEntry;
        if (entry.getChildren() != null && pos + 1 <= text.length() - 1) {
            HashMap<Character, TermIndexEntry> hashMap = entry.getChildren();
            this.deepFirstQueryRound(text, pos + 1, hashMap == null ? MapsKt.emptyMap() : (Map)hashMap, visitor);
        }
        if (entry.hasItem() && visitor.visit(entry, text, pos)) {
            int p = visitor.position();
            if (p + 1 <= text.length() - 1) {
                this.deepMostQuery(text, p + 1, visitor);
            }
            visitor.endVisit(entry, text, p);
        }
    }

    @Nullable
    public final List<TermIndexItem> fullMatch(@Nullable String text) {
        if (text == null || ((CharSequence)text).length() == 0) {
            return null;
        }
        return this.fullMatch(text, 0, (Map<Character, ? extends TermIndexEntry>)this.indexRoot.getChildren());
    }

    private final List<TermIndexItem> fullMatch(String text, int pos, Map<Character, ? extends TermIndexEntry> entries) {
        if (entries == null) {
            return null;
        }
        char c = text.charAt(pos);
        TermIndexEntry termIndexEntry = entries.get(Character.valueOf(c));
        if (termIndexEntry == null) {
            return null;
        }
        TermIndexEntry entry = termIndexEntry;
        if (pos == text.length() - 1) {
            return entry.getItems();
        }
        return this.fullMatch(text, pos + 1, (Map<Character, ? extends TermIndexEntry>)entry.getChildren());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RegionType.values().length];
            nArray[RegionType.Country.ordinal()] = 1;
            nArray[RegionType.Province.ordinal()] = 2;
            nArray[RegionType.ProvinceLevelCity1.ordinal()] = 3;
            nArray[RegionType.City.ordinal()] = 4;
            nArray[RegionType.ProvinceLevelCity2.ordinal()] = 5;
            nArray[RegionType.District.ordinal()] = 6;
            nArray[RegionType.CityLevelDistrict.ordinal()] = 7;
            nArray[RegionType.PlatformL4.ordinal()] = 8;
            nArray[RegionType.Town.ordinal()] = 9;
            nArray[RegionType.Village.ordinal()] = 10;
            nArray[RegionType.Street.ordinal()] = 11;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

