/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.spi.docker.swarm.dnsrr;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.MemberAddressProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class DockerDNSRRMemberAddressProvider
implements MemberAddressProvider {
    public static Properties properties;
    public static InetSocketAddress bindAddress;
    ILogger logger = Logger.getLogger(DockerDNSRRMemberAddressProvider.class);

    public DockerDNSRRMemberAddressProvider(Properties properties) throws NumberFormatException, SocketException, UnknownHostException {
        DockerDNSRRMemberAddressProvider.properties = properties;
        if (properties != null) {
            String serviceName = properties.getProperty("serviceName");
            String portString = properties.getProperty("servicePort");
            Integer port = 5701;
            if (portString != null && !"".equals(portString.trim())) {
                try {
                    port = Integer.valueOf(portString);
                }
                catch (NumberFormatException nfe) {
                    this.logger.severe("Unable to parse servicePort with value " + portString);
                    throw nfe;
                }
            }
            Set<InetAddress> potentialInetAddresses = this.resolveServiceName(serviceName);
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                block4: while (networkInterfaces.hasMoreElements() && bindAddress == null) {
                    Enumeration<InetAddress> networkInterfaceAddresses = networkInterfaces.nextElement().getInetAddresses();
                    while (networkInterfaceAddresses.hasMoreElements()) {
                        InetAddress address = networkInterfaceAddresses.nextElement();
                        if (address != null) {
                            this.logger.info("Checking address " + address.toString());
                        }
                        if (!potentialInetAddresses.contains(address)) continue;
                        bindAddress = new InetSocketAddress(address, (int)port);
                        continue block4;
                    }
                }
            }
            catch (SocketException e) {
                this.logger.severe("Unable to bind socket: " + e.toString());
                throw e;
            }
        }
    }

    private Set<InetAddress> resolveServiceName(String serviceName) throws UnknownHostException {
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        try {
            InetAddress[] inetAddresses = InetAddress.getAllByName(serviceName);
            addresses.addAll(Arrays.asList(inetAddresses));
            this.logger.info("Resolved domain name '" + serviceName + "' to address(es): " + addresses);
        }
        catch (UnknownHostException e) {
            this.logger.severe("Unable to resolve service name " + serviceName);
            throw e;
        }
        return addresses;
    }

    public InetSocketAddress getBindAddress() {
        return bindAddress;
    }

    public InetSocketAddress getPublicAddress() {
        return bindAddress;
    }

    static {
        bindAddress = null;
    }
}

