/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.spi.docker.swarm.dnsrr.discovery;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bitsofinfo.hazelcast.spi.docker.swarm.dnsrr.discovery.DockerDNSRRDiscoveryConfiguration;

public class DockerDNSRRDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private ILogger logger;

    public DockerDNSRRDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.logger = logger;
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        LinkedList<DiscoveryNode> discoveryNodes = new LinkedList<DiscoveryNode>();
        String servicesCsv = (String)((Object)this.getOrDefault(DockerDNSRRDiscoveryConfiguration.SERVICESCSV, (Comparable)((Object)"")));
        if (servicesCsv == null || servicesCsv.trim().isEmpty()) {
            return discoveryNodes;
        }
        Set<Object> serviceNameResolutions = new HashSet();
        Integer port = 5701;
        for (String service : servicesCsv.split(",")) {
            if (service.trim().isEmpty()) continue;
            String[] serviceHostnameAndPort = service.split(":");
            if (serviceHostnameAndPort[0] == null || serviceHostnameAndPort[0].trim().isEmpty()) {
                this.logger.info("Unable to resolve service hostname " + serviceHostnameAndPort[0] + " Skipping service entry.");
                continue;
            }
            if (serviceHostnameAndPort.length <= 1 || serviceHostnameAndPort[1] == null || serviceHostnameAndPort[1].trim().isEmpty()) {
                port = 5701;
            } else {
                try {
                    port = Integer.valueOf(serviceHostnameAndPort[1]);
                }
                catch (NumberFormatException nfe) {
                    this.logger.info("Unable to parse port " + serviceHostnameAndPort[1] + " Skipping service entry.");
                    continue;
                }
            }
            serviceNameResolutions = this.resolveDomainNames(serviceHostnameAndPort[0]);
            for (InetAddress inetAddress : serviceNameResolutions) {
                discoveryNodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(inetAddress, port.intValue())));
            }
        }
        return discoveryNodes;
    }

    private Set<InetAddress> resolveDomainNames(String domainName) {
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        try {
            InetAddress[] inetAddresses = InetAddress.getAllByName(domainName);
            addresses.addAll(Arrays.asList(inetAddresses));
            this.logger.info("Resolved domain name '" + domainName + "' to address(es): " + addresses);
        }
        catch (UnknownHostException e) {
            this.logger.severe("Unable to resolve domain name " + domainName);
        }
        return addresses;
    }
}

