/*
 * Decompiled with CFR 0.152.
 */
package org.bklab.wot.warmonger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.bklab.wot.warmonger.CompressedFolders;
import org.bklab.wot.warmonger.Config;
import org.bklab.wot.warmonger.FileLocationManager;
import org.bklab.wot.warmonger.ReadFileUtils;
import org.bklab.wot.warmonger.ReplaceUpdateTime;
import org.bklab.wot.warmonger.UrlDownloader;
import org.bklab.wot.warmonger.entity.ModEntity;

public class UpdateMods {
    private static Set<ModEntity> modEntitySet = new ReadFileUtils().readFiles(Config.DWLIST);

    public static UpdateMods create() {
        return new UpdateMods();
    }

    public static void main(String[] args) {
        UpdateMods.create().start();
    }

    private void start() {
        this.downloadUpdateIndex();
        String baseDir = Config.BASE_DIRECTORY + "Warmonger_Mods" + "_" + "0.9.22.0.1";
        new FileLocationManager().moving(baseDir);
        new CompressedFolders().doCompress(baseDir, Config.ABSOLUTE_BASE + "Warmonger_Mods" + "_" + "0.9.22.0.1" + ".zip");
        new ReplaceUpdateTime().doReplace();
    }

    public void parseUpdateIndex(String singleLine) {
        if (singleLine.indexOf("res_wbp") <= 0) {
            String id = singleLine.substring(singleLine.indexOf("-") + 1, singleLine.indexOf(",")) + "-DW";
            String date = singleLine.substring(singleLine.lastIndexOf(",") + 1);
            for (ModEntity wotMod : modEntitySet) {
                ModEntity mods = this.parseIdInModSets(id, date, wotMod);
                if (mods == null) continue;
                UrlDownloader.forceUpdate = true;
                UrlDownloader.create().downloadFile(mods.getFileNames(), Config.BASE_DIRECTORY, mods.getName() + ".wbp", "");
            }
        }
    }

    private ModEntity parseIdInModSets(String id, String date, ModEntity wotMod) {
        if (wotMod.getId().equals(id) && Integer.parseInt(new SimpleDateFormat("MMdd").format(new Date(new File(String.format(Config.BASE_DIRECTORY + "wbp" + File.separator + "%s.wbp", wotMod.getName())).lastModified()))) - 1 < Integer.parseInt(date)) {
            System.out.printf("%s.wbp%n", wotMod.getName().trim());
            return wotMod;
        }
        return null;
    }

    public File downloadUpdateIndex() {
        File newMods = UrlDownloader.create().downloadFile("", Config.BASE_DIRECTORY, "new.lst", "http://list.guazihe.com/0tkmod/new.js");
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(newMods), StandardCharsets.UTF_8));
            while ((s = reader.readLine()) != null) {
                this.parseUpdateIndex(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newMods;
    }
}

